h06682
s 00003/00003/00099
d D 1.8 83/03/02 22:43:52 mjb 8 7
c 
e
s 00002/00002/00100
d D 1.7 83/02/18 13:43:37 mjb 7 6
c 
e
s 00003/00003/00099
d D 1.6 83/02/07 11:24:24 mjb 6 5
c if deffed all stops in these routines
e
s 00001/00001/00101
d D 1.5 83/02/01 20:07:44 tes 5 4
c modified MNUCOMxSIZE to begin at mnuid versus floc
e
s 00002/00002/00100
d D 1.4 83/02/01 19:29:34 mjb 4 3
c fixed problem with checking for 0 file descriptors
e
s 00001/00001/00101
d D 1.3 83/01/31 12:42:45 tes 3 2
c modified nxtcmd to pass in terminator character for logical lines
e
s 00002/00010/00100
d D 1.2 83/01/28 13:03:54 mjb 2 1
c made changes to accomadate using as a build tool for menus.bin
e
s 00110/00000/00000
d D 1.1 83/01/20 11:14:25 tes 1 0
c date and time created 83/01/20 11:14:25 by tes
e
u
tes
mjb
U
t
T
I 1
subroutine qmenu (fname)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Define a menu from the given file                      #
#                                                                      #
#     Input Parameters:                                                #
#            fname - a null terminated byte array which defines the    #
#                    disk file name for the menu file to be read       #
#                                                                      #
#     Output Parameters:                                               #
#            None                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            nxtcmd - get next command from file                       #
#            gdopen - open a disk file                                 #
#            qnewid - define a new menu id                             #
#            qtitle - define a menu title                              #
#            qfield - define a menu field                              #
#            pmnitm - put a menu item to memory                        #
#            pfditm - put a field item to memory                       #
#                                                                      #
########################################################################
ifdef(`UNIX',`CHAR fname',`SHORTINT fname(1)')

D 7
ifdef(`F80',`integer*1 mnutmp(10)')
E 7
I 7
D 8
ifdef(`UNIX',`',`integer*1 mnutmp(10)')
E 8
I 8
ifdef(`UNIX',`',`integer*1 mnutmp(11)')
E 8
E 7

SHORTINT buffer(81), c
integer fildes, i, loc, mode, error

integer menufd

integer gdopen, gdclos, gdwrit

include(`mnucom')

common /mnfdcm/ menufd

D 7
ifdef(`F80',`
E 7
I 7
ifdef(`UNIX',`',`
E 7
D 2
data mnutmp/BIGM,BIGE,BIGN,BIGU,BIGS,PERIOD,BIGT,BIGM,BIGP,NUL/
E 2
I 2
D 8
data mnutmp/BIGM,BIGE,BIGN,BIGU,BIGS,PERIOD,BIGB,BIGI,BIGN,NUL/
E 8
I 8
data mnutmp/BIGG,BIGR,BIGA,BIGP,BIGH,BIGY,PERIOD,BIGM,BIGN,BIGU,NUL/
E 8
E 2
')

# initialize common variables
floc(1) = 0
floc(2) = 0
fbfknt = 0
do i=1, MAXMENUS {
   mnuid(i) = 0
   }
lastid = 0
mfrept = 1
ffrept = 1

# open the menu file read only  
mode = ASCIIxREAD
fildes = gdopen (fname, mode)
D 4
if (fildes <= 0) stop 1
E 4
I 4
D 6
if (fildes < 0) stop 1
E 6
I 6
ifdef(`UNIX',`if (fildes < 0) stop 1')
E 6
E 4

loc = 0
repeat {
   # get the next menu item from the file  
D 3
   call nxtcmd (fildes, buffer)
E 3
I 3
   call nxtcmd (fildes, buffer, SEMICOL)
E 3
   c = buffer(1)
   if (c > 0) {
      if      (c == 123) call qnewid (buffer)    # '{' next menu id  
      else if (c == 60) call qtitle (buffer) # '<' next menu title  
      else if (c == 91) call qfield (buffer) # '[' next menu field  
D 6
      else stop 2
E 6
I 6
      ifdef(`UNIX',`else stop 2')
E 6
      }
   } until (c <= 0)
c = 0
call pmnitm (c)
call pfditm (c)

error = gdclos (fildes)

# Now make a dump of the menu commmon so that memory space can be reused
# in overlays

# open the menu file for reading and writing
mode = BINARYxWRITE
changequote([,])
ifdef([UNIX],
D 2
[ menufd = gdopen ('menus.tmp', mode) ],
E 2
I 2
D 8
[ menufd = gdopen ('menus.bin', mode) ],
E 8
I 8
[ menufd = gdopen ('graphy.mnu', mode) ],
E 8
E 2
[ menufd = gdopen (mnutmp, mode) ])
changequote(`,')

D 4
if (menufd <= 0) stop 1
E 4
I 4
D 6
if (menufd < 0) stop 1
E 6
I 6
ifdef(`UNIX',`if (menufd < 0) stop 1')
E 6
E 4

# write the menu common block to disk
D 5
i = gdwrit (menufd, floc, MNUCOMxSIZE)
E 5
I 5
i = gdwrit (menufd, mnuid, MNUCOMxSIZE)
E 5
i = gdclos (menufd)
D 2

# open the menu file for reading
mode = BINARYxREAD
changequote([,])
ifdef([UNIX],
[ menufd = gdopen ('menus.tmp', mode) ],
[ menufd = gdopen (mnutmp, mode) ])
changequote(`,')
E 2

return
end
E 1
