h42671
s 00001/00001/00057
d D 1.2 83/01/28 13:56:29 tes 2 1
c initial_internal_update
e
s 00058/00000/00000
d D 1.1 83/01/28 13:03:23 tes 1 0
c date and time created 83/01/28 13:03:23 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gppenv (index, prdstr, prdend, numprd)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: set up the periodic environment                        #
#                                                                      #
#     Input Parameters:                                                #
#            index  - axis being acted upon                            #
#            prdstr - label starting value                             #
#            lperid - end of 1 period                                  #
#            numprd - number of periods to be displayed                #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gpgnax - generate an axis with labels                     #
#            gpitic - initialize tic environment                       #
#                                                                      #
########################################################################
integer index
real prdstr, prdend, numprd
 
integer gimnmx, kperid
real length,   # length (max) of one period
     grmnmx    # real function which bounds a real variable
 
include(`pltcom')
 
DxB write (DEBUGxUNIT, 100) index, prdstr, prdend, numprd
DxB 100 format (' gppenv:', i5, 3f10.5)
 
   if (nperid != 6) {
      kperid = prdend
      if (nperid < 3)      kperid = gimnmx (kperid, 1, 7)
      else if (nperid < 5) kperid = gimnmx (kperid, 1, 12)
      else                 kperid = gimnmx (kperid, 1, 4)
      zpend = kperid
      }
   else
      zpend = amax1 (0., prdend)
 
   zlincr = 1.0  # For periodics, increment is always 1 
 
   length = zpend - 1.0 # number of intervals is one less than tics 
 
   nminor = 1
D 2
   nmajor = grmnmx ((numprd*(length/zlincr + 1.) - 1.), 0.0, 32767.)
E 2
I 2
   nmajor = grmnmx ((numprd*(length/zlincr + 1.) - 1.+ZEPS), 0.0, 32767.)
E 2
 
   return
end
E 1
