h65229
s 00004/00003/00242
d D 1.2 83/01/28 13:57:28 tes 2 1
c initial_internal_update
e
s 00245/00000/00000
d D 1.1 83/01/28 13:03:37 tes 1 0
c date and time created 83/01/28 13:03:37 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gppisl (stangl, enangl, value, index)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Output a pie slice centered at x, y with an arc from   #
#               start angle 'stangl' to 'enangl'                       #
#                                                                      #
#     Input Parameters:                                                #
#            stangl - start angle in radians                           #
#            enangl - end angle in radians                             #
#            value  - value to be used as slice label                  #
#            index  - slice kount                                      #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            imove  - modify position for later action                 #
#            idraw  - do a 2d draw                                     #
#            gzemfl - emulate a filled area                            #
#            gzddop - device independent interface to current device   #
#            gpsatt - Set an attribute on the current device           #
#            text   - Display a text string                            #
#                                                                      #
########################################################################
integer index
real value, stangl, enangl

integer i, j, k, ixplod, ifill, iflclr, kount, just, idir, length, 
	fillem, iout
D 2
integer gitoch, gr2chr, kerror
E 2
I 2
integer gr2chr, kerror
E 2
real xmax, ymax, diffx, diffy, xc, yc, radius, x1, y1, x2, xpxlfc, ypxlfc,
     y2, averag, xmidl, ymidl, xs, ys, factor, degree, angle,
     savx, savy, longax, axfact, xaxfac, yaxfac, widsav, hgtsav
 
integer contrl(5),  # gzddop control parameter array
	intin(1),   # Argument for gzddop
        intout(1),  # Dummy argument for gzddop
	ptsout(1),  # Argument for gzddop
        txtstr(16), # Array used to pass labels to routine 'text'
	ptsin(148)  # Array used to pass polygon to device
 
real scrtch(8)     # Scratch array used by gzemfl for filling
                    #    to xarray/yarray)

real xarray(74), yarray(74)
 
include(`pltcom')

# The following equivelences were made to reduce code space:
#      txtstr(1) = scrtch(1) # Equivalence two scratch arrays to save space
equivalence (txtstr(1), scrtch(1))
 
   ixplod = 0    # Set attributes to 0 in case greater than 15
   ifill = 0
D 2
   iflclr = 0
E 2
I 2
   iflclr = 1
E 2
   if (index <= 15) {
      ixplod = npslcx(index)      # Slice explode status
      ifill = npslcf(index)       # Slice fill pattern
      iflclr = npslcc(index)      # Slice fill color
      }
   
   savx = xvwlng
   savy = yvwlng
   longax = amax1 (xvwlng, yvwlng)

   diffx = xvwlng/longax    # Put space into 0 - 1 space
   diffy = yvwlng/longax
   
   xvwlng = longax
   yvwlng = longax

   xmax = diffx
   ymax = diffy
   xc = xmax/2.0
   yc = ymax/2.0

   # In order to make pies round, must modify the scale factors to
   # Use the size of a pixel to scale properly
   factor = amax0 (npxlx, npxly)  # Determine which pixel is bigger
   xpxlfc = float(npxlx) / factor
   ypxlfc = float(npxly) / factor
 
   # Need to determine x and y scale factors to put the pie into
   # a unity aspect ratio since the device interface is 32K in x and y
   axfact = amax0 (nxrast, nyrast)  # Determine longest axis
   xaxfac = float(nxrast) / axfact * xpxlfc
   yaxfac = float(nyrast) / axfact * ypxlfc

    # The radius will be 20% of the available space
   radius = 0.2*amin1(diffx*xaxfac,diffy*yaxfac) 

   x1 = radius*cos (stangl)      # Determine the distance and location of the
   y1 = radius*sin (stangl)      # center of the arc so that the label and
   x2 = radius*cos (enangl)      # explode have correct locations to move to.
   y2 = radius*sin (enangl)
 
   averag = stangl + (enangl - stangl)/2.
   xmidl = radius*cos (averag)
   ymidl = radius*sin (averag)
   xs = .15*xmidl
   ys = .15*ymidl
 
   if (ixplod != 0)    # This slice is exploded, shift the arc center out.
      factor = .15
   else
      factor = .0075
 
   xc = xc + factor*xmidl
   yc = yc + factor*ymidl
 
   xmidl = xmidl/xaxfac + xc
   ymidl = ymidl/yaxfac + yc

   degree = .0872663    #  5 degrees in radians  ( 5.*(6.28318/360.) )
   kount = ((enangl-stangl)/degree) + 1   # Kount is the number of iterations
   angle = stangl                         # Set angle to the start angle
I 2
   if (kount == 1) kount = 2              # Arc less than 5 degrees
E 2
   for (k=1; k<=kount; k=k+1) {           # Build the arc
      if (k == kount) angle = enangl
      xarray(k) = radius*cos(angle)/xaxfac + xc
      yarray(k) = radius*sin(angle)/yaxfac + yc
      angle = angle + degree
      }
 
   if (k < 73) {    # Make data include the center point
      xarray(k) = xc
      yarray(k) = yc
      k = k + 1
      xarray(k) = xarray(1)
      yarray(k) = yarray(1)
      }
   else
      k = k - 1
 
   call gpsatt (SETxFILLxCOLORxINDEX, iflclr, iout)

   # Need to determine if the device can do the desired polygon
   # fill pattern by mapping the FILL INTERIOR STYLE and the 
   # FILL STYLE INDEX to the user's choice of (0-7)

   fillem = NO  # Start by saying the device can not do the fill
   iout = -1    # Just in case nothing is returned by the driver

   if (ifill > SOLID)  {  # Use a fill pattern or hatch
      call gpsatt (SETxFILLxINTERIORxSTYLE, PATTERN, iout)
      if (iout == PATTERN) {
	 fillem = YES  # The device can do this fill
	 }
      else {
	 iout = -1
	 call gpsatt (SETxFILLxINTERIORxSTYLE, HATCH, iout)
	 if (iout == HATCH)  fillem = YES
	 }
      call gpsatt (SETxFILLxSTYLExINDEX, ifill-1, iout)
      }
   else  {  # Use a hollow or solid fill
      call gpsatt (SETxFILLxINTERIORxSTYLE, ifill, iout)
      if (iout == ifill)  fillem = YES # The device does this fill
      }
 
   # Fill slice of pie
   if (nfill == YES & fillem == YES) { # The device can do it
      # Convert points from 0-1 to 32k space and put into ptsin array
      j = 1
      do i = 1, k  {
	 call gpn2dc (xarray(i), yarray(i), ptsin(j))
	 j = j + 2
	 }
      contrl(1) = FILLxAREA
      contrl(VERTICESxIN) = k
      call gzddop (contrl, intin, ptsin, intout, ptsout)
      }
   else {   # Emulate the pie slice
      call gzemfl (k, xarray, yarray, scrtch, ifill, iflclr)
      }
 
   # Position for label
 
   call imove (ABSOLUTE, xmidl, ymidl)
   call idraw (RELATIVE, xs, ys)
   call imove (RELATIVE, xs/2., ys/2.)
 
   # Justify the labels vertically centered and horizontally left or right
   # depending upon which quadrant we're in. Left for quadrants I & IV,
   # right for quadrants II & III.
 
   txtjv = 2    # Center justify the text
   if (averag < 1.57 | averag > 4.85) {  # If the label is on the right side
      txtjh = 0
      just = 4
      idir = 1
      }
   else {  # Justify it for the left side of the pie
      txtjh = 2
      just = 6
      idir = -1
      }

   # Convert value to characters, either percentage or actual value
 
   if (npltyp == 0) {
D 2
      length = gitoch (ifix(100.*value+.49), txtstr, 4, kerror)
E 2
I 2
      length = gr2chr (100.*value+.05, txtstr, 10, 1, kerror)
E 2
      length = length + 1
      txtstr(length) = PERCENT
      }
   else
      length = gr2chr (value, txtstr, 10, 2, kerror)

   # Now due to the special space that pies are calulated
   # in, we must put the character size back into 0-1 space for
   # the entire screen, that is remove the viewport transformation
   widsav = zchwdt
   hgtsav = zchhgt
   zchwdt = zchwdt*savx/longax
   zchhgt = zchhgt*savy/longax

   call text (length, txtstr)      # Output the data value

   # Now restore the correct character sizes for the current viewport
   zchwdt = widsav
   zchhgt = hgtsav

   # Restore the viewing transform
   xvwlng = savx
   yvwlng = savy

   # Determine where label is to be positioned
   if (index <= 15) {
      j = index + 15

      # Now save this ndc position for later time
      zpspos(index) = zxabsl*(longax/xvwlng) + (length+1)*idir*zchwdt 
      zpspos(j) = zyabsl*(longax/yvwlng)
      npslcj(index) = just
      }
 
   return
end
E 1
