; CUSTOM BIOS TO IMPLEMENT MOVE-IT ON DECMATION D100 SYSTEM
; USE UNDER RT-11 CONTROL PROGRAM CP.SAV ONLY
; MERGE THIS CODE WITH MOVE-IT USING DDT
; DO IT THIS WAY:
; A>ASM MOVBIOS2
; A>PIP MOVIT.COM=MOVE-IT.UCF
; A>DDT MOVIT.COM
; -IMOVBIOS2.HEX
; -R
; -G0
; A>SAVE 64 MOVIT.COM
;
; THE CONTROL PROGRAM (CP.SAV) MUST BE PATCHED AT COMMON LOCATION "MDMCSR"
; WITH THE ADDRESS OF THE DLV11 (J) TO BE USED (RECEIVER STATUS
; REGISTER ADDRESS
;
; COPYRIGHT 1983 BY DECMATION
; 4-AUG-83
;
	ORG	0100H
	JMP	0302H	;GOT TO MOVE IT
	JMP	04000H	; POINTS TO FREE AREA
	JMP	INITI
	JMP	FINISH
	JMP	INSTA	
	JMP	INDAT
	JMP	OUTSTA
	JMP	OUTDAT
	JMP	CNFGMS
	JMP	DIAL
; ADDRESSES OF SPECIAL BIOS CALLS
MDMOUT	EQU	0FA45H	;SEND CHARACTER TO DLV11
MDMIN	EQU	0FA48H	;GET CHAR FROM DLV11
; NOTE CP.SAV MUST BE PATCHED WITH DLV11 ADDRESS
;
; SIGNON MESSAGE
CNFGMS	DB	'               DLV11 INTERFACE',0DH,0AH,0AH,'$'
	DB	'                                              '
	DB	'                                       '
; DIAL NOT IMPLEMENTED
DIAL	RET
; INITIALZIATION  ENABLE INTERFACE
INITI	MVI	A,0
	STA	INCNT
	STA	OUTCNT	;BUFFER COUNTS IN 11
	MVI	B,2	;ACTION CODE FOR 11
	JMP	MDMOUT	;MESSAGE TO 11
FINISH	MVI	B,3	;ACTION CODE
	JMP	MDMOUT
; HERE TO SEE IF CHARACTER READY, KEEPLOCAL BUFFER COUNT
; WHICH IS PERIODICALLY UPDATED
INSTA	PUSH	H
	PUSH	D
	PUSH	B
	LDA	INCNT
	ORA	A
	JZ	INSTA3	;LOCAL COUNTER SHOWS NO SPACE
INSTA2	MVI	A,0FFH	;CHARACTERS AVAILABLE, SEND READY FLAG
	JMP	EX
;
INSTA3	MVI	B,2	;GET READER BUFFER COUNT, ACTION CODE
	CALL	MDMIN
	STA	INCNT	;SAVE CHAR CNT IN 11 BUFFER
	ORA	A
	JNZ	INSTA2	;RETURN READY IF NOT ZERO
	JMP	EX	;ELSE RETURN 0 NOT READY
; RETURN THE RECEIVED CHARACTER
INDAT	PUSH	H
	PUSH	D
	PUSH	B
	LDA	INCNT
	DCR	A	;DEC LOCAL CHAR COUNT
	STA	INCNT
	MVI	B,1	;ACTION CODE TO GET RECEIVED CHAR
	CALL	MDMIN	;RETURNS CHAR IN A
	JMP	EX
; REQUEST FOR OUTPUT STATUS
OUTSTA	PUSH	H
	PUSH	D
	PUSH	B
	LDA	OUTCNT
	ORA	A
	JZ	OUTST3	;LOCAL COUNT SHOWS OUT BUFFER FULL
OUTST2	MVI	A,0FFH	;READY FLAG
	JMP	EX
OUTST3	MVI	B,3	;CHECK BUFFER IN 11
	CALL	MDMIN
	STA	OUTCNT	;UPDATE LOCAL COUNT
	ORA	A
	JNZ	OUTST2	;SPACE IS AVAILABLE
	JMP	EX
; SEND DATA TO PORT, PRINT A CHARACTER
OUTDAT	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW	;MUST PERSERVE A IN THIS !!!!
	MOV	C,A	;STASH CHAR IN C
	LDA	OUTCNT
	DCR	A
	STA	OUTCNT	;DECREMENT LOCAL COUNT
	MVI	B,1	;SIGNAL TO TRANSMITT CHAR
	CALL	MDMOUT	;SEND CHAR IN C
	POP	PSW	;RESTORE A
	JMP	EX
INCNT	DB	0
OUTCNT	DB	0
EX	POP	B
	POP	D
	POP	H
	RET
                                                            