title	'EMPERORX.ASM - PALANTIR Font Definition File -- 04/25/83'

*****************************************************************
*								*
*	NEC EMPEROR P.S. Proportional Font (Translation Mode)	*
*		         803 - 020004 - 312		        *
*								*
*	The definition table must be assembled to produce	*
*	a HEX file, which should then be LOADed or SAVEd	*
*	(e.g., SAVE 1 name.WPF) from DDT to create the		*
*	font definition file expected by the PALANTIR.		*
*								*
*	The table consists of 128 2-byte entries for the	*
*	character set from Ascii 0-127.  The first byte of	*
*	each entry is the character size in increments.  The	*
*	second byte is the code to be sent to the printer,	*
*	which for some print wheels is different from the	*
*	original Ascii character.  If the high-order bit of	*
*	the second byte is on, the DFSHFT (Shift) logic in	*
*	the print driver is invoked at printout.		*
*								*
*	For mono-spaced wheels, the first byte will be the	*
*	same throughout.  For wheels that use the normal	*
*	character arrangement, the second byte of each entry	*
*	will contain the next higher binary value.  The first	*
*	32 entries of the table are not normally used, unless	*
*	by the Extended Character Set option for printers	*
*	with more than 96 characters per wheel. 		*
*								*
*****************************************************************

	org	100h

	page
;	Control/Extended Range

	db	0,0
	db	10,045h			; Left Arrow <-
	db	10,04Ch			; Logical NOT
	db	10,0DFh			; 1/2
	db	10,0DEh			; Cent Sign
	db	10,027h			; 1/4
	db	0,6
	db	0,7
	db	0,8
	db	0,9
	db	0,10
	db	0,11
	db	0,12
	db	0,13
	db	0,14
	db	0,15
	db	0,16
	db	0,17
	db	0,18
	db	0,19
	db	0,20
	db	0,21
	db	0,22
	db	0,23
	db	0,24
	db	0,25
	db	0,26
	db	0,27
	db	0,28
	db	10,' '		;Soft Space
	db	8,'-'		;Hard Hyphen
	db	10,' '		;Hard Space

	page
;	Standard Ascii Character Set

	db	10,' '	 	;Blank
	db	06,'K' 		;Exclamation Point
	db	08,'"' 		;Double Quotes
	db	12,'=' 		;Pound (Number) Sign

	db	10,'z'		;Dollar Sign
	db	12,'K'+128	;Percent Sign
	db	12,'<'		;Ampersand
	db	06,'O'		;Single Quote

	db	06,'n' 		;Left Parenthesis
	db	06,'G' 		;Right Parenthesis
	db	10,'*' 		;Asterisk
	db	10,'4' 		;Plus Sign

	db	06,'Q'+128	;Comma
	db	08,'$' 		;Hyphen (Minus Sign)
	db	06,'3' 		;Period
	db	08,'t' 		;Slash

	db	10,'I'+128	;Digit Zero
	db	10,'C'+128	;Digit One
	db	10,'P'+128	;Digit Two
	db	10,'M'+128	;Digit Three

	db	10,'A'+128	;Digit Four
	db	10,'T'+128	;Digit Five
	db	10,'E'+128	;Digit Six
	db	10,'O'+128	;Digit Seven

	db	10,'R'+128	;Digit Eight
	db	10,'S'+128	;Digit Nine
	db	06,'q' 		;Colon
	db	06,'f' 		;Semicolon

	db	10,'U' 		;Less Than
	db	10,'7' 		;Equal Sign
	db	10,'v' 		;Greater Than
	db	10,'S' 		;Question Mark

	db	12,'^' 		;At-Sign
	db	12,'/' 		;Capital A
	db	10,'M' 		;Capital B
	db	12,'6' 		;Capital C

	db	12,'J' 		;Capital D
	db	10,'?' 		;Capital E
	db	10,'!' 		;Capital F
	db	12,'Z' 		;Capital G

	db	12,'w' 		;Capital H
	db	06,'W' 		;Capital I
	db	08,'e' 		;Capital J
	db	12,'R' 		;Capital K

	db	10,'N'		;Capital L
	db	14,'C' 		;Capital M
	db	12,'F' 		;Capital N
	db	14,'X'+128	;Capital O

	db	10,'D' 		;Capital P
	db	14,'Y'+128	;Capital Q
	db	12,'#' 		;Capital R
	db	10,'B' 		;Capital S

	db	12,'%' 		;Capital T
	db	12,'@' 		;Capital U
	db	10,'(' 		;Capital V
	db	14,'A' 		;Capital W

	db	12,'{' 		;Capital X
	db	12,'H' 		;Capital Y
	db	12,'[' 		;Capital Z
	db	06,'5' 		;Left Square Bracket (Open)

	db	08,'8' 		;Backslash
	db	06,'\'+128	;Right Square Bracket (Close)
	db	10,'|' 		;Carat
	db	10,'['+128	;Underscore

	db	10,',' 		;Accent
	db	08,'H'+128	;Lowercase a
	db	10,'d' 		;Lowercase b
	db	08,'x' 		;Lowercase c

	db	10,';' 		;Lowercase d
	db	08,'N'+128	;Lowercase e
	db	06,'&' 		;Lowercase f
	db	08,'k' 		;Lowercase g

	db	10,'B'+128	;Lowercase h
	db	06,'J'+128	;Lowercase i
	db	06,'l' 		;Lowercase j
	db	10,'a' 		;Lowercase k

	db	06,'g' 		;Lowercase l
	db	12,'u' 		;Lowercase m
	db	10,'L'+128	;Lowercase n
	db	10,'U'+128	;Lowercase o

	db	10,'s' 		;Lowercase p
	db	10,'y' 		;Lowercase q
	db	08,':' 		;Lowercase r
	db	08,'G'+128 	;Lowercase s

	db	06,'W'+128	;Lowercase t
	db	10,'b' 		;Lowercase u
	db	10,'r' 		;Lowercase v
	db	12,'o' 		;Lowercase w

	db	10,'i' 		;Lowercase x
	db	10,'m' 		;Lowercase y
	db	10,'h' 		;Lowercase z
	db	06,'-' 		;Left Curly Brace (Open)

	db	4,'`' 		;Vertical Bar
	db	06,'.' 		;Right Curly Brace (Close)
	db	10,'0' 		;Tilde
	db	0,0		;Delete Code (Not Used)

	end
