; module wsvtter.asm - for using wordstar v3.3 with vt100
;
; This module may be inserted between CP/M and the Decmation
; Bios to change terminal or printer characteristics
; All calls to the bios pass through here
;
; In order to use this a 63K cp/m can be created:
; A>MOVCPM 63 *
; A>SAVE 34 CPM63.COM
; A>DDT CPM63.COM
; -IRWS1.HEX
; -R
; -IRWS2.HEX
; -R2980
; -G0
; A>SAVE 37 RWS.COM
; A>RWS	(RUNS WORDSTAR WITH MODIFIED KEY ASSIGNMENTS ON VT100)
;
;
esc	equ	27
;
	org	0f600h	;start of bios for 63k CP/M
x	equ	0400h	;1024 byte offset
	jmp	$+x
wboot	equ	$+x
	jmp	wbootx	;warm boot call
contst	equ	$+x	;bios address for console ready check
	jmp	contsx	;console char ready check
			;returns A =ff for ready, 00 for not
conin	equ	$+x
	jmp	coninx	;get console char in A
conout	equ	$+x
	jmp	conoux	;console char out, sends C to console
	jmp	$+x	;list char out, sends C to list device
	jmp	$+x	;punch char out (C)
	jmp	$+x	;get reader char (A) (1AH=eof)
	jmp	$+x	;home (set disk track to 0)
	jmp	$+x	;seldsk (set current disk to value of C)
	jmp	$+x	;settrk BC contains track number
	jmp	$+x	;setsec BC contains disk sectory number
	jmp	$+x	;setdma BC contains DMA address for disk
	jmp	$+x	;read read 1 sector, return A=1 error, =0 
			;no error
	jmp	$+x	;write sector, A returned =1 error, =0
			;no error
	jmp	$+x	;listst test list ready A=0 not ready, ff
			;ready
	jmp	$+x	;sectran sector in in BC, out in HL
			;table in DE
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
;
; The codes esc [ M and esc [ L may be used for delete line and
; insert line respectively. These are standard ANSI codes for
; these functions, but are not recognized by the VT100. This
; routine catches these codes and transform them into a much
; more complicated sequence which accomplishes the same thing
; for the VT100. The use of terminal repeat keys, especially
; for scrolling, should be avoided. If more than 128 characters
; stack in the buffer here it will lose data and confuse 
; Wordstar.
;
;	The 4 arrow keys on the VT-100 are used for cursor positioning.
;
;	The auxillary keypad is used as follows:
;
;
;
;  ---------------------------------------------------------------------
;  |                |                |                |                |
;  |  Quick Menu    |  Block Menu    | Onscreen Menu  |  Help Menu     |
;  |  ^Q            |  ^K            | ^O             |  ^J            |
;  |                |                |                |                |
;  ---------------------------------------------------------------------
;  |                |                |                |                |
;  |  Scroll        |  Scroll Fast   |  Toggle        |  Print Menu    |
;  |  Forward       |  Forward       |  Insert mode   |  ^P            |
;  |  ^Z            |  ^C            |  ^V            |                |
;  ---------------------------------------------------------------------
;  |                |                |                |                |
;  |  Scroll        |  Scroll Fast   |  <--- Word     |  Word --->     |
;  |  Backwards     |  Backwards     |                |                |
;  |  ^W            |  ^R            |  ^A            |  ^F            |
;  ---------------------------------------------------------------------
;  |                |                |                |                |
;  |  Delete        |  Delete        |  Delete        |                |
;  |  Character     |  Word          |  Line          |                |
;  |  ^G            |  ^T            |  ^Y            |                |
;  ---------------------------------------------------|  Open          |
;  |                                 |                |  ^N            |
;  |             Reform              |  Search        |                |
;  |             ^B                  |  Again         |                |
;  |                                 |  ^L            |                |
;  ---------------------------------------------------------------------
;
;
;
ttable:	DB	5	; ESC O A  (^) --->  ^E (Cursor up)
	DB	24	; ESC O B  (v) --->  ^X (Cursor down)
	DB	4	; ESC O C  (>) --->  ^D (Cursor right)
	DB	19	; ESC O D  (<) --->  ^S (Cursor left)
	DB	0	; ESC O E
	DB	0	; ESC O F
	DB	0	; ESC O G
	DB	0	; ESC O H
	DB	0	; ESC O I
	DB	0	; ESC O J
	DB	0	; ESC O K
	DB	0	; ESC O L
	DB	14	; ESC O M (En) --->  ^N (Open)
	DB	0	; ESC O N
	DB	0	; ESC O O
	DB	17	; ESC O P (PF1)--->  ^Q (Quick Menu)
	DB	11	; ESC O Q (PF2)--->  ^K (Block Menu)
	DB	15	; ESC O R (PF3)--->  ^O (Onscreen Menu)
	DB	10	; ESC O S (PF4)--->  ^J (Help Menu)
	DB	0	; ESC O T
	DB	0	; ESC O U
	DB	0	; ESC O V
	DB	0	; ESC O W
	DB	0	; ESC O X
	DB	0	; ESC O Y
	DB	0	; ESC O Z
	DB	0	; ESC O [
	DB	0	; ESC O \
	DB	0	; ESC O ]
	DB	0	; ESC O ^
	DB	0	; ESC O _
	DB	0	; ESC O '
	DB	0	; ESC O a
	DB	0	; ESC O b
	DB	0	; ESC O c
	DB	0	; ESC O d
	DB	0	; ESC O e
	DB	0	; ESC O f
	DB	0	; ESC O g
	DB	0	; ESC O h
	DB	0	; ESC O i
	DB	0	; ESC O j
	DB	0	; ESC O k
	DB	6	; ESC O l (K,) --->  ^F (Word right)
	DB	16	; ESC O m (K-) --->  ^P (Print Menu)
	DB	12	; ESC O n (K.) --->  ^L (Search again)
	DB	0	; ESC O o
	DB	2	; ESC O p (K0) --->  ^B (Reform)
	DB	7	; ESC O q (K1) --->  ^G (Delete char)
	DB	20	; ESC O r (K2) --->  ^T (Delete word)
	DB	25	; ESC O s (K3) --->  ^Y (Delete line)
	DB	23	; ESC O t (K4) --->  ^W (Scroll back)
	DB	18	; ESC O u (K5) --->  ^R (Scroll Fast backwards)
	DB	1	; ESC O v (K6) --->  ^A (Word left)
	DB	26	; ESC O w (K7) --->  ^Z (Scroll Forward)
	DB	3	; ESC O x (K8) --->  ^C (Scroll Fast Forward)
	DB	22	; ESC O y (K9) --->  ^V (Toggle Insert mode)
; translation routine for input character stream
; to translate for wordstar
; detects cursor postion reports in incomming stream
; e.g.: ESC [ 1 ; 2 1 R
;
curpos:	db	0	;set to ff when postion report detected
rownum:	db	0,0,0,0		;rown number in ascii
colnum:	db	0,0,0,0	;col number in ascii
;
; places characters in a circular fifo from keyboard
;
trans:	call	conin	;get next char in A
	cpi	esc
	jz	tran2	;if start of escape sequence
tran1:	lxi	h,fifo
	call	putc	;stash character
	ret
tran2:	call	conin
	cpi	esc
	jz	tran1	;esc-esc is esc
	cpi	'O'	;aux keypad?
	jnz	tran5
; use ttable to translate next char
	call	conin
	sui	'A'
	mov	e,a
	mvi	d,0
	lxi	h,ttable
	dad	d
	mov	a,m	;get translated value
	jmp	tran1	;stash it
; test for [
tran5:	cpi	'['
	jnz	tran1	;illegal something, take it
; now start of cursor postion report
	lxi	h,rownum
	push	h
	call	conin
	pop	h
	cpi	'9'+1
	jnc	tran1	;not number
	cpi	'0'-1
	jc	tran1	;not number
	mov	m,a	;put away in row number
	inx	h
	push	h
	call	conin
	pop	h
	cpi	';'	;row col separator?
	jz	tran7	;if so terminate row number
	cpi	'9'+1
	jnc	tran1
	cpi	'0'-1
	jc	tran1
	mov	m,a	;put in row num
	inx	h
	push	h
	call	conin
	pop	h
	cpi	';'	;must be separator
	jnz	tran1
tran7:	xra	a
	mov	m,a	;terminate row num
; now parse the column number
	lxi	h,colnum
	push	h
	call	conin
	pop	h
	cpi	'9'+1
	jnc	tran1	;must be num
	cpi	'0'-1
	jc	tran1
	mov	m,a	;put away col digit
	inx	h
	push	h
	call	conin
	pop	h
	cpi	'R'	;end of report?
	jz	tran9
	cpi	'9'+1
	jnc	tran1
	cpi	'0'-1
	jc	tran1
	mov	m,a	;put digit
	inx	h
	push	h
	call	conin
	pop	h
	cpi	'R'	;must be R now
	jnz	tran1
tran9:	xra	a
	mov	m,a	;terminate col num
	mvi	a,0ffh
	sta	curpos	;set cursor position received flag
	ret
; general purpose routine to service a circular buffer fifo
; of 2**n bytes in lenght (n<=256)
; call with HL pointing to pointers and buffer, character
; passed in A
; pointers and buffer have format: mask, inptr, outptr, buffer
; mask masks a byte address to buffer size. For example, if the
; buffer length is 16 bytes, then mask is 00001111=0fh. inptr 
; points to next location to put a byte, outptr points to next 
; location to get a byte from. pointers are bytes such that
; a zero refers to first location in buffer. Buffer is empty
; if inptr=outptr. Buffer is full if mask .and. (inptr+1)=outptr
;
; put a character into the buffer
;
putc:	push b
	push	d
	push	h
	push	psw	;save regs, A on top
	mov	c,m	;get the mask in C
	inx	h
	mov	a,m	;get inptr
	inr	a	;does inptr+1=outptr (full?)
	ana	c	;mask inptr
	inx	h
	cmp	m
	jz	putc20	;if so toss char
	dcx	h	;replace inptr with inptr+1
	mov	m,a	;put it away
	dcr	a	;step inptr back
	ana	c	;mask
	mov	e,a	;set up DE with offset
	mvi	d,0
	inx	h
	inx	h	;point to buffer
	dad	d	;point to empty space
	pop	psw
	mov	m,a	;put away data
putc10:	pop	h
	pop	d
	pop	b
	ret
putc20:	pop	psw
	jmp	putc10	;error exit
;
;
; routine to get a character from fifo
; returns character in A
; enter with HL pointing to buffer structure

getc:	push	b
	push	d
	push	h
	mov	c,m	;mask to c
	inx	h
	mov	a,m	;the inptr
	inx	h
	cmp	m	;if equal, buffer empty
	jz	getc20	;error exit
	mov	a,m	;outptr
	mov	e,m
	mvi	d,0	;DE has offset
	inr	a	;step outptr
	ana	c	;mask it
	mov	b,a	;stash in b
	inx	h	;pt to buf
	dad	d	;pt to char
	mov	a,m	;char in A
	pop	h
	inx	h
	inx	h	;point to out ptr
	mov	m,b	;new outptr
	dcx	h
	dcx	h	;restore hl
	pop	d
	pop	b
	ret
getc20:	pop	h
	pop	d
	pop	d
	xra	a	;zero A on error exit
	ret
; routine to test for characters in buffer, returns 0 if empty
; otherwise ffh
;
tstchr:	inx	h
	mov	a,m	;inptr
	inx	h
	cmp	m
	jz	tstc5	;buffer empty
	mvi	a,0ffh
	ora	a	;set flags for caller
	dcx	h
	dcx	h
	ret
tstc5:	xra	a
	dcx	h
	dcx	h
	ret
;
; test for buffer full, returns 00 if full, otherwise ff
;
tstful:	push	h
	push	b
	mov	c,m	;mask
	inx	h
	mov	a,m	;inptr
	inr	a
	ana	c	;inc and mask
	inx	h
	cmp	m	;if equal, full
	jz	tstfl5
	mvi	a,0ffh
	ora	a
	pop	b
	pop	h
	ret
tstfl5:	xra	a
	pop	b
	pop	h
	ret
; the fifo
fifo:	db	07fh	;mask
	db	0,0	;inptr, outptr
	ds	128	;data storage
; routine to send char string ending in null
send:	mov	a,m	;enter with HL pointing to string
	ora	a
	rz		;end of string
	mov	c,a	;for conout
	inx	h	;next char
	push	h
	call	conout
	pop	h
	jmp	send	;loop till null
; routine to handle keyboard characte ready test
contsx:	lxi	h,fifo
	call	tstchr	;see if any in fifo
	rnz		;if yes send back offh
	jmp	contst	;call on bios to do test
; routine to handle requests for keyboard input
coninx:	lxi	h,fifo
	call	tstchr	;any in fifo?
	jnz	conx2	;jmp if yes
	call	trans	;attempt to fill up fifo
	jmp	coninx	;loop till something typed
conx2:	lxi	h,fifo
	call	getc	;get char from fifo
	ret
; routine to handle output to terminal
; extract special sequences esc [ M (L) delete (insert) line
;
; set keypad mode, cursor key, jump scroll, wrap off
initst:	db	esc,'=',esc,'[?1h',esc,'[?4l',esc,'[?7l',0
eflg:	db	0	;=0 no esc, =1 esc, =2 esc [ received
;
conoux:	mvi	a,0	;this zero subject to modification
	ora	a
	jnz	cn00
; here to send initialization string to terminal on
; first call to send to terminal
	push	b
	lxi	h,initst
	call	send
	pop	b
	mvi	a,0ffh
	sta	conoux+1	;instruction mod
cn00:	lda	eflg
	ora	a
	jnz	cn1
	mov	a,c	;char to send
	cpi	esc
	jz	cn01
	jmp	conout	;relay to system
cn01:	mvi	a,1	;escape received flag
	sta	eflg
	ret
cn1:	cpi	1	;already previous escape?
	jnz	cn2	;if not
;is next a [
	mov	a,c
	cpi	'['
	jnz	cn11
;yes [
	mvi	a,2	;flag for esc [ received
	sta	eflg
	ret
cn11:	push	b	;save this char, send prev esc
	mvi	c,esc
	call	conout
cn12:	pop	b
	call	conout
	xra	a
	sta	eflg
	ret
cn2:	mov	a,c	;previous esc [  what is this
	cpi	'M'
	jz	dellin	;esc [ M  is delete a line
	cpi	'L'
	jz	inslin	;esc [ L is insert a line
; none of those, must send previous not sent
	push	b	;save e
	mvi	c,esc
	call	conout
	mvi	c,'['
	call	conout
	jmp	cn12
;
; this routine attempts to get vt100 to report cursor position
; returns A=ff for ok, else 00. Complicated by possible buffering
; of characters in system
;
curreq:	db	esc,'[6n',0	;sequence to request report
;
getcur:	call	contst	; see if any characters ready now
	ora	a
	jz	gtc2	;if none ready
	call	trans	;get the old ready ones
	jmp	getcur	;empty stacked chars
; now ask vt100 for postion report
gtc2:	lxi	h,curreq	;escape code for request
	call	send	;send it
	xra	a
	sta	curpos	;set postion report not received flag
	mvi	a,25	;don't hang for more than 25 chars waiting
gtc4:	push	psw	;save a
	call	trans
	lda	curpos
	ora	a
	jnz	gtc5	;postion report received!
	pop	psw
	dcr	a
	jnz	gtc4	;loop up to 25 times
	xra	a	;error flag
	ret
gtc5:	pop	psw
	mvi	a,0ffh	;good flag
	ora	a
	ret		;no error return
;
; different sequences to send
seq1:	db	esc,'[',0
seq2:	db	';',0
seq3:	db	';24r',0	;tail of scroll window setup
seq4:	db	';1H',0		;tail of cursor postion
seq5:	db	esc,'[24;1H',0	;position at bottom
;
;routine to set scrolling region
setscr:	lxi	h,seq1
	call	send
	lxi	h,rownum
	call	send
	lxi	h,seq3
	call	send
	ret
; here to delete a line
dellin:	call	getcur
	rz		;bad get postion
; if cursor on line 24 special case
	lda	rownum
	cpi	'2'
	jnz	del3
	lda	rownum+1
	cpi	'4'
	jnz	del3
; send esc [ 2 K to erase line 24 which has cursor
deler:	lxi	h,erlin
	call	send
	ret
erlin:	db	esc,'[2K',0
rindex:	db	esc,'M',0	;reverse index
index:	db	esc,'D',0	;index (LF)
seqh:	db	'H',0
noscr:	db	esc,'[1;24r',0	;normal full screen scroll window
;
del3:	call	setscr	;set scrolling window
	lxi	h,seq5	;postion cursor at bottom
	call	send
	lxi	h,index	;scroll windo up
	call	send
	lxi	h,noscr	;full screen scrolling
	call	send
; put cursor back
deldon:	lxi	h,seq1
	call	send
	lxi	h,rownum
	call	send
	lxi	h,seq2	;separator ;
	call	send
	lxi	h,colnum
	call	send
	lxi	h,seqh
	call	send
	ret
; routine to insert a line at cursor postion
;
inslin:	call	getcur
	ora	a
	rz		;ignore if can't get cursor postion
; line 24 is special case
	lda	rownum
	cpi	'2'
	jnz	ins2
	lda	rownum+1
	cpi	'4'
	jnz	ins2
; for row 24 erase the line
	jmp	deler
;
ins2:	call	setscr	;set scrolling region from cursor to bottom
	call	deldon	;repostion cursor on line
	lxi	h,rindex	;send revers index to scroll down
	call	send
	lxi	h,noscr	;disable scrolling region
	call	send
	jmp	deldon	;restore cursor postion
; here on exiting program, reset terminal
;
wbootx:	lxi	h,tstr
	call	send
	jmp	wboot
; terminal string for terminal
tstr:	db	esc,'[?1l',esc,'>',0	;cursor key mode, applic mode, off
