M"  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt  ,       StampElems Alloc 26 May 94          ?        *    l    0        !        %       Syntax10b.Scn.Fnt                                          
                                                            	                    
        `    
                    0        /    @            0        /    B    
            	    #                                                                                    .                                                                                                                    8  FoldElems New $   Syntax10i.Scn.Fnt         graphic  $  j GraphicElems Alloc  Curves New  0 @         Syntax10.Scn.Fnt $y    X1, Y1  P 0      P<    L $       X, Y            >    System.Close  p    Rectangles New  0p `    P#    Display        QL    Origin of model (M    Frame  q    Xa, Ya  9    x, y pP  8               !        
            	            
                                                                                 nN '  LineElems Alloc  ?                M                N    8   T    8       8      8           E '   
        '            8           A        #        %        9            8   
        *    +            8      8   4    8   U    8   7                    8                   h    8   7                    8                   y    8   9                    8                   j    8   :                    8                            
        N    8   k       *        E    8      8   
                7    8                  1           8   B    8           P   8   
        "                            8   J       W        U        @                      u        T        d        T        d        e        u                                        e    /    9   8   5    8   Y   8   
            8           G        @                K        L        N        1                6        '        "        
    8   5    8   Y   8   
            8           H        A                L        M        O        *                .        1        6        d    8   5    8   W   8   
            8           C        K                P        N        S        *                .        7    "        8   5    8   W   8   
            8           B        J                O        M        R        1            "    7        %            8   
        5    8              .        8   
        6    8              /        8   
    	    "    8           ]           8   
    	    +    8       8   
    	    ,    8       8   
            8       8   
            8       8   
            8       8   
            8       8   
        
    8   w   8   
    	    n    8           8  $   Syntax12i.Scn.Fnt         graphic * @' d    o    p    <        Syntax10.Scn.Fnt       repV h     repU         @     cellV X    `    `     cellU h    d     =    secV ( D   <  x       secU      ` |    Rectangles New                                           t      d      d t     t t      t      t      t      t      t      t      t      d      d      d      d      d      d      d     t d     d d     d T     t T      T      T      T      T      T      T      T      D      D      D      D      D      D      D     t D     d D     d 4     t 4      4      4      4      4      4      4      4      $      $      $      $      $      $      $     t $     d $     d      t                                                                                          t      d       K    repRow = TRUE  D    repCol = TRUE K  8                         8   
        
    8               8       8               +    *        5    .         '    *    '    :    G    5    .         '    *    '    :    A        $        D                        t                        d                                                                                           
    K        	        M                                               K        
        ]                        p               +        	        ]                                        q                                       /    8   
        
    8   J    8   
        3    8                   -        Z           8   
    	    $    8   E        
        '        
        &        
        &        
                :                +                        l    8   
    	    $    8   O                )                )                (                g                    8   
            
        
        8      8   
            8   I            8   
        "    8   f   8   
    	    ,    8      8   
    	    +    8   u   8   
                        8      +    (   8       8       8       դ  MODULE CLFramesD;	(** NW 2.8.92 / 20.10.92, SHML 30 Oct 92 /  **)
	(* 27 Apr 94: added support for undo (field b in FrameDesc) *)
	(* 19 May 94: new font pattern numbers *)

	IMPORT Display, Printer, Viewers, Fonts, Oberon, CLGAs;

	CONST
		Dim = CLGAs.Dim; Sector = CLGAs.Sector;	(* dimension of chip/sector (e.g. 8x8 cells) *)
		RepW = 16; RepPerCell = 5; CellW = RepPerCell*RepW; PadW = 2*RepW;
		RepPerSector = Sector*RepPerCell;
		CellLen = CellW-25; PadLen = CellW-RepW+1;
		SWPadRep = -2; NEPadRep = Dim DIV Sector * (RepPerSector+1);	(* repeater coords for border *)
		AOff = 20; BOff = 28;	(* offsets of A_input and B_input *)
		cellSel* = 0; nRepSel* = 1; sRepSel* = 2; wRepSel* = 3; eRepSel* = 4;
		nPadSel* = 5; sPadSel* = 6; wPadSel* = 7; ePadSel* = 8;	(** values of Frame.selTyp **)
		cellMode* = 0; (*localMode* = 1; expressMode* = 2; gridMode = 3;*)	(** bits for Frame.mode **)
		EBusCol = 1; LBusCol = 2; CellCol = 14(*11*); PadCol = 14(*11*); ConnCol = 12; LabelCol = 14;	(* colors *)
		PatternFontName = "CLi.Scn.Fnt"; PrinterLabelFont = "CLi10.Scn.Fnt";
		drawMode = Display.replace; patternMode = Display.replace;

	TYPE
		BusCache* = POINTER TO RECORD
				localNS*: ARRAY Dim DIV Sector, Dim, 2 OF BOOLEAN;
				localWE*: ARRAY Dim, Dim DIV Sector, 2 OF BOOLEAN;
				(** is local bus of sector u, v north/south/west/east used? **)
				expNS*: ARRAY Dim DIV Sector, Dim, 2 OF BOOLEAN;
				expWE*: ARRAY Dim, Dim DIV Sector, 2 OF BOOLEAN;
				(** is express bus of sector u, v north/south/west/east used? **)
		END;
		Frame* = POINTER TO FrameDesc;
		FrameDesc* = RECORD (Display.FrameDesc)
				a*, b*: CLGAs.GA;	(** original, backup  **)
				cache*: BusCache;	(** display oriented data **)
				selU*, selV*, selW*, selH*, selTyp*: INTEGER;	(** array coordinates & type of selection **)
				time*: LONGINT;	(** of selection **)
				x*, y*, Xa*, Ya*, X1*, Y1*: INTEGER;	(** read only! **)
				mode*: SET;	(** of display **)
				selected*, print*: BOOLEAN
			END;
		(**)

		SelMsg* = RECORD (Display.FrameMsg)
			f*: Frame;
			time*: LONGINT
		END;

		UpdateMsg* = RECORD (Display.FrameMsg) a*: CLGAs.GA; u*, v*: INTEGER END;

		CellMsg* = RECORD (UpdateMsg) w*, h*: INTEGER END;

		PadMsg* = RECORD (UpdateMsg) side*: SHORTINT END;

		RepMsg* = RECORD (UpdateMsg) typ*: SHORTINT END;

		Pattern = RECORD x, y: INTEGER; p: Display.Pattern END;

		Pen = RECORD F: Frame; col, x, y: INTEGER END;

	VAR
		syn8, syn10, syn12, cli: Fonts.Font;
		pat: ARRAY 256 OF Pattern;
		pat0, pat1, patSer, patPar: Pattern;

	(* Support *) 

	PROCEDURE Min(x, y: INTEGER): INTEGER;	BEGIN IF x <= y THEN RETURN x ELSE RETURN y END END Min;
	PROCEDURE Max(x, y: INTEGER): INTEGER;	BEGIN IF x >= y THEN RETURN x ELSE RETURN y END END Max;

	PROCEDURE InitFont(VAR f: Fonts.Font; name: ARRAY OF CHAR);	
	BEGIN f := Fonts.This(name); IF f = NIL THEN f := Fonts.Default END
	END InitFont;

	PROCEDURE InitPatterns;	
		VAR i, dx, w, h: INTEGER;
	BEGIN
		FOR i := 0 TO LEN(pat)-1 DO Display.GetChar(cli.raster, CHR(i), dx, pat[i].x, pat[i].y, w, h, pat[i].p) END;
		Display.GetChar(syn8.raster, "0", dx, pat0.x, pat0.y, w, h, pat0.p);
		Display.GetChar(syn8.raster, "1", dx, pat1.x, pat1.y, w, h, pat1.p);
		Display.GetChar(syn8.raster, "-", dx, patSer.x, patSer.y, w, h, patSer.p);
		Display.GetChar(syn8.raster, "|", dx, patPar.x, patPar.y, w, h, patPar.p)
	END InitPatterns;

	(** Frame procedures **) 

	PROCEDURE Block*(F: Frame; col, x, y, w, h: INTEGER);	(* Clipped block *) 	
	BEGIN
		IF F.print (*& (2*x < F.X) & (2*y < F.Y) & (2*x+2*w < F.X1) & (2*y+2*h < F.Y1)*) THEN Printer.ReplConst(x, y, w, h)(*Printer.ReplConst(2*x, 2*y, 2*w, 2*h)*)
		ELSE Display.ReplConstC(F, col, x, y, w, h, drawMode)
		END
	END Block;

	PROCEDURE Rect*(F: Frame; col, x, y, w, h, d: INTEGER);	(* Clipped rectangle with border_thickness d *)	
	BEGIN
		IF d = -1 THEN
			IF F.print THEN
				Block(F, col, x, y, w, 1); Block(F, col, x, y+h-1, w, 1);
				Block(F, col, x, y+1, 1, h-2*1); Block(F, col, x+w-1, y+1, 1, h-2*1)
			ELSE
				Display.ReplPatternC(F, col, Display.grey1, x, y, w, 1, F.Xa, F.Ya, drawMode);
				Display.ReplPatternC(F, col, Display.grey1, x, y+h-1, w, 1, F.Xa, F.Ya, drawMode);
				Display.ReplPatternC(F, col, Display.grey1, x, y+1, 1, h-2, F.Xa, F.Ya, drawMode);
				Display.ReplPatternC(F, col, Display.grey1, x+w-1, y+1, 1, h-2, F.Xa, F.Ya, drawMode)
			END
		ELSE
			Block(F, col, x, y, w, d); Block(F, col, x, y+h-d, w, d);
			Block(F, col, x, y+d, d, h-2*d); Block(F, col, x+w-d, y+d, d, h-2*d)
		END
	END Rect;

	PROCEDURE Invert(F: Frame; x, y, w, h: INTEGER);	
	BEGIN Display.ReplConstC(F, Display.white, x, y, w, h, Display.invert)
	END Invert;

	PROCEDURE DnArrow(F: Frame; col, x, y, l: INTEGER);	(* v *)	
	BEGIN	(* l >= 3 *)
		Block(F, col, x, y, 1, l); Block(F, col, x-1, y+1, 3, 1); Block(F, col, x-2, y+2, 5, 1)
	END DnArrow;

	PROCEDURE UpArrow(F: Frame; col, x, y, l: INTEGER);	(* ^ *)	
	BEGIN	(* l >= 3 *)
		Block(F, col, x, y-l, 1, l); (*INC(y, l);*) Block(F, col, x-2, y-3, 5, 1); Block(F, col, x-1, y-2, 3, 1)
	END UpArrow;

	PROCEDURE LeftArrow(F: Frame; col, x, y, l: INTEGER);	(* < *)	
	BEGIN	(* l >= 3 *)
		Block(F, col, x, y, l, 1); Block(F, col, x+1, y-1, 1, 3); Block(F, col, x+2, y-2, 1, 5)
	END LeftArrow;

	PROCEDURE RightArrow(F: Frame; col, x, y, l: INTEGER);	(* > *)	
	BEGIN	(* l >= 3 *)
		Block(F, col, x-l, y, l, 1); (*INC(x, l);*) Block(F, col, x-3, y-2, 1, 5); Block(F, col, x-2, y-1, 1, 3)
	END RightArrow;

	PROCEDURE Set(VAR p: Pen; x, y: INTEGER);	BEGIN p.x := x; p.y := y END Set;

	PROCEDURE Up(VAR p: Pen; d: INTEGER);	BEGIN Block(p.F, p.col, p.x, p.y, 1, d+1); INC(p.y, d) END Up;

	PROCEDURE Dn(VAR p: Pen; d: INTEGER);	BEGIN DEC(p.y, d); Block(p.F, p.col, p.x, p.y, 1, d+1) END Dn;

	PROCEDURE Left(VAR p: Pen; d: INTEGER);	BEGIN DEC(p.x, d); Block(p.F, p.col, p.x, p.y, d+1, 1) END Left;

	PROCEDURE Right(VAR p: Pen; d: INTEGER);	BEGIN Block(p.F, p.col, p.x, p.y, d+1, 1); INC(p.x, d) END Right;

	PROCEDURE PrintString(x, y: INTEGER; string, fontName: ARRAY OF CHAR);
	BEGIN Printer.String(x, y, string, fontName)(*Printer.String(2*x, 2*y, string, fontName)*)
	END PrintString;

	PROCEDURE WriteInt(F: Frame; k, x, y: INTEGER);	
		VAR dx, x1, y1, w1, h1: INTEGER; p: Display.Pattern; fnt: Fonts.Font; s: ARRAY 32 OF CHAR;
	BEGIN
		fnt := syn12;
		IF (x >= F.X) & (x+2*fnt.height <= F.X1) & (y >= F.Y) & (y+fnt.height <= F.Y1) THEN
			IF F.print THEN
				s[0] := CHR(k DIV 10 + 30H); s[1] := CHR(k MOD 10 + 30H); s[2] := 0X;
				PrintString(x, y, s, PrinterLabelFont)
			ELSE
				Display.GetChar(fnt.raster, CHR(k DIV 10 + 30H), dx, x1, y1, w1, h1, p);
				Display.CopyPattern(LabelCol, p, x+x1, y+y1, patternMode); INC(x, dx);
				Display.GetChar(fnt.raster, CHR(k MOD 10 + 30H), dx, x1, y1, w1, h1, p);
				Display.CopyPattern(LabelCol, p, x+x1, y+y1, patternMode)
			END
		END
	END WriteInt;

	PROCEDURE CopyPattern*(col, x, y: INTEGER; ch: INTEGER);
	BEGIN Display.CopyPattern(col, pat[ch].p, x+pat[ch].x, y+pat[ch].y, patternMode)
	END CopyPattern;

	PROCEDURE CellPattern*(F: Frame; col, x, y: INTEGER; VAR cell: CLGAs.Cell);	
		VAR left, right, lL, lR, uL, uR: INTEGER; s: ARRAY 3 OF CHAR; in: BOOLEAN;
	BEGIN
		IF cell.routing # CLGAs.None THEN
			lL := 21H; lR := 24H; uL := 26H; uR := 2BH;	(* default *)
			CASE cell.routing OF
			| CLGAs.Turn0: uR := 2AH
			| CLGAs.TurnB:
			| CLGAs.Read: uL := 28H
			| CLGAs.Mux:
				IF cell.state IN {CLGAs.State2, CLGAs.State3} THEN uL := 36H ELSE uL := 29H; uR := 2CH END
			| CLGAs.Write: IF (cell.nsL # CLGAs.None) OR (cell.weL # CLGAs.None) THEN lL := 22H END
			| CLGAs.TS:
				IF (cell.nsL # CLGAs.None) OR (cell.weL # CLGAs.None) THEN lL := 23H; lR := 25H; uL := 27H; uR := 2DH
				ELSE uR := 2AH
				END
			END;
			IF cell.a = CLGAs.None THEN INC(uL, 60H) END;	(* constant 1 *)
			IF cell.b = CLGAs.None THEN INC(uR, 60H) END;	(* constant 1 *)
			IF F.print THEN
				s[2] := 0X;
				s[0] := CHR(lL); s[1] := CHR(lR); PrintString(x, y, s, PatternFontName);
				s[0] := CHR(uL); s[1] := CHR(uR); PrintString(x, y+32, s, PatternFontName)
			ELSE
				Display.CopyPatternC(F, col, pat[lL].p, x+pat[lL].x, y+pat[lL].y, patternMode);
				Display.CopyPatternC(F, col, pat[lR].p, x+32+pat[lR].x, y+pat[lR].y, patternMode);
				Display.CopyPatternC(F, col, pat[uL].p, x+pat[uL].x, y+32+pat[uL].y, patternMode);
				Display.CopyPatternC(F, col, pat[uR].p, x+32+pat[uR].x, y+32+pat[uR].y, patternMode)
			END
		END;
		IF cell.state # CLGAs.None THEN
			in := TRUE;
			INC(y, 11);
			CASE cell.state OF
			| CLGAs.State0: left := 2EH; right := 2FH
			| CLGAs.State1: left := 30H; right := 31H
			| CLGAs.State2:
				IF cell.routing = CLGAs.Mux THEN left := 37H; right := 39H
				ELSIF cell.routing IN {CLGAs.TS, CLGAs.Turn0} THEN left := 2EH; right := 95H; in := FALSE
				ELSIF cell.routing = CLGAs.Read THEN
					in := FALSE;
					IF cell.b = CLGAs.None THEN left := 3CH; right := 3EH
					ELSE left := 32H; right := 33H
					END
				ELSIF cell.a = CLGAs.None THEN left := 3BH; right := 3DH
				ELSIF cell.b = CLGAs.None THEN left := 3CH; right := 3EH
				ELSE left := 32H; right := 33H
				END
			| CLGAs.State3:
				IF cell.routing = CLGAs.Mux THEN left := 38H; right := 3AH
				ELSIF cell.routing IN {CLGAs.TS, CLGAs.Turn0} THEN left := 43H; right := 93H; in := FALSE
				ELSIF cell.routing = CLGAs.Read THEN
					in := FALSE;
					IF cell.b = CLGAs.None THEN left := 40H; right := 42H
					ELSE left := 34H; right := 35H
					END
				ELSIF cell.a = CLGAs.None THEN left := 3FH; right := 41H
				ELSIF cell.b = CLGAs.None THEN left := 40H; right := 42H
				ELSE left := 34H; right := 35H
				END
			END;
			IF in & (cell.a = CLGAs.None) & (cell.b = CLGAs.None) THEN INC(left, 60H); INC(right, 60H) END;
			IF F.print THEN s[0] := CHR(left); s[1] := CHR(right); s[2] := 0X; PrintString(x, y, s, PatternFontName)
			ELSE
				Display.CopyPatternC(F, col, pat[left].p, x+pat[left].x, y+pat[left].y, patternMode);
				Display.CopyPatternC(F, col, pat[right].p, x+32+pat[right].x, y+pat[right].y, patternMode)
			END
		END
	END CellPattern;

	PROCEDURE Label(F: Frame; u, v, x, y: INTEGER; sig: SHORTINT);	
		VAR label: CLGAs.Label; i, dx, cx, cy, w, h, Y, W, H: INTEGER; p: LONGINT; ch: CHAR;
	BEGIN
		label := CLGAs.LabelAt(F.a, u, v, sig);
		IF label # NIL THEN
			IF F.print THEN PrintString(x, y, label.name, PrinterLabelFont)
			ELSE
				IF F.X < 4096 THEN	(* not printer bitmap *)
					Y := y; W := 0; H := 0; i := 0; ch := label.name[0];
					WHILE ch # 0X DO
						Display.GetChar(syn8.raster, ch, dx, cx, cy, w, h, p);
						INC(W, dx); H := Max(h, H); Y := Min(Y, y+cy);
						INC(i); ch := label.name[i]
					END;
					Display.ReplConstC(F, Display.black, x-1, Y-1, W+2, H+2+(y-Y), Display.replace)
				END;
				i := 0; ch := label.name[0];
				WHILE ch # 0X DO
					Display.GetChar(syn8.raster, ch, dx, cx, cy, w, h, p);
					Display.CopyPatternC(F, LabelCol, p, x+cx, y+cy, patternMode);
					INC(x, dx); INC(i); ch := label.name[i]
				END
			END
		END
	END Label;

	PROCEDURE Cell*(F: Frame; x, y, u, v: INTEGER);	(* draw cell at x, y (cell's lower left corner) *)	
		VAR cell: CLGAs.Cell; su, sv, len: INTEGER; drawCell: BOOLEAN; cache: BusCache;
		PROCEDURE LOut(dir: SHORTINT);
		BEGIN
			CASE dir OF
			| CLGAs.None:
			| CLGAs.North: UpArrow(F, ConnCol, x+(CellW DIV 2), y+(CellW-6), 5)
			| CLGAs.South: DnArrow(F, ConnCol, x+(CellW DIV 2), y+7, 5)
			| CLGAs.East: RightArrow(F, ConnCol, x+(CellW-6), y+(CellW DIV 2), 5)
			| CLGAs.West: LeftArrow(F, ConnCol, x+7, y+(CellW DIV 2), 5)
			END
		END LOut;
		PROCEDURE LIn(dir: SHORTINT);
		BEGIN
			CASE dir OF
			| CLGAs.None:
			| CLGAs.North: DnArrow(F, ConnCol, x+(CellW DIV 2), y+(CellW-11), 5)
			| CLGAs.South: UpArrow(F, ConnCol, x+(CellW DIV 2), y+12, 5)
			| CLGAs.East: LeftArrow(F, ConnCol, x+(CellW-11), y+(CellW DIV 2), 5)
			| CLGAs.West: RightArrow(F, ConnCol, x+12, y+(CellW DIV 2), 5)
			END
		END LIn;
		PROCEDURE LConn(dir: SHORTINT);
		BEGIN
			CASE dir OF
			| CLGAs.None:
			| CLGAs.North: Block(F, ConnCol, x+(CellW DIV 2 -1), y+(CellW-11), 2, 5)
			| CLGAs.South: Block(F, ConnCol, x+(CellW DIV 2 -1), y+7, 2, 5)
			| CLGAs.East: Block(F, ConnCol, x+(CellW-11), y+(CellW DIV 2 -1), 5, 2)
			| CLGAs.West: Block(F, ConnCol, x+7, y+(CellW DIV 2 -1), 5, 2)
			END
		END LConn;
	BEGIN
		cell := F.a.c[u, v]; cache := F.cache;
		drawCell := (cellMode IN F.mode) OR
			(cell.routing+cell.state+cell.a+cell.b+cell.weL+cell.nsL # 6*CLGAs.None);
		(*IF ~drawCell & ~F.print THEN Rect(F, CellCol, x+12, y+12, CellLen+2, CellLen+2, 1) END;*)
		IF drawCell THEN
			Rect(F, CellCol, x+12, y+12, CellLen+2, CellLen+2, 1(*, 2*));	(* cell frame *)
			CellPattern(F, ConnCol, x+15, y+14, cell);
			CASE cell.a OF	(* a_input *)
			| CLGAs.None:
			| CLGAs.North:
				IF (v MOD Sector = Sector-1) & (v # Dim-1) THEN len := 11+RepW ELSE len := 11 END;
				DnArrow(F, ConnCol, x+AOff, y+(CellW-11), len)
			| CLGAs.South:
				IF (v MOD Sector = 0) & (v # 0) THEN len := 12+RepW ELSE len := 12 END;
				UpArrow(F, ConnCol, x+(CellW-AOff), y+12, len)
			| CLGAs.West:
				IF (u MOD Sector = 0) & (u # 0) THEN len := 12+RepW ELSE len := 12 END;
				RightArrow(F, ConnCol, x+12, y+(CellW-AOff), len)
			| CLGAs.East:
				IF (u MOD Sector = Sector-1) & (u # Dim-1) THEN len := 11+RepW ELSE len := 11 END;
				LeftArrow(F, ConnCol, x+(CellW-11), y+AOff, len)
			END;
			CASE cell.b OF	(* b_input *)
			| CLGAs.None:
			| CLGAs.North:
				IF (v MOD Sector = Sector-1) & (v # Dim-1) THEN len := 11+RepW ELSE len := 11 END;
				DnArrow(F, ConnCol, x+(CellW-BOff), y+(CellW-11), len)
			| CLGAs.South:
				IF (v MOD Sector = 0) & (v # 0) THEN len := 12+RepW ELSE len := 12 END;
				UpArrow(F, ConnCol, x+BOff, y+12, len)
			| CLGAs.West:
				IF (u MOD Sector = 0) & (u # 0) THEN len := 12+RepW ELSE len := 12 END;
				RightArrow(F, ConnCol, x+12, y+BOff, len)
			| CLGAs.East:
				IF (u MOD Sector = Sector-1) & (u # Dim-1) THEN len := 11+RepW ELSE len := 11 END;
				LeftArrow(F, ConnCol, x+(CellW-11), y+(CellW-BOff), len)
			END;
			IF cell.routing IN {CLGAs.Write, CLGAs.TS} THEN LOut(cell.nsL); LOut(cell.weL)
			ELSIF (cell.routing = CLGAs.None) OR (cell.routing IN {CLGAs.TurnB, CLGAs.Turn0}) THEN
				LConn(cell.nsL); LConn(cell.weL)
			ELSE LIn(cell.nsL); LIn(cell.weL)
			END;
			Block(F, ConnCol, x+(BOff-2), y+(CellW-10), 5, 1); Block(F, ConnCol, x+BOff, y+(CellW-9), 1, 9);	(* N-output markers, B *)
			Block(F, ConnCol, x+(CellW-(AOff+2)), y+(CellW-11), 5, 2); Block(F, ConnCol, x+(CellW-AOff), y+(CellW-9), 1, 9);	(* A *)
			Block(F, ConnCol, x+AOff, y, 1, 10); Block(F, ConnCol, x+(AOff-2), y+10, 5, 2);	(* S-output markers, A *)
			Block(F, ConnCol, x+(CellW-BOff), y, 1, 10); Block(F, ConnCol, x+(CellW-(BOff+2)), y+10, 5, 1);	(* B *)
			Block(F, ConnCol, x, y+AOff, 10, 1); Block(F, ConnCol, x+10, y+(AOff-2), 2, 5);	(* W-output markers, A *)
			Block(F, ConnCol, x, y+(CellW-BOff), 10, 1); Block(F, ConnCol, x+10, y+(CellW-(BOff+2)), 1, 5);	(* B *)
			Block(F, ConnCol, x+(CellW-10), y+(BOff-2), 1, 5); Block(F, ConnCol, x+(CellW-9), y+BOff, 9, 1);	(* E-output markers, B *)
			Block(F, ConnCol, x+(CellW-11), y+(CellW-(AOff+2)), 2, 5); Block(F, ConnCol, x+(CellW-9), y+(CellW-AOff), 9, 1);	(* A *)
		END;
		su := u DIV Sector; sv := v DIV Sector;
		IF cache.expWE[u, sv, CLGAs.West MOD 2] THEN Block(F, EBusCol, x+3, y, 1, CellW) END;	(* NS express bus lines *)
		IF cache.expWE[u, sv, CLGAs.East MOD 2] THEN Block(F, EBusCol, x+(CellW-3), y, 1, CellW) END;
		IF cache.expNS[su, v, CLGAs.South MOD 2] THEN Block(F, EBusCol, x, y+3, CellW, 1) END;	(* WE express bus lines *)
		IF cache.expNS[su, v, CLGAs.North MOD 2] THEN Block(F, EBusCol, x, y+(CellW-3), CellW, 1) END;
		IF cache.localWE[u, sv, CLGAs.West MOD 2] THEN Block(F, LBusCol, x+6, y, 1, CellW) END;	(* NS local bus lines *)
		IF cache.localWE[u, sv, CLGAs.East MOD 2] THEN Block(F, LBusCol, x+(CellW-6), y, 1, CellW) END;
		IF cache.localNS[su, v, CLGAs.South MOD 2] THEN Block(F, LBusCol, x, y+6, CellW, 1) END;	(* WE local bus lines *)
		IF cache.localNS[su, v, CLGAs.North MOD 2] THEN Block(F, LBusCol, x, y+(CellW-6), CellW, 1) END;
		(* labels have to be drawn after all lines! *)
		IF drawCell THEN
			Label(F, u, v, x+(AOff-10), y+2, CLGAs.AOut); Label(F, u, v, x+(CellW-BOff-2), y+2, CLGAs.BOut)
		END;
		IF u MOD CLGAs.Sector = 0 THEN
			Label(F, u, v, x-8, y+(CellW-4), CLGAs.EBusN); Label(F, u, v, x-8, y, CLGAs.EBusS);
			Label(F, u, v, x-8, y+(CellW-14), CLGAs.LBusN); Label(F, u, v, x-8, y+8, CLGAs.LBusS)
		END;
		IF v MOD CLGAs.Sector = 0 THEN
			Label(F, u, v, x-8, y-8, CLGAs.EBusW); Label(F, u, v, x+(CellW-4), y-8, CLGAs.EBusE);
			Label(F, u, v, x+8, y-8, CLGAs.LBusW); Label(F, u, v, x+(CellW-14), y-8, CLGAs.LBusE)
		END
	END Cell;

	PROCEDURE NPadPat(F: Frame; x, y, w, k: INTEGER);	
		VAR p: Pattern; s: ARRAY 2 OF CHAR;
	BEGIN
		IF F.print THEN
			CASE F.a.p[CLGAs.North, k DIV 2].selector OF
			| CLGAs.TSOff: s[0] := "0"
			| CLGAs.TSOn: s[0] := "1"
			| CLGAs.TSSerial: s[0] := "|"
			| CLGAs.TSParallel: s[0] := "-"
			END;
			s[1] := 0X; PrintString(x+w DIV 2 - 2, y+5, s, PrinterLabelFont)
		ELSE
			CASE F.a.p[CLGAs.North, k DIV 2].selector OF
			| CLGAs.TSOff: p := pat0
			| CLGAs.TSOn: p := pat1
			| CLGAs.TSSerial: p := patPar
			| CLGAs.TSParallel: p := patSer
			END;
			Display.CopyPatternC(F, PadCol, p.p, x+p.x+w DIV 2 - 2, y+p.y+5, patternMode)
		END
	END NPadPat;

	PROCEDURE NPad*(F: Frame; x, y, k: INTEGER);	
		VAR ww, w: INTEGER; pen: Pen;
	BEGIN
		IF k MOD Sector = 7 THEN ww := RepW; w := PadLen+RepW ELSE ww := 0; w := PadLen END;
		pen.F := F; pen.col := ConnCol;
		(* input cell *)
		Set(pen, x+(CellW-3), y); Up(pen, 3); Left(pen, AOff-3); Dn(pen, 3);	(* E_bus to A-output *)
		Set(pen, x+3, y); Up(pen, 3); Right(pen, BOff-3); Dn(pen, 3);	(* E_bus to B-output *)
		(* output cell *)
		Set(pen, x+(CellW+3)+ww, y); Up(pen, 3); Right(pen, AOff-3); Dn(pen, 3);	(* E_bus to A-input *)
		Set(pen, x+(2*CellW-3)+ww, y); Up(pen, 3); Left(pen, BOff-3); Dn(pen, 3);	(* E_bus to B-input *)
		Set(pen, x+(CellW-BOff), y); Up(pen, 6); Right(pen, 2*BOff+ww); Dn(pen, 6);	(* B_output to B_input *)
		INC(x, RepW DIV 2+CellW DIV 2); INC(y, RepW); 	(* draw pad *)
		Rect(F, PadCol, x, y, w, RepW, 1(*, 2*)); NPadPat(F, x, y, w, k); Label(F, k DIV 2, Dim, x+w+3, y+3, CLGAs.AOut);
		pen.col := ConnCol; Set(pen, x-BOff, y-RepW); Up(pen, 10); Right(pen, 40); Up(pen, 3);
		Block(F, ConnCol, x+10, y-2, 5, 2);	(* A_output marker *)
		INC(x, w);
		Block(F, ConnCol, x+27, y-RepW, 1, 10);	(* from cell's A_output up *)
		Block(F, ConnCol, x-12, y-6, 40, 1);	(* left *)
		UpArrow(F, ConnCol, x-13, y, 6)	(* to pad *)
	END NPad;

	PROCEDURE SPadPat(F: Frame; x, y, w, k: INTEGER);	
		VAR p: Pattern; s: ARRAY 2 OF CHAR;
	BEGIN
		IF F.print THEN
			CASE F.a.p[CLGAs.South, k DIV 2].selector OF
			| CLGAs.TSOff: s[0] := "0"
			| CLGAs.TSOn: s[0] := "1"
			| CLGAs.TSSerial: s[0] := "|"
			| CLGAs.TSParallel: s[0] := "-"
			END;
			s[1] := 0X; PrintString(x+w DIV 2 - 2, y+5, s, PrinterLabelFont)
		ELSE
			CASE F.a.p[CLGAs.South, k DIV 2].selector OF
			| CLGAs.TSOff: p := pat0
			| CLGAs.TSOn: p := pat1
			| CLGAs.TSSerial: p := patPar
			| CLGAs.TSParallel: p := patSer
			END;
			Display.CopyPatternC(F, PadCol, p.p, x+p.x+w DIV 2 - 2, y+p.y+5, patternMode)
		END
	END SPadPat;

	PROCEDURE SPad*(F: Frame; x, y, k: INTEGER);	
		VAR w, ww, yy: INTEGER; pen: Pen;
	BEGIN
		IF k MOD Sector = 7 THEN ww := RepW; w := PadLen+RepW ELSE ww := 0; w := PadLen END;
		pen.F := F; pen.col := ConnCol; yy := y+(PadW-1);
		(* output cell *)
		Set(pen, x+(CellW-3), yy); Dn(pen, 3); Left(pen, AOff-3); Up(pen, 3);	(* E_bus to A-input *)
		Set(pen, x+3, yy); Dn(pen, 3); Right(pen, BOff-3); Up(pen, 3);	(* E_bus to B-input *)
		(* input cell *)
		Set(pen, x+(CellW+3)+ww, yy); Dn(pen, 3); Right(pen, AOff-3); Up(pen, 3);	(* E_bus to A-output *)
		Set(pen, x+(2*CellW-3)+ww, yy); Dn(pen, 3); Left(pen, BOff-3); Up(pen, 3);	(* E_bus to B-output *)
		Set(pen, x+(CellW-BOff), yy); Dn(pen, 6); Right(pen, 2*BOff+ww); Up(pen, 6);	(* B_output to B_input *)
		INC(x, RepW DIV 2+CellW DIV 2); INC(y);	(* draw pad *)
		Rect(F, PadCol, x, y, w, RepW, 1(*, 2*)); SPadPat(F, x, y, w, k); Label(F, k DIV 2, -1, x+w+3, y+3, CLGAs.AOut);
		DnArrow(F, ConnCol, x+12, y+RepW, 6);	(* from pad up *)
		Block(F, ConnCol, x-27, y+(RepW+5), 39, 1);	(* left *)
		Block(F, ConnCol, x-BOff, y+(RepW+5), 1, 10);	(* to cell's A_output *)
		INC(x, w);
		Block(F, ConnCol, x-15, y+RepW, 5, 2);	(* A_output marker *)
		pen.col := ConnCol; Set(pen, x-13, y+(RepW+2)); Up(pen, 3); Right(pen, 40); Up(pen, 9)
	END SPad;

	PROCEDURE WPadPat(F: Frame; x, y, h, k: INTEGER);	
		VAR p: Pattern; s: ARRAY 2 OF CHAR;
	BEGIN
		IF F.print THEN
			CASE F.a.p[CLGAs.West, k DIV 2].selector OF
			| CLGAs.TSOff: s[0] := "0"
			| CLGAs.TSOn: s[0] := "1"
			| CLGAs.TSSerial: s[0] := "-"
			| CLGAs.TSParallel: s[0] := "|"
			END;
			s[1] := 0X; PrintString(x+6, y+h DIV 2 - 2, s, PrinterLabelFont)
		ELSE
			CASE F.a.p[CLGAs.West, k DIV 2].selector OF
			| CLGAs.TSOff: p := pat0
			| CLGAs.TSOn: p := pat1
			| CLGAs.TSSerial: p := patSer
			| CLGAs.TSParallel: p := patPar
			END;
			Display.CopyPatternC(F, PadCol, p.p, x+p.x+6, y+p.y+h DIV 2 - 2, patternMode)
		END
	END WPadPat;

	PROCEDURE WPad*(F: Frame; x, y, k: INTEGER);	
		VAR h, hh, xx: INTEGER; pen: Pen;
	BEGIN
		IF k MOD Sector = 7 THEN hh := RepW; h := PadLen+RepW ELSE hh := 0; h := PadLen END;
		pen.F := F; pen.col := ConnCol; xx := x+(PadW-1);
		(* input cell *)
		Set(pen, xx, y+3); Left(pen, 3); Up(pen, AOff-3); Right(pen, 3);	(* E_bus to A-output *)
		Set(pen, xx, y+(CellW-3)); Left(pen, 3); Dn(pen, BOff-3); Right(pen, 3);	(* E_bus to B-output *)
		(* output cell *)
		Set(pen, xx, y+(2*CellW-3)+hh); Left(pen, 3); Dn(pen, AOff-3); Right(pen, 3);	(* E_bus to A-input *)
		Set(pen, xx, y+(CellW+3)+hh); Left(pen, 3); Up(pen, BOff-3); Right(pen, 3);	(* E_bus to B-input *)
		Set(pen, xx, y+BOff); Left(pen, 6); Up(pen, (2*CellW-2*BOff)+hh); Right(pen, 6);	(* B_input to B_output *)
		INC(x); INC(y, RepW DIV 2+CellW DIV 2);	(* draw pad *)
		Rect(F, PadCol, x, y, RepW, h, 1(*, 2*)); WPadPat(F, x, y, h, k); Label(F, -1, k DIV 2, x+2, y-10, CLGAs.AOut);
		Block(F, ConnCol, x+RepW, y+10, 2, 5);	(* A_output marker *)
		Block(F, ConnCol, x+(RepW+2), y+12, 13, 1);	(* from pad right *)
		INC(y, h);
		LeftArrow(F, ConnCol, x+RepW, y-13, 15)	(* from pad to cell's A_output *)
	END WPad;

	PROCEDURE EPadPat(F: Frame; x, y, h, k: INTEGER);	
		VAR p: Pattern; s: ARRAY 2 OF CHAR;
	BEGIN
		IF F.print THEN
			CASE F.a.p[CLGAs.East, k DIV 2].selector OF
			| CLGAs.TSOff: s[0] := "0"
			| CLGAs.TSOn: s[0] := "1"
			| CLGAs.TSSerial: s[0] := "-"
			| CLGAs.TSParallel: s[0] := "|"
			END;
			s[1] := 0X; PrintString(x+6, y+h DIV 2 - 2, s, PrinterLabelFont)
		ELSE
			CASE F.a.p[CLGAs.East, k DIV 2].selector OF
			| CLGAs.TSOff: p := pat0
			| CLGAs.TSOn: p := pat1
			| CLGAs.TSSerial: p := patSer
			| CLGAs.TSParallel: p := patPar
			END;
			Display.CopyPatternC(F, PadCol, p.p, x+p.x+6, y+p.y+h DIV 2 - 2, patternMode)
		END
	END EPadPat;

	PROCEDURE EPad*(F: Frame; x, y, k: INTEGER);	
		VAR h, hh: INTEGER; pen: Pen;
	BEGIN
		IF k MOD Sector = 7 THEN hh := RepW; h := PadLen+RepW ELSE hh := 0; h := PadLen END;
		pen.F := F; pen.col := ConnCol;
		(* output cell *)
		Set(pen, x, y+3); Right(pen, 3); Up(pen, AOff-3); Left(pen, 3);	(* E_bus to A-input *)
		Set(pen, x, y+(CellW-3)); Right(pen, 3); Dn(pen, BOff-3); Left(pen, 3);	(* E_bus to B-input *)
		(* input cell *)
		Set(pen, x, y+(2*CellW-3)+hh); Right(pen, 3); Dn(pen, AOff-3); Left(pen, 3);	(* E_bus to A-output *)
		Set(pen, x, y+(CellW+3)+hh); Right(pen, 3); Up(pen, BOff-3); Left(pen, 3);	(* E_bus to B-output *)
		Set(pen, x, y+BOff); Right(pen, 6); Up(pen, (2*CellW-2*BOff)+hh); Left(pen, 6);	(* B_output to B_input *)
		INC(x, RepW); INC(y, RepW DIV 2+CellW DIV 2); 	(* draw pad *)
		IF k MOD Sector = 7 THEN h := PadLen+RepW ELSE h := PadLen END;
		Rect(F, PadCol, x, y, RepW, h, 1(*, 2*)); EPadPat(F, x, y, h, k); Label(F, Dim, k DIV 2, x+2, y-10, CLGAs.AOut);
		RightArrow(F, ConnCol, x, y+12, 16);	(* from cell's A_output to pad *)
		INC(y, h);
		Block(F, ConnCol, x-RepW, y-13, 14, 1);	(* right to pad *)
		Block(F, ConnCol, x-2, y-15, 2, 5)	(* A_output marker *)
	END EPad;

	PROCEDURE NSRep*(F: Frame; col, x, y, rep: INTEGER; east: BOOLEAN);	
		VAR i: INTEGER; s: ARRAY 2 OF CHAR; pass: BOOLEAN;
	BEGIN
		s[1] := 0X; pass := FALSE;
		IF east THEN
			i := 0F0H;
			IF ODD(rep DIV CLGAs.PassGate) THEN pass := TRUE; DEC(rep, CLGAs.PassGate) END
		ELSE i := 0E0H
		END;
		WHILE rep # 0 DO
			IF ODD(rep) THEN
				IF F.print THEN s[0] := CHR(i); PrintString(x+1, y+4, s, PatternFontName)
				ELSE Display.CopyPatternC(F, col, pat[i].p, x+1+pat[i].x, y+4+pat[i].y, patternMode)
				END
			END;
			INC(i); rep := rep DIV 2
		END;
		(* repeater connections *)
		Block(F, col, x+6, y, 1, 4); Block(F, col, x+6, y+12, 1, 4);
		Block(F, col, x+3, y, 1, 4); Block(F, col, x+3, y+12, 1, 4);
		IF pass THEN Block(F, col, x+2, y+4, 2, 8) END	(* thick line for east local bus pass gate *)
	END NSRep;

	PROCEDURE WERep*(F: Frame; col, x, y, rep: INTEGER; north: BOOLEAN);	
		VAR i: INTEGER; s: ARRAY 2 OF CHAR; pass: BOOLEAN;
	BEGIN
		s[1] := 0X; pass := FALSE;
		IF north THEN i := 0C0H
		ELSE
			i := 0D0H;
			IF ODD(rep DIV CLGAs.PassGate) THEN pass := TRUE; DEC(rep, CLGAs.PassGate) END
		END;
		WHILE rep # 0 DO
			IF ODD(rep) THEN
				IF F.print THEN s[0] := CHR(i); PrintString(x+4, y+1, s, PatternFontName)
				ELSE Display.CopyPatternC(F, col, pat[i].p, x+4+pat[i].x, y+1+pat[i].y, patternMode)
				END
			END;
			INC(i); rep := rep DIV 2
		END;
		(* repeater connections *)
		Block(F, col, x, y+6, 4, 1); Block(F, col, x+12, y+6, 4, 1);
		Block(F, col, x, y+3, 4, 1); Block(F, col, x+12, y+3, 4, 1);
		IF pass THEN Block(F, col, x+4, y+6, 8, 2) END	(* thick line for south local bus pass gate *)
	END WERep;

	PROCEDURE MarkCells*(F: Frame; u, v, w, h: INTEGER);	
		VAR u1, u2: INTEGER;
	BEGIN	(* (0 <= u) & (u < Dim) & (0 <= v) & (v < Dim) & (w > 0) & (h > 0) & (u+w <= Dim) & (v+h <= Dim) *)
		u2 := u+w;
		WHILE h > 0 DO
			u1 := u;
			WHILE u1 < u2 DO
				Invert(F, F.x + u1*(RepPerSector+1) DIV Sector * RepW + 14,
					F.y + v*(RepPerSector+1) DIV Sector * RepW + 14, CellLen-2, CellLen-2
				);
				INC(u1)
			END;
			INC(v); DEC(h)
		END
	END MarkCells;

	PROCEDURE MarkNSRep*(F: Frame; u, v: INTEGER; east: BOOLEAN);	
	BEGIN
		u := (u*(RepPerSector+1) DIV Sector)*RepW;
		IF east THEN INC(u, CellW-9) END;
		Invert(F, F.x + u, F.y + ((v+1)*(RepPerSector+1) - 1)*RepW, 9, RepW)
	END MarkNSRep;

	PROCEDURE MarkWERep*(F: Frame; u, v: INTEGER; north: BOOLEAN);	
	BEGIN
		v := (v*(RepPerSector+1) DIV Sector)*RepW;
		IF north THEN INC(v, CellW-9) END;
		Invert(F, F.x + ((u+1)*(RepPerSector+1) - 1)*RepW, F.y + v, RepW, 9)
	END MarkWERep;

	PROCEDURE MarkNPad*(F: Frame; k: INTEGER);	
		VAR w: INTEGER;
	BEGIN
		IF k MOD (Sector DIV 2) = Sector DIV 2 - 1 THEN w := CellLen+RepW+6 ELSE w := CellLen+6 END;
		Invert(F, F.x+(2*k+1)*CellW+(k DIV (Sector DIV 2) + 3)*RepW+2, F.y+NEPadRep*RepW+2, w, RepW-4)
	END MarkNPad;

	PROCEDURE MarkSPad*(F: Frame; k: INTEGER);	
		VAR w: INTEGER;
	BEGIN
		IF k MOD (Sector DIV 2) = Sector DIV 2 - 1 THEN w := CellLen+RepW+6 ELSE w := CellLen+6 END;
		Invert(F, F.x+(2*k+1)*CellW+(k DIV (Sector DIV 2) + 3)*RepW+2, F.y+SWPadRep*RepW+3, w, RepW-4)
	END MarkSPad;

	PROCEDURE MarkWPad*(F: Frame; k: INTEGER);	
		VAR h: INTEGER;
	BEGIN
		IF k MOD (Sector DIV 2) = Sector DIV 2 - 1 THEN h := CellLen+RepW+6 ELSE h := CellLen+6 END;
		Invert(F, F.x+SWPadRep*RepW+3, F.y+(2*k+1)*CellW+(k DIV (Sector DIV 2) + 3)*RepW+2, RepW-4, h)
	END MarkWPad;

	PROCEDURE MarkEPad*(F: Frame; k: INTEGER);	
		VAR h: INTEGER;
	BEGIN
		IF k MOD (Sector DIV 2) = Sector DIV 2 - 1 THEN h := CellLen+6+RepW ELSE h := CellLen+6 END;
		Invert(F, F.x+NEPadRep*RepW+2, F.y+(2*k+1)*CellW+(k DIV (Sector DIV 2) + 3)*RepW+2, RepW-4, h)
	END MarkEPad;

	PROCEDURE Mark*(F: Frame);	
	BEGIN
		CASE F.selTyp OF
		| cellSel: MarkCells(F, F.selU, F.selV, F.selW, F.selH)
		| nRepSel, sRepSel: MarkWERep(F, F.selU, F.selV, F.selTyp = nRepSel)
		| wRepSel, eRepSel: MarkNSRep(F, F.selU, F.selV, F.selTyp = eRepSel)
		| nPadSel: MarkNPad(F, F.selU)
		| sPadSel: MarkSPad(F, F.selU)
		| wPadSel: MarkWPad(F, F.selV)
		| ePadSel: MarkEPad(F, F.selV)
		END
	END Mark;

	PROCEDURE Translate*(F: Frame; x, y: INTEGER;
		VAR repU, repV, cellU, cellV, secU, secV: INTEGER; VAR repCol, repRow: BOOLEAN);	
	BEGIN	(**)
		repU := (x - F.x) DIV RepW; repV := (y - F.y) DIV RepW;
		secU := repU DIV (RepPerSector+1); secV := repV DIV (RepPerSector+1);
		repCol := (repU > 0) & (repU < NEPadRep-2) & ((repU MOD (RepPerSector+1)) = RepPerSector);
		repRow := (repV > 0) & (repV < NEPadRep-2) & ((repV MOD (RepPerSector+1)) = RepPerSector);
		cellU := (repU - secU) DIV RepPerCell; cellV := (repV - secV) DIV RepPerCell
(*;IF gridMode IN F.mode THEN Str("repU, repV:"); Int(repU); Int(repV); Str("  secU, secV:"); Int(secU); Int(secV);
Str("  repCol, repRow:");
IF repCol THEN Str(" T") ELSE Str(" F") END; IF repRow THEN Str(" T") ELSE Str(" F") END;
Str("  cellU, cellV:"); Int(cellU); Int(cellV); Ln
END*)
	END Translate;

	PROCEDURE Restore*(F: Frame);	
		VAR
			pen: Pen;
			u, v, cellU, cellV, secU, secV: INTEGER;
			x, x0, y, y0: INTEGER;
			repCol, repCol0, repRow: BOOLEAN;
		(*PROCEDURE Grid;	
			VAR X, Y: INTEGER;
		BEGIN
			FOR X := x0 TO F.X1-1 BY RepW DO Block(F, ConnCol, X, y0, 1, 2*F.H) END;
			FOR Y := y0 TO F.Y1-1 BY RepW Block(F, ConnCol, x0, Y, 2*F.W, 1) END
		END Grid;*)
	BEGIN
		Oberon.RemoveMarks(F.X, F.Y, F.W, F.H);
		F.X1 := F.X + F.W; F.Y1 := F.Y + F.H; F.x := F.X + F.Xa; F.y := F.Y1 + F.Ya;
		IF ~F.print THEN Display.ReplConst(Display.black, F.X, F.Y, F.W, F.H, Display.replace)	(* erase *)
		ELSE DEC(F.X1, CellW); DEC(F.Y1, CellW)	(* ensure proper clipping when printing *)
		END;
		Translate(F, F.X, F.Y, u, v, cellU, cellV, secU, secV, repCol0, repRow);
		IF secU < 0 THEN x0 := F.x - PadW; repCol0 := TRUE; cellU := 0	(* model's x-origin is visible, start with W-pads *)
		ELSE
			(*IF cellU > 0 THEN DEC(cellU) END;	(* ensure visibility of pads *) *)
			IF F.print THEN INC(cellU) END;	(* ensure proper clipping when printing *)
			x0 := F.x + cellU*CellW + secU*RepW	(* model's x-origin is not visible, start within cells *)
		END;
		IF secV < 0 THEN y0 := F.y - PadW; repRow := TRUE; cellV := 0	(* model's y-origin is visible, start with S-pads *)
		ELSE
			(*IF cellV > 0 THEN DEC(cellV) END;	(* ensure visibility of pads *) *)
			IF F.print THEN INC(cellV) END;	(* ensure proper clipping when printing *)
			y0 := F.y + cellV*CellW + secV*RepW	(* model's y-origin is not visible, start within cells *)
		END;
		v := cellV; y := y0; pen.F := F; pen.col := ConnCol;
		(*IF gridMode IN F.mode THEN Grid END;*)
		LOOP
			IF (y >= F.Y1) OR ~repRow & (v >= Dim) OR (v > Dim) THEN EXIT END;
			IF ~repRow THEN	(* cell row *)
				x := x0; repCol := repCol0; u := cellU;
				LOOP
					IF (x >= F.X1) OR ~repCol & (u >= Dim) OR (u > Dim) THEN EXIT END;
					IF ~repCol THEN	(* cell *)
						Cell(F, x, y, u, v); INC(x, CellW); INC(u); repCol := u MOD Sector = 0
					ELSIF u = 0 THEN	(* W_pad *)
						IF v = 0 THEN	(* E_bus to A_ & B_input *)
							Set(pen, x+(PadW-1), y+(CellW-3)); Left(pen, 3); Dn(pen, AOff-3); Right(pen, 3);
							Set(pen, x+(PadW-1), y+3); Left(pen, 3); Up(pen, BOff-3); Right(pen, 3)
						ELSIF v = Dim-1 THEN	(* E_bus to A_ & B_output *)
							Set(pen, x+(PadW-1), y+3); Left(pen, 3); Up(pen, AOff-3); Right(pen, 3);
							Set(pen, x+(PadW-1), y+(CellW-3)); Left(pen, 3); Dn(pen, BOff-3); Right(pen, 3)
						ELSIF ODD(v) THEN WPad(F, x, y, v)
						END;
						INC(x, PadW); repCol := FALSE
					ELSIF u < Dim THEN	(* WE_rep *)
						WERep(F, ConnCol, x, y, F.a.hr[u DIV Sector - 1, v].s, FALSE);
						WERep(F, ConnCol, x, y+(CellW-9), F.a.hr[u DIV Sector - 1, v].n, TRUE);
						WriteInt(F, v, x+3, y+(CellW DIV 2 - 4));
						INC(x, RepW); repCol := FALSE
					ELSE	(* E_pad *)
						IF v = 0 THEN	(* E_bus to A_ & B_output *)
							Set(pen, x, y+(CellW-3)); Right(pen, 3); Dn(pen, AOff-3); Left(pen, 3);
							Set(pen, x, y+3); Right(pen, 3); Up(pen, BOff-3); Left(pen, 3)
						ELSIF v = Dim-1 THEN	(* E_bus to A_ & B_input *)
							Set(pen, x, y+3); Right(pen, 3); Up(pen, AOff-3); Left(pen, 3);
							Set(pen, x, y+(CellW-3)); Right(pen, 3); Dn(pen, BOff-3); Left(pen, 3)
						ELSIF ODD(v) THEN EPad(F, x, y, v)
						END;
						EXIT
					END
				END;	(* LOOP *)
				INC(y, CellW); INC(v); repRow := v MOD Sector = 0
			ELSIF v = 0 THEN	(* S_pad row *)
				x := x0; repCol := repCol0; u := cellU;
				LOOP
					IF x >= F.X1 THEN EXIT END;
					IF ~repCol THEN	(* S_pad *)
						IF u = 0 THEN	(* E_bus to A_ & B_output *)
							Set(pen, x+3, y+(PadW-1)); Dn(pen, 3); Right(pen, AOff-3); Up(pen, 3);
							Set(pen, x+(CellW-3), y+(PadW-1)); Dn(pen, 3); Left(pen, BOff-3); Up(pen, 3)
						ELSIF u = Dim-1 THEN	(* E_bus to A_ & B_input *)
							Set(pen, x+(CellW-3), y+(PadW-1)); Dn(pen, 3); Left(pen, AOff-3); Up(pen, 3);
							Set(pen, x+3, y+(PadW-1)); Dn(pen, 3); Right(pen, BOff-3); Up(pen, 3)
						ELSIF ODD(u) THEN SPad(F, x, y, u)
						END;
						INC(x, CellW); INC(u); repCol := u MOD Sector = 0
					ELSIF u = 0 THEN INC(x, PadW); repCol := FALSE
					ELSIF u < Dim THEN INC(x, RepW); repCol := FALSE
					ELSE EXIT
					END
				END;
				INC(y, PadW); repRow := FALSE
			ELSIF v < Dim THEN	(* NS_rep row *)
				x := x0; repCol := repCol0; u := cellU;
				LOOP
					IF (x >= F.X1) OR (u >= Dim) THEN EXIT END;
					IF ~repCol THEN	(* NS_rep *)
						NSRep(F, ConnCol, x, y, F.a.vr[u, v DIV Sector - 1].w, FALSE);
						NSRep(F, ConnCol, x+(CellW-9), y, F.a.vr[u, v DIV Sector - 1].e, TRUE);
						WriteInt(F, u, x+(CellW DIV 2 - 5), y+5);
						INC(x, CellW); INC(u); repCol := u MOD Sector = 0
					ELSIF u = 0 THEN INC(x, PadW); repCol := FALSE
					ELSIF u < Dim THEN INC(x, RepW); repCol := FALSE
					ELSE EXIT
					END
				END;	(* LOOP *)
				INC(y, RepW); repRow := FALSE
			ELSE	(* N_pad row *)
				x := x0; repCol := repCol0; u := cellU;
				LOOP
					IF (x >= F.X1) OR (u >= Dim) THEN EXIT END;
					IF ~repCol THEN	(* N_pad *)
						IF u = 0 THEN	(* E_bus to A_ & B_input *)
							Set(pen, x+3, y); Up(pen, 3); Right(pen, AOff-3); Dn(pen, 3);
							Set(pen, x+(CellW-3), y); Up(pen, 3); Left(pen, BOff-3); Dn(pen, 3)
						ELSIF u = Dim-1 THEN	(* E_bus to A_ & B_output *)
							Set(pen, x+(CellW-3), y); Up(pen, 3); Left(pen, AOff-3); Dn(pen, 3);
							Set(pen, x+3, y); Up(pen, 3); Right(pen, BOff-3); Dn(pen, 3)
						ELSIF ODD(u) THEN NPad(F, x, y, u)
						END;
						INC(x, CellW); INC(u); repCol := u MOD Sector = 0
					ELSIF u = 0 THEN INC(x, PadW); repCol := FALSE
					ELSIF u < Dim THEN INC(x, RepW); repCol := FALSE
					ELSE EXIT
					END
				END;	(* LOOP *)
				EXIT
			END	(* IF (y >= F.Y1) ... *)
		END;	(* LOOP *)
		IF F.selected THEN Mark(F) END
	END Restore;

	PROCEDURE Deselect*(F: Frame);	
	BEGIN IF F.selected THEN F.selected := FALSE; Mark(F) END
	END Deselect;

	PROCEDURE SelectCells*(F: Frame; u, v, w, h: INTEGER; extend: BOOLEAN);	
	(*	PROCEDURE WriteLabel(ch: CHAR; which: SHORTINT);
			VAR l: CLGAs.Label;
		BEGIN l := CLGAs.LabelAt(F.a, u, v, which); IF l # NIL THEN Char(" "); Char(ch); Char(":"); Str(l.name) END
		END WriteLabel;
	*)
	BEGIN
		IF ~extend THEN
			Deselect(F);
			(*Str("cell"); Int(u); Int(v); WriteLabel("A", CLGAs.AOut); WriteLabel("B", CLGAs.BOut); Ln;*)
			MarkCells(F, u, v, w, h)
		ELSE
			IF w > F.selW THEN MarkCells(F, u+F.selW, v, w-F.selW, h)
			ELSIF w < F.selW THEN MarkCells(F, u+w, v, F.selW-w, F.selH)
			END;
			IF h > F.selH THEN MarkCells(F, u, v+F.selH, Min(w, F.selW), h-F.selH)
			ELSIF h < F.selH THEN MarkCells(F, u, v+h, Min(w, F.selW), F.selH-h)
			END
		END;
		F.selU := u; F.selV := v; F.selW := w; F.selH := h; F.selTyp := cellSel;
		F.selected := TRUE; F.time := Oberon.Time()
	END SelectCells;

	PROCEDURE SelectPad*(F: Frame; u, v, selTyp: INTEGER);	
	BEGIN
		Deselect(F);
		CASE selTyp OF
		| nPadSel: MarkNPad(F, u); (*Str("N pad");*) v := Dim
		| sPadSel: MarkSPad(F, u); (*Str("S pad");*) v := -1
		| wPadSel: MarkWPad(F, v); (*Str("W pad");*) u := -1
		| ePadSel: MarkEPad(F, v); (*Str("E pad");*) u := Dim
		END;
		(*Int(u); Int(v); l := CLGAs.LabelAt(F.a, u, v, CLGAs.AOut);*)
		(*IF l # NIL THEN Char(" "); Str(l.name) END;*)
		(*Ln;*)
		F.selU := u; F.selV := v; F.selTyp := selTyp; F.selected := TRUE; F.time := Oberon.Time()
	END SelectPad;

	PROCEDURE SelectRep*(F: Frame; u, v, selTyp: INTEGER);	
	BEGIN
		Deselect(F);
		CASE selTyp OF
		| nRepSel: MarkWERep(F, u, v, TRUE); (*Str("WE north repeater")*)
		| sRepSel: MarkWERep(F, u, v, FALSE); (*Str("WE south repeater")*)
		| wRepSel: MarkNSRep(F, u, v, FALSE); (*Str("NS west repeater")*)
		| eRepSel: MarkNSRep(F, u, v, TRUE); (*Str("NS east repeater")*)
		END;
		F.selU := u; F.selV := v; F.selTyp := selTyp; F.selected := TRUE; F.time := Oberon.Time();
		(*Int(u); Int(v); Ln*)
	END SelectRep;

	PROCEDURE Select*(F: Frame; u, v: INTEGER);	(* -1 <= u, v <= Dim *)	
	BEGIN
		Deselect(F);
		IF u = -1 THEN SelectPad(F, -1, v, wPadSel)
		ELSIF u = Dim THEN SelectPad(F, Dim, v, ePadSel)
		ELSIF v = -1 THEN SelectPad(F, u, -1, sPadSel)
		ELSIF v = Dim THEN SelectPad(F, u, Dim, nPadSel)
		ELSE SelectCells(F, u, v, 1, 1, FALSE)
		END
	END Select;

	PROCEDURE Selected*(): Frame;	
		VAR M: SelMsg;
	BEGIN M.f := NIL; M.time := -1; Viewers.Broadcast(M); RETURN M.f
	END Selected;

	PROCEDURE UpdateCells*(F: Frame; u, v, w, h: INTEGER);	
		CONST black = Display.black;
		VAR x, y, U, V, u1, v1, w1, h1: INTEGER; invert: BOOLEAN;
	BEGIN
		IF F.selected & (F.selTyp = cellSel) THEN
			u1 := Max(F.selU, u); v1 := Max(F.selV, v);
			w1 := Min(F.selU+F.selW, u+w)-u1; h1 := Min(F.selV+F.selH, v+h)-v1;
			IF (w1 > 0) & (h1 > 0) THEN MarkCells(F, u1, v1, w1, h1); invert := TRUE ELSE invert := FALSE END
		ELSE invert := FALSE
		END;
		Oberon.RemoveMarks(F.x+u*CellW+(u DIV Sector)*RepW,
			F.y+v*CellW+(v DIV Sector)*RepW, w*CellW, h*CellW
		);
		FOR V := v TO v+h-1 DO
			y := F.y+V*CellW+(V DIV Sector)*RepW;
			FOR U := u TO u+w-1 DO
				x := F.x+U*CellW+(U DIV Sector)*RepW;
				Block(F, black, x, y, CellW, CellW);
				IF (V MOD Sector = Sector-1) & (V # Dim-1) THEN
					Block(F, black, x+AOff, y+CellW, 1, RepW); Block(F, black, x+(CellW-BOff), y+CellW, 1, RepW)
				ELSIF (V MOD Sector = 0) & (V # 0) THEN
					Block(F, black, x+(CellW-AOff), y-RepW, 1, RepW); Block(F, black, x+BOff, y-RepW, 1, RepW)
				END;
				IF (U MOD Sector = 0) & (U # 0) THEN
					Block(F, black, x-RepW, y+(CellW-AOff), RepW, 1); Block(F, black, x-RepW, y+BOff, RepW, 1)
				ELSIF (U MOD Sector = Sector-1) & (U # Dim-1) THEN
					Block(F, black, x+CellW, y+AOff, RepW, 1); Block(F, black, x+CellW, y+(CellW-BOff), RepW, 1)
				END;
				Cell(F, x, y, U, V)
			END
		END;
		IF invert THEN MarkCells(F, u1, v1, w1, h1) END
	END UpdateCells;

	PROCEDURE UpdatePad*(F: Frame; u, v: INTEGER; side: SHORTINT);	
		VAR invert: BOOLEAN; x, y, w, h, k: INTEGER; pad: PROCEDURE(F: Frame; x, y, k: INTEGER);
	BEGIN
		IF F.selected & (u = F.selU) & (v = F.selV) THEN Mark(F); invert := TRUE ELSE invert := FALSE END;
		CASE side OF
		| CLGAs.North, CLGAs.South:
			k := 2*u+1; h := PadW; x := F.x+k*CellW+(k DIV Sector)*RepW;
			IF k MOD Sector = Sector-1 THEN w := 2*CellW+RepW ELSE w := 2*CellW END;
			IF side = CLGAs.North THEN pad := NPad; y := F.y+(NEPadRep-1)*RepW
			ELSE pad := SPad; y := F.y+SWPadRep*RepW
			END
		| CLGAs.West, CLGAs.East:
			k := 2*v+1; w := PadW; y := F.y+k*CellW+(k DIV Sector)*RepW;
			IF k MOD Sector = Sector-1 THEN h := 2*CellW+RepW ELSE h := 2*CellW END;
			IF side = CLGAs.West THEN pad := WPad; x := F.x+SWPadRep*RepW
			ELSE pad := EPad; x := F.x+(NEPadRep-1)*RepW
			END
		END;
		Oberon.RemoveMarks(x, y, w, h); Block(F, Display.black, x, y, w, h); pad(F, x, y, k);
		IF invert THEN Mark(F) END
	END UpdatePad;

	PROCEDURE UpdateRep*(F: Frame; u, v: INTEGER; typ: SHORTINT);	
		VAR x, y, rep: INTEGER; invert: BOOLEAN;
	BEGIN
		IF F.selected & (u = F.selU) & (v = F.selV) & (F.selTyp IN {nRepSel, sRepSel, wRepSel, eRepSel}) THEN
			Mark(F); invert := TRUE
		ELSE invert := FALSE
		END;
		CASE typ OF
		| nRepSel:
			x := F.x+u*RepW*(RepPerSector+1)+RepW*RepPerSector;
			y := F.y+v*CellW+(v DIV Sector)*RepW+(CellW-RepW);
			rep := F.a.hr[u, v].n
		| sRepSel:
			x := F.x+u*RepW*(RepPerSector+1)+RepW*RepPerSector;
			y := F.y+v*CellW+(v DIV Sector)*RepW;
			rep := F.a.hr[u, v].s
		| wRepSel:
			x := F.x+u*CellW+(u DIV Sector)*RepW;
			y := F.y+v*RepW*(RepPerSector+1)+RepW*RepPerSector;
			rep := F.a.vr[u, v].w
		| eRepSel:
			x := F.x+u*CellW+(u DIV Sector)*RepW+(CellW-RepW);
			y := F.y+v*RepW*(RepPerSector+1)+RepW*RepPerSector;
			rep := F.a.vr[u, v].e
		END;
		Oberon.RemoveMarks(x, y, RepW, RepW); Block(F, Display.black, x, y, RepW, RepW);
		CASE typ OF
		| nRepSel: WERep(F, ConnCol, x, y+7, rep, TRUE)
		| sRepSel: WERep(F, ConnCol, x, y, rep, FALSE)
		| wRepSel: NSRep(F, ConnCol, x, y, rep, FALSE)
		| eRepSel: NSRep(F, ConnCol, x+7, y, rep, TRUE)
		END;
		IF invert THEN Mark(F) END
	END UpdateRep;

	PROCEDURE Position*(F: Frame; u, v: INTEGER);	(** -1 <= u, v <= Dim **)	
		VAR repU, repV, cellU, cellV, cellU1, cellV1, secU, secV: INTEGER; repCol, repRow: BOOLEAN;
	BEGIN
		Translate(F, F.X, F.Y, repU, repV, cellU, cellV, secU, secV, repCol, repRow);
		Translate(F, F.X1, F.Y1, repU, repV, cellU1, cellV1, secU, secV, repCol, repRow);
		IF (u = -1) OR (u = Dim) OR (v = -1) OR (v = Dim)
				OR (u < cellU) OR (cellU1 < u) OR (v < cellV) OR (cellV1 < v) THEN	(* position only if not visible already *)
			IF ((u = -1) OR (u = Dim)) & (0 <= v) & (v < Dim) THEN v := 2*(v+1) END;
			IF ((v = -1) OR (v = Dim)) & (0 <= u) & (u < Dim) THEN u := 2*(u+1) END;
			F.Xa := F.W DIV 2 - u*CellW - u DIV Sector * RepW;
			F.Ya := -F.H DIV 2 - v*CellW - v DIV Sector * RepW;
			Restore(F)
		END
	END Position;

BEGIN	
	InitFont(syn8, "Syntax8.Scn.Fnt"); InitFont(syn10, "Syntax10.Scn.Fnt"); InitFont(syn12, "Syntax12.Scn.Fnt");
	InitFont(cli, PatternFontName); InitPatterns
END CLFramesD.
