O  Syntax10.Scn.Fnt  u ]  ParcElems Alloc     
 +6      ևԒҝШϳ;    Syntax10i.Scn.Fnt        StampElems Alloc 20 Jun 94  B                .   2    8  FoldElems New  ?   8       8       8       8      Syntax10b.Scn.Fnt                                  8   2    8   *    8        8   *    8       8   D    8           -    8      8   -    8   -   8       8   %    8   #    8   s   8   %    8      8   S    8   +   8   ;    8       8   6    8      8   M    8       8       8   %    8   /   8   9    8   m   8      8   H    8   m    8   7    8       8   U   8   j   8   G    8      8   W    8   '	   8   p    8      8   [    8   M   8   \    8      8   V    8   2   8   9    8   q   8   5    8   	   8   0    8       8               8   E    8           @    8      8   :    8      8       8      8       8   n    8       z  MODULE CLExtractor;	(* sg ,  *)
(* 24. Dec 93: latches with labels at output work correctly *)
(* 24. Dec 93: for GSX: x := REG (MUX(en, x, d)) => REG (en, d) (synch. load) *)
(* 11. Jan 94: if clock column disabled: zero in clock enable *)
(* 24. Jan 94: clock is ignored => only synchronous designs *)
(* 7./14. Apr 94: adaption to new Lola *)
(* 5. May 94: Fixup for already traversed nodes to ensure proper Latch detection when entering same latch from *)
(*                  different sides *)
(*                  No calls to CLLola.This before calls to CLLola.Enter *)
(*                  detection of SR flipflops *)
(* 18. May 94: tries to extract variable xxx' if xxx is not found in layout (and vice-versa) *)
(* 27. May 94: doesn't stop at a label when corresponing Lola variable is constant *)
(* 6.Jun 94: latch feedback allowed only over B input *)

IMPORT Texts, Oberon, CLGAs, LSD, CLLola;

CONST
	(* extraction error codes *)
	NoDesignVar = 1; UndefCell = 2; ABLabel = 3; BorderConn = 4; AnonBus = 5; NoTS = 6; TwoOuts = 7; EmptyBus = 8;
	NoOut = 9; NoIn = 10; UnnamedPad = 11; UndefPad = 12; NoBusVar = 13; IllegalLatch = 14;

	(* constants defined in CLGAs *)
	Dim = CLGAs.Dim; Sector = CLGAs.Sector;
	None = CLGAs.None; North = CLGAs.North; South = CLGAs.South; West = CLGAs.West; East = CLGAs.East;
	Write = CLGAs.Write; TS = CLGAs.TS; Read = CLGAs.Read; Mux = CLGAs.Mux; (* internal cell routing *)
	TurnB = CLGAs.TurnB; Turn0 = CLGAs.Turn0;
	State0 = CLGAs.State0; State1 = CLGAs.State1; State2 = CLGAs.State2; State3 = CLGAs.State3; (* cell states *)
	EEWE = CLGAs.EEWE; LEWE = CLGAs.LEWE; LLWE = CLGAs.LLWE; ELWE = CLGAs.ELWE;
	EEEW = CLGAs.EEEW; LEEW = CLGAs.LEEW; LLEW = CLGAs.LLEW; ELEW = CLGAs.ELEW; PassGate = CLGAs.PassGate;
	ClkOne = CLGAs.ClkOne; ClkAout = CLGAs.ClkAout; ClkGlobal = CLGAs.ClkGlobal; ClkExpress = CLGAs.ClkExpress;
	TSOff = CLGAs.TSOff; TSSerial = CLGAs.TSSerial; TSParallel = CLGAs.TSParallel; TSOn = CLGAs.TSOn;
	AOut = CLGAs.AOut; BOut = CLGAs.BOut; LOut = CLGAs.LOut;
	LBusN = CLGAs.LBusN; LBusS = CLGAs.LBusS; LBusW = CLGAs.LBusW; LBusE = CLGAs.LBusE;
	EBusN = CLGAs.EBusN; EBusS = CLGAs.EBusS; EBusW = CLGAs.EBusW; EBusE = CLGAs.EBusE;

	(* constants defined in LSD *)
	or = LSD.or; xor = LSD.xor; and = LSD.and; not = LSD.not; mux = LSD.mux; reg = LSD.reg;

	AIn = 16; BIn = 17; LIn = 18; ZeroIn = 19; OneIn = 20; ClkIn = 21;
	NofStates = State3 + 1; NofRoutings = Turn0 + 1;
	Local = 0; Express = 1; Left = 0; Right = 1; (* repeaters *)

	Debug = FALSE;

TYPE
	Node = POINTER TO NodeDesc;		(* DS to keep already traversed cells/pads/repeaters (efficiency) *)
	NodeDesc	=	RECORD
							left, right : Node;
							key : LONGINT;
							s : LSD.Signal
						END;

VAR
	topScope*, markScope, marks, dummy : LSD.Variable; (* marks: list of temp. vars for proper cycle handling *)
	searchRoot : Node; (* root of all already traversed cells *)
	errU*, errV*, nofMarks : INTEGER;
	showErr*, ok* : BOOLEAN;
	W : Texts.Writer;
	table : ARRAY NofRoutings * NofStates * 2 OF RECORD (* table for tree node generation *)
		data : ARRAY 7 OF SHORTINT;
		len : SHORTINT
	END;
	rep : ARRAY 2, 2, 2 OF INTEGER; (* input, output, direction *)

(* output *)

PROCEDURE Str (s : ARRAY OF CHAR);
BEGIN
	Texts.WriteString (W, s)
END Str;

PROCEDURE Int (i, w : LONGINT);
BEGIN
	Texts.WriteInt (W, i, w)
END Int;

PROCEDURE Ln;
BEGIN
	Texts.WriteLn (W); Texts.Append (Oberon.Log, W.buf)
END Ln;

PROCEDURE ErrMsg* (msg : ARRAY OF CHAR; u, v, sig : INTEGER);
BEGIN
	Str (" <- "); Str (msg);
	IF (u >= 0) OR (v >= 0) THEN
		Str (" at "); Int (u, 3); Int (v, 3); Str ("  ");
		CASE sig OF
			AOut	:	Str ("AOut")
		|	BOut	:	Str ("BOut")
		|	LOut		:	Str ("LOut")
		|	LBusN	:	Str ("LBusN")
		|	LBusS	:	Str ("LBusS")
		|	LBusW	:	Str ("LBusW")
		|	LBusE	:	Str ("LBusE")
		|	EBusN	:	Str ("EBusN")
		|	EBusS	:	Str ("EBusS")
		|	EBusW	:	Str ("EBusW")
		|	EBusE	:	Str ("EBusE")
		ELSE Str ("unknown")
		END
	END;
	Ln
END ErrMsg;

PROCEDURE Err (errNo, u, v, sig : SHORTINT);
BEGIN
	IF ok THEN
		ok := FALSE; errU := u; errV := v;
		IF showErr THEN
			CASE errNo OF
				NoDesignVar	:	ErrMsg ("no such variable in design", u, v, sig)
			|	UndefCell		:	ErrMsg ("undefined cell/routing", u, v, sig)
			|	ABLabel			:	ErrMsg ("label expected at A/B output", u, v, sig)
			|	BorderConn		:	ErrMsg ("illegal border connection", u, v, sig)
			|	AnonBus			:	ErrMsg ("conditional output (TS) to unlabelled bus", u, v, sig)
			|	NoTS				:	ErrMsg ("unconditional output to TS bus", u, v, sig)
			|	TwoOuts			:	ErrMsg ("more than one unconditional output to bus", u, v, sig)
			|	EmptyBus		:	ErrMsg ("empty bus connected through repeater", u, v, sig)
			|	NoOut			:	ErrMsg ("no output connected to bus", u, v, sig)
			|	NoIn				:	ErrMsg ("no local bus input connected to bus", u, v, sig)
			|	UnnamedPad	:	ErrMsg ("unnamed pad", u, v, sig)
			|	UndefPad		:	ErrMsg ("disabled pad", u, v, sig)
			|	NoBusVar		:	ErrMsg ("bus variable expected", u, v, sig)
			|	IllegalLatch		:	ErrMsg ("latch feedback must enter B input", u, v, sig)
			END
		END
	END;
END Err;

(*
PROCEDURE Char (ch : CHAR);
BEGIN
	Texts.Write (W, ch)
END Char;
PROCEDURE ShowOp (s : LSD.Signal);
BEGIN
	IF s IS LSD.Variable THEN LSD.WriteName (W, s(LSD.Variable))
	ELSE
		CASE s.fct OF
			or		:	Char ("+")
		|	xor		:	Char ("-")
		|	and		:	Char ("*")
		|	not		:	Char ("~")
		|	reg		:	Char ("^")
		|	LSD.lch		:	Char ("$")
		|	mux		:	Char (":")
		|	LSD.mux1	:	Char (",")
		|	LSD.ts		:	Char ("|")
		|	LSD.tsc		:	Char (".")
		|	LSD.sr		:	Char ("%")
		END
	END
END ShowOp;
PROCEDURE ShowForm (s : LSD.Signal);
CONST Flag = 50;
BEGIN
	IF s # NIL THEN
		IF s.val >= 0 THEN
			DEC (s.val, Flag);
			IF s IS LSD.Variable THEN ShowOp (s)
			ELSE (* omit parantheses around mux1 and tsc *)
				IF (s.fct # LSD.mux1) & (s.fct # LSD.tsc) THEN Char ("(") END;
				ShowForm (s.x);
				ShowOp (s);
				ShowForm (s.y);
				IF (s.fct # LSD.mux1) & (s.fct # LSD.tsc) THEN Char (")") END
			END;
			INC (s.val, Flag)
		ELSE Char ("@")
		END
	END
END ShowForm;
*)

(* formula extraction *)

PROCEDURE Find (VAR n : Node; key : LONGINT) : Node;
(* search if a cell has already been traversed (and its tree built) *)
BEGIN
	IF n = NIL THEN NEW (n); n.left := NIL; n.right := NIL; n.key := key; n.s := NIL; RETURN n
	ELSIF key < n.key THEN RETURN Find(n.left, key)
	ELSIF key > n.key THEN RETURN Find(n.right, key)
	ELSE RETURN n
	END
END Find;

PROCEDURE Position (s : LSD.Signal; u, v, sig : SHORTINT);
(* store position information (used for error location in the checker) *)
BEGIN
	s.u := u; s.v := v; s.val := sig
END Position;

PROCEDURE Mark (u, v, sig : SHORTINT) : LSD.Variable;
(* create a temporary mark to handle cycles (feedbacks) correctly *)
VAR m : LSD.Variable; s : LSD.Name; n, i : INTEGER;
BEGIN
	IF marks = NIL THEN (* recycling queue empty, create new temporary variable *)
		INC (nofMarks);
		n := nofMarks; i := 2;
		WHILE n > 9 DO INC (i); n := n DIV 10 END;
		n := nofMarks; s[i] := 0X; DEC (i);
		REPEAT s[i] := CHR (ORD ("0") + (n MOD 10)); n := n DIV 10; DEC (i) UNTIL n = 0;
		s[0] := "#";
		NEW (m); COPY (s, m.name); m.y := markScope; m.fct := LSD.OC; (* any type *)
	ELSE m := marks; marks := m.next; m.next := NIL (* recycle temporary variable *)
	END;
	Position (m, u, v, sig);
	RETURN m
END Mark;


PROCEDURE Fixup (src : LSD.Variable; dst : LSD.Signal; VAR s : LSD.Signal);
(* replace all occurences of src with dst in tree rooted at s *)
(* detect latches, registers with enable and RS flipflops *)
CONST Flag = 50;
VAR u, v, val : SHORTINT; set, reset : LSD.Signal;

	PROCEDURE Init (s : LSD.Signal); (* setup s.val so that it is unchanged when we leave Fixup *)
	BEGIN
		IF (s # NIL) & (s.val >= 0) THEN
			DEC (s.val, Flag);
			IF ~(s IS LSD.Variable) THEN Init (s.x); Init (s.y) END
		END
	END Init;

	PROCEDURE Fix (VAR s : LSD.Signal); (* substitute occurrences of src by dst *)
	BEGIN
		IF (s # NIL) & (s.val < 0) THEN
			INC (s.val, Flag);
			WHILE (s.y = markScope) & (s.y.y = markScope) DO s := s.y END; (* successive marks *)
			IF s = src THEN s := dst
			ELSIF ~(s IS LSD.Variable) THEN Fix (s.x); Fix (s.y)
			END
		END
	END Fix;

	PROCEDURE RSFF (VAR set, reset : LSD.Signal) : BOOLEAN; (* check for RS flipflops *)
	VAR x, y, x1, y1 : LSD.Signal; match : BOOLEAN;
	BEGIN
		match := FALSE;
		IF (s.fct = not) & (s.y.fct = and) THEN
			x := s.y.x; y := s.y.y;
			IF (x.fct = not) & (x.y.fct = and) THEN
				x1 := x.y.x; y1 := x.y.y;
				IF x1 = dst THEN set := y; reset := y1; match := TRUE
				ELSIF y1 = dst THEN set := y; reset := x1; match := TRUE
				END
			END;
			IF (y.fct = not) & (y.y.fct = and) THEN
				x1 := y.y.x; y1 := y.y.y;
				IF x1 = dst THEN set := x; reset := y1; match := TRUE
				ELSIF y1 = dst THEN set := x; reset := x1; match := TRUE
				END
			END
		END;
		RETURN match
	END RSFF;

BEGIN
	IF s # NIL THEN
		IF src # NIL THEN u := src.u; v := src.v; val := src.val; Init (s); Fix (s) (* substitute src by dst *)
		ELSE u := s.u; v := s.v; val := s.val
		END;
		IF (s.fct = mux) & (s.y.x = dst) THEN s := CLLola.Latch (s.x, s.y.y); Position (s, u, v, val)
		ELSIF (s.fct = mux) & (s.y.y = dst) THEN Err (IllegalLatch, u, v, val)
		ELSIF (s.fct = reg) & (s.y.fct = mux) THEN (* register with enable *)
			IF s.y.y.x = dst THEN s := CLLola.Reg (s.y.x, s.y.y.y)
			ELSIF s.y.y.y = dst THEN s := CLLola.Reg (CLLola.Not (s.y.x), s.y.y.x)
			END
		ELSIF RSFF (set, reset) THEN s := CLLola.SR (set, reset); Position (s, u, v, val)
		END
	END;
	IF src # NIL THEN src.next := marks; marks := src END (* enter into recycling queue *)
END Fixup;

PROCEDURE CheckNIL (s : LSD.Signal; u, v, sig : SHORTINT) : LSD.Signal;
(* ensure s # NIL *)
BEGIN
	IF s = NIL THEN Err (NoOut, u, v, sig); s := dummy END;
	RETURN s
END CheckNIL;

PROCEDURE IsConstant (name : ARRAY OF CHAR) : BOOLEAN;
VAR var : LSD.Variable;
BEGIN
	var := CLLola.This (LSD.org, name);
	RETURN ((var # NIL) & ((var.x = LSD.zero) OR (var.x = LSD.one)))
END IsConstant;

PROCEDURE ^ Cell (ga : CLGAs.GA; u, v, sig : SHORTINT; bus : LSD.Variable) : LSD.Signal;
PROCEDURE ^ Bus (ga : CLGAs.GA; u, v, sig, from : SHORTINT; bus : LSD.Variable) : LSD.Signal;
PROCEDURE ^ Pad (ga : CLGAs.GA; u, v, sig : SHORTINT; bus : LSD.Variable) : LSD.Signal;

PROCEDURE Input (ga : CLGAs.GA; u, v, sig : SHORTINT) : LSD.Signal;
(* return tree attached to cell at u/v/sig *)
VAR L : CLGAs.Label; var : LSD.Variable; i, dir, type, from : SHORTINT;
BEGIN
	IF Debug THEN Str ("Input"); Ln END;
	IF sig = AOut THEN
		CASE ga.c[u, v].a OF
			North	:	INC (v)
		|	South	:	DEC (v)
		|	West		:	DEC (u)
		|	East		:	INC (u)
		ELSE RETURN LSD.one
		END;
		IF (u = -1) OR (u = Dim) OR (v = -1) OR (v = Dim) THEN (* at border *)
			IF (u = -1) & ~ODD (v) THEN RETURN CheckNIL (Bus (ga, 0, v, EBusN, 0, NIL), 0, v, EBusN)
			ELSIF (u = Dim) & ODD (v) THEN RETURN CheckNIL (Bus (ga, Dim - 1, v, EBusS, Dim - 1, NIL), Dim - 1, v, EBusS)
			ELSIF (v = -1) & ODD (u) THEN RETURN CheckNIL (Bus (ga, u, 0, EBusE, 0, NIL), u, 0, EBusE)
			ELSIF (v = Dim) & ~ODD (u) THEN RETURN CheckNIL (Bus (ga, u, Dim - 1, EBusW, Dim - 1, NIL), u, Dim - 1, EBusW)
			ELSE (* pad *)
				IF (u < 0) OR (u >= Dim) THEN v := (v - 1) DIV 2 ELSE u := (u - 1) DIV 2 END;
				L := CLGAs.LabelAt (ga, u, v, AOut);
				IF L # NIL THEN
					var := CLLola.This (topScope, L.name);
					IF var = NIL THEN
						IF u < 0 THEN dir := West; i := v
						ELSIF u >= Dim THEN dir := East; i := v
						ELSIF v < 0 THEN dir := South; i := u
						ELSE dir := North; i := u
						END;
						IF ga.p[dir, i].selector IN {TSSerial, TSParallel} THEN type := LSD.TS ELSE type := LSD.Bit END;
						var := CLLola.Enter (topScope, L.name, type); Position (var, u, v, sig)
					END
				ELSE Err (UnnamedPad, u, v, sig); var := dummy
				END;
				RETURN var
			END
		ELSE RETURN Cell (ga, u, v, AOut, NIL) (* within cell array *)
		END
	ELSIF sig = BOut THEN
		CASE ga.c[u, v].b OF
			North	:	INC (v)
		|	South	:	DEC (v)
		|	West		:	DEC (u)
		|	East		:	INC (u)
		ELSE RETURN LSD.one
		END;
		IF (u = -1) OR (u = Dim) OR (v = -1) OR (v = Dim) THEN (* at border *)
			IF u = -1 THEN
				IF ~ODD (v) THEN RETURN CheckNIL (Bus (ga, 0, v, EBusS, 0, NIL), 0, v, EBusS)
				ELSIF v < Dim - 1 THEN RETURN Cell (ga, 0, v + 1, BOut, NIL)
				ELSE Err (BorderConn, 0, v, sig)
				END
			ELSIF u = Dim THEN
				IF ODD (v) THEN RETURN CheckNIL (Bus (ga, Dim - 1, v, EBusN, Dim - 1, NIL), Dim - 1, v, EBusN)
				ELSIF v > 0 THEN RETURN Cell (ga, Dim - 1, v - 1, BOut, NIL)
				ELSE Err (BorderConn, Dim - 1, v, sig)
				END
			ELSIF v = -1 THEN
				IF ODD (u) THEN RETURN CheckNIL (Bus (ga, u, 0, EBusW, 0, NIL), u, 0, EBusW)
				ELSIF u > 0 THEN RETURN Cell (ga, u - 1, 0, BOut, NIL)
				ELSE Err (BorderConn, u, 0, sig)
				END
			ELSIF v = Dim THEN
				IF ~ODD (u) THEN RETURN CheckNIL (Bus (ga, u, Dim - 1, EBusE, Dim - 1, NIL), u, Dim - 1, EBusE)
				ELSIF u < Dim - 1 THEN RETURN Cell (ga, u + 1, Dim - 1, BOut, NIL)
				ELSE Err (BorderConn, u, Dim - 1, sig)
				END
			END;
			RETURN dummy
		ELSE
			RETURN Cell (ga, u, v, BOut, NIL) (* within cell *)
		END
	ELSE (* local bus *)
		IF sig IN {LBusN, LBusS} THEN from := u ELSE from := v END;
		RETURN CheckNIL (Bus (ga, u, v, sig, from, NIL), u, v, sig)
	END
END Input;

PROCEDURE Generate (ga : CLGAs.GA; u, v, sig : SHORTINT) : LSD.Signal;
(* generate tree for cell u/v/sig (prefix table based generation) *)
(* uses an argument stack for generation *)
VAR entry, i, loc : SHORTINT;
	ptr : SHORTINT; stack : ARRAY 3 OF LSD.Signal; (* argument stack *)
BEGIN
	IF Debug THEN Str ("Generate"); Ln END;
	IF sig = BOut THEN entry := (ga.c[u, v].routing * NofStates + ga.c[u, v].state ) * 2 + BOut
	ELSE entry := (ga.c[u, v].routing * NofStates + ga.c[u, v].state ) * 2 + AOut (* AOut, LBusN..LBusE *)
	END;
	ptr := -1;
	i := 0;
	WHILE i < table[entry].len DO
		CASE table[entry].data[i] OF
			or		:	DEC (ptr); stack[ptr] := CLLola.Or (stack[ptr], stack[ptr + 1])
		|	xor		:	DEC (ptr); stack[ptr] := CLLola.Xor (stack[ptr], stack[ptr + 1])
		|	and		:	DEC (ptr); stack[ptr] := CLLola.And (stack[ptr], stack[ptr + 1])
		|	not		:	stack[ptr] := CLLola.Not (stack[ptr])
		|	mux		:	DEC (ptr, 2); stack[ptr] := CLLola.Mux (stack[ptr], stack[ptr + 1], stack[ptr + 2])
		|	reg		:	DEC (ptr); stack[ptr] := CLLola.Reg (stack[ptr + 1], stack[ptr])
		|	AIn		:	INC (ptr); stack[ptr] := Input (ga, u, v, AOut)
		|	BIn		:	INC (ptr); stack[ptr] := Input (ga, u, v, BOut)
		|	LIn		:	INC (ptr);
							IF ga.c[u, v].nsL # None THEN
								IF ga.c[u, v].nsL = North THEN loc := LBusN ELSE loc := LBusS END;
								stack[ptr] := Input (ga, u, v, loc)
							ELSIF ga.c[u, v].weL # None THEN
								IF ga.c[u, v].weL = West THEN loc := LBusW ELSE loc := LBusE END;
								stack[ptr] := Input (ga, u, v, loc)
							ELSE Err (NoIn, u, v, LOut); stack[ptr] := dummy
							END
		|	ZeroIn	:	INC (ptr); stack[ptr] := LSD.zero
		|	OneIn	:	INC (ptr); stack[ptr] := LSD.one
		|	ClkIn		:	INC (ptr);
							CASE ga.clk[u] OF
								ClkOne		:	stack[ptr] := LSD.zero
							|	ClkAout		:	stack[ptr] := Cell (ga, u, Dim - 1, AOut, NIL);
													IF stack[ptr] = LSD.one THEN stack[ptr] := LSD.zero
													ELSE stack[ptr] := LSD.one
													END
							|	ClkGlobal	:	stack[ptr] := LSD.one
							|	ClkExpress	:	stack[ptr] := Input (ga, u, Dim - 1, EBusS);
													IF stack[ptr] = LSD.one THEN stack[ptr] := LSD.zero
													ELSE stack[ptr] := LSD.one
													END
							END
		END;
		IF table[entry].data[i] IN {or, xor, and, not, mux, reg} THEN Position (stack[ptr], u, v, sig) END;
		INC (i)
	END;
	RETURN stack[0]
END Generate;

PROCEDURE Cell (ga : CLGAs.GA; u, v, sig : SHORTINT; bus : LSD.Variable) : LSD.Signal;
(* build tree for cell *)
VAR n : Node; sig1, routing, state : SHORTINT; L : CLGAs.Label; m, var : LSD.Variable; e : LSD.Signal;
BEGIN
	sig1 := sig;
	IF (sig IN {LBusN..LBusE}) & (ga.c[u, v].routing = Write) THEN sig1 := AOut END;
	n := Find (searchRoot, LONG (u) + (LONG (v) + LONG (sig1) * Dim) * Dim);
IF Debug THEN
	Str ("Cell"); Int (u, 3); Int (v, 3); Int (sig, 3);
	IF n.s = NIL THEN Str (" miss") ELSE Str (" hit") END;
	Ln
END;
	IF n.s = NIL THEN (* create new nodes *)
		routing := ga.c[u, v].routing; state := ga.c[u, v].state;
		IF (routing # None) & (state # None) THEN
			IF sig IN {LBusN..LBusE} THEN
				IF  routing IN {Turn0, TurnB} THEN L := NIL ELSE L := CLGAs.LabelAt (ga, u, v, LOut) END
			ELSE L := CLGAs.LabelAt (ga, u, v, sig)
			END;
			m := Mark (u, v, sig); n.s := m; (* insert temporary variables to prevent cycles *)
			IF (L # NIL) & IsConstant (L.name) THEN L := NIL END; (* don't stop at labels whose Lola variable is constant *)
			IF L = NIL THEN
				IF (sig IN {LBusN..LBusE}) & (routing IN {Turn0, TurnB}) THEN (* cornerturn *)
					IF sig IN {LBusN, LBusS} THEN
						IF ga.c[u, v].weL = West THEN sig := LBusW ELSE sig := LBusE END;
						n.s := Bus (ga, u, v, sig, v, bus)
					ELSE
						IF ga.c[u, v].nsL = North THEN sig := LBusN ELSE sig := LBusS END;
						n.s := Bus (ga, u, v, sig, u, bus)
					END
				ELSE (* sig IN {AOut, BOut, LBusN..LBusE} *)
					n.s := Generate (ga, u, v, sig)
				END
			ELSE (* stop at labels *)
				n.s := CLLola.Enter (topScope, L.name, LSD.Bit); Position (n.s, u, v, sig)
			END;
			IF sig IN {LBusN..LBusE} THEN
				IF routing = TS THEN
					e := Input (ga, u, v, BOut); (* what if e uses cell output (m) ??? *)
					IF (bus # NIL) THEN CLLola.Assign (bus, CLLola.TS (e, n.s)); Position (bus.x.x, u, v, sig)
					ELSIF e # LSD.one THEN Err (AnonBus, u, v, sig) (* constantly enabled TS *)
					END
				ELSIF bus # NIL THEN Err (NoTS, u, v, sig)
				END
			END;
			Fixup (m, n.s, n.s) (* remove temporary variable, detect latches, registers with enable, SR FFs *)
		ELSE Err (UndefCell, u, v, sig); n.s := dummy (* undefined routing or state *)
		END;
		IF Debug THEN Str ("Cell done"); Int (u, 3); Int (v, 3); Int (sig, 3); Ln END
	ELSE Fixup (NIL, n.s, n.s) (* need fixup, because may have come from a different direction previously *)
	END;
	RETURN n.s
END Cell;

PROCEDURE Segment (ga : CLGAs.GA; VAR u, v, sig : SHORTINT; dir : SHORTINT; VAR pass : BOOLEAN) : LSD.Variable;
(* traverse a bus segment follow repeaters at both ends *)
VAR bus, var : LSD.Variable; L : CLGAs.Label; repU, repV, r : INTEGER; locBus, exprBus : SHORTINT;
BEGIN
	bus := NIL; pass := FALSE; repU := u; repV := v;
	IF sig IN {LBusN, LBusS, EBusN, EBusS} THEN
		IF dir = Left THEN DEC (u, Sector); repU := u DIV Sector
		ELSE repU := u DIV Sector; INC (u, Sector)
		END
	ELSE (* sig IN {LBusW, LBusE, EBusW, EBusE} *)
		IF dir = Left THEN repV := v DIV Sector; INC (v, Sector)
		ELSE DEC (v, Sector); repV := v DIV Sector
		END
	END;
	IF (u >= 0) & (u < Dim) & (v >= 0) & (v < Dim) THEN
		CASE sig OF
			LBusN, EBusN	:	r := ga.hr[repU, repV].n; locBus := LBusN; exprBus := EBusN
		|	LBusS, EBusS	:	r := ga.hr[repU, repV].s; locBus := LBusS; exprBus := EBusS
		|	LBusW, EBusW	:	r := ga.vr[repU, repV].w; locBus := LBusW; exprBus := EBusW
		|	LBusE, EBusE	:	r := ga.vr[repU, repV].e; locBus := LBusE; exprBus := EBusE
		END;
		IF ((r >= PassGate) & (sig IN {LBusN..LBusE})) OR ODD (r DIV rep[Local, (sig - LBusN) DIV 4, dir]) THEN
			sig := locBus; pass := ((r >= PassGate) & (sig IN {LBusN..LBusE}))
		ELSIF ODD (r DIV rep[Express, (sig - LBusN) DIV 4, dir]) THEN sig := exprBus
		ELSE sig := None (* signal end reached *)
		END;
		L := CLGAs.LabelAt (ga, u, v, sig);
		IF (L # NIL) & IsConstant (L.name) THEN L := NIL END; (* don't stop at labels whose Lola variable is constant *)
		IF L # NIL THEN
			bus := CLLola.Enter (topScope, L.name, LSD.TS); Position (bus, u, v, sig)
		END
	ELSE sig := None (* signal boarder reached *)
	END;
	RETURN bus
END Segment;

PROCEDURE Adjust (ga : CLGAs.GA; VAR u, v, sig : SHORTINT; dir : SHORTINT; val : INTEGER);
(* adjust repeater values to prevent endless loops with pass gates *)
VAR repU, repV : INTEGER;
BEGIN
	repU := u; repV := v;
	IF sig IN {LBusN, LBusS, EBusN, EBusS} THEN
		IF dir = Left THEN repU := (u - Sector) DIV Sector ELSE repU := u DIV Sector END
	ELSE (* sig IN {LBusW, LBusE, EBusW, EBusE} *)
		IF dir = Left THEN repV := v DIV Sector ELSE repV := (v - Sector) DIV Sector END
	END;
	CASE sig OF
		LBusN	:	INC (ga.hr[repU, repV].n, val)
	|	LBusS	:	INC (ga.hr[repU, repV].s, val)
	|	LBusW	:	INC (ga.vr[repU, repV].w, val)
	|	LBusE	:	INC (ga.vr[repU, repV].e, val)
	END;
END Adjust;

PROCEDURE Bus (ga : CLGAs.GA; u, v, sig, from : SHORTINT; bus : LSD.Variable) : LSD.Signal;
(* traverse a bus line (local, express) *)
VAR u1, v1, sig1, nofOuts, dir : SHORTINT; s, s1 : LSD.Signal; b, var : LSD.Variable; routing, state : SHORTINT; L : CLGAs.Label;
	pass : BOOLEAN;
BEGIN
	IF Debug THEN Str ("Bus"); Int (u, 3); Int (v, 3); Int (sig, 3); Ln END;
	IF sig IN {LBusN, LBusS, EBusN, EBusS} THEN u := (u DIV Sector) * Sector (* adjust to sector bounds *)
	ELSE v := (v DIV Sector) * Sector
	END;
	IF bus = NIL THEN (* search for bus label *)
		L := CLGAs.LabelAt (ga, u, v, sig);
		IF (L # NIL) & IsConstant (L.name) THEN L := NIL END; (* don't stop at labels whose Lola variable is constant *)
		b := NIL;
		IF L # NIL THEN
			b := CLLola.Enter (topScope, L.name, LSD.TS); Position (b, u, v, sig)
		END;
		IF b = NIL THEN
			u1 := u; v1 := v; sig1 := sig;
			REPEAT (* follow to the left/up *)
				b := Segment (ga, u1, v1, sig1, Left, pass)
			UNTIL (b # NIL) OR (sig1 = None)
		END;
		IF b = NIL THEN (* follow to the right/down (we need this second IF!) *)
			u1 := u; v1 := v; sig1 := sig;
			REPEAT
				b := Segment (ga, u1, v1, sig1, Right, pass)
			UNTIL (b # NIL) OR (sig1 = None)
		END;
		IF b # NIL THEN RETURN b END (* stop at labels *)
	END;
	s := NIL; s1 := NIL; nofOuts :=0;
	IF sig IN {LBusN,LBusS} THEN (* look for outputs to local bus *)
		IF sig = LBusN THEN dir := North ELSE dir := South END;
		u1 := u;
		WHILE u1 < u + Sector DO (* look for outputs to local bus *)
			routing := ga.c[u1, v].routing; state := ga.c[u1, v].state;
			IF ga.c[u1, v].nsL = dir THEN (* potential output *)
				IF (routing IN {Write, TS}) OR ((u1 # from) & (ga.c[u1, v].weL # None)) THEN
					IF (routing = None) & (state = None) THEN ga.c[u1, v].routing:= TurnB; ga.c[u1, v].state := State0 END;
					s1 := Cell (ga, u1, v, sig, bus);
					IF s1 # NIL THEN s := s1; INC (nofOuts) END;
					IF (routing = None) & (state = None) THEN ga.c[u1, v].routing:= None; ga.c[u1, v].state := None END
				END
			END;
			INC (u1)
		END
	ELSIF sig IN {LBusW,LBusE} THEN (* look for outputs to local bus *)
		IF sig = LBusW THEN dir := West ELSE dir := East END;
		v1 := v;
		WHILE v1 < v + Sector DO
			routing := ga.c[u, v1].routing; state := ga.c[u, v1].state;
			IF ga.c[u, v1].weL = dir THEN (* potential output *)
				IF (routing IN {Write, TS}) OR ((v1 # from) & (ga.c[u, v1].nsL # None)) THEN
					IF (routing = None) & (state = None) THEN ga.c[u, v1].routing:= TurnB; ga.c[u, v1].state := State0 END;
					s1 := Cell (ga, u, v1, sig, bus);
					IF s1 # NIL THEN s := s1; INC (nofOuts) END;
					IF (routing = None) & (state = None) THEN ga.c[u, v1].routing:= None; ga.c[u, v1].state := None END
				END
			END;
			INC (v1)
		END
	END;
	u1 := u; v1 := v; sig1 := sig; (* check adjacent left/upper segment *)
	b := Segment (ga, u1, v1, sig1, Left, pass);
	IF sig1 # None THEN
		IF pass THEN Adjust (ga, u, v, sig, Left, -PassGate) END; (* prevent infinite loops with pass gates *)
		s1 := Bus (ga, u1, v1, sig1, -1, bus);
		IF pass THEN Adjust (ga, u, v, sig, Left, PassGate) END;
		IF s1 # NIL THEN s := s1; INC (nofOuts)
		ELSE Err (EmptyBus, u1, v1, sig1); s := dummy
		END
	ELSIF ((sig IN {EBusN, EBusS}) & (u1 < 0)) OR ((sig IN {EBusW, EBusE}) & (v1 >= Dim)) THEN (* left/upper border *)
		IF (sig = EBusN) & ODD (v) THEN s1 := Cell (ga, 0, v, BOut, bus)
		ELSIF (sig = EBusS) & ODD (v) THEN s1 := Cell (ga, 0, v, AOut, bus)
		ELSIF (sig = EBusW) & ODD (u) THEN s1 := Cell (ga, u, Dim - 1, BOut, bus)
		ELSIF (sig = EBusE) & ODD (u) THEN s1 := Cell (ga, u, Dim - 1, AOut, bus)
		END;
		IF s1 # NIL THEN s := s1; INC (nofOuts) END
	END;
	u1 := u; v1 := v; sig1 := sig; (* check adjacent right/lower segment *)
	b := Segment (ga, u1, v1, sig1, Right, pass);
	IF sig1 # None THEN
		IF pass THEN Adjust (ga, u, v, sig, Right, -PassGate) END; (* prevent infinite loops with pass gates *)
		s1 := Bus (ga, u1, v1, sig1, -1, bus);
		IF pass THEN Adjust (ga, u, v, sig, Right, PassGate) END;
		IF s1 # NIL THEN s := s1; INC (nofOuts)
		ELSE Err (EmptyBus, u1, v1, sig1); s := dummy
		END
	ELSIF ((sig IN {EBusN, EBusS}) & (u1 >= Dim)) OR ((sig IN {EBusW, EBusE}) & (v1 < 0)) THEN (* right/lower border *)
		s1 := NIL;
		IF (sig = EBusN) & ~ODD (v) THEN s1 := Cell (ga, Dim - 1, v, AOut, bus)
		ELSIF (sig = EBusS) & ~ODD (v) THEN s1 := Cell (ga, Dim - 1, v, BOut, bus)
		ELSIF (sig = EBusW) & ~ODD (u) THEN s1 := Cell (ga, u, 0, AOut, bus)
		ELSIF (sig = EBusE) & ~ODD (u) THEN s1 := Cell (ga, u, 0, BOut, bus)
		END;
		IF s1 # NIL THEN s := s1; INC (nofOuts) END
	END;
	IF (nofOuts > 1) & (bus = NIL) THEN Err (TwoOuts, u, v, sig) END;
	RETURN s
END Bus;

PROCEDURE Pad (ga : CLGAs.GA; u, v, sig : SHORTINT; bus : LSD.Variable) : LSD.Signal;
(* handle borders *)
VAR u1, v1, sel, b, serb, parb : SHORTINT; s, en : LSD.Signal;
BEGIN
	IF u < 0 THEN sel := ga.p[West, v].selector; u1 := 0; v1 := 2 * v + 2; serb := LBusS; parb := LBusW
	ELSIF u >= Dim THEN sel := ga.p[East, v].selector; u1 := Dim - 1; v1 := 2 * v + 1; serb := LBusN; parb := LBusE
	ELSIF v < 0 THEN sel := ga.p[South, u].selector; u1 := 2 * u + 1; v1 := 0; serb := LBusE; parb := LBusS
	ELSE sel := ga.p[North, u].selector; u1 := 2 * u + 2; v1 := Dim - 1; serb := LBusW; parb := LBusN
	END;
	s := dummy;
	CASE sel OF
		TSOff		:	Err (UndefPad, u, v, sig)
	|	TSSerial,
		TSParallel	:	IF sel = TSSerial THEN b := serb ELSE b := parb END;
							IF bus # NIL THEN
								s := Cell (ga, u1, v1, AOut, NIL);
								en := CheckNIL (Bus (ga, u1, v1, b, -1, NIL), u1, v1, b);
								CLLola.Assign (bus, CLLola.TS (CLLola.Not (en), s));
								Position (bus.x.x, u, v, sig)
							ELSE Err (NoBusVar, u, v, sig)
							END
	|	TSOn		:	IF bus = NIL THEN s := Cell (ga, u1, v1, AOut, NIL)
							ELSE Err (NoTS, u, v, sig)
							END
	END;
	RETURN s
END Pad;


PROCEDURE BusVar (ga : CLGAs.GA; name : ARRAY OF CHAR);
(* extract a bus variable *)
VAR L : CLGAs.Label; ignore : LSD.Signal; out : LSD.Variable;
BEGIN
	L := CLGAs.This (ga, name);
	IF L # NIL THEN
		out := CLLola.Enter (topScope, name, LSD.TS);
		Position (out, SHORT (L.u), SHORT (L.v), L.sig);
		IF (L.u < 0) OR (L.u >= Dim) OR (L.v < 0 ) OR (L.v >= Dim) THEN
			ignore := Pad (ga, SHORT (L.u), SHORT (L.v), L.sig, out)
		ELSIF L.sig IN {LBusN..EBusE} THEN
			ignore := CheckNIL (Bus (ga, SHORT (L.u), SHORT (L.v), L.sig, -1, out), SHORT (L.u), SHORT (L.v), L.sig)
		ELSE Err (NoBusVar, SHORT (L.u), SHORT (L.v), L.sig)
		END
	ELSE Err (NoDesignVar, 0, 0, 0)
	END
END BusVar;

PROCEDURE Var (ga : CLGAs.GA; name : ARRAY OF CHAR);
(* extract a normal variable *)
VAR L : CLGAs.Label; out : LSD.Variable; s : LSD.Signal; sel : INTEGER;
BEGIN
	L := CLGAs.This (ga, name);
	IF L # NIL THEN
		IF L.sig IN {AOut, BOut} THEN
			IF (L.u < 0) OR (L.u >= Dim) OR (L.v < 0 ) OR (L.v >= Dim) THEN
				IF L.u < 0 THEN sel := ga.p[West, L.v].selector
				ELSIF L.u >= Dim THEN sel := ga.p[East, L.v].selector
				ELSIF L.v < 0 THEN sel := ga.p[South, L.u].selector
				ELSE sel := ga.p[North, L.u].selector
				END;
				IF sel IN {TSOff, TSOn} THEN (* LSD.norm variable *)
					out := CLLola.Enter (topScope, name, LSD.Bit);
					Position (out, SHORT (L.u), SHORT (L.v), L.sig);
					CLLola.Assign (out, Pad (ga, SHORT (L.u), SHORT (L.v), L.sig, NIL))
				ELSE BusVar (ga, name) (* LSD.tsbus variable *)
				END
			ELSIF (ga.c[L.u, L.v].routing # None) & (ga.c[L.u, L.v].state # None) THEN
				out := CLLola.Enter (topScope, name, LSD.Bit);
				Position (out, SHORT (L.u), SHORT (L.v), L.sig);
				s := Generate (ga, SHORT (L.u), SHORT (L.v), L.sig);
				Fixup (NIL, out, s); (* handle special cases (like FF := SR (set', reset')) *)
				CLLola.Assign (out, s)
			ELSE Err (UndefCell, SHORT (L.u), SHORT (L.v), L.sig)
			END
		ELSE Err (ABLabel, SHORT (L.u), SHORT (L.v), L.sig)
		END
	ELSE Err (NoDesignVar, 0, 0, 0)
	END
END Var;


PROCEDURE NewScope (VAR scope : LSD.Variable);
BEGIN
	NEW (scope); scope.x := NIL; scope.y := NIL; scope.fct := LSD.Array; 
	scope.name := "Extract"; scope.next := NIL; scope.dsc := NIL;
END NewScope;


PROCEDURE Init*;
BEGIN
	NewScope (topScope); searchRoot := NIL; ok := TRUE
END Init;

PROCEDURE Extract* (ga : CLGAs.GA; name : ARRAY OF CHAR; VAR var : LSD.Variable);
(* extract a variable *)
VAR L : CLGAs.Label; s : ARRAY CLGAs.LabelLen OF CHAR; i : INTEGER; var2 : LSD.Variable;
BEGIN
	ok := TRUE; var := NIL; COPY (name, s);
	L := CLGAs.This (ga, s);
	IF L = NIL THEN
		i := 0; WHILE s[i] # 0X DO INC (i) END;
		IF (i > 0) & (s[i - 1] = "'") THEN s[i - 1] := 0X ELSE s[i] := "'"; s[i + 1] := 0X END;
		L := CLGAs.This (ga, s)
	END;
	IF L # NIL THEN
		IF L.sig IN {LBusN..EBusE} THEN BusVar (ga, s) ELSE Var (ga, s) END;
		IF ok THEN var := CLLola.This (topScope, s) END
	ELSIF IsConstant (name) THEN (* create matching constant variable *)
		var2 := CLLola.This (LSD.org, name);
		var := CLLola.Enter (topScope, name, var2.fct); var.x := var2.x;
	ELSE Err (NoDesignVar, -1, -1, -1)
	END;
END Extract;


PROCEDURE InitTable (routing, state, outSig : SHORTINT);
(* initialization stuff *)
VAR entry, len : SHORTINT;

	PROCEDURE Init (op : SHORTINT);
	BEGIN
		table[entry].data[len] := op; INC (len)
	END Init;

	PROCEDURE A;
	BEGIN
		CASE routing OF
			Write, TS, Turn0, TurnB	:	Init (AIn)
		|	Read, Mux				:	Init (AIn); Init (LIn); Init (and)
		END
	END A;

	PROCEDURE B;
	BEGIN
		CASE routing OF
			Write, Read, TurnB	:	Init (BIn)
		|	TS, Turn0			:	Init (ZeroIn)
		|	Mux					:	Init (LIn); Init (not); Init (BIn); Init (and)
		END
	END B;

BEGIN
	entry := (routing * NofStates + state ) * 2 + outSig;
	len := 0;
	IF outSig = AOut THEN
		IF state = State0 THEN A
		ELSIF state = State1 THEN B
		ELSE
			IF routing = Mux THEN Init (LIn); Init (BIn); Init (AIn); Init (mux)
			ELSE
				A;
				IF routing IN {Write, Read, TurnB, Mux} THEN B; Init (xor) END
			END;
			IF state = State3 THEN Init (ClkIn); Init (reg) END
		END
	ELSE (* BOut *)
		IF state = State0 THEN B
		ELSIF state = State1 THEN A
		ELSIF routing IN {Write, Read, TurnB} THEN (* B # zero *)
			A; B; Init (and);
			IF state = State2 THEN Init (not) END
		ELSIF state = State2 THEN
			Init (OneIn)
		ELSE Init (ZeroIn)
		END
	END;
	table[entry].len := len
END InitTable;

PROCEDURE Setup;
(* initialization stuff *)
VAR i, j : SHORTINT;
BEGIN
	FOR i := Write TO Turn0 DO
		FOR j := State0 TO State3 DO
			InitTable (i, j, AOut);
			InitTable (i, j, BOut)
		END
	END;
	rep [Express, Express, Left] := EEWE; rep [Local, Express, Left] := LEWE;
	rep [Local, Local, Left] := LLWE; rep [Express, Local, Left] := ELWE;
	rep [Express, Express, Right] := EEEW; rep [Local, Express, Right] := LEEW;
	rep [Local, Local, Right] := LLEW; rep [Express, Local, Right] := ELEW
END Setup;


BEGIN
	Texts.OpenWriter (W);
	Init; NewScope (markScope); marks := NIL; dummy := LSD.one; showErr := TRUE;
	Setup
	
END CLExtractor.
