7	  Syntax10.Scn.Fnt       p  StampElems Alloc 7 Jun 94  X   Syntax10b.Scn.Fnt      d   Syntax10i.Scn.Fnt                                         {       }           S        V        @        l        7        v                                        E    8  FoldElems New  )    8   !    8   )    8       8   C    8   &    8       8           +    8   7   8           +    8      8       8      8       8       8   .    8      8       8      8       8   s   8   7    8      8   '    8       8   ,    8   F   8   ,    8   F   8   &    8      8   =    8       8   =    8       8   &    8   j    8   &    8   j    8   &    8      8   *    8          P                U        a                       &                M        ]                                        +        X                O                        +        X                O                    8   }    8   
   8               8       8   $    8      8               8   j    8               8   j    8           !    8           T    8           !    8   )        ;    8           %    8   )        J    8   +    J  MODULE CLLoader; (* sg 2 Dec 92/ *) (* s. "A guide to the Configuration of a CLi6002 and the bitstream file" *)

IMPORT SYSTEM, CLGAs, Texts, Oberon;

CONST
	PC = FALSE; HasBoard = TRUE; NoBoard = " No board in this machine!";	(* search for PC *)
	BufferSize = 4096;
	FirstWindow = 8;
	DataOffset = 5;
	Preamble* = 0B2X;
	Postamble* = 04DX;
	Core* = 0; (* absolute starting addresses of CLi6002 sections *)
	VRep* = 2048;
	HRep* = 2240;
	IOSouth* = 2432;
	IONorth* = 2496;
	IOWest* = 2560;
	IOEast* = 2592;
	Tristate* = 2624;

	C3IOSel0Base = 0F8000000H; C3IOSel1Base =  0F9000000H; (* Ceres 3 *)
	C2IOBase = 0FFFF4000H; (* Ceres 2 *)
	PCIOBase = 300H; (* PC ISA board *)

(* PC
	CurrBase = PCIOBase;
	State = CurrBase + 0CH;	(* read *)
	Data = CurrBase;	(* read/write *)
	Configure = CurrBase + 4H;	(* write *)
	Clear = CurrBase + 8H;
	Setup = CurrBase + 0CH;
*)

(* Ceres *)
	CurrBase = C3IOSel0Base; (* set this constant depending on machine/slot *)
	State = CurrBase + 0C0H; (* read locations *)
	(* communication modes *)
	Data = CurrBase + 000H; (* normal operating mode (6) for data reads/writes *)
	Configure = CurrBase + 040H; (* configuration *)
	Clear = CurrBase + 080H; (* register reset *)
	Setup = CurrBase + 0C0H; (* configuration setup *)
(**)

	(* signal bits *)
	ConBit = 0; (* bit position of CON' status *)
	Con = 1; (* configure' *)
	CS = 2; (* chip select' *)
	CClk = 4; (* configuration clock *)
	Boot = 8; (* reboot chip *)

VAR
	buffer* : ARRAY BufferSize OF CHAR;
	cnt*, nofWindows : INTEGER; (* index of next write/window counter *)
	windowStart : INTEGER; (* start index of current window *)
	W : Texts.Writer;

(* PC
PROCEDURE- InAlDx 0EDX;
PROCEDURE- OutDxAl 0EEX; (* OUT DX,AX does not work (?) *)
*)

PROCEDURE GET(adr: LONGINT; VAR val: SYSTEM.BYTE);
	VAR ch: CHAR;
BEGIN
	IF PC THEN (* SYSTEM.PUTREG(2, adr); InAlDx; SYSTEM.GETREG(0, ch); val := ch *)
	ELSE SYSTEM.GET(adr, val)
	END
END GET;

PROCEDURE PUT(adr: LONGINT; val: SYSTEM.BYTE);
BEGIN
	IF PC THEN (* SYSTEM.PUTREG(2, adr); SYSTEM.PUTREG(0, val); OutDxAl *)
	ELSE SYSTEM.PUT(adr, val)
	END
END PUT;

PROCEDURE BIT(adr, n: LONGINT): BOOLEAN;
	VAR val: CHAR;
BEGIN
	IF PC THEN (* GET(adr, val); RETURN n IN SYSTEM.VAL(SET, val) *)
	ELSE RETURN SYSTEM.BIT(adr, n)
	END
END BIT;

PROCEDURE Str (s : ARRAY OF CHAR);
BEGIN
	Texts.WriteString (W, s)
END Str;

PROCEDURE Int (i, w : LONGINT);
BEGIN
	Texts.WriteInt (W, i, w)
END Int;

PROCEDURE Ln;
BEGIN
	Texts.WriteLn (W); Texts.Append (Oberon.Log, W.buf)
END Ln;

PROCEDURE Msg (msg : ARRAY OF CHAR);
BEGIN
	Str (msg); Ln
END Msg;

PROCEDURE WordBit2Abs* (word, bit : INTEGER; VAR abs : INTEGER);
BEGIN
	IF bit < 64 THEN
		IF word >= 35 THEN abs := (word - 35) * 64 + bit + IOSouth
		ELSE abs := word * 64 + bit
		END
	ELSIF word >= 32 THEN abs := (word - 32) * 8 + bit - 64 + Tristate
	ELSIF bit < 70 THEN abs := word * 6 + bit - 64 + HRep
	ELSE abs := (bit - 70) * 32 + word + IOWest
	END
END WordBit2Abs;

PROCEDURE Abs2WordBit* (abs : INTEGER; VAR word, bit : INTEGER);
BEGIN
	IF abs < HRep THEN word := abs DIV 64; bit := abs MOD 64
	ELSIF abs < IOSouth THEN word := (abs - HRep) DIV 6; bit := (abs - HRep) MOD 6 + 64
	ELSIF abs < IOWest THEN word := (abs - IOSouth) DIV 64 + 35; bit := (abs - IOSouth) MOD 64
	ELSIF abs < Tristate THEN bit := (abs - IOWest) DIV 32 + 70; word := (abs - IOWest) MOD 32
	ELSE word := (abs - Tristate) DIV 8 + 32; bit := (abs - Tristate) MOD 8 + 64
	END
END Abs2WordBit;

PROCEDURE StartFile;
BEGIN
	buffer[0] := Preamble;
	buffer[1] := Preamble;
	buffer[2] := Preamble;
	buffer[3] := 04X; (* configuration register *)
	buffer[4] := 0X; (* external jump address (ignored in mode 6)*)
	buffer[5] := 0X;
	buffer[6] := 0X;
	cnt := FirstWindow; nofWindows := 0
END StartFile;

PROCEDURE EndFile;
BEGIN
	buffer[7] := CHR (255 - nofWindows); (* 1's complement *)
	buffer[cnt] := Postamble; INC (cnt);
	buffer[cnt] := Postamble; INC (cnt);
	buffer[cnt] := Postamble; INC (cnt);
	(* Str ("number of windows:"); Int (nofWindows, 4); Ln *)
END EndFile;

PROCEDURE StartWindow (word, bit : INTEGER);
BEGIN
	INC (nofWindows);
	windowStart := cnt;
	buffer[windowStart] := 0X; (* start of window marker *)
	buffer[windowStart + 1] := CHR (bit); (* window start address *)
	buffer[windowStart + 2] := CHR (word);
	cnt := windowStart + DataOffset; (* skip end address, fill in later *)
	(* Str ("window  "); Int (ORD (buffer[windowStart + 2]), 5); Int (ORD (buffer[windowStart + 1]), 5) *)
END StartWindow;

PROCEDURE EndWindow;
VAR
	startAdr, endAdr : INTEGER;
	word, bit : INTEGER;
BEGIN
	WordBit2Abs (ORD (buffer[windowStart + 2]), ORD (buffer[windowStart + 1]), startAdr);
	endAdr :=startAdr + cnt - windowStart - DataOffset - 1;
	Abs2WordBit (endAdr, word, bit);
	buffer[windowStart + 3] := CHR (bit);
	buffer[windowStart + 4] := CHR (word);
	(* Str ("  ..  "); Int (ORD (buffer[windowStart + 4]), 0); Int (ORD (buffer[windowStart + 3]), 5); Ln *)
END EndWindow;

PROCEDURE Download;
(* file header/tail is 11 bytes, window header/tail is 5 bytes *)
VAR i : INTEGER;
BEGIN
	PUT (Configure, 0X); PUT (Configure, 0X); (* tickle chip *)
	PUT (Setup, CHR (Con + CS + CClk)); (* assert CS', CON' & CCKL to start download *)
	i := 0;
	WHILE i < 4 DO PUT (Configure, buffer[i]); INC (i) END; (* FPGA will assert CON' after 4 write pulses *)
	PUT (Setup, CHR (CS + CClk)); (* stop asserting CON' *)
	IF ~BIT (State, ConBit) THEN (* chip now asserts CON' itself *)
		WHILE i < cnt DO PUT (Configure, buffer[i]); INC (i) END; (* download (rest of) buffer *)
		PUT (Setup, CHR (CClk)); (* stop asserting CS' *)
		PUT (Configure, 0X); PUT (Configure, 0X); (* idle two ticks *)
		IF BIT (State, ConBit) THEN Msg (" done") ELSE Msg (" not done (configuration failed)") END;
		PUT (Clear, 0); (* reset registers *)
	ELSE Msg (" not done (no response from FPGA)")
	END
END Download;

PROCEDURE StuffCell (c : CLGAs.Cell; x, y : INTEGER);
VAR
	a, b : INTEGER;
BEGIN
	CASE c.a OF
	|	CLGAs.None	:	a := 0
	|	CLGAs.North	:	a := 1
	|	CLGAs.South	:	a := 2
	|	CLGAs.West	:	a := 4
	|	CLGAs.East	:	a := 8
	END;
	CASE c.b OF
	|	CLGAs.None	:	(* nothing *)
	|	CLGAs.North	:	a := a + 16
	|	CLGAs.South	:	a := a + 32
	|	CLGAs.West	:	a := a + 128
	|	CLGAs.East	:	a := a + 64
	END;
	CASE c.weL OF
	|	CLGAs.None	:	b := 0
	|	CLGAs.North	:	b := 8
	|	CLGAs.South	:	b := 4
	|	CLGAs.West	:	b := 1
	|	CLGAs.East	:	b := 2
	END;
	CASE c.nsL OF
	|	CLGAs.None	:	(* nothing *)
	|	CLGAs.North	:	b := b + 8
	|	CLGAs.South	:	b := b + 4
	|	CLGAs.West	:	b := b + 1
	|	CLGAs.East	:	b := b + 2
	END;
	IF (c.nsL # CLGAs.None) & (c.weL # CLGAs.None) & (c.routing = CLGAs.None) THEN c.routing := CLGAs.TurnB END;
	CASE c.routing OF
	|	CLGAs.Write, CLGAs.None	:	(* nothing *)
	|	CLGAs.TS	:	b := b + 32
	|	CLGAs.Read, CLGAs.TurnB	:	b := b + 16
	|	CLGAs.Mux, CLGAs.Turn0	:	b := b + 48
	END;
	CASE c.state OF
	|	CLGAs.State0	:	b := b + 128
	|	CLGAs.State1, CLGAs.None	:	(* nothing *)
	|	CLGAs.State2	:	b := b + 64
	|	CLGAs.State3	:	b := b + 192
	END;
	buffer[cnt] := CHR (a); INC (cnt);
	buffer[cnt] := CHR (b); INC (cnt)
END StuffCell;

PROCEDURE StuffCells (ga : CLGAs.GA);
VAR
	i, j : INTEGER;
BEGIN
	StartWindow (0, 0);
	i := 0;
	WHILE i < CLGAs.Dim DO
		j := 0;
		WHILE j < CLGAs.Dim DO StuffCell (ga.c[j, i], j, i); INC (j) END;
		INC (i)
	END;
	EndWindow
END StuffCells;

PROCEDURE StuffVRep (r : CLGAs.VRepeater);
BEGIN
	IF r.e = CLGAs.None THEN r.e := 0 END; (* check is obsolete when all designes are converted with CLTool.Update *)
	buffer[cnt] := CHR (r.e); INC (cnt);
	IF r.w = CLGAs.None THEN r.w := 0 END; (* check is obsolete when all designes are converted with CLTool.Update *)
	buffer[cnt] := CHR (r.w); INC (cnt)
END StuffVRep;

PROCEDURE StuffHRep (r : CLGAs.HRepeater);
BEGIN
	IF r.n = CLGAs.None THEN r.n := 0 END; (* check is obsolete when all designes are converted with CLTool.Update *)
	buffer[cnt] := CHR (r.n); INC (cnt);
	IF r.s = CLGAs.None THEN r.s := 0 END; (* check is obsolete when all designes are converted with CLTool.Update *)
	buffer[cnt] := CHR (r.s); INC (cnt)
END StuffHRep;

PROCEDURE StuffReps (ga : CLGAs.GA);
VAR
	i, j : INTEGER;
BEGIN
	StartWindow (32, 0);
	i := 0;
	WHILE i < CLGAs.Dim DIV CLGAs.Sector - 1 DO (* vertical repeaters *)
		j := 0;
		WHILE j < CLGAs.Dim DO StuffVRep (ga.vr [j, i]); INC (j) END;
		INC (i)
	END;
	EndWindow;
	StartWindow (0, 64);
	i := 0;
	WHILE i < CLGAs.Dim DO (* horizontal repeaters *)
		j := 0;
		WHILE j < CLGAs.Dim DIV CLGAs.Sector - 1 DO StuffHRep (ga.hr [j, i]); INC (j) END;
		INC (i)
	END;
	EndWindow
END StuffReps;

PROCEDURE StuffNPad (p : CLGAs.Pad; clk1, clk2 : SHORTINT);
BEGIN
	buffer[cnt] := CHR (clk1); INC (cnt); buffer[cnt] := CHR (p.flags); INC (cnt);
	buffer[cnt] := CHR (clk2); INC (cnt); buffer[cnt] := CHR (p.selector); INC (cnt)
END StuffNPad;

PROCEDURE StuffSPad (p : CLGAs.Pad; res1, res2 : SHORTINT);
BEGIN
	buffer[cnt] := CHR (res1); INC (cnt); buffer[cnt] := CHR (p.selector); INC (cnt);
	buffer[cnt] := CHR (res2); INC (cnt); buffer[cnt] := CHR (p.flags); INC (cnt)
END StuffSPad;

PROCEDURE StuffWPad (p : CLGAs.Pad);
BEGIN
	buffer[cnt] := CHR (p.flags); INC (cnt); buffer[cnt] := CHR (p.selector); INC (cnt)
END StuffWPad;

PROCEDURE StuffEPad (p : CLGAs.Pad);
BEGIN
	buffer[cnt] := CHR (p.selector); INC (cnt); buffer[cnt] := CHR (p.flags); INC (cnt)
END StuffEPad;

PROCEDURE StuffPads (ga : CLGAs.GA);
VAR
	i : INTEGER;
	p : CLGAs.Pad;
BEGIN
	StartWindow (35, 0);											(* south I/O *)
	buffer[cnt] := 0X; INC (cnt); (* dummy *)
	i := 0;
	WHILE i < CLGAs.Dim DIV 2 DO
		p := ga.p[CLGAs.South, i];
		IF i < 8 THEN
			IF i = 7 THEN p.flags := p.flags + 16 * ga.p[CLGAs.South, 8].flags END; (* merge B input *)
			StuffSPad (p, ga.res[2 * i], ga.res[2 * i + 1])
		ELSIF i > 8 THEN
			IF i = 9 THEN p.selector := p.selector + 16 * ga.p[CLGAs.South, 8].selector END; (* merge B output *)
			StuffSPad (p, ga.res[2 * (i - 1)], ga.res[2 * (i - 1) + 1])
		END;
		INC (i)
	END;
	buffer[cnt] := CHR (ga.res[30]); INC (cnt); buffer[cnt] := 0X; INC (cnt); buffer[cnt] := CHR (ga.res[31]); INC (cnt);
	EndWindow;

	StartWindow (36, 0);											(* north I/O *)
	buffer[cnt] := 0X; INC (cnt); (* dummy *)
	i := 0;
	WHILE i < CLGAs.Dim DIV 2 DO
		p := ga.p[CLGAs.North, i];
		IF i < 7 THEN
			IF i = 6 THEN p.selector := p.selector + 16 * ga.p[CLGAs.North, 7].selector END; (* merge B output *)
			StuffNPad (p, ga.clk[2 * i], ga.clk[2 * i + 1])
		ELSIF i > 7 THEN
			IF i = 8 THEN p.flags := p.flags + 16 * ga.p[CLGAs.North, 7].flags END; (* merge B input *)
			StuffNPad (p, ga.clk[2 * (i - 1)], ga.clk[2 * (i - 1) + 1])
		END;
		INC (i)
	END;
	buffer[cnt] := CHR (ga.clk[30]); INC (cnt); buffer[cnt] := 0X; INC (cnt); buffer[cnt] := CHR (ga.clk[31]); INC (cnt);
	EndWindow;

	StartWindow (0, 70);												(* west I/O *)
	buffer[cnt] := 0X; INC (cnt); (* dummy *)
	i := 0;
	WHILE i < CLGAs.Dim DIV 2 DO
		p := ga.p[CLGAs.West, i];
		IF i = 6 THEN p.selector := p.selector + 16 * ga.p[CLGAs.West, 7].selector (* merge B output *)
		ELSIF i = 8 THEN p.flags := p.flags + 16 * ga.p[CLGAs.West, 7].flags (* merge B input *)
		END;
		IF i # 7 THEN StuffWPad (p) END;
		INC (i)
	END;
	buffer[cnt] := 0X; INC (cnt); (* dummy *)
	EndWindow;

	StartWindow (0, 71);												(* east I/O *)
	buffer[cnt] := 0X; INC (cnt); (* dummy *)
	i := 0;
	WHILE i < CLGAs.Dim DIV 2 DO
		p := ga.p[CLGAs.East, i];
		IF i = 7 THEN p.flags := p.flags + 16 * ga.p[CLGAs.East, 8].flags (* merge B input *)
		ELSIF i = 9 THEN p.selector := p.selector + 16 * ga.p[CLGAs.East, 8].selector (* merge B output *)
		END;
		IF i # 8 THEN StuffEPad (p) END;
		INC (i)
	END;
	buffer[cnt] := 0X; INC (cnt); (* dummy *)
	EndWindow
END StuffPads;

PROCEDURE StuffTristate (ga : CLGAs.GA);
VAR
	u, v, i, l, m, p, q, s, t : INTEGER;
BEGIN
	StartWindow (32, 64);
	v := 0;
	WHILE v < (CLGAs.Dim DIV CLGAs.Sector) - 1 DO
		u := 0;
		WHILE u < (CLGAs.Dim DIV CLGAs.Sector) - 1 DO
			i := CLGAs.Sector - 1; l := 0; m := 0;
			WHILE i >= 0 DO
				l := 2 * l; m := 2 * m;
				IF ga.vr[u * CLGAs.Sector + (CLGAs.Sector DIV 2) + i, v].e >= CLGAs.PassGate THEN INC (l) END;
				IF ga.hr[u, v * CLGAs.Sector + (CLGAs.Sector DIV 2) + i].s >= CLGAs.PassGate THEN INC (m) END;
(*Int (u * CLGAs.Sector + (CLGAs.Sector DIV 2) + i, 4); Int (v, 4); Str (" east");*)
(*Int (u, 4); Int (v * CLGAs.Sector + (CLGAs.Sector DIV 2) + i, 4); Str (" south"); Ln;*)
				DEC (i)
			END;
			buffer[cnt] := CHR (l); INC (cnt);
			buffer[cnt] := CHR (m); INC (cnt);
(*Int (l, 4); Int (m, 4);*)
			INC (u)
		END;
		i := (CLGAs.Sector DIV 2) - 1; p := 0; q := 0;
		WHILE i >= 0 DO
			p := 2 * p; q := 2 * q;
			IF ga.vr[i, v].e >= CLGAs.PassGate THEN INC (p) END;
			IF ga.vr[CLGAs.Dim - (CLGAs.Sector DIV 2) + i, v].e >= CLGAs.PassGate THEN INC (q) END;
(*Int (i, 4); Int (v, 4); Str (" east");*)
(*Int (CLGAs.Dim - (CLGAs.Sector DIV 2) + i, 4); Int (v, 4); Str (" east"); Ln;*)
			DEC (i)
		END;
		buffer[cnt] := CHR (p); INC (cnt);
		buffer[cnt] := CHR (q); INC (cnt);
(*Int (p, 4); Int (q, 4); Ln;*)
		INC (v)
	END;
(*Ln;*)
	u := 0;
	WHILE u < (CLGAs.Dim DIV CLGAs.Sector) - 1 DO
		i := (CLGAs.Sector DIV 2) - 1; s := 0;
		WHILE i >= 0 DO
			s := 2 * s;
			IF ga.hr[u, i].s >= CLGAs.PassGate THEN INC (s) END;
(*Int (u, 4); Int (i, 4); Str (" south"); Ln;*)
			DEC (i)
		END;
		buffer[cnt] := CHR (s); INC (cnt);
		buffer[cnt] := 0X; INC (cnt);
(*Int (s, 4); Int (0, 4);*)
		INC (u)
	END;
	buffer[cnt] := 0X; INC (cnt);
	buffer[cnt] := 0X; INC (cnt);
(*Int (0, 4); Int (0, 4); Ln;*)
	u := 0;
	WHILE u < (CLGAs.Dim DIV CLGAs.Sector) - 1 DO
		i := CLGAs.Dim - 1; t := 0;
		WHILE i >= CLGAs.Dim - (CLGAs.Sector DIV 2) DO
			t := 2 * t;
			IF ga.hr[u, i].s >= CLGAs.PassGate THEN INC (t) END;
(*Int (u, 4); Int (i, 4); Str (" south"); Ln;*)
			DEC (i)
		END;
		buffer[cnt] := CHR (t); INC (cnt);
		buffer[cnt] := 0X; INC (cnt);
(*Int (t, 4); Int (0, 4);*)
		INC (u)
	END;
	buffer[cnt] := 0X; INC (cnt);
	buffer[cnt] := 0X; INC (cnt);
(*Int (0, 4); Int (0, 4); Ln;*)
	EndWindow
END StuffTristate;

(* check whether a configuration adheres to the board specific IO connections *)
PROCEDURE Legal (ga : CLGAs.GA) : BOOLEAN;
VAR
	i, j : INTEGER; error : BOOLEAN; c : CLGAs.Cell;

	PROCEDURE ShowErr (l : CLGAs.Label; u, v : INTEGER; msg : ARRAY OF CHAR);
	BEGIN
		error := TRUE;
		IF l # NIL THEN Str (l.name); Str (" at ") END;
		Int (u, 3); Int (v, 3); Str (" error: "); Str (msg); Ln
	END ShowErr;

	PROCEDURE Undef (dir0, dir1, u, v : INTEGER) : BOOLEAN;
	BEGIN
		RETURN (dir0 = dir1) & (u >= 0) & (u < CLGAs.Dim) & (v >= 0) & (v < CLGAs.Dim) & (ga.c[u, v].routing = CLGAs.None)
	END Undef;

	PROCEDURE PassAndLocal (rep : INTEGER) : BOOLEAN; (* TRUE iff pass gate & any local bus connected *)
	BEGIN
		IF rep >= CLGAs.PassGate THEN
			DEC (rep, CLGAs.PassGate);
			rep := (rep MOD CLGAs.EEEW) + (rep DIV CLGAs.LEEW) * CLGAs.LEEW;
			RETURN (rep > CLGAs.EEWE)
		ELSE RETURN FALSE
		END;
	END PassAndLocal;

BEGIN
	error := FALSE;
	i := 0;
	WHILE i < 7 DO
		IF ga.p[CLGAs.West, i].selector = CLGAs.TSOn THEN
			ShowErr (CLGAs.LabelAt (ga, -1, i, CLGAs.AOut), -1, i, " must not be unconditional output")
		END;
		INC (i)
	END;
	IF ga.p[CLGAs.West, 7].selector = CLGAs.TSOn THEN
		ShowErr (NIL, -1, 7, " unexpected B type output at D7")
	END;
	IF ga.p[CLGAs.West, 8].selector = CLGAs.TSOn THEN
		ShowErr (CLGAs.LabelAt (ga, -1, 7, CLGAs.AOut), -1, 7, " must not be unconditional output")
	END;
	IF ga.p[CLGAs.East, 15].selector # CLGAs.TSOff THEN
		ShowErr (CLGAs.LabelAt (ga, CLGAs.Dim, 14, CLGAs.AOut), CLGAs.Dim, 14, " is input only")
	END;
	IF ga.p[CLGAs.South, 2].selector # CLGAs.TSOff THEN
		ShowErr (CLGAs.LabelAt (ga, 2, -1, CLGAs.AOut), 2, -1, " is input only")
	END;
	IF ga.p[CLGAs.South, 6].selector # CLGAs.TSOff THEN
		ShowErr (CLGAs.LabelAt (ga, 6, -1, CLGAs.AOut), 6, -1, " is input only")
	END;
	i := 10;
	WHILE i < 15 DO
		IF ga.p[CLGAs.West, i].selector # CLGAs.TSOff THEN
			ShowErr (CLGAs.LabelAt (ga, -1, i - 1, CLGAs.AOut), -1, i - 1, " is input only")
		END;
		INC (i)
	END;
	i := 0;
	WHILE i < CLGAs.Dim DO
		j := 0;
		WHILE j < CLGAs.Dim DO
			c := ga.c[i, j];
			IF (c.routing # CLGAs.None) & (c.state # CLGAs.None) THEN
				IF Undef (c.a, CLGAs.West, i - 1, j) OR Undef (c.b, CLGAs.West, i - 1, j) OR
					Undef (c.a, CLGAs.North, i, j + 1) OR Undef (c.b, CLGAs.North, i, j + 1) OR
					Undef (c.a, CLGAs.East, i + 1, j) OR Undef (c.b, CLGAs.East, i + 1, j) OR
					Undef (c.a, CLGAs.South, i, j - 1) OR Undef (c.b, CLGAs.South, i, j - 1) OR
					((c.routing IN {CLGAs.Read, CLGAs.Mux}) & (c.weL = CLGAs.None) & (c.nsL = CLGAs.None)) THEN
						ShowErr (NIL, i, j, " has undefined inputs")
				END
			ELSIF (c.routing # CLGAs.None) OR (c.state # CLGAs.None) THEN
				ShowErr (NIL, i, j, " incompletely defined")
			END;
			INC (j)
		END;
		INC (i)
	END;
	i := 0;
	WHILE i < (CLGAs.Dim DIV CLGAs.Sector) - 1 DO (* check for conflicts between pass gates and unidirectional busses *)
		j := 0;
		WHILE j < CLGAs.Dim DO
			IF PassAndLocal (ga.hr[i, j].s) THEN ShowErr (NIL, i, j, " south pass gate/repeater conflict") END;
			IF PassAndLocal (ga.vr[j, i].e) THEN ShowErr (NIL, j, i, " east pass gate/repeater conflict") END;
			INC (j)
		END;
		INC (i)
	END;
	RETURN ~error
END Legal;

PROCEDURE GetState*;
BEGIN
	IF HasBoard THEN
		IF BIT (State, ConBit) THEN Msg ("CON' is high (chip in operation mode)")
		ELSE Msg ("CON' is low (chip in configuration mode)")
		END
	ELSE Msg(NoBoard)
	END
END GetState;

PROCEDURE Initialize () : BOOLEAN;
BEGIN
	(* first wake up chip, then reboot *)
	PUT (Configure, 0FFX); PUT (Configure, 0X); PUT (Configure, 0FFX); PUT (Configure, 0X);
	PUT (Setup, CHR (Con + CS + CClk + Boot)); (* reboot (assert FPGA mode 0)*)
	PUT (Configure, 0X); PUT (Configure, 0X); (* tickle chip to start rebooting *)
	IF ~BIT (State, ConBit) THEN (* chip in reboot phase *)
		PUT (Setup, CHR (CS + CClk)); (* assert FPGA mode 6 again, let chip signal end of reboot *)
		WHILE ~BIT (State, ConBit) DO PUT (Configure, 0X) END; (* wait till reboot done *)
		RETURN TRUE
	ELSE (* not able to reboot chip *)
		PUT (Setup, CHR (CS + CClk)); (* assert FPGA mode 6 anyway *)
		Msg (" not done (no response from FPGA)");
		RETURN FALSE
	END
END Initialize;

PROCEDURE Reboot*;
BEGIN
	IF HasBoard THEN IF Initialize () THEN Msg ("reboot done") END
	ELSE Msg(NoBoard)
	END
END Reboot;

PROCEDURE Reset*;
BEGIN
	IF HasBoard THEN PUT (Clear, 0); (* clear FFs (RESET' pulse) *)
	ELSE Msg(NoBoard)
	END
END Reset;

PROCEDURE Load* (ga : CLGAs.GA; dry : BOOLEAN);
BEGIN
	dry := dry OR ~HasBoard;
	IF Legal (ga) THEN
		StartFile;
		StuffCells (ga);
		StuffReps (ga);
		StuffPads (ga);
		StuffTristate (ga);
		EndFile;
		IF ~dry THEN
			IF Initialize () THEN Download END
		END
	END
END Load;

(* offset: 0..3 *)
PROCEDURE Put* (ch : CHAR; offset : SHORTINT);
BEGIN
	IF HasBoard THEN
		IF PC THEN PUT (Data + (offset MOD 4), ch) ELSE PUT (Data + 4 * (offset MOD 4), ch) END
	END
END Put;

(* offset: 0..3 *)
PROCEDURE Get* (VAR ch : CHAR; offset : SHORTINT);
BEGIN
	IF HasBoard THEN
		IF PC THEN GET (Data + (offset MOD 4), ch) ELSE GET (Data + 4 * (offset MOD 4), ch) END
	ELSE ch := 0X
	END
END Get;

BEGIN Texts.OpenWriter (W)
END CLLoader.
