m  Syntax10.Scn.Fnt  6  Syntax10b.Scn.Fnt              W    	    $    	    >        
          
    '       W        w               r                  Syntax10i.Scn.Fnt                                                        
       ~  MODULE ErrorElems;	(** CAS 24-Jan-91 **)
	IMPORT
		Display, Input, Files, Fonts, Printer, Oberon, Texts, Viewers, MenuViewers,
		WriteTexts, WriteFrames, WriteParcs;

	CONST
		ErrFile = "Oberon2Errors.Text"; ErrFont = "Syntax8.Scn.Fnt";
		mm = WriteTexts.mm;
		CR = 0DX;
		middleKey = 1; leftKey = 2;

	TYPE
		Elem* = POINTER TO ElemDesc;
		ElemDesc* = RECORD(WriteTexts.ElemDesc)
			err*: INTEGER;
			msg*: ARRAY 128 OF CHAR
		END;

		DeleteMsg* = RECORD(Display.FrameMsg) END;
		LocateMsg* = RECORD(Display.FrameMsg)
			pos*: LONGINT
		END;


	VAR
		font*: Fonts.Font;
		W: Texts.Writer;
		lastTime: LONGINT;


	PROCEDURE MarkedFrame(): WriteFrames.Frame;
		VAR V: Viewers.Viewer;
	BEGIN V := Oberon.MarkedViewer();
		IF (V IS MenuViewers.Viewer) & (V.dsc.next IS WriteFrames.Frame) THEN RETURN V.dsc.next(WriteFrames.Frame)
		ELSE RETURN NIL
		END
	END MarkedFrame;

	PROCEDURE Show(F: WriteFrames.Frame; pos: LONGINT);
		VAR beg, end, delta: LONGINT;
	BEGIN delta := 200;
		LOOP WriteFrames.GetVisibleRange(F, beg, end);
			IF (beg <= pos) & (pos < end) OR (beg = end) THEN EXIT END;
			WriteFrames.Show(F, pos - delta); DEC(delta, 20)
		END
	END Show;


	PROCEDURE Width(E: Elem): INTEGER;
		VAR fnt: Fonts.Font; pat: Display.Pattern; i, px, dx, x, y, w, h: INTEGER;
	BEGIN fnt := Fonts.This(ErrFont); i := 0; px := 0;
		WHILE E.msg[i] # 0X DO
			Display.GetChar(fnt.raster, E.msg[i], dx, x, y, w, h, pat); INC(px, dx); INC(i)
		END;
		RETURN px + 6
	END Width;

	PROCEDURE ShowErrMsg*(E: Elem; F: Display.Frame; col: SHORTINT; x0, y0, dw: INTEGER);
		VAR fnt: Fonts.Font; pat: Display.Pattern; i, px, rm, dx, x, y, w, h: INTEGER; ch: CHAR;
	BEGIN fnt := Fonts.This(ErrFont); i := 0; px := x0 + 3; rm := x0 + dw - 3; INC(y0, 2);
		LOOP ch := E.msg[i]; INC(i);
			IF ch = 0X THEN EXIT END;
			Display.GetChar(fnt.raster, ch, dx, x, y, w, h, pat);
			IF px + dx > rm THEN EXIT END;
			Display.CopyPattern(col, pat, px + x, y0 + y, Display.invert); INC(px, dx)
		END
	END ShowErrMsg;

	PROCEDURE Expand*(E: Elem; unit: LONGINT);
		VAR S: Texts.Scanner; T: Texts.Text; n: INTEGER; ch: CHAR;
	BEGIN NEW(T); Texts.Open(T, ErrFile); Texts.OpenScanner(S, T, 0);
		REPEAT S.line := 0;
			REPEAT Texts.Scan(S) UNTIL S.eot OR (S.line # 0)
		UNTIL S.eot OR (S.class = Texts.Int) & (S.i = E.err);
		IF ~S.eot THEN Texts.Read(S, ch); n := 0;
			WHILE ~S.eot & (ch # CR) & (n + 1 < LEN(E.msg)) DO E.msg[n] := ch; INC(n); Texts.Read(S, ch) END;
			E.msg[n] := 0X; E.W := Width(E) * unit; E.DX := E.W; WriteTexts.ChangedElem(E)
		END
	END Expand;

	PROCEDURE Reduce*(E: Elem);
	BEGIN E.W := 3 * mm; E.DX := E.W; E.msg[0] := 0X; WriteTexts.ChangedElem(E)
	END Reduce;

	PROCEDURE Delete*(E: Elem);
		VAR T: WriteTexts.Text; pos: LONGINT;
	BEGIN T := WriteTexts.ElemBase(E);
		IF T # NIL THEN pos := WriteTexts.ElemPos(E); WriteTexts.Delete(T, pos, pos + 1) END
	END Delete;


	PROCEDURE Handle*(E: WriteTexts.Elem; VAR msg: Display.FrameMsg);
		VAR e: Elem; pos: LONGINT; w, h: INTEGER; keys, keysum: SET;
	BEGIN
		WITH E: Elem DO
			IF msg IS WriteTexts.DrawMsg THEN
				WITH msg: WriteTexts.DrawMsg DO w := SHORT(E.W DIV msg.unit); h := SHORT(E.H DIV msg.unit);
					Display.ReplConst(15, msg.X0 + 1, msg.Y0 + 2, w - 2, h, Display.replace);
					IF E.msg[0] # 0X THEN ShowErrMsg(E, msg.frame, msg.col, msg.X0, msg.Y0 + 2, w) END
				END
			ELSIF msg IS WriteTexts.PrintMsg THEN
				WITH msg: WriteTexts.PrintMsg DO w := SHORT(E.W DIV msg.unit); h := SHORT(E.H DIV msg.unit);
					Printer.ReplConst(msg.X0 + 1, msg.Y0 + 2, w - 2, h)
				END
			ELSIF msg IS WriteTexts.CopyMsg THEN	(*copy element*)
				WITH msg: WriteTexts.CopyMsg DO
					IF msg.e = NIL THEN NEW(e); msg.e := e ELSE e := msg.e(Elem) END;
					e.err := E.err; e.msg := E.msg
				END
			ELSIF msg IS WriteFrames.TrackMsg THEN	(*a mouse click hit the element*)
				WITH msg: WriteFrames.TrackMsg DO 
					IF msg.keys = {middleKey} THEN w := SHORT(E.W DIV msg.unit); h := SHORT(E.H DIV msg.unit);
						Oberon.RemoveMarks(msg.X0, msg.Y0, w, h);
						Display.ReplConst(15, msg.X0 + 2, msg.Y0 + 3, w - 4, h - 2, Display.invert);
						keysum := msg.keys;
						REPEAT Input.Mouse(keys, msg.X, msg.Y); keysum := keysum + keys;
							Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, msg.X, msg.Y);
						UNTIL keys = {};
						Display.ReplConst(15, msg.X0 + 2, msg.Y0 + 3, w - 4, h - 2, Display.invert);
						IF keysum = {middleKey} THEN
							IF E.msg[0] = 0X THEN Expand(E, msg.unit) ELSE Reduce(E) END
						ELSIF keysum = {middleKey, leftKey} THEN Delete(E)
						END
					END
				END
			ELSIF msg IS DeleteMsg THEN Delete(E)
			ELSIF msg IS LocateMsg THEN
				WITH msg: LocateMsg DO pos := WriteTexts.ElemPos(E);
					IF pos < msg.pos THEN msg.pos := pos END
				END
			END
		END
	END Handle;


	PROCEDURE InsertAt*(T: WriteTexts.Text; pos: LONGINT; err: INTEGER);
		VAR e: Elem;
	BEGIN NEW(e); WriteTexts.OpenElem(e, Handle, 3 * mm, 3 * mm, 3 * mm);
		e.temp := TRUE; e.err := err; e.msg[0] := 0X; WriteTexts.InsertElem(T, pos, e)
	END InsertAt;


	PROCEDURE Unmark*;
		VAR F: WriteFrames.Frame; msg: DeleteMsg;
	BEGIN F := MarkedFrame();
		IF F # NIL THEN WriteTexts.Broadcast(F.text(WriteTexts.Text), 0, F.text.len, msg) END
	END Unmark;

	PROCEDURE Mark*;
		VAR F: WriteFrames.Frame; S: Texts.Scanner; T: WriteTexts.Text;
			text: Texts.Text; beg, end, time, pos, delta: LONGINT; err: INTEGER;
	BEGIN Unmark; F := MarkedFrame(); Oberon.GetSelection(text, beg, end, time); delta := 0;
		IF (F # NIL) & (time >= lastTime) THEN lastTime := time; T := F.text(WriteTexts.Text); Texts.OpenScanner(S, text, beg);
			LOOP S.line := 0;
				REPEAT Texts.Scan(S) UNTIL S.eot OR (S.line # 0) OR (S.class = Texts.Int);
				IF S.eot OR (S.line # 0) THEN EXIT END;
				pos := S.i;
				REPEAT Texts.Scan(S) UNTIL S.eot OR (S.line # 0) OR (S.class = Texts.Int);
				IF S.eot OR (S.line # 0) THEN EXIT END;
				err := SHORT(S.i); InsertAt(T, pos + delta, err); INC(delta);
				REPEAT Texts.Scan(S) UNTIL S.eot OR (S.line # 0)
			END
		END
	END Mark;

	PROCEDURE LocateNext*;
		VAR F: WriteFrames.Frame; msg: LocateMsg; beg: LONGINT;
	BEGIN F := MarkedFrame();
		IF F # NIL THEN msg.pos := MAX(LONGINT);
			IF F.hasCar THEN beg := F.carLoc.pos ELSE beg := 0 END;
			WriteTexts.Broadcast(F.text(WriteTexts.Text), beg, F.text.len, msg);
			IF msg.pos < MAX(LONGINT) THEN Oberon.PassFocus(Viewers.This(F.X, F.Y));
				Show(F, msg.pos); WriteFrames.SetCaret(F, msg.pos + 1)
			END
		END
	END LocateNext;

BEGIN font := Fonts.This(ErrFont); Texts.OpenWriter(W); lastTime := -1
END ErrorElems.
