#   Syntax10.Scn.Fnt         
   
  MODULE Out;	
(* Stream-oriented text output, NW 15.3.94 *)
IMPORT Texts, Oberon;

VAR W: Texts.Writer;

PROCEDURE Char*(ch: CHAR);
BEGIN Texts.Write(W, ch); Texts.Append(Oberon.Log, W.buf)
END Char;

PROCEDURE String*(str: ARRAY OF CHAR);
BEGIN Texts.WriteString(W, str); Texts.Append(Oberon.Log, W.buf)
END String;

PROCEDURE Int*(i, n: LONGINT);
BEGIN Texts.WriteInt(W, i, n); Texts.Append(Oberon.Log, W.buf)
END Int;

PROCEDURE Real*(x: REAL; n: INTEGER);
BEGIN Texts.WriteReal(W, x, n); Texts.Append(Oberon.Log, W.buf)
END Real;

PROCEDURE LongReal*(x: LONGREAL; n: INTEGER);
BEGIN Texts.WriteLongReal(W, x, n); Texts.Append(Oberon.Log, W.buf)
END LongReal;

PROCEDURE Ln*;
BEGIN Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
END Ln;

BEGIN Texts.OpenWriter(W)
END Out.
