#   Syntax10.Scn.Fnt  M   M  MODULE Scheme;	(*mf 11.2.89/10.3.92*)

	IMPORT
		SVM:=SchemeMachine, SIO:=SchemeInOut,
		Oberon, Texts, MenuViewers, TextFrames, Viewers, Display;

	TYPE
		Obj=LONGINT;	(* Object. *)
		SType=SHORTINT;	(* Scheme Data Type. *)

		Bindg=POINTER TO BindgDescr;
		Env=POINTER TO EnvDescr;

		BindgDescr=RECORD l, r: Bindg; obj: Obj; ref: INTEGER END;
		EnvDescr=RECORD encl: Env; bindg: Bindg; cnt: INTEGER END;


	VAR
		globEnv: Env;

		exp: Obj;	(* Last partial expression read. *)
		cnt: INTEGER;	(* Length of last list read. *)
		error: BOOLEAN;

		gcCnt: INTEGER;
		W: Texts.Writer;


(* Parser Procedures. ****************************************************************************)

	PROCEDURE OpenEnv(base: Env): Env;	(* Extend base environment. *)
		VAR e: Env;
	BEGIN	NEW(e); e.encl:=base; e.bindg:=NIL; e.cnt:=1; (* 0 is static link! *)	RETURN e
	END OpenEnv;

	PROCEDURE AddBinding(obj: Obj; env: Env);	(* Add a binding to environment. *)
		VAR b, p, q: Bindg;
	BEGIN
		NEW(b); b.l:=NIL; b.r:=NIL; b.obj:=obj; b.ref:=env.cnt; INC(env.cnt);
		IF	env.bindg=NIL	THEN	env.bindg:=b
		ELSE	p:=env.bindg;
			REPEAT
				IF	obj < p.obj	THEN	q:=p; p:=p.l	ELSIF	obj > p.obj	THEN	q:=p; p:=p.r	ELSE	error:=TRUE; RETURN	END;
			UNTIL	p=NIL;
			IF	obj < q.obj	THEN	q.l:=b	ELSE	q.r:=b	END
		END
	END AddBinding;

	PROCEDURE Reference(obj: Obj; env: Env): Obj;	(* Return a variable reference object for 'obj'. *)
		VAR lvl: SHORTINT; b, p, q: Bindg; refobj: Obj;
	BEGIN	lvl:=0;
		REPEAT	p:=env.bindg;
			WHILE	p#NIL	DO
				IF	obj=p.obj	THEN
					IF	env=globEnv	THEN	RETURN SVM.NewGlobRef(p.ref)
					ELSE	RETURN SVM.NewLocRef(lvl, p.ref)	END
				ELSIF	obj < p.obj	THEN	q:=p; p:=p.l	ELSE	q:=p; p:=p.r	END
			END;
			INC(lvl); env:=env.encl
		UNTIL	env=NIL;	(* Must create new global binding for free variable. *)
		refobj:=SVM.NewGlobRef(globEnv.cnt); SVM.SetGlobal(globEnv.cnt, SVM.undefined);
		NEW(b); b.l:=NIL; b.r:=NIL; b.obj:=obj; b.ref:=globEnv.cnt; INC(globEnv.cnt);
		IF	obj < q.obj	THEN	q.l:=b	ELSE	q.r:=b	END;	RETURN refobj
	END Reference;

	PROCEDURE Error();
	BEGIN	error:=TRUE; SVM.Trap(SVM.errSyntx, SIO.Pos())
	END Error;


	PROCEDURE Expr(quoted: BOOLEAN; env: Env);
		VAR aux, ref: Obj;

		PROCEDURE ListExpr(tag: SType; env: Env; proper: BOOLEAN);
			VAR lst: Obj; count: INTEGER;
		BEGIN
			Expr(quoted, env);	IF	error	THEN	RETURN	END;
			lst:=SVM.TCONS(tag, exp, SVM.nil); SVM.PSH1(lst); count:=1;
			WHILE	(SIO.sym#SIO.rparenS) & (SIO.sym#SIO.periodS)	DO
				SVM.PSH1(lst);	Expr(quoted, env);	IF	error	THEN	RETURN	END;
				SVM.POP1(lst);	lst:=SVM.RCONS(lst, exp); INC(count)
			END;
			IF	SIO.sym=SIO.periodS	THEN
				IF	proper	THEN	Error(); RETURN
				ELSE	SIO.GetSym(); SVM.PSH1(lst); Expr(quoted, env);	IF	error	THEN	RETURN	END;
					SVM.POP1(lst); SVM.SETCDR(lst, exp)
				END
			END;
			IF	SIO.sym#SIO.rparenS	THEN	Error()	ELSE	SIO.GetSym(); SVM.POP1(exp); cnt:=count	END
		END ListExpr;

		PROCEDURE AndClause();
			VAR test: Obj;
		BEGIN
			Expr(FALSE, env);
			IF	error	THEN	RETURN
			ELSIF	SIO.sym=SIO.rparenS	THEN	exp:=SVM.TCONS(SVM.andC, exp, SVM.nil)
			ELSE	SVM.PSH1(exp); AndClause(); SVM.POP1(test); exp:=SVM.TCONS4(SVM.ifC, test, exp, SVM.popCmd, SVM.nil)	END
		END AndClause;

		PROCEDURE CondClause();
			VAR test, consequence: Obj;
		BEGIN
			IF	SIO.sym#SIO.lparenS	THEN	Error(); RETURN	ELSE	SIO.GetSym();	END;
			IF	SIO.sym=SIO.elseS	THEN	SIO.GetSym(); ListExpr(SVM.beginC, env, TRUE);
				IF	SIO.sym#SIO.rparenS	THEN	Error()	ELSE	SIO.GetSym()	END
			ELSE
				Expr(FALSE, env);	IF	error	THEN	RETURN	END; SVM.PSH1(exp);
				IF	SIO.sym=SIO.rparenS	THEN	SIO.GetSym(); exp:=SVM.popCmd
				ELSE	ListExpr(SVM.beginC, env, TRUE); IF	error	THEN	RETURN	END
				END;
				IF	SIO.sym=SIO.rparenS	THEN	SIO.GetSym(); SVM.POP1(test); exp:=SVM.TCONS4(SVM.ifC, test, exp, SVM.false, SVM.nil)
				ELSE	SVM.PSH1(exp); CondClause(); SVM.POP1(consequence); SVM.POP1(test);
					exp:=SVM.TCONS4(SVM.ifC, test, consequence, exp, SVM.nil)
				END
			END
		END CondClause;

		PROCEDURE IfClause();
			VAR test, consequence: Obj;
		BEGIN
			Expr(FALSE, env);	IF	error	THEN	RETURN	END; SVM.PSH1(exp);
			Expr(FALSE, env);	IF	error	THEN	RETURN	END;
			IF	SIO.sym=SIO.rparenS	THEN	SVM.POP1(test); exp:=SVM.TCONS4(SVM.ifC, test, exp, SVM.false, SVM.nil)
			ELSE
				SVM.PSH1(exp); Expr(FALSE, env);	IF	error	THEN	RETURN	END;
				SVM.POP1(consequence); SVM.POP1(test); exp:=SVM.TCONS4(SVM.ifC, test, consequence, exp, SVM.nil);
				IF	SIO.sym#SIO.rparenS	THEN	Error(); RETURN	END
			END;
			SIO.GetSym()
		END IfClause;

		PROCEDURE Lambda();
			VAR lenv: Env; restarg: Obj; nargs: INTEGER;
		BEGIN
			IF	SIO.sym=SIO.variableS	THEN
				lenv:=OpenEnv(env); AddBinding(SIO.obj, lenv); SIO.GetSym();
				ListExpr(SVM.beginC, lenv, TRUE);	IF	error	THEN	RETURN	END;
				exp:=SVM.TCONS4(SVM.lambdaC, 2, exp, SVM.false, SVM.nil)
			ELSIF	SIO.sym=SIO.lparenS	THEN	SIO.GetSym();
				IF	SIO.sym=SIO.rparenS	THEN	(* Parameterless function; no new scope needed! *)
					lenv:=env; nargs:=0; restarg:=SVM.false
				ELSE	lenv:=OpenEnv(env);
					WHILE	SIO.sym=SIO.variableS	DO	AddBinding(SIO.obj, lenv); SIO.GetSym()	END;
					IF	SIO.sym=SIO.periodS	THEN
						SIO.GetSym(); IF	SIO.sym#SIO.variableS	THEN	Error(); RETURN	END;
						AddBinding(SIO.obj, lenv); SIO.GetSym(); restarg:=SVM.true
					ELSE	restarg:=SVM.false
					END;
					IF	SIO.sym#SIO.rparenS	THEN	Error(); RETURN	END;
					nargs:=lenv.cnt
				END;
				SIO.GetSym(); ListExpr(SVM.beginC, lenv, TRUE);	IF	error	THEN	RETURN	END;
				exp:=SVM.TCONS4(SVM.lambdaC, nargs, exp, restarg, SVM.nil)
			ELSE	Error()  END
		END Lambda;


		PROCEDURE Let();
			VAR eenv, lenv: Env; let: Obj; cnt: INTEGER;
			
			PROCEDURE Binding();
				VAR ref: Obj;
			BEGIN
				IF	SIO.sym#SIO.lparenS	THEN	Error(); RETURN	ELSE	SIO.GetSym()	END;
				IF	SIO.sym#SIO.variableS	THEN	Error(); RETURN	END;
				AddBinding(SIO.obj, lenv); ref:=SVM.NewLocRef(0, cnt); SIO.GetSym();
				Expr(FALSE, eenv); exp:=SVM.TCONS(SVM.setLocC, ref, exp);
				IF	SIO.sym#SIO.rparenS	THEN	Error()	ELSE	SIO.GetSym()	END;
			END Binding;

		BEGIN
			IF	SIO.sym#SIO.lparenS	THEN	Error(); RETURN	ELSE	SIO.GetSym()	END;
			cnt:=1; eenv:=OpenEnv(env); lenv:=OpenEnv(env); Binding();	IF	error	THEN	RETURN	END;
			let:=SVM.TCONS(SVM.beginC, exp, SVM.nil); SVM.PSH1(let); SVM.PSH1(let);
			WHILE	SIO.sym#SIO.rparenS	DO
				INC(cnt); Binding();	IF	error	THEN	RETURN	END;
				SVM.POP1(let); let:=SVM.RCONS(let, exp); SVM.PSH1(let)
			END;
			SIO.GetSym(); ListExpr(SVM.pairT, lenv, TRUE); SVM.POP1(let); SVM.SETCDR(let, exp); SVM.POP1(let);
			exp:=SVM.TCONS(SVM.letC, cnt + 1, let)
		END Let;


		PROCEDURE LetRec();
			VAR lenv: Env; let: Obj;

			PROCEDURE BindConditionally(obj: Obj; env: Env): Obj;
				VAR b, p, q: Bindg; refobj: Obj;
			BEGIN
				p:=env.bindg;
				WHILE	p#NIL	DO
					IF	obj=p.obj	THEN	RETURN SVM.NewLocRef(0, p.ref)
					ELSIF	obj < p.obj	THEN	q:=p; p:=p.l	ELSE	q:=p; p:=p.r	END
				END;
				NEW(b); b.l:=NIL; b.r:=NIL; b.obj:=obj; b.ref:=env.cnt; INC(env.cnt);
				IF	env.bindg=NIL	THEN	env.bindg:=b	ELSIF	obj < q.obj	THEN	q.l:=b	ELSE	q.r:=b	END;
				RETURN SVM.NewLocRef(0, b.ref)
			END BindConditionally;

			PROCEDURE Binding();
				VAR ref: Obj;
			BEGIN
				IF	SIO.sym#SIO.lparenS	THEN	Error(); RETURN	ELSE	SIO.GetSym()	END;
				IF	SIO.sym#SIO.variableS	THEN	Error(); RETURN	END;
				ref:=BindConditionally(SIO.obj, lenv); SIO.GetSym();
				Expr(FALSE, lenv); exp:=SVM.TCONS(SVM.setLocC, ref, exp);
				IF	SIO.sym#SIO.rparenS	THEN	Error()	ELSE	SIO.GetSym()	END;
			END Binding;

		BEGIN
			lenv:=OpenEnv(env);
			IF	SIO.sym=SIO.lbracS	THEN	SIO.GetSym();
				WHILE	SIO.sym=SIO.variableS	DO	AddBinding(SIO.obj, lenv); SIO.GetSym()	END;
				IF	SIO.sym#SIO.rbracS	THEN	Error(); RETURN	ELSE	SIO.GetSym()	END
			END;
			IF	SIO.sym#SIO.lparenS	THEN	Error(); RETURN	ELSE	SIO.GetSym()	END;
			Binding();	IF	error	THEN	RETURN	END;
			let:=SVM.TCONS(SVM.beginC, exp, SVM.nil); SVM.PSH1(let); SVM.PSH1(let);
			WHILE	SIO.sym#SIO.rparenS	DO
				Binding();	IF	error	THEN	RETURN	END;
				SVM.POP1(let); let:=SVM.RCONS(let, exp); SVM.PSH1(let)
			END;
			SIO.GetSym(); ListExpr(SVM.pairT, lenv, TRUE); SVM.POP1(let); SVM.SETCDR(let, exp); SVM.POP1(let);
			exp:=SVM.TCONS(SVM.letC, lenv.cnt, let)
		END LetRec;


		PROCEDURE OrClause();
			VAR test: Obj;
		BEGIN
			Expr(FALSE, env);
			IF	error	THEN	RETURN
			ELSIF	SIO.sym=SIO.rparenS	THEN	exp:=SVM.TCONS(SVM.orC, exp, SVM.nil)
			ELSE	SVM.PSH1(exp); OrClause(); SVM.POP1(test); exp:=SVM.TCONS4(SVM.ifC, test, SVM.popCmd, exp, SVM.nil)	END
		END OrClause;


	BEGIN	(* Expr *)
		IF	quoted	THEN
			CASE	SIO.sym	OF
			| SIO.andS .. SIO.constS:	
				exp:=SIO.obj; SIO.GetSym()
			| SIO.lparenS:
				SIO.GetSym();
				IF	SIO.sym=SIO.rparenS	THEN	SIO.GetSym(); exp:=SVM.nil; ELSE	ListExpr(SVM.pairT, env, FALSE)	END
			| SIO.vecS:
				SIO.GetSym();
				IF	SIO.sym=SIO.rparenS	THEN	SIO.GetSym(); exp:=SVM.emptyVec
				ELSE	ListExpr(SVM.pairT, env, TRUE); exp:=SVM.NewArrList(SVM.vecT, cnt, exp)	END
			| SIO.quotS:
				SIO.GetSym(); Expr(TRUE, env); exp:=SVM.CONS(SIO.quoteSym, SVM.CONS(exp, SVM.nil))
			ELSE	Error()	END
		ELSE
			CASE	SIO.sym	OF
			| SIO.lparenS:
				SIO.GetSym();
				CASE	SIO.sym	OF
				| SIO.andS:	SIO.GetSym();	IF	SIO.sym=SIO.rparenS	THEN	SIO.GetSym(); exp:=SVM.true	ELSE	AndClause()	END
				| SIO.beginS:	SIO.GetSym(); ListExpr(SVM.beginC, env, TRUE)
				| SIO.condS:	SIO.GetSym(); CondClause()
				| SIO.defineS:
					IF	env#globEnv	THEN	Error(); RETURN	ELSE	SIO.GetSym()	END;
					IF	SIO.sym#SIO.variableS	THEN	Error(); RETURN	END;
					ref:=Reference(SIO.obj, globEnv); SIO.GetSym();
					Expr(FALSE, env);	IF	error	THEN	RETURN	END;
					IF	SIO.sym#SIO.rparenS	THEN	Error(); RETURN	ELSE	SIO.GetSym()	END;
					exp:=SVM.TCONS(SVM.setGlobC, ref, exp)
				| SIO.ifS:	SIO.GetSym(); IfClause()
				| SIO.lambdaS:	SIO.GetSym(); Lambda()
				| SIO.letS:	SIO.GetSym(); Let()
				| SIO.letrecS:	SIO.GetSym(); LetRec()
				| SIO.orS:	SIO.GetSym();	IF	SIO.sym=SIO.rparenS	THEN	SIO.GetSym(); exp:=SVM.false	ELSE	OrClause()	END
				| SIO.quoteS:	SIO.GetSym(); Expr(TRUE, env);	IF	SIO.sym#SIO.rparenS	THEN	Error()	END
				| SIO.setXS:
					SIO.GetSym();
					IF	SIO.sym#SIO.variableS	THEN	Error(); RETURN	END;
					ref:=Reference(SIO.obj, env); SIO.GetSym();
					Expr(FALSE, env);	IF	error	THEN	RETURN	END;
					IF	SIO.sym#SIO.rparenS	THEN	Error(); RETURN	ELSE	SIO.GetSym()	END;
					IF	SVM.TAG(ref)=SVM.globalC	THEN	exp:=SVM.TCONS(SVM.setGlobC, ref, exp)
					ELSE	exp:=SVM.TCONS(SVM.setLocC, ref, exp)	END
				| SIO.variableS:	(* Procedure Call. *)
					ref:=Reference(SIO.obj, env); SIO.GetSym();
					IF	SIO.sym=SIO.rparenS	THEN	exp:=SVM.TCONS(SVM.pcall0C, ref, SVM.nil)
					ELSE	ListExpr(SVM.pairT, env, TRUE); exp:=SVM.TCONS(SVM.pcallC, ref, exp)	END
				| SIO.lparenS:
					Expr(FALSE, env);	IF	error	THEN	RETURN	END;
					IF	SIO.sym=SIO.rparenS	THEN	exp:=SVM.TCONS(SVM.pcall0C, exp, SVM.nil)
					ELSE	SVM.PSH1(exp); ListExpr(SVM.pairT, env, TRUE); SVM.POP1(aux); exp:=SVM.TCONS(SVM.pcallC, aux, exp)	END
				ELSE	Error()	END
			| SIO.variableS:	exp:=Reference(SIO.obj, env); SIO.GetSym()
			| SIO.constS:	exp:=SIO.obj; SIO.GetSym()
			| SIO.quotS:	SIO.GetSym(); Expr(TRUE, env)
			ELSE	Error()	END
		END
	END Expr;

	PROCEDURE Read(rdr: Texts.Reader): Obj;
	BEGIN	SIO.Init(rdr); SIO.GetSym(); error:=FALSE; Expr(FALSE, globEnv);	RETURN exp
	END Read;


(* Global Environment. *************************************************************************)

	PROCEDURE EnterPredef(name: ARRAY OF CHAR; cl, num: SHORTINT);
	BEGIN	SVM.SetGlobal(globEnv.cnt, SVM.NewPProc(cl, num)); AddBinding(SIO.Enter(name), globEnv)
	END EnterPredef;

	PROCEDURE EnterPredefCh(name: CHAR; cl, num: SHORTINT);
	BEGIN	SVM.SetGlobal(globEnv.cnt, SVM.NewPProc(cl, num)); AddBinding(SIO.EnterCh(name), globEnv)
	END EnterPredefCh;

	PROCEDURE * GlobalCount(): INTEGER;
	BEGIN	INC(gcCnt); RETURN globEnv.cnt
	END GlobalCount;


(* User Interface. ******************************************************************************)

	PROCEDURE Eval*;
		VAR R: Texts.Reader; ch: CHAR; T: Texts.Text; beg, end, time: LONGINT; form: Obj;
	BEGIN	Texts.OpenReader(R, Oberon.Par.text, Oberon.Par.pos); Texts.Read(R, ch);
		WHILE	ch=" "	DO	Texts.Read(R, ch)	END;
		IF	(ch="^") OR (ch=0DX)	THEN	Oberon.GetSelection(T, beg, end, time);
			IF	time >= 0	THEN	Texts.OpenReader(R, T, beg)	END
		ELSE	Texts.OpenReader(R, Oberon.Par.text, Texts.Pos(R)-1)	END;
		IF	Oberon.Par.frame IS TextFrames.Frame	THEN	TextFrames.Mark(Oberon.Par.frame(TextFrames.Frame), -1)	END;
		SVM.ResetTrap(); form:=Read(R); gcCnt:=0; form:=SVM.Eval(form);
		SIO.Write(form, W); Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf);
		IF	Oberon.Par.frame IS TextFrames.Frame	THEN	TextFrames.Mark(Oberon.Par.frame(TextFrames.Frame), 1)	END
	END Eval;


BEGIN	NEW(globEnv); globEnv.encl:=NIL; globEnv.bindg:=NIL; globEnv.cnt:=0; SVM.globalCount:=GlobalCount;
	SVM.SetGlobal(globEnv.cnt, SVM.NewPProc(SVM.clDyadic, SVM.ppAdd)); AddBinding(SIO.plusSym, globEnv);
	SVM.SetGlobal(globEnv.cnt, SVM.NewPProc(SVM.clDyadic, SVM.ppSub)); AddBinding(SIO.minusSym, globEnv);

	EnterPredef("NOT", SVM.clMonadic, SVM.ppNot); EnterPredef("BOOLEAN?", SVM.clMonadic, SVM.ppBoolP);
	EnterPredef("EQV?", SVM.clDyadic, SVM.ppEqvP); EnterPredef("EQ?", SVM.clDyadic, SVM.ppEqP);
	EnterPredef("EQUAL?", SVM.clDyadic, SVM.ppEqualP);

	EnterPredef("PAIR?", SVM.clMonadic, SVM.ppPairP); EnterPredef("CONS", SVM.clDyadic, SVM.ppCons);
	EnterPredef("CAR", SVM.clMonadic, SVM.ppCar); EnterPredef("CDR", SVM.clMonadic, SVM.ppCdr);
	EnterPredef("SET-CAR!", SVM.clDyadic, SVM.ppSetCarX); EnterPredef("SET-CDR!", SVM.clDyadic, SVM.ppSetCdrX);
	EnterPredef("CAAR", SVM.clMonadic, SVM.ppCaar); EnterPredef("CADR", SVM.clMonadic, SVM.ppCadr);
	EnterPredef("CDAR", SVM.clMonadic, SVM.ppCdar); EnterPredef("CDDR", SVM.clMonadic, SVM.ppCddr);
	EnterPredef("CAAAR", SVM.clMonadic, SVM.ppCaaar); EnterPredef("CAADR", SVM.clMonadic, SVM.ppCaadr);
	EnterPredef("CADAR", SVM.clMonadic, SVM.ppCadar); EnterPredef("CADDR", SVM.clMonadic, SVM.ppCaddr);
	EnterPredef("CDAAR", SVM.clMonadic, SVM.ppCdaar); EnterPredef("CDADR", SVM.clMonadic, SVM.ppCdadr);
	EnterPredef("CDDAR", SVM.clMonadic, SVM.ppCddar); EnterPredef("CDDDR", SVM.clMonadic, SVM.ppCdddr);
	EnterPredef("CAAAAR", SVM.clMonadic, SVM.ppCaaaar); EnterPredef("CAAADR", SVM.clMonadic, SVM.ppCaaadr);
	EnterPredef("CAADAR", SVM.clMonadic, SVM.ppCaadar); EnterPredef("CAADDR", SVM.clMonadic, SVM.ppCaaddr);
	EnterPredef("CADAAR", SVM.clMonadic, SVM.ppCadaar); EnterPredef("CADADR", SVM.clMonadic, SVM.ppCadadr);
	EnterPredef("CADDAR", SVM.clMonadic, SVM.ppCaddar); EnterPredef("CADDDR", SVM.clMonadic, SVM.ppCadddr);
	EnterPredef("CDAAAR", SVM.clMonadic, SVM.ppCdaaar); EnterPredef("CDAADR", SVM.clMonadic, SVM.ppCdaadr);
	EnterPredef("CDADAR", SVM.clMonadic, SVM.ppCdadar); EnterPredef("CDADDR", SVM.clMonadic, SVM.ppCdaddr);
	EnterPredef("CDDAAR", SVM.clMonadic, SVM.ppCddaar); EnterPredef("CDDADR", SVM.clMonadic, SVM.ppCddadr);
	EnterPredef("CDDDAR", SVM.clMonadic, SVM.ppCdddar); EnterPredef("CDDDDR", SVM.clMonadic, SVM.ppCddddr);
	EnterPredef("NULL?", SVM.clMonadic, SVM.ppNullP);
	EnterPredef("LIST", SVM.clGeneral, SVM.ppList); EnterPredef("LENGTH", SVM.clMonadic, SVM.ppLength);
	EnterPredef("APPEND", SVM.clDyadic, SVM.ppApp); EnterPredef("REVERSE", SVM.clMonadic, SVM.ppRev);
	EnterPredef("LIST-TAIL", SVM.clDyadic, SVM.ppListTail); EnterPredef("LIST-REF", SVM.clDyadic, SVM.ppListRef);
	EnterPredef("LAST-PAIR", SVM.clMonadic, SVM.ppLastPair);
	EnterPredef("MEMQ", SVM.clDyadic, SVM.ppMemq); EnterPredef("MEMV", SVM.clDyadic, SVM.ppMemv);
	EnterPredef("MEMBER", SVM.clDyadic, SVM.ppMember); EnterPredef("ASSQ", SVM.clDyadic, SVM.ppAssq);
	EnterPredef("ASSV", SVM.clDyadic, SVM.ppAssv); EnterPredef("ASSOC", SVM.clDyadic, SVM.ppAssoc);

	EnterPredef("SYMBOL?", SVM.clMonadic, SVM.ppSymP);
	EnterPredef("SYMBOL->STRING", SVM.clMonadic, SVM.ppSymToStr);
	EnterPredef("STRING->SYMBOL", SVM.clMonadic, SVM.ppStrToSym);

	EnterPredef("NUMBER?", SVM.clMonadic, SVM.ppNumP); EnterPredef("COMPLEX?", SVM.clMonadic, SVM.ppCmxP);
	EnterPredef("REAL?", SVM.clMonadic, SVM.ppRealP); EnterPredef("RATIONAL?", SVM.clMonadic, SVM.ppRatP);
	EnterPredef("INTEGER?", SVM.clMonadic, SVM.ppIntP); EnterPredef("ZERO?", SVM.clMonadic, SVM.ppZeroP);
	EnterPredef("POSITIVE?", SVM.clMonadic, SVM.ppPosP); EnterPredef("NEGATIVE?", SVM.clMonadic, SVM.ppNeg);
	EnterPredef("ODD?", SVM.clMonadic, SVM.ppOddP); EnterPredef("EVEN?", SVM.clMonadic, SVM.ppEvenP);
	EnterPredef("EXACT?", SVM.clMonadic, SVM.ppExP); EnterPredef("INEXACT?", SVM.clMonadic, SVM.ppInexP);
	EnterPredefCh("=", SVM.clDyadic, SVM.ppEq);
	EnterPredefCh("<", SVM.clDyadic, SVM.ppLt); EnterPredefCh(">", SVM.clDyadic, SVM.ppGt);
	EnterPredef("<=", SVM.clDyadic, SVM.ppLe); EnterPredef(">=", SVM.clDyadic, SVM.ppGe);
	EnterPredef("MAX", SVM.clDyadic, SVM.ppMax); EnterPredef("MIN", SVM.clDyadic, SVM.ppMin);
	EnterPredefCh("*", SVM.clDyadic, SVM.ppMult); EnterPredefCh("/", SVM.clDyadic, SVM.ppDiv);
	EnterPredef("ABS", SVM.clMonadic, SVM.ppAbs); EnterPredef("QUOTIENT", SVM.clDyadic, SVM.ppQuot);
	EnterPredef("REMAINDER", SVM.clDyadic, SVM.ppRem); EnterPredef("MODULO", SVM.clDyadic, SVM.ppMod);

	EnterPredef("CHAR?", SVM.clMonadic, SVM.ppChP); EnterPredef("CHAR=?", SVM.clDyadic, SVM.ppChEq);
	EnterPredef("CHAR<?", SVM.clDyadic, SVM.ppChLt); EnterPredef("CHAR>?", SVM.clDyadic, SVM.ppChGt);
	EnterPredef("CHAR<=?", SVM.clDyadic, SVM.ppChLe); EnterPredef("CHAR>=?", SVM.clDyadic, SVM.ppChGe);
	EnterPredef("CHAR->INTEGER", SVM.clMonadic, SVM.ppChToInt); EnterPredef("INTEGER->CHAR", SVM.clMonadic, SVM.ppIntToCh);

	EnterPredef("STRING?", SVM.clMonadic, SVM.ppStrP); EnterPredef("STRING-LENGTH", SVM.clMonadic, SVM.ppStrLength);
	EnterPredef("STRING-REF", SVM.clDyadic, SVM.ppStrRef); EnterPredef("STRING=?", SVM.clDyadic, SVM.ppStrEq); 
	EnterPredef("STRING<?", SVM.clDyadic, SVM.ppStrLt); EnterPredef("STRING>?", SVM.clDyadic, SVM.ppStrGt); 
	EnterPredef("STRING<=?", SVM.clDyadic, SVM.ppStrLe); EnterPredef("STRING>=?", SVM.clDyadic, SVM.ppStrGe);
	EnterPredef("SUBSTRING", SVM.clGeneral, SVM.ppSubstr); EnterPredef("STRING-APPEND", SVM.clDyadic, SVM.ppStrApp);
	EnterPredef("STRING->LIST", SVM.clMonadic, SVM.ppStrToList); EnterPredef("LIST->STRING", SVM.clMonadic, SVM.ppListToStr);

	EnterPredef("VECTOR?", SVM.clMonadic, SVM.ppVecP); EnterPredef("MAKE-VECTOR", SVM.clMonadic, SVM.ppMkVec);
	EnterPredef("VECTOR", SVM.clGeneral, SVM.ppVec); EnterPredef("VECTOR-LENGTH", SVM.clMonadic, SVM.ppVecLength);
	EnterPredef("VECTOR-REF", SVM.clDyadic, SVM.ppVecRef); EnterPredef("VECTOR-SET!", SVM.clGeneral, SVM.ppVecSetX);
	EnterPredef("VECTOR->LIST", SVM.clMonadic, SVM.ppVecToList); EnterPredef("LIST->VECTOR", SVM.clMonadic, SVM.ppListToVec);

	EnterPredef("PROCEDURE?", SVM.clMonadic, SVM.ppProcP); EnterPredef("APPLY", SVM.clDyadic, SVM.ppApply);
	EnterPredef("MAP", SVM.clDyadic, SVM.ppMap); EnterPredef("FOR-EACH", SVM.clDyadic, SVM.ppForEach);
	EnterPredef("CALL-WITH-CURRENT-CONTINUATION", SVM.clMonadic, SVM.ppCallCC);

	EnterPredef("CALL-WITH-INPUT-FILE", SVM.clDyadic, SVM.ppCWInF);
	EnterPredef("CALL-WITH-OUTPUT-FILE", SVM.clDyadic, SVM.ppCWOutF);
	EnterPredef("CURRENT-INPUT-PORT", SVM.clNiladic, SVM.ppCurrInPrt);
	EnterPredef("CURRENT-OUTPUT-PORT", SVM.clNiladic, SVM.ppCurrOutPrt);
	EnterPredef("INPUT-PORT?", SVM.clMonadic, SVM.ppInPrtP); EnterPredef("OUTPUT-PORT?", SVM.clMonadic, SVM.ppOutPrtP);
	EnterPredef("READ", SVM.clMonadic, SVM.ppRead); EnterPredef("READ-CHAR", SVM.clMonadic, SVM.ppReadCh);
	EnterPredef("EOF-OBJECT?", SVM.clMonadic, SVM.ppEofObjP); EnterPredef("WRITE", SVM.clGeneral, SVM.ppWrite);
	EnterPredef("DISPLAY", SVM.clGeneral, SVM.ppDispl); EnterPredef("NEWLINE", SVM.clMonadic, SVM.ppNl);
	EnterPredef("WRITE-CHAR", SVM.clGeneral, SVM.ppWriteCh); EnterPredef("LOAD", SVM.clMonadic, SVM.ppLoad);

	Texts.OpenWriter(W)
END Scheme.