#   Syntax10.Scn.Fnt  $.   $.  MODULE SchemeInOut;	(*mf 11.2.89/11.5.92*)

	IMPORT
		SVM:=SchemeMachine, Texts;

	CONST
		eofS*=0;	andS*=1; beginS*=2; caseS*=3; condS*=4; defineS*=5; delayS*=6;
		doS*=7; elseS*=8; ifS*=9; lambdaS*=10; letS*=11; letXS*=12; letrecS*=13; orS*=14;
		quasiquoteS*=15; quoteS*=16; setXS*=17; unquoteS*=18; unquotesplicingS*=19; implS*=20;
		variableS*=21; constS*=22;
		lparenS*=23; rparenS*=24; lbracS*=25; rbracS*=26; vecS*=27; quotS*=28; periodS*=29; illegalS*=30;

		lexLt=0; lexEq=1; lexGt=2;	eot=0X; cr=0DX; tab=09X;


	TYPE
		Obj*=LONGINT;	(* Object. *)
		ID=INTEGER;	(* Indices into Name Table. *)

		LexTreePtr=POINTER TO LexTreeNode;
		LexTreeNode=RECORD	a, z: LexTreePtr; id: ID; obj: Obj; sym: SHORTINT	END;


	VAR
		sym*: SHORTINT;	(* Last Symbol read. *)
		obj*: Obj;	(* Object representation of last Symbol (if any). *)

		ch: CHAR;	(* Current character. *)
		R: Texts.Reader;	(* Current Reader. *)

		lexTreeRoot: LexTreePtr;	(* Sorting structure for symbol names. *)
		free: ID;	(* Index to next unused character in Name Table. (The 'name' of a symbol is its textual representation). *)
		names: ARRAY 10000 OF CHAR;	(* Character array for storing names and error messages. *)
		errors: ARRAY 28 OF ID;	(* Index to the first character of error message, indexed by error Number. *)

		plusSym*, minusSym*, quoteSym*: Obj;	(* Symbols that must be global to the scanner. *)


(* Symbol Table Management. ********************************************************************)

	PROCEDURE LexCompare(x, y: ID): SHORTINT;
	BEGIN
		WHILE names[x]=names[y] DO
			IF	names[x]= 0X	THEN	RETURN lexEq	ELSE	INC(x); INC(y)	END
		END;
		IF	names[x] < names[y]	THEN	RETURN lexLt	ELSE	RETURN lexGt	END
	END LexCompare;

	PROCEDURE Copy(strg: ARRAY OF CHAR): ID;	(* Return index of last character. *)
		VAR t: ID; n: INTEGER;
	BEGIN	t:=free; n:=0;
		WHILE	strg[n] # 0X	DO	names[t]:=strg[n]; INC(n); INC(t)	END;
		names[t]:=0X; RETURN t
	END Copy;

	PROCEDURE LinkLex(VAR lp: LexTreePtr; obj: Obj; sym: SHORTINT);
	BEGIN	NEW(lp); lp.a:=NIL; lp.z:=NIL; lp.id:=free; lp.obj:=obj; lp.sym:=sym
	END LinkLex;

	PROCEDURE Ent(name: ARRAY OF CHAR; obj: Obj; key: SHORTINT);
		VAR t: ID; lexOrder: SHORTINT; p, q: LexTreePtr;
	BEGIN
		t:=Copy(name); p:=lexTreeRoot;
		WHILE	p # NIL	DO	lexOrder:=LexCompare(free, p.id);
			IF	lexOrder=lexLt	THEN	q:=p; p:=p.a	ELSE	q:=p; p:=p.z	END
		END;
		IF	lexOrder=lexLt	THEN	LinkLex(q.a, obj, key)	ELSE	LinkLex(q.z, obj, key)	END;	free:=t+1;
	END Ent;

	PROCEDURE EnterKW(name: ARRAY OF CHAR; key: SHORTINT);
		VAR obj: Obj;
	BEGIN	obj:=SVM.NewSym(free); Ent(name, obj, key)
	END EnterKW;

	PROCEDURE Enter*(name: ARRAY OF CHAR): Obj;
		VAR obj: Obj;
	BEGIN	obj:=SVM.NewSym(free); Ent(name, obj, variableS); RETURN obj
	END Enter;

	PROCEDURE EnterCh*(ch: CHAR): Obj;
		VAR name: ARRAY 2 OF CHAR; obj: Obj;
	BEGIN	name[0]:=ch; name[1]:=0X; obj:=SVM.NewSym(free); Ent(name, obj, variableS); RETURN obj
	END EnterCh;

	PROCEDURE EnterErr(errNo: SHORTINT; msg: ARRAY OF CHAR);
	BEGIN	errors[errNo]:=free; free:=Copy(msg)+1
	END EnterErr;

	PROCEDURE * SymToString(sym: Obj): Obj;
		VAR i: ID; strg: Obj; count: INTEGER;
	BEGIN
		i:=SVM.SymName(sym); strg:=SVM.CONS(SVM.NewChar(names[i]), SVM.nil);
		SVM.PSH1(strg); count:=1; INC(i);
		WHILE	names[i] # 0X	DO	strg:=SVM.RCONS(strg, SVM.NewChar(names[i])); INC(count); INC(i)	END;
		SVM.POP1(strg); strg:=SVM.NewArrList(SVM.strgT, count, strg); RETURN strg
	END SymToString;

	PROCEDURE * StringToSym(strg: Obj): Obj;
		VAR t: ID; i, l: INTEGER; lexOrder: SHORTINT; p, q: LexTreePtr; obj: Obj;
	BEGIN	l:=SVM.ArrLen(strg); t:=free; i:=0;
		WHILE	i < l	DO	names[t]:=SVM.CharCh(SVM.ArrRef(strg, i)); INC(t); INC(i)	END;
		names[t]:=0X; p:=lexTreeRoot;
		WHILE	p # NIL	DO	lexOrder:=LexCompare(free, p.id);
			IF	lexOrder=lexEq	THEN	RETURN p.obj	ELSIF	lexOrder=lexLt
			THEN	q:=p; p:=p.a	ELSE	q:=p; p:=p.z	END
		END;
		obj:=SVM.NewSym(free);
		IF	lexOrder=lexLt	THEN	LinkLex(q.a, obj, variableS)	ELSE	LinkLex(q.z, obj, variableS)	END;
		free:=t+1; RETURN obj
	END StringToSym;


(* Scanner Procedures. **************************************************************************)

	PROCEDURE Numeral(negative: BOOLEAN);
		VAR val: LONGINT;
	BEGIN	sym:=constS;
		val:=0; REPEAT val:=10 * val+ORD(ch) - ORD("0"); Texts.Read(R, ch) UNTIL (ch < "0") OR (ch > "9");
		IF	negative	THEN	obj:=SVM.NewNum(-val)	ELSE	obj:=SVM.NewNum(val)	END
	END Numeral;

	PROCEDURE Character();
		VAR char: Obj;
	BEGIN	sym:=constS; obj:=SVM.NewChar(ch); Texts.Read(R, ch)
	END Character;

	PROCEDURE String();
		VAR strg: Obj; count: INTEGER;
	BEGIN	sym:=constS; Texts.Read(R, ch);
		IF	ch=22X	THEN	Texts.Read(R, ch); obj:=SVM.emptyStrg
		ELSE	count:=1; strg:=SVM.CONS(SVM.NewChar(ch), SVM.nil); Texts.Read(R, ch); SVM.PSH1(strg);
			WHILE	(ch # 22X) & (ch # eot)	DO
				INC(count); strg:=SVM.RCONS(strg, SVM.NewChar(ch)); Texts.Read(R, ch)
			END;
			IF	ch=22X	THEN	Texts.Read(R, ch); SVM.POP1(strg); obj:=SVM.NewArrList(SVM.strgT, count, strg)
			ELSE	sym:=eofS	END
		END
	END String;

	PROCEDURE Symbol();
		VAR i: ID; lexOrder: SHORTINT; p, q: LexTreePtr;
	BEGIN	i:=free;
		LOOP
			CASE ch OF
			| "a".."z":	names[i]:=CAP(ch); INC(i); Texts.Read(R, ch)
			| "A" .. "Z", "!", "$", "%", "&", "*", "/", ":", "<", "=", ">", "?", "~", ".", "^", "_", "+", "-", "0".."9":	names[i]:=ch; INC(i); Texts.Read(R, ch)
			| eot, " ", cr, tab, 22X, "#", "'"..")", ";", "@", "[".."]", "{".."}":	names[i]:=0X; p:=lexTreeRoot;
				WHILE	p # NIL	DO	lexOrder:=LexCompare(free, p.id);
					IF	lexOrder=lexEq	THEN	sym:=p.sym; obj:=p.obj; RETURN
					ELSIF	lexOrder=lexLt	THEN	q:=p; p:=p.a	ELSE	q:=p; p:=p.z	END
				END;
				obj:=SVM.NewSym(free);
				IF	lexOrder=lexLt	THEN	LinkLex(q.a, obj, variableS)	ELSE	LinkLex(q.z, obj, variableS)	END;
				free:=i+1; sym:=variableS; RETURN
			END
		END
	END Symbol;

	PROCEDURE GetSym*();
	BEGIN
		LOOP
			IF	(ch=" ") OR (ch=cr) OR (ch=tab)	THEN	Texts.Read(R, ch)
			ELSIF	ch=";"	THEN	REPEAT Texts.Read(R, ch) UNTIL (ch=cr) OR (ch=eot); Texts.Read(R, ch)
			ELSE	EXIT	END
		END;
		CASE	ch	OF
		| eot:	sym:=eofS; Texts.Read(R, ch)
		| "a".. "z", "A" .. "Z", "!", "$", "%", "&", "*", "/", ":", "<", "=", ">", "?", "~":	Symbol();	
		| "(":	sym:=lparenS; Texts.Read(R, ch)
		| ")":	sym:=rparenS; Texts.Read(R, ch)
		| "{":	sym:=lbracS; Texts.Read(R, ch)
		| "}":	sym:=rbracS; Texts.Read(R, ch)
		| 22X:	String()
		| "'":	sym:=quotS; Texts.Read(R, ch)
		| ".":	sym:=periodS; Texts.Read(R, ch)
		| "+":	Texts.Read(R, ch);	IF	("0" <= ch) & (ch <= "9")	THEN	Numeral(FALSE)	ELSE	sym:=variableS; obj:=plusSym	END
		| "-":	Texts.Read(R, ch);	IF	("0" <= ch) & (ch <= "9")	THEN	Numeral(TRUE)	ELSE	sym:=variableS; obj:=minusSym	END
		| "0" .. "9":	Numeral(FALSE)
		| "#":
			Texts.Read(R, ch);
			IF	(ch="t") OR (ch="T")	THEN	Texts.Read(R, ch); sym:=constS; obj:=SVM.true
			ELSIF	(ch="f") OR (ch="F")	THEN	Texts.Read(R, ch); sym:=constS; obj:=SVM.false
			ELSIF	ch="\"	THEN	Texts.Read(R, ch); Character()
			ELSIF	ch="("	THEN	Texts.Read(R, ch); sym:=vecS
			ELSE	sym:=illegalS	END
		ELSE	sym:=illegalS	END
	END GetSym;

	PROCEDURE Init*(VAR r: Texts.Reader);
	BEGIN	R:=r; Texts.Read(R, ch)
	END Init;

	PROCEDURE Pos*(): Obj;
	BEGIN	RETURN SVM.NewNum(Texts.Pos(R)-1)
	END Pos;


(* Text Output. *******************************************************************************)

	PROCEDURE Write*(obj: Obj; VAR writer: Texts.Writer);	(* Write the textual representation of "obj" into "writer". *)

		PROCEDURE WName(i: ID);
		BEGIN	WHILE names[i] # 0X DO	Texts.Write(writer, names[i]); INC(i) 	END
		END WName;

		PROCEDURE Indent(n: INTEGER);
		BEGIN	WHILE n > 0 DO Texts.WriteString(writer, "  "); DEC(n)	END
		END Indent;
			
		PROCEDURE W(form: Obj; level: INTEGER; ind, listcont: BOOLEAN);
			VAR i: ID; p: Obj; s: SHORTINT; inx, len: INTEGER;
		BEGIN
			IF	ind	THEN	Texts.WriteLn(writer); Indent(level)	END;
			CASE	SVM.TAG(form)	OF
			| SVM.constT:
					IF	form=SVM.nil	THEN	Texts.WriteString(writer, "()")
					ELSIF	form=SVM.false	THEN	Texts.WriteString(writer, "#F")
					ELSIF	form=SVM.true	THEN	Texts.WriteString(writer, "#T")
					ELSIF	form=SVM.emptyVec	THEN	Texts.WriteString(writer, "#()")
					ELSE	Texts.Write(writer, 22X); Texts.Write(writer, 22X)	END
			| SVM.pairT:
					IF	SVM.Mark2d(form) THEN
						IF	listcont	THEN	Texts.WriteString(writer, "...)")	ELSE	Texts.WriteString(writer, "<...>")	END
					ELSE
						IF	~listcont	THEN	Texts.Write(writer, "(")	END;
						SVM.Mark(form); W(SVM.CAR(form), level+1, FALSE, FALSE);
						IF	SVM.TAG(SVM.CDR(form))=SVM.pairT	THEN	W(SVM.CDR(form), level, TRUE, TRUE)
						ELSIF	SVM.CDR(form)=SVM.nil	THEN	Texts.Write(writer, ")")
						ELSE	Texts.WriteString(writer, " . "); W(SVM.CDR(form), level, FALSE, TRUE); Texts.Write(writer, ")")	END;
						SVM.Unmark(form)
					END
			| SVM.symT:	WName(SVM.SymName(form))
			| SVM.numT:	Texts.WriteInt(writer, SVM.NumVal(form), 1)
			| SVM.charT:	Texts.WriteString(writer, "#\"); Texts.Write(writer, SVM.CharCh(form))
			| SVM.strgT:
					len:=SVM.ArrLen(form); inx:=0; Texts.Write(writer, 22X);
					WHILE	len > 0	DO	Texts.Write(writer, SVM.CharCh(SVM.ArrRef(form, inx))); INC(inx); DEC(len)	END;
					Texts.Write(writer, 22X)
			| SVM.vecT: 
					len:=SVM.ArrLen(form); inx:=0; Texts.WriteString(writer, "#(");
					WHILE	len > 0	DO	W(SVM.ArrRef(form, inx), level+2, FALSE, FALSE); INC(inx); DEC(len)	END;
					Texts.Write(writer, ")")
			| SVM.contT:	Texts.WriteString(writer, "#<CONTINUATION-PROCEDURE>")
			| SVM.pProcT:	Texts.WriteString(writer, "#<PRIMITIVE-PROCEDURE>")
			| SVM.uProcT:	Texts.WriteString(writer, "#<PROCEDURE>")
			| SVM.portT:	Texts.WriteString(writer, "#<PORT>")
			| SVM.undefT:	Texts.WriteString(writer, "#VARIABLE-NOT-BOUND-ERROR")
			| SVM.errorT:	Texts.Write(writer, "#"); WName(errors[SHORT(SHORT(form))]); Texts.WriteString(writer, "-ERROR")
			END
		END W;

	BEGIN	SVM.NewMark(); W(obj, 1, FALSE, FALSE)
	END Write;


BEGIN
	(* Initialize identifier table and lexically ordered tree *)
	quoteSym:=SVM.NewSym(0); NEW(lexTreeRoot); lexTreeRoot.a:=NIL; lexTreeRoot.z:=NIL; lexTreeRoot.id:=0;
	lexTreeRoot.sym:=quoteS; lexTreeRoot.obj:=quoteSym;
	names[0]:="Q"; names[1]:="U"; names[2]:="O"; names[3]:="T"; names[4]:="E"; names[5]:=0X; free:=6;

	(* Enter Scheme"s syntactic keywords in an order that places often used keywords near root of tree; "LET" is at root *)
	EnterKW("COND", condS);	EnterKW("LET", letS);	EnterKW("AND", andS); EnterKW("IF", ifS);
	EnterKW("OR", orS); EnterKW("SET!", setXS);	EnterKW("=>", implS); EnterKW("BEGIN", beginS);
	EnterKW("DEFINE", defineS);	EnterKW("LAMBDA", lambdaS);

	EnterKW("CASE", caseS); EnterKW("DO", doS); EnterKW("QUASIQUOTE", quasiquoteS);
	EnterKW("UNQUOTE", unquoteS); EnterKW("DELAY", delayS); EnterKW("ELSE", elseS);
	EnterKW("LET*", letXS); EnterKW("LETREC", letrecS); EnterKW("UNQUOTE-SPLICING", unquotesplicingS);
	plusSym:=EnterCh("+"); minusSym:=EnterCh("-");

	EnterErr(SVM.pairT+8, "PAIR-EXPECTED");	EnterErr(SVM.vecT+8, "VECTOR-EXPECTED");
	EnterErr(SVM.strgT+8, "STRING-EXPECTED");	EnterErr(SVM.symT+8, "SYMBOL-EXPECTED");
	EnterErr(SVM.numT+8, "NUMBER-EXPECTED");	EnterErr(SVM.charT+8, "CHARACTER-EXPECTED");
	EnterErr(SVM.portT+8, "PORT-EXPECTED");
	EnterErr(SVM.errOvfl, "OVERFLOW");	EnterErr(SVM.errUnfl, "UNDERFLOW");
	EnterErr(SVM.errDiv0, "DIVISION-BY-ZERO"); EnterErr(SVM.errOOM, "OUT-OF-MEMORY");
	EnterErr(SVM.errOORng, "REFERENCE-OUT-OF-RANGE");
	EnterErr(SVM.errSyntx, "SYNTAX"); EnterErr(SVM.errNotImpl, "IMPLEMENTATION-RESTRICTION");
	EnterErr(SVM.errArTooMny, "TOO-MANY-ARGUMENTS"); EnterErr(SVM.errArTooFew, "NOT-ENOUGH-ARGUMENTS");
	EnterErr(SVM.errListX, "PROPER-LIST-EXPECTED"); EnterErr(SVM.errProcX, "PROCEDURE-EXPECTED");
	EnterErr(SVM.errListEnd, "END-OF-LIST-REACHED");

	SVM.symToString:=SymToString; SVM.stringToSym:=StringToSym
END SchemeInOut.