#   Syntax10.Scn.Fnt  5   5  Split.Split maxsize {name} ~      Split the named files into subfiles of maxsize each
Split.Split ^                                same but take selection as parameters
Split.Join {name} ~                    Join the subfiles of each named file into one file
Split.Join ^                                 same but take selection as parameters

Syntax:
	Split.Split	(maxsize {filename} "~" | "^")
	Split.Join	({filename} "~" | "^")

Purpose:
	Split large files into smaller files in order to being able to copy them to a diskette.
	The names of the subfiles are the name of the file with ".Spl.A", ".Spl.B", etc. appended.

Examples:
	Split.Split 50000 test1 test2 ~
		Split 'test1' into subfiles 'test1.Spl.A', 'test1.Spl.B', 'test1.Spl.C', ... each of size 50000.
		Same for 'test2'.
	
	Split.Join test1 test2 ~
		Join the subfiles 'test1.Spl.A', 'test1.Spl.B', 'test1.Spl.C', ... into 'test1'.
		Same for subfiles of 'test2'.

Limitations:
	Maximum number of subfiles: 52 ("A".."Z", "a".."z")
	Upon writing a sequence with the same name, the subfiles of the older sequence are deleted.
	E.g.
		Split.Split 100 test ~      writes test.Spl.A, test.Spl.B, test.Spl.C, test.Spl.D
		Split.Split 200 test ~      writes test.Spl.A, test.Spl.B   but test.Spl.C, test.Spl.D are deleted

Net.ReceiveFiles Pluto shml:Split.Obj shml:Split.Tool~