/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: bd.h,v 1.2 87/04/24 13:52:02 davidb Exp $ */
/* @(#)bd.h	1.1 8/16/85 */

/* host-Exos message queue header */

typedef struct hms {

	struct hms *nxthms;
	char	hmsrsr;
	char	hmssta;	
	int	hmslen;

} hmshdr, *phmsg;

#define hbufsiz sizeof(hmshdr)


/* the following are messages defined for the internal test program */

#define adrlen 6

/* common msg header for Ethernet msg */

typedef	struct {

	char dstaddrs[adrlen];
	char srcaddrs[adrlen];
	int  typval;

} stdhdr;


/* statistics block structure */

typedef struct {

	int pktxmt1;
	int pktxmt2;
	int xsvcol1;
	int xsvcol2;
	int sqeabs1;
	int sqeabs2;
	int dmandr1;
	int dmandr2;
	int pktrcv1;
	int pktrcv2;
	int alnerr1;
	int alnerr2;
	int crcerr1;
	int crcerr2;
	int missed1;
	int missed2;
	int dmaovr1;
	int dmaovr2;
	int ovflow1;
	int ovflow2;
	int numcol1;
	int numcol2;
	int rntpkt1;
	int rntpkt2;

} stsarr, *psts;

#define objnum 12



/* format of messages */

/* network messages */

#define maxdat 1504		/* includes CRC */
#define hdrlen 14		/* ethernet packet header */
#define msglen maxdat+hdrlen	/* maximum size of messages */
#define maxsndlen msglen-4	/* maximum send length */

typedef struct {

	char	dstadr[adrlen]; /* destination address */
	char	srcadr[adrlen]; /* source address */
	unsigned int	typfld;		/* type field */
	char	usrdat[maxdat];	/* message data		*/
	int	datlen;
	char 	pktslt;
	char  	flag;		/* status of xmt msg */

} netmsg, *nmptr;

/* status bit of xmt msg flag */

#define copbit	1			/* msg already copied into buffer */


typedef struct usrmsg {

	int	rsrvd;
	char	rfrcod;
	char	unused;
	int	userid;
	char	reqcod;
	char	retcod;

} usrhdr, *pusrhdr;


/* values for message status */

#define ownbit 1
#define donbit 2
#define oflbit 4


/* values for request code */

#define watreq	7		/* for test only */
#define modreq	8
#define adrreq	9
#define nrcreq	10
#define stsreq	11
#define xmtreq	12
#define rcvreq	13
#define srcreq	14		/* self rcv request */

/* values for rfrcod */

#define cmdcod	0
#define xmtcod	1
#define rcvcod  2

/* values for return code */

#define errnon 0
#define errireq 0xa1
#define	sucsxmt	2		/* successful xmt can return code 0/1/2 */

typedef	struct {

	usrhdr	ums;

} waitmsg, *pwaitmsg;

#define	watmlen	sizeof(waitmsg)


/* xmit/recv  message */

typedef struct {

	usrhdr	ums;
	char	nadslt;
	char	blknum;
	int	blklen;
	int	blkadr;
	int	blkseg;
	int	blkln1;
	int	blkad1;
	int	blksg1;

} xrmsg, *pxrmsg;

#define xrmlen sizeof(xrmsg)


/* net addr message */

typedef struct {

	usrhdr	ums;
	char	reqmsk;
	char	adrslt;
	char	adrs[adrlen];

} adrmsg, *padrmsg;

#define adrmlen sizeof(adrmsg)


/* net mode message */

typedef struct {

	usrhdr	ums;
	char	reqmsk;
	char	eroptn;
	char	nmode;

} modmsg, *pmodmsg;

#define modmlen sizeof(modmsg)

/* values for mode */

#define discnct	0
#define cnctpf	1
#define cncthf	2
#define cnctmon	3
#define	cnctlcl	0xFF
#define rmotmod cnctpf
#define loclmod cnctlcl



/* netrcv message */


typedef struct {

	usrhdr	ums;
	char	reqmsk;
	char	adrslt;

} nrcmsg, *pnrcmsg;

#define nrcmlen sizeof(nrcmsg)


/* stats message */

typedef struct {

	usrhdr	ums;
	char	reqmsk;
	char	stsrsr;
	int	numobj;
	int	inxobj;
	stsarr	stsread;

} stsmsg, *pstsmsg;

#define stsmlen sizeof(stsmsg)

typedef	stsmsg	usrmsg,*pusrmsg;

#define	maxusrlen stsmlen

/* request mask */

#define wrflag 1		/* write new parameter values */
#define rdflag 2		/* read old parameters */

#define arcbit 4		/* receive set up on the slot */
#define avlbit 8		/* address in the slot valid */


/* address slot numbers */

#define physlt 0xFD		/* physical address slot  */
#define brdslt 0xFF		/* broadcast address slot */
#define mlcslt 0xFE		/* multicast address slot */




/* status of the returned message */


#define clsbit 0x10			/* collision bit	*/

#define	ovfbit	0x04			/* overflow bit		*/
#define crcbit	0x20			/* crc error bit	*/
#define alnbit	0x10			/* alignemnt error	*/


/* recieve options */

#define noerr 0				/* no packets with error */
#define allerr 0x7F			/* on net, all errors accepted	*/
#define onnet 0				/* on net */
#define offnet 0x80			/* off net */

/* exos modes */

#define ctlrmod 0
#define hstboot 1
#define netboot 2

/* exos status */

#define ready 0


