/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: comm.h,v 1.3 87/05/14 17:46:48 davidb Exp $ */

/* @(#)comm.h	1.1 8/16/85 */

/* This header file defines all the shared communication space on the
EXOS board. */

#define	SEGDIF	0x0000		/* segment difference between the PC
				and the board view */

/* communication segment */
#define	ECOMSEG	0x3000		/* exos view */
#define	HCOMSEG	ECOMSEG+SEGDIF	/* host view */

/* the following are offset to COMSEG */
#define	EXSTAT	0xff00		/* exos status */
#define	EXLED	EXSTAT+1	/* error code */
#define SVCPTR	EXLED+1		/* host service block 1ff02 - 1ff0f */

#define	WATVCT	0xff70		/* NX idle wait routine 1ff70 - 1ff73 */
				/* used internally */

/* 0xff80 thru 0xffdf is reserved for console buffer CONBUFR */
/* see definitions in ccom.i */

#define	DRVBLK	0xffe0
#define	CTLCOP	DRVBLK	
#define	LOWMAP	CTLCOP+2	/* low bound of available user mem */
#define	HIMAP	LOWMAP+2	/* high bound of available user mem */
#define	SNDPTR	HIMAP+2		/* header ptr to PC-EXOS queue */
#define	RCVPTR	SNDPTR+4	/* header ptr ot EXOS-PC queue */
#define	MBUFSIZ	RCVPTR+4	/* # of bytes per msg buffer */

#define	BNK2LO	DRVBLK-2	/* internl use between nx and init */

#define	ADRVCT	0xfff0		/* address vector 1fff0 - 1fff3 */

#define	EXRDY	1		/* EXOS in ready state */

typedef struct	{
	UBYTE2	srvsta;
	UBYTE2	srvreq;
	UBYTE2	hstoff;
	UBYTE2	hstseg;
	UBYTE2	exooff;
	UBYTE2	exoseg;
	UBYTE2	xfrcnt;
} srvblk;

#define	SRVBLKLEN sizeof(srvblk)

/* request codes */
#define	DMAE2H	01
#define	DMAH2E	02
#define	RSTNET	03

/* host DMA status bit definitions */
#define	EXOBIT	01
#define	DONBIT	02


