/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: config.h,v 1.2 87/04/24 14:04:54 davidb Exp $ */
/*@(#)config.h	1.1 8/16/85*/
/*
 * This file contains three types of things:
 * 	1) include lines for kernel info of intrest to drivers.
 *	2) constants for EXOS configuration.
 *	3) macros for system specific portions of code.
 */

/*
 * Pull in include files for driver routines.
 * The idea is that all declarations of possible interest are pulled in here.
 * If one does not wish such a broad brush approach, don't define PULLIN.
 */

#define EXOSASYNCIO
#define ibmxenix2

#ifdef uniq
/* 
 * uniq's port of AT and T system 5 to the 730, is close enough to 
 * AT&T's System V that this seems justified.
 */
#define S5vax750
#endif

#ifdef PULLIN

/*
 * Host system header files.
 */


#ifdef zilog
#include <sys/param.h>
#include <sys/signal.h>
#include <sys/s.out.h>		/* user.h */
#include <sys/mmu.h>		/* user.h */
#include <sys/dir.h>		/* user.h */
#include <sys/user.h>
#include <sys/file.h>		/* ex_subr.c */
#include <sys/proc.h>
#include <sys/buf.h>
#include <sys/inode.h>		/* ex_subr.c */
#include <sys/callo.h>		/* ex_subr.c */

/*
 * It would be nice to include these, but the compiler can't hack it.
 */
/* #include <sys/sysinfo.h>	/* systm.h */
/* #include <sys/systm.h>	/* geteblk(), etc */

#else	/* zilog */

#ifdef scoxenix5

/* The following symbols were removed from super Makefile and put here to
 * avoid compilation problem.  They are used by system include files.
 */
#ifdef ibmxenix2
#define NULL 0
#else
#define M_KERNEL
#endif

#define M_OLDSIGN

#include "sys/types.h"
#include "sys/param.h"
#ifndef ibmxenix2
#include "sys/sysmacros.h"
#endif /* ibmxenix2 */
#include "sys/systm.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#ifndef EPERM
#include "sys/errno.h"
#endif
#include "sys/file.h"
#include "sys/tty.h"
#include "sys/ttold.h"
#include "sys/conf.h"
#include "sys/buf.h"
#include "sys/inode.h"
/*
#include "sys/sysmacros.h"
*/
#include "sys/proc.h"
#include "sys/callo.h"
#include <sys/var.h>
#define SYSTIME time
#define SBUFSIZE BSIZE
#else	/* scoxenix5 */

#ifdef xenix286

#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/systm.h>
#include <sys/file.h>
#include <sys/proc.h>
#include <sys/buf.h>
#include <sys/inode.h>
#include <sys/callo.h>
#include <sys/var.h>
#define SYSTIME time
#else	/* xenix286 */

#ifdef BSD4dot2

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/conf.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/proc.h>
#include <sys/buf.h>
#include <sys/inode.h>
#include <sys/callout.h>
#include <sys/uio.h>
#include <sys/kernel.h>
#include <signal.h>
#define u_qsav u_qsave
#define f_inode f_data
#define p_clktim p_realtimer.it_value.tv_sec
#define SYSTIME (time.tv_sec)

#else	/* BSD4dot2 */
#ifdef SYSTEM5
#include "sys/param.h"
#ifndef cadmus
#ifndef S5vax750
#ifndef rtpc
#include "sys/config.h"
#endif /* rtpc */
#endif /* S5vax750 */
#endif /* cadmus */
/* system5 ifdef */
#include "sys/types.h"
#include "sys/systm.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/file.h"
#include "sys/tty.h"
#ifndef rtpc
#include "sys/ttold.h"
#endif
#include "sys/termio.h"
#include "sys/conf.h"
#include "sys/buf.h"
#ifdef cadmus
#include "sys/virtual.h"
#endif
#include "sys/inode.h"
#include "sys/sysmacros.h"
#include "sys/proc.h"
#include "sys/callo.h"
#include <sys/var.h>
#define SYSTIME time

#else	/* SYSTEM5 */

#include <sys/param.h>
#ifndef plexus
#ifndef mostek
#include <sys/mmu.h>
#endif
#endif
#include <sys/systm.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/conf.h>
#include <sys/file.h>
#include <sys/tty.h>
#include <sys/ttold.h>
#include <sys/proc.h>
#include <sys/buf.h>
#include <sys/inode.h>
#include <sys/callo.h>
#include <macros.h>
#ifdef V7
#include <signal.h>
#else
#ifndef plexus
#include <sys/var.h>
#endif
#endif
#define SYSTIME time

#endif	/* SYSTEM5 */
#endif	/* BSD4dot2 */
#endif	/* xenix286 */
#endif	/* scoxenix5 */
#endif	/* zilog */


/*
 * Excelan supplied headers
 */
#include <sys/extypes.h> /* Used to be misc.h. For u_long defns. dab 861124. */
#include <sys/socket.h>
#include <net/route.h>
#include <ex_errno.h>
#include "exreg.h"
#include <sys/init.h>
#include "exos.h"
#include "context.h"  
#include <sys/proc_dep.h>
#include <sys/soioctl.h>
#include <ex_ioctl.h>
#include <sys/ts.h>

#ifdef DEBUG
#undef DEBUG
#endif
#endif	/* PULLIN */

/* 
   The following definitions of NPROC, BSIZE, SSEL, fd_set and loint
   used to be contained in include/EXOS/exos/misc.h. dab 861119.
*/

/* 
   NPROC is used in src/lib/libex_driver/ex_config.c to define
   char procflags[NPROC]. procflags is used to parallel the normal proc
   table and hold SSEL and STIMO flag indications. There aren't enough
   bits in the proc table's own flags byte for these.

   NPROC is also used in src/lib/libex_driver/ex_subr.c in the
   routine findproc() to limit the bounds of a search through the process
   table (only for V7 and zilog systems: System V & III use v.v_proc and
   4.2 BSD uses procNPROC).
*/
	
#ifndef NPROC
#define NPROC 500	/* should be enough for most systems */
#endif

#ifdef BSD4dot2
#define BSIZE	CLBYTES
#endif /* BSD4dot2 */


/*
 * "Extra" proc flags.  Could/should be put into p_flags in proc table,
 * but some systems don't have enough room.
 */
#define SSEL	1

/* low int of a long */
/* Used by ex_subr.c */
#define	loint(l)	(((long) l) & 0177777)

/* fd_set is used by ex_subr.c */
#ifndef BSD4dot2 /* fd_set is defined in sys/types.h in BSD */
typedef struct { 
	long fds_bits[1]; 
} fd_set;
#endif /* BSD4dot2 */

#ifdef zilog
/* This stuff was in Zilog's sys/exzilog.h */
#define clear	bzero
#define copyin	excopyin
#define copyout	excopyout
#define SYSTIME time
extern	time_t time;
struct buf *geteblk();
caddr_t	exvtop();
#endif

#ifdef plexus
#define	MAXDEVS		24		/* socket limit */
#else
#define	MAXDEVS		29		/* socket limit */
#endif

u_short	so_id[MAXDEVS];			/* exos board socket id */
u_char	so_state[MAXDEVS];		/* state of socket */
int	ex_inited;			/* has EXOS been inited? */

#ifdef	EXOSASYNCIO
u_char	so_async[MAXDEVS];		/* bits for async sockets */
u_char	so_signum[MAXDEVS];		/* signum for asyncio */

/*
 * SOA_ON bit of so_async[dev] is set if socket dev is in asynchronous mode
 * SOA_SIGNAL bit of so_async[dev] is set if a signal should be generated
 * upon receiving a SELWAKEUP response for socket dev from the board.
 * SOA_SIGNAL is cleared either in exintr() or in xsoselect(),
 * as soon as the socket becomes selectable.
 */
#define	SOA_ON		0x01		/* async-io on this socket */
#define	SOA_SIGNAL	0x02		/* signal when selectable */
#endif	/* EXOSASYNCIO */

/* so_state's */
#define	SOS_FREE	0x00	/* socket unallocated */
#define	SOS_RESERVED	0x01	/* socket allocated on the board */
#define	SOS_BUSY	0x02	/* pending reply from the board */
#define SOS_RESET	0x04	/* abnormal closing of socket */
#define	SOS_PENDRD	0x08	/* interrupted socket read call */
#define	SOS_PENDWRT	0x10	/* interrupted socket write call */

#ifdef tower
#define ex_fingmsg EXOS_find
#define ex_send    EXOS_send
#endif

/*
MWP:
Define macros for dealing with the various ways of getting
buffers from the system, and another macro for the various
ways of returning them.
Basically, we need a way to get buffers that the board can
DMA to/from.  Generally, a call to geteblk() is sufficient, but ...

EXbtype is the type of object returned by whatever call is used
	to get buffers.
EXbatype is the address of the data (useable portion) of that object.
EXioctltype is the type of the "addr" parameter passed to driver ioctl
	routines.
EXlatype is the type of pointers used to point to the log buffer.
EXgetblk gets a block from the system for DMA.
EXgetsblk gets a block which does't cross a 64K boundry.
EXbrelse releases a block.
EXvtop takes a buffer object and the pointer to the
	data portion of the buffer, (or the address of a kernel data
	structure as both arguments
	if "flag" is non zero); and returns the address of the buffer
	as seen by the EXOS board.
EXioaddr takes the address of the data portion of a buffer ,
	as well as, a pointer to the buffer object and returns
	a value which may be used as an argument to "iomove" or its equivalent.
EXiocpaddr takes the address of the data portion of a buffer ,
	as well as, a pointer to the buffer object and returns
	a value which may be used as an argument to "copyin", "copyout" or
	their equivalents.
EXupaddr converts a user's pointer which has been passed down to the
	kernel into something which can be used as an argument to
	"copyin", "copyout", "iomove" or their equivalents.
EXlogaddr takes a pointer to the buffer object used for logging and
	returns a pointer to the data portion of that buffer.
EXgetlblk is the same as EXgetblk, except that the buffer will not
	be directly accessed by the EXOS board.
EXmapout releases any resources aquired for io transfer eg UNIBUS
	mapping registers.
STRUCTLABELT is to be defined if "label_t" is a structure, rather than
	a simple array (true of BSD4dot2).
*/
#ifdef BSD4dot1

typedef struct buf EXbtype;
typedef caddr_t EXbatype;
typedef caddr_t EXioctltype;
typedef char *EXlatype;
#define EXMASKADDR 0xffff0000
#define EXgetblk( baddr, bp, size )	{ \
	bp = (EXbtype *)geteblk(); \
	baddr = mapin( bp ); \
	mapout( bp ); \
	}
#define EXgetsblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf(); \
	baddr = mapin( bp ); \
	mapout( bp ); \
	}
#define EXbrelse( bp, size )	brelse( (bp) )
#define EXvtop( baddr, bp, flag )	((flag)?exvtop(baddr):exbuftop(bp))
#define EXioaddr( baddr, bp )	( (mapin( bp ))? (baddr) : (baddr))
#define EXiocpaddr( baddr, bp )	( (mapin( bp ))? (baddr) : (baddr))
#define EXupaddr(x) ((caddr_t)(x))
#define EXgetlblk( baddr, bp, size )	{ \
	bp = (EXbtype *)geteblk(); \
	baddr = mapin( bp ); \
	mapout( bp ); \
	}
#define EXlogaddr( bp )	((EXlatype)mapin( bp ))
#define EXmapout( bp )	mapout( bp )
#else
#ifdef Siemens3

typedef struct buf EXbtype;
typedef paddr_t EXbatype;
typedef caddr_t EXioctltype;
typedef char *EXlatype;
#define EXMASKADDR 0xffff0000
#define EXgetblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk( 0 ); \
	baddr = paddr(bp); \
	}
#define EXgetsblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf(); \
	paddr(bp); \
	}
#define EXbrelse( bp, size )	brelse( (bp) )
#define EXvtop( baddr, bp, flag )	exvtop( baddr )
#define EXioaddr( baddr, bp )	( (paddr_t)(baddr) )
#define EXiocpaddr( baddr, bp )	( (baddr) )
#define EXupaddr(x) ((caddr_t)(x))
#define EXgetlblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk( 1 ); \
	baddr = paddr(bp); \
	}
#define EXlogaddr( bp )	((caddr_t)paddr( bp ))
#define EXmapout( bp )	{}
#else
#ifdef scoxenix5


typedef struct buf EXbtype;
typedef faddr_t EXbatype;
typedef faddr_t EXioctltype;
typedef faddr_t EXlatype;
extern EXbtype *getblk();
#define EXMASKADDR 0xff0000
#ifndef FROMXTY
/*
 * macros for mapping buffer physical addresses to far pointers.
*/
/*
* It would be very nice if we could pull in mmu.h for these,
* but the compiler cann't handle it.
*/
#define SABUF_SEL 0x18
#define BUF_SEL 0x98

extern paddr_t bufbase;

/* sabuf physical address to far pointer */
#define sabuftofar(x) sotofar(SABUF_SEL,(unsigned)ptok(x))

/* buffer physical address to selector */
#define bptos(x) ((((unsigned short) (((x)-bufbase) >> 16)) << 3) + BUF_SEL)

/* buffer physical address to offset */
#define bptooff(x) ((unsigned short) ((x)-bufbase))

/* out-of-kernel buffer physical address to far pointer */
#define bufptof(x) sotofar(bptos(x),bptooff(x))

/* any buffer physical address to far pointer */
#define bptof(x) (((x) >= bufbase ) ? bufptof(x): sabuftofar(x))

#endif	/* FROMXTY */
/*
********************************
*/
#define EXgetblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk(EXSEG_BUF); \
	baddr = bptof(bp->b_paddr); \
	}
#define EXgetsblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk(EXSEG_BUF); \
	baddr = bptof(bp->b_paddr); \
	}
#define EXbrelse( bp, size )	brelse( (bp) )
/*
Since, the host performs transfers,
we might as well use a virtual address.
*/
#define EXvtop( baddr, bp, flag )	( baddr )
#define iomove pimove
#define clear xclear
#define EXioaddr( baddr, bp )	(bp->b_paddr)
#define EXiocpaddr( baddr, bp )	(baddr)
/*
It turns out that 0 isn't a valid descriptor.
Therefore, large model programs will pass addresses with a non-zero
segment number while small and middle model programs
will pass a zero segment descriptor.
*/
#define EXupaddr(x) ((0xffff0000 & (long)(x)) == (long)0) ? \
	((faddr_t)((long)(x) + (0xffff0000 & (long)u.u_stkbot))) : \
	((faddr_t)(x))
#define EXgetlblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk( 1 ); \
	baddr = bptof(bp->b_paddr); \
	}
#define EXlogaddr( bp )	((EXlatype)bptof(bp->b_paddr))
#define EXmapout( bp )	{}

#else	/* scoxenix5 */
#ifdef pcxenix


typedef struct buf EXbtype;
typedef faddr_t EXbatype;
typedef faddr_t EXioctltype;
typedef faddr_t EXlatype;
extern EXbtype *getblk();
#define EXMASKADDR 0xff0000
#ifndef FROMXTY
/*
 * macros for mapping buffer physical addresses to far pointers.
*/
/*
* It would be very nice if we could pull in mmu.h for these,
* but the compiler cann't handle it.
*/
#define SABUF_SEL 0x18
#define BUF_SEL 0xA8

extern paddr_t bufbase;

/* sabuf physical address to far pointer */
#define sabuftofar(x) sotofar(SABUF_SEL,(unsigned)ptok(x))

/* buffer physical address to selector */
#define bptos(x) ((((unsigned short) (((x)-bufbase) >> 16)) << 3) + BUF_SEL)

/* buffer physical address to offset */
#define bptooff(x) ((unsigned short) ((x)-bufbase))

/* out-of-kernel buffer physical address to far pointer */
#define bufptof(x) sotofar(bptos(x),bptooff(x))

/* any buffer physical address to far pointer */
#define bptof(x) (((x) >= bufbase ) ? bufptof(x): sabuftofar(x))

#endif	/* FROMXTY */
/*
********************************
*/
#define EXgetblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk(EXSEG_BUF); \
	baddr = bptof(bp->b_paddr); \
	}
#define EXgetsblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk(EXSEG_BUF); \
	baddr = bptof(bp->b_paddr); \
	}
#define EXbrelse( bp, size )	brelse( (bp) )
/*
Since, the host performs transfers,
we might as well use a virtual address.
*/
#define EXvtop( baddr, bp, flag )	( baddr )
#define iomove pimove
#define clear xclear
#define EXioaddr( baddr, bp )	(bp->b_paddr)
#define EXiocpaddr( baddr, bp )	(baddr)
/*
It turns out that 0 isn't a valid descriptor.
Therefore, large model programs will pass addresses with a non-zero
segment number while small and middle model programs
will pass a zero segment descriptor.
*/
#define EXupaddr(x) ((0xffff0000 & (long)(x)) == (long)0) ? \
	((faddr_t)((long)(x) + (0xffff0000 & (long)u.u_stkbot))) : \
	((faddr_t)(x))
#define EXgetlblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk( 1 ); \
	baddr = bptof(bp->b_paddr); \
	}
#define EXlogaddr( bp )	((EXlatype)bptof(bp->b_paddr))
#define EXmapout( bp )	{}

#else	/* pcxenix */
#ifdef xenix286


typedef struct buf EXbtype;
typedef caddr_t EXbatype;
typedef faddr_t EXioctltype;
typedef caddr_t *EXlatype;
#define EXMASKADDR 0xff0000
#define EXgetblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk( EXSEG_BUF ); \
	baddr = ptok(bp->b_paddr); \
	}
#define EXgetsblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf(); \
	baddr = ptok(bp->b_paddr); \
	}
#define EXbrelse( bp, size )	brelse( (bp) )
#define EXvtop( baddr, bp, flag )	exvtop( baddr )
#define iomove pimove
#define clear xclear
#define EXioaddr( baddr, bp )	ktop( baddr )
#define EXiocpaddr( baddr, bp )	((caddr_t)( baddr ))
/*
It turns out that 0 isn't a valid descriptor.
Therefore, large model programs will pass addresses with a non-zero
segment number while small and middle model programs
will pass a zero segment descriptor.
*/
#define EXupaddr(x) ((0xffff0000 & (long)(x)) == (long)0) ? \
	((faddr_t)((long)(x) + (0xffff0000 & (long)u.u_stkbot))) : \
	((faddr_t)(x))
#define EXgetlblk( baddr, bp, size )	{ \
	bp = (EXbtype *)getablk( EXSEG_BUF ); \
	baddr = ptok(bp->b_paddr); \
	}
#define EXlogaddr( bp )	((EXlatype)ptok(bp->b_paddr))
#define EXmapout( bp )	{}
#else
#ifdef S5vax750


typedef struct buf EXbtype;
typedef caddr_t EXbatype;
typedef caddr_t EXioctltype;
typedef char *EXlatype;
#define EXMASKADDR 0xffff0000
#define EXgetblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf( 0 ); \
	baddr = bp->b_un.b_addr; \
	}
#define EXgetsblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf( 0 ); \
	baddr = bp->b_un.b_addr; \
	}
#define EXbrelse( bp, size )	brelse( (bp) )
#define EXvtop( baddr, bp, flag )	exvtop( bp, flag )
#define EXioaddr( baddr, bp )	( baddr )
#define EXiocpaddr( baddr, bp )	( baddr )
#define EXupaddr(x) ((caddr_t)(x))
#define EXgetlblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf( 0 ); \
	baddr = bp->b_un.b_addr; \
	}
#define EXlogaddr( bp )	((EXlatype)(bp->b_un.b_addr))
#define EXmapout( bp )	{}
#else

#ifdef BSD4dot2

typedef struct buf EXbtype;
typedef caddr_t EXbatype;
typedef caddr_t EXioctltype;
typedef char *EXlatype;
#define EXMASKADDR 0xffff0000
#ifdef parallel
#define EXgetblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf( size ); \
	baddr = bp->b_un.b_addr; \
	}
#else	/* parallel */
#define EXgetblk( baddr, bp, size )	{ \
	bp = (EXbtype *)geteblk( size ); \
	baddr = bp->b_un.b_addr; \
	}
#endif	/* parallel */
#define EXgetsblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf(); \
	baddr = bp->b_un.b_addr; \
	}
#ifdef parallel
#define EXbrelse( bp, size )	ex_brelse( (bp) )
#else
#define EXbrelse( bp, size )	brelse( (bp) )
#endif
#define EXvtop( baddr, bp, flag )	exvtop( baddr )
#define EXioaddr( baddr, bp )	( baddr )
#define EXiocpaddr( baddr, bp )	( baddr )
#define EXupaddr(x) ((caddr_t)(x))
#define EXgetlblk( baddr, bp, size )	{ \
	bp = (EXbtype *)geteblk( size ); \
	baddr = bp->b_un.b_addr; \
	}
#define EXlogaddr( bp )	((EXlatype)(bp->b_un.b_addr))
#define EXmapout( bp )	{}
#define STRUCTLABELT
#ifdef parallel
#define printf pprintf
#endif
#ifdef integrated

/*
 * barrow the entry point for an existing interupt handler,
 * and avoid conflicts with EXOS link level driver.
 */
#define exintr ibintr
#define EXdriver XEXdriver
#define exprobe xexprobe
#define exattach xexattach
#define exslave xexslave
#define exopen xexopen
#define exclose xexclose
#define exread xexread
#define exwrite xexwrite
#define exioctl xexioctl
#define exinit xexinit
#endif	/* integrated */
#else	/* BSD4dot2 */


#ifdef plexus
typedef unsigned EXbtype;
typedef unsigned EXbatype;
typedef caddr_t EXioctltype;
typedef char *EXlatype;
#define EXMASKADDR 0xffff0000
#define EXgetblk( baddr, bp, size )	{ \
	bp = smalloc( (size) ); \
	baddr = bp; \
	}
#define EXgetsblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf(); \
	baddr = bp; \
	}
#define EXbrelse( bp, size )	smfree( (size), (bp) )
#define EXvtop( baddr, bp,flag )	exvtop( baddr )
#define EXioaddr( baddr, bp )	( baddr )
#define EXiocpaddr( baddr, bp )	( baddr )
#define EXupaddr(x) ((caddr_t)(x))
#define EXgetlblk( baddr, bp, size )	{ \
	bp = (EXbtype *)geteblk(); \
	baddr = bp; \
	}
#define EXlogaddr( bp )	((EXlatype)(bp->b_un.b_addr))
#define EXmapout( bp )	{}
#else

/*
Most Common Case.
*/

typedef struct buf EXbtype;
typedef caddr_t EXbatype;
typedef caddr_t EXioctltype;
typedef char *EXlatype;
#define EXMASKADDR 0xffff0000
#define EXgetblk( baddr, bp, size )	{ \
	bp = (EXbtype *)geteblk(); \
	baddr = bp->b_un.b_addr; \
	}
#define EXgetsblk( baddr, bp, size )	{ \
	bp = (EXbtype *)ex_getbuf(); \
	baddr = bp->b_un.b_addr; \
	}
#define EXbrelse( bp, size )	brelse( (bp) )
#ifdef rtpc
#define EXvtop( baddr, bp, flag )	( baddr )
#else
#define EXvtop( baddr, bp, flag )	exvtop( baddr )
#endif /* rtpc */
#define EXioaddr( baddr, bp )	( baddr )
#define EXiocpaddr( baddr, bp )	( baddr )
#define EXupaddr(x) ((caddr_t)(x))
#define EXgetlblk( baddr, bp, size )	{ \
	bp = (EXbtype *)geteblk(); \
	baddr = bp->b_un.b_addr; \
	}
#define EXlogaddr( bp )	((EXlatype)(bp->b_un.b_addr))
#define EXmapout( bp )	{}
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif


/*
MWP:
Define macros for setting processor priority.

	EXSPL7 - locks out everything.
	EXSPL6 - locks out the clock.
	EXSPL5 - locks out devices other than the clock.
	EXSPL0 - allows pending interupts to be serviced.
	EXSPLX - sets to specified priority - used to restore priority.
*/
#ifdef scoxenix5

#define EXSPL7( s ) { \
	s = spl7(); \
	}
#define EXSPL6( s ) { \
	s = spl6(); \
	}
#define EXSPL5( s ) { \
	s = spl5(); \
	}
#define EXSPL0( s ) { \
	s = spl0(); \
	}
#define EXSPLX( s ) { \
	splx( s ); \
	}

#else	/* scoxenix5 */
#ifdef pcxenix

extern int ex_intlev;
#ifndef FROMXTY
#define EXSPL7( s ) { \
	s = spl7(); \
	}
#define EXSPL6( s ) { \
	s = spl6(); \
	}
#endif	/* FROMXTY */
#define EXSPL5( s ) { \
	s = spl6(); \
	}
#ifndef FROMXTY
#define EXSPL0( s ) { \
	s = spl0(); \
	}
#endif	/* FROMXTY */
#define EXSPLX( s ) { \
	splx( s ); \
	}
#else	/* pcxenix */
#ifdef cadmus

#define EXSPL7( s ) { \
	s = currpl(); \
	sploff(); \
	}
#define EXSPL6( s ) { \
	s = currpl(); \
	sploff(); \
	}
#define EXSPL5( s ) { \
	s = currpl(); \
	sploff(); \
	}
#define EXSPL0( s ) { \
	s = currpl(); \
	sploff(); \
	}
#else

/*
Most Usual case.
*/
#define EXSPL7( s ) { \
	s = spl7(); \
	}
#define EXSPL6( s ) { \
	s = spl6(); \
	}
#define EXSPL5( s ) { \
	s = spl5(); \
	}
#define EXSPL0( s ) { \
	s = spl0(); \
	}
#define EXSPLX( s) { \
	splx(s); \
	}
#endif
#endif	/* pcxenix */
#endif	/* scoxenix5 */

/*
pointer to buffer for initialization message (for systems which need it).
*/
extern EXbtype *imsgbuf;

/* ================== BEGIN MACROS FOR MESSAGE QUEUE ACCESS =========== */

#if (pcxenix || rtpc)
extern char xpeekb();
extern unsigned short xpeekw();
extern long xpeekd();
#ifdef rtpc
extern long xpeekadr();
#endif
#ifndef rtpc
#define xpokeadr	xpoked
#endif

#define xgetb(a)	xpeekb(&a)
#define xgetw(a)	xpeekw(&a)
#define xgetd(a)	xpeekd(&a)
#ifdef rtpc
#define xgetp(a)	xpeekd(&a)
#else
#define xgetp(a)	xpeekw(&a)
#endif
#define xgetadr(a)	xpeekd(&a)
#define xputb(a, v)	xpokeb(&a,v)
#define xputw(a, v)	xpokew(&a,v)
#define xputd(a, v)	xpoked(&a,v)
#ifdef rtpc
#define xputp(a, v)	xpoked(&a,v)
#else
#define xputp(a, v)	xpokew(&a,v)
#endif
#define xputadr(a, v)	xpoked(&a,v)
#define xcpi(f, t, l)	xcopyi(t, f, l)
#define xcpo(f, t, l)	xcopyo(t, f, l)
#define xcl(a, l)	xclear(a, l)
#else	/* pcxenix */
#define xgetb(a)	(a)
#define xgetw(a)	(a)
#define xgetd(a)	(a)
#define xgetp(a)	(a)
#define xputb(a, v)	(a = v)
#define xputw(a, v)	(a = v)
#define xputd(a, v)	(a = v)
#define xputp(a, v)	(a = v)
#define xcpi(f, t, l)	bcopy(t, f, l)
#define xcpo(f, t, l)	bcopy(t, f, l)
#define xcl(a, l)	clear(a, l)
#endif	/* pcxenix */

/* ================== BEGIN EXOS I/O PORT MACROS ====================== */

#if (pcxenix || rtpc)

#include "sys/exos205.h"

#define	XIORESET()	out(CP2_ADR, 0)
#define	XIOCLRINT()	out(CP3_ADR, 0);
#define	XIOSTATUS()	in(CP1_ADR)
#define	XIOWVAL(val)	out(CP1_ADR, val)
#define	XIONTRUPT()	out(CP1_ADR, 0)

#else	/* pcxenix */
#ifdef zilog

extern	enetioaddr;
#define	EXSTATPORT	(enetioaddr + 0) /* stat register, read only */
#define	EXRCOMPORT	(enetioaddr + 2) /* comm register, for reading */
#define	EXVECPORT 	(enetioaddr + 4) /* exos vector, read */
#define EXIUSRPORT	(enetioaddr + 8) /* reset interrupt under service */
#define	EXWCOMPORT	(enetioaddr + 10) /* comm register, for writing */
#define	EXRSTPORT	(enetioaddr + 12) /* soft exos reset, write */

#define	XIORESET()	outb(EXRSTPORT, 0)
#define	XIOCLRINT()	outb(EXIUSRPORT, 0)
#define	XIOSTATUS()	inb(EXSTATPORT)
#define	XIOWVAL(val)	outb(EXWCOMPORT, val)
#define	XIONTRUPT()	outb(EXWCOMPORT, 0)

#else	/* zilog */
#ifdef MULTIBUS

#define	XIORESET()	inb(PORTA)
#define	XIOCLRINT()	outb(PORTA, 0)
#define	XIOSTATUS()	inb(PORTB)
#define	XIOWVAL(val)	outb(PORTB, val)
#define	XIONTRUPT()	outb(PORTB, 0)

#else	/* MULTIBUS */

#define	XIORESET()	outb(PORTA)
#define	XIOCLRINT()
#define	XIOSTATUS()	inb(PORTB)
#define	XIOWVAL(val)	outb(PORTB, val)
#define	XIONTRUPT()	outb(PORTB, 0)

#endif	/* MULTIBUS */
#endif	/* zilog */
#endif	/* pcxenix */

/* ================== END EXOS I/O PORT MACROS ====================== */

/*
   The following used to be in include/EXOS/swap.h.
   dab 861209.
*/

/*======================== BEGIN tick definitions ====================*/

/*
   EXHZ is used in ex_subr.c and xty.c for calls to timeout().
   EXNCALLP is used in ex_subr.c in rm_callout().
   dab 861209.
*/

#ifdef tower

#define EXHZ HZ
#define EXNCALLP &callout[v.v_call - 1]

#else	/* tower */
#ifdef zilog

#define EXHZ HZ
#define EXNCALLP &callout[NCALL - 1]

#else	/* zilog */
#ifdef xenix286

#define EXHZ HZ
#define EXNCALLP &callout[v.v_call - 1]

#else	/* xenix286 */
#ifdef plexus

#define EXHZ HZ
#define EXNCALLP &callout[v.v_call - 1]

#else	/* plexus */
#ifdef Siemens3

#define EXHZ HZ
#define EXNCALLP &callout[v.v_call - 1]

#else	/* Siemens3 */
#ifdef cadmus

#define EXHZ 60
#define EXNCALLP &callout[v.v_call - 1]

#else	/* cadmus */
#ifdef S5vax750

#ifndef uniq
#define EXHZ 60
#define EXNCALLP &callout[v.v_call - 1]
#else	/* uniq */
#define EXHZ 60
#define EXNCALLP (struct callo *)v.ve_call-1
#endif	/* uniq */

#else
#ifdef V7

#define EXHZ HZ
#define EXNCALLP &callout[NCALL-1]

#else
#ifdef rtpc

#define EXHZ HZ
#define EXNCALLP &callout[v.v_call-1]

#else

#define EXHZ v.v_hz
#define EXNCALLP (struct callo *)v.ve_call-1

#endif	/* default */
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif

/*======================== BEGIN exvtop(x) definitions ====================*/
/* 
 * Define exvtop(x), which takes a kernel virtual data address and
 * converts it to a physical bus address, which the EXOS will use
 * for DMA data transfers.
 */

#ifdef tower
#define vtop(x) (x)
#endif

#ifdef plexus
#define exvtop(x) (x)
#endif

#ifdef cadmus
#define exvtop(x) (logtophys(x))
#endif

/*
 * Note address modifier used for VME-bus systems.
 */
#ifdef mostek
#define exvtop(x) ((long)(x) | 0x3d000000)
#endif

#ifdef victory
#define exvtop(x) ((long)(x) | 0x3d000000)
#endif

#ifdef callan
#define exvtop(x) (vtop(x))
#endif

#ifdef integrated
#ifdef BSD4dot2
#ifdef QBUS
#define exvtop(x) (x)
#else /* VMEbus */
#define exvtop(x) (0x3d000000 | ((u_long) (x) & 0x7fffff))
#endif /* VMEbus */
#else
#define exvtop(x) (svtop((x)))
#endif
#endif

#ifdef	parallel
#ifndef	MBI_ADDR
#include "sundev/mbvar.h"
#endif
#define exvtop(x)	MBI_ADDR((long)(x))
#define MBTOV(x)	((caddr_t)(&DVMA[(int)(x)]))
#endif	/* parallel */

#ifdef pcxenix

#define EXSEG_BUF 0
/*
 * Convert a buffer far pointer to a physical address.
 */
extern long dscraddr();

#define bftop(x)	(dscraddr( ftoseg(x)) + ftooff(x))
#define exvtop(x) (bftop(x))
#else	/* pcxenix */
#ifdef xenix286
#define EXSEG_BUF 1
#define exvtop(x) (ktop(x))
#endif
#endif	/* pcxenix */

#ifdef xenix086
#define	exvtop(x) (((long)(x))&0xFFFFL)
#endif

#ifdef altos
#define	exvtop(x) (((long)(x))&0xFFFFL)
#endif

#ifdef zilog
#define	exvtop(x) physaddr(x)
#endif

#ifdef rtpc
#define exvtop(x)	((unsigned)(x))
#endif /* rtpc */

/*
 * The definitions below are designed to take care of any systems
 * not covered above, but they are just an educated guess.
 */

#ifdef notdef
#define	vtop(x) ((unsigned)(x))
#endif

#ifdef BSD4dot1


extern struct buf *ex_vaxhashtab[];

#define b_exunibusaddr b_resid
/*
 * It is known that buffers start on page boundries.
 * What's done here is -- get address of buffer where this address is,
 * get unibus info for that address, then add any offset into the page.
 */
#define exvtop(addr) ((unsigned)(ex_vaxhash((unsigned)addr) + \
	(((unsigned)addr) & PGOFSET)))
#endif

#ifndef exvtop
#ifndef S5vax750
#define	exvtop(x) ((long)vtop(x))
#endif
#endif

/*===================== END exvtop(x) definitions ========================*/

#ifdef SYSTEM5
#define	EXBSIZE	SBUFSIZE
#else
#define	EXBSIZE BSIZE
#endif

#ifndef I8086
/* get an 8086 segment number from an address */
#define	SEGNO(x)	(((int)(x) >> 4) & 0xF000)
#endif

extern unsigned short htons(), ntohs();

#ifdef BSD4dot1
#define ex_vaxhash(addr) (ex_vaxhashtab[ex_vhash(addr)] ? \
	(((ex_vaxhashtab[ex_vhash(addr)])->b_exunibusaddr)&0x3ffff) : \
	panic("ex_hash of 0"))

extern char *buffers;
#define ex_vhash(addr) (((((unsigned)addr)>>PGSHIFT)&0xfff) - \
	((((unsigned)buffers)>>PGSHIFT)&0xfff))

/* see BSD4dot1.c for what happens here... */
#define geteblk()	ex_geteblk()
#define brelse(x)	ex_brelse(x)
extern struct buf *ex_geteblk();

#define save(x)	setjmp(x)
#define resume(proc, sav) longjmp(sav)

#endif
