/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: cmds.c,v 1.2 87/04/24 14:55:52 davidb Exp $ */
#ifndef lint
static char sccsid[] =
 " @(#)cmds.c	1.22 7/29/85";
#endif

/*
 * FTP User Program -- Command Routines.
 */
#include "ftpc.h"

extern	char *globerr;
extern	char **nglob();
extern	char **xglob();
extern	char **xmkarglist();
extern	short gflag;
extern	char *remglob();
extern	char *xstrchr();
extern	char *xstrrchr();
extern	int get();
extern	int put();
extern  struct filesystem *xgetfs();
extern  struct filesystem *xgetfsp();
static	int globulize();

static char **glizept = (char **)0;
static int lsmore;	/* Append to files during ls commands */

#define BUFSIZ 1024

/*
 * print status of various flags maintained by protocol independent
 * code
 */
status( argc, argv )
	int argc;
	char *argv[];
{
	xoprintf( xstdout, "Connection-independent Flags:\n\t" );
	if( doglob )
		xoprintf( xstdout,
			"Local filename expansion (globbing) enabled.\n\t" );
	if( force )
		xoprintf( xstdout,
			"Transfer files according to current transfer parameter settings.\n\t");
	if( xexitonerror )
		xoprintf( xstdout, "Exit on error.\n\t" );
	if( bell )
		xoprintf( xstdout, "Ring bell on command completion.\n\t" );
	if( statistics )
		xoprintf( xstdout, "Print transfer statistics.\n\t" );
	if( hash )
		xoprintf( xstdout, "Print # for every 1K transfered.\n\t" );
	if( interactive )
		xoprintf( xstdout, "Prompt during m[ultiple] commands.\n\t" );
	xoprintf( xstdout, "\n" );
	xfsstatus(FTP, xstdout);
	return( 0 );
}
/*
 * close the currently active connection, or a named connection,
 * but remain in FTP.
 */
bye( argc, argv )
	int argc;
	char *argv[];
{
	int rval = 0;
	char null = 0;
	char *null_pt = &null;
	struct filesystem *context;

	if( argc < 2 ) {
		rval = xrelsfs( ccontext, 1 );
		conned = 0;
	} else {
		xrelsfs( ccontext, 0 );
		while( argc > 1 ) {
			--argc;
			++argv;
			context = xgetfs( *argv, null_pt, null_pt, null_pt, 1 );
			if( context == XNULL ) {
				rval = XEINVAL;
			} else {
				rval = xrelsfs( context, 1 );
				if( context == ccontext ) {
					ccontext = 0;
					conned = 0;
				}
			}
			if( rval < 0 )
				break;
		}
		if( conned ) {
			ccontext = xgetfsp( ccontext );
		}
	}
	return( rval );
}


/*
 * Set current working directory
 * on remote machine.
 */
cd(argc, argv)
	char *argv[];
{
	int madeargs = 0;
	int rval = XEINVAL;
	int stat;

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(remote-directory) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
		xoprintf(xstdout,"%s remote-directory\n", argv[0]);
		goto endcd;
	}
	rval = echdir( argv[1], FILE_NAME, ccontext );
endcd:
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return (0);
	return( rval );
}

/*
 * copy
 */
copy( argc, argv )
	int argc;
	char *argv[];
{
	struct filesystem *context;
	struct filesystem *lconn;
	int rval;

	lconn = lcontext;
	xrelsfs( lcontext, 0 );
	context = (struct filesystem *)0;
	if( ccontext ) {
		context = ccontext;
		xrelsfs( context, 0 );
		ccontext = 0;
		conned = 0;
	}
	rval = xcopy( argc, argv );
	if( context ) {
		ccontext = xgetfsp( context );
		conned = 1;
	}
	lcontext = xgetfsp( lconn );
	return( rval );
}


/*
 * Delete a single file.
 */
delete(argc, argv)
	char *argv[];
{
	int madeargs = 0;
	int rval = XEINVAL;
	int stat;

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(remote-file) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
		xoprintf(xstdout,"%s remote-file\n", argv[0]);
		goto enddelete;
	}
	rval = eunlink( argv[1], FILE_NAME, ccontext );
enddelete:
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return (0);
	return( rval );
}

/*
 * Get a directory listing of
 * local files.
 */
lls( argc, argv )
	char *argv[];
{
	struct filesystem *context;
	int rval = 0;
	char *argv1[3];
	char **argv2;
	char **argv3;
	char **argp;
	int argc2;
	char *pt;

	context = ccontext;
	ccontext = lcontext;
	if( argc > 1 ) {
		/*
		 each name may require globbing.
		*/
		argp = argv;
		++argp;
		for( ; *argp ; ++argp ) {
			argv1[0] = *argp;
			argv1[1] = (char *)0;
			argv2 = xglob( argv1 );
			if( argv2 == XNULL || globerr ) {
				if( argv2 != XNULL )
					xdealglob( argv2 );
				continue;
			}
			argv3 = argv2;
			for( pt = *argv3++ ; pt ; pt = *argv3++ ) {
				argv1[0] = argv[0];
				argv1[1] = pt;
				argv1[2] = 0;
				if( !rval ) {
					rval = ls( 2, argv1 );
				} else {
					ls( 2, argv1 );
				}
			}
			xdealglob( argv2 );
		}
	} else {
		rval = ls( argc, argv );
	}
	ccontext = context;
	return( rval );
}

/*
 * Get current directory on local system.
 */
lpwd( argc, argv )
	char *argv[];
{
	struct filesystem *context;
	int rval;
	int overb;

	context = ccontext;
	ccontext = lcontext;
	overb = verbose;
	verbose = 0;
	rval = pwd( argc, argv );
	verbose = overb;
	ccontext = context;
	return( rval );
}

/*
 * Change current directory on local system.
 */
lcd( argc, argv )
	char *argv[];
{
	struct filesystem *context;
	int rval;

	context = ccontext;
	ccontext = lcontext;
	if( argc == 1 ) {
		rval = echdir( "", HOME_DIR, ccontext );
	} else {
		rval = cd( argc, argv );
	}
	ccontext = context;
	return( rval );
}


/*
 * Execute a program locally.
 */
lexec(argc, argv)
	char *argv[];
{
	int rval = XEINVAL;
	int madeargs = 0;
	int stat;

	if ( argc == 1 && !xstrcmp( *argv, "!" ) ) {
		rval = xexec( argc, argv, 0, 1, 2 );
		goto endlexec;
	}
	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(command line to send) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
		xoprintf(xstdout,"usage: %s command-to-execute\n", argv[0]);
		goto endlexec;
	}
	rval = xexec( argc - 1, &argv[1], 0, 1, 2 );
endlexec:
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return (0);
	return( rval );
}

/*
 * Get a directory listing
 * of remote files.
 */
ls(argc, argv)
	char *argv[];
{
	int fun_code;
	char *rdir;
	char *lfile;
	int madeglob = 0;
	int outod;
	int rval = 0;
	char *pt;

	if (argc < 2) {
		argc++, rdir = XNULL;
		fun_code = (argv[0][0] == 'd' || argv[0][1] == 'd') ?
			LSLONG : LS;
	} else {
		rdir = argv[1];
		fun_code = (argv[0][0] == 'd' || argv[0][1] == 'd') ?
			LSLONG_ARG : LS_ARG;
	}
	if (argc > 3) {
		xoprintf(xstdout,"usage: %s remote-directory local-file\n",
			argv[0]);
		return( XEINVAL );
	}
	if (( argc == 3 ) && xstricmp(argv[2], "-")) {
		/*
		expand local file name
		*/
		lfile = argv[2];
		if (!(madeglob = globulize(&lfile)))
			goto endls;
		/*
		open file for output
		*/
		if( interactive ) {
		    xoprintf(xstdout,
			"Listing directed to %s.  Are you sure(y/n)?",
			lfile );
		    xfflush(xstdout);
		    line[0] = 0;
		    xgets( line );
		}
		for( pt = line ; *pt ; ++pt ) {
			if( *pt == 'y' || *pt == 'Y' )
				break;
			if( *pt == 'n' || *pt == 'N' )
				goto endls;
		}
		outod = xdopen( lfile, XFWRITE | XFCREAT | XFASCII | 
			((lsmore)? XFAPPEND : XFTRUNC),
				FILE_NAME );
		if( outod < 0 ) {
			rval = outod;
			goto endls;
		}
	} else {
		outod = xfileno(xstdout);
	}
	rval = els( outod, rdir, fun_code, 0, ccontext );
	if( outod != xfileno(xstdout) ) {
		xclose( outod );
	}
endls:
	if( madeglob && doglob )
		xdealglob( glizept );
	return( rval );
}


/*
 * Get a directory listing
 * of multiple remote files.
 */
mls(argc, argv)
	char *argv[];
{
	int i, dest;
	char *rdir;
	char *lfile;
	int madeglob = 0;
	int cfrval;
	int old_interactive;
	int rval = XEINVAL;
	int mlargc;
	char *mlargv[4];

	old_interactive = interactive;
	if (argc == 1)	/* treat as ls */
		return (ls(argc, argv));
	if (argc < 2)
		argc++, rdir = XNULL;
	else
		rdir = argv[1];
	if (argc < 3)
		{
		argc++, lfile = "-";
		dest = argc - 1;
		}
	else
		{
		dest = argc - 1;
		lfile = argv[dest];
		}
	if (xstrcmp(lfile, "-") != 0) {
		if (!(madeglob = globulize(&lfile)))
			goto endmls;
	} else
		lfile = "";	/* output to standard output */
	mlargv[0] = argv[0];
	mlargv[2] = lfile;
	mlargv[3] = 0;
	mlargc = *lfile ? 3 : 2;
	for (i = 2; i < dest + 1 ; i++)
		{
		mlargv[1] = rdir;
		rval = ls( mlargc, mlargv );
		if( rval < 0 )
			break;
		rdir = argv[i];
		interactive = 0;
		lsmore = 1;
		}
endmls:
	interactive = old_interactive;
	lsmore = 0;
	if( madeglob && doglob )
		xdealglob( glizept );
	return( rval );
}


/*
 * Delete multiple files.
 */
mdelete(argc, argv)
	char *argv[];
{
	int madeargs = 0;
	int rval = XEINVAL;
	int stat;

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(remote-files) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
		xoprintf(xstdout,"%s remote-files\n", argv[0]);
		goto endmdel;
	}
	rval = mop( ccontext, delete, 2, argc, argv );
endmdel:
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return (0);
	return( rval );
}

/* 
 * Force a file to be sent/receive in record structure using the current ASCII/BINARY
 * transfer parameter
 *
 * This is done by saving the current transfer parameter, temporarily change
 * to record structure, start the transfer and restore the parameter
 */

static int rop(func, argc, argv)
int (*func)();		/* function to perform */
int	argc;
char	*argv[];
{
int	rval;
int	saveforce;	/* save force flag */
int	inrecord;	/* already in record mode */
struct xstatbuf attr;	/* save current transfer parameters */

	rval = 0;
	saveforce = force;
	estat("", SERVICE_PARA, &attr, ccontext);	

	/* now set to force and set to record mode */
	force = 1;
	inrecord = attr.x_mode & X_IFRECORD;
	attr.x_mode |= X_IFRECORD;
	if (!inrecord)
		rval = echattr("", SERVICE_PARA, &attr, ccontext);
	if (rval != 0) {
		force = saveforce;
		return (rval);	/* error in changing parameter */
	};

	/* now call put to send the file */
	rval = (*func) (argc, argv);
	force = saveforce;
	if (!inrecord) {
		attr.x_mode &= ~X_IFRECORD;
		echattr("", SERVICE_PARA, &attr, ccontext);
	};
	return (rval);
}

rput(argc, argv)
int	argc;
char	*argv[];
{
	return (rop(put, argc, argv));
}

rget(argc, argv)
int	argc;
char	*argv[];
{
	return (rop(get, argc, argv));
}

/*
 * Get multiple files.
 */
mget(argc, argv)
	char *argv[];
{
	int madeargs = 0;
	int rval = XEINVAL;
	int stat;

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(remote-files) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
		xoprintf(xstdout,"%s remote-files\n", argv[0]);
		goto endmget;
	}
	rval = mop( ccontext, get, 3, argc, argv );
endmget:
	if (madeargs && (stat == 0))
		return (0);
	if( madeargs )
		xdealglob( argv );
	return( rval );
}

/*
 * Common code for `m' operations
 */
mop( context, fun_arg, narg, argc, argv )
	struct filesystem *context;
	int (*fun_arg)();
	int narg;		/* number of arguments to call "fun_arg" with*/
	char *argv[];
{
	int globod;
	char *opargv[4];
	int opargc;
	int rval;
	int stat;
	char **cargv;
	int doall = 0;
	int cfrval = 0;
	struct xstatbuf attr;
	char nambuf[XBUFSIZ];

	--argc;
	cargv = argv;
	++cargv;
	opargc = narg;
	opargv[0] = argv[0];
	opargv[opargc] = 0;
	while( argc ) {
		globod = eglobopen( *cargv, FILE_NAME, context );
		if( globod < 0 ) {
			rval = globod;
			xoprintf(xstdout,"%s name expansion failed.\n", *argv );
			if (globerr)
				xoprintf(xstdout,"Reason: %s\n", globerr);
			goto endmop;
		}
		while ((rval = xread(globod, nambuf, sizeof(nambuf))) > 0 ) {
			if (fun_arg == put) {
				/* check if the file exists */
				stat = estat(nambuf, FILE_NAME, &attr, context);
				if (stat != 0)
					continue;
			};
			if( !doall )
				cfrval = confirm(argv[0], nambuf );
			if( cfrval == 'a' )
				doall = 1;
			if( cfrval == 'q' ) {
				goto endmop;
			}
			if ( cfrval ) {
				opargv[1] = nambuf;
				if( narg > 2 )
					opargv[2] = nambuf;
				rval = (*fun_arg)(opargc,opargv);
				if (( rval < 0 ) && xexitonerror)
					break;
			}
		}
		if (( rval < 0 ) && (rval != XEOF) && xexitonerror)
			break;
		--argc; ++cargv;
		xclose( globod );
	}
endmop:
	if( globod >= 0 )
		xclose( globod );
	if (rval == XEOF)
		rval = 0;
	return( rval );
}


/*
 * Send multiple files.
 */
mput(argc, argv)
	char *argv[];
{
	char **cpp, **gargs = XNULL;
	int madeargs = 0;
	int cfrval;
	int doall = 0;
	char *mpargv[4];
	int mpargc;
	int rval;
	int stat;

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(local-files) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
		xoprintf(xstdout,"%s local-files\n", argv[0]);
		rval = XEINVAL;
		goto endmput;
	}
	rval = mop( lcontext, put, 3, argc, argv );
endmput:
	if (madeargs && (stat == 0))
		return 0;
	if( madeargs )
		xdealglob( argv );
	return( rval );
}

/*
 * Send a single file.
 */
int put(argc, argv)
	int argc;
	char *argv[];
{
	int rval;
	int mode;
	int inod;
	int outod;
	char *remote;
	char *local;
	int madeargs = 0;
	int madeglob = 0;
	int dontclose = 0;
	int flags;
	int stat;
	int expandloc = 0;		/* flag to show if we need to expand
					   local file name to be used as 
					   remote */
	int needrestore = 0;		/* flag to show if need to restore
					   transfer parameters */
	struct xstatbuf curattr;	/* current transfer parameters */
	struct xstatbuf attr;

	if (argc == 2)
		argc++, expandloc = 1, remote = argv[1];
	else if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(local-file)");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	else {
		remote = argv[2];
	}
	if( argc < 2 ) {
		xoprintf(xstdout,"%s local-file [remote-file]\n", argv[0]);
		goto endput;
	}
	if (argc < 3) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(remote-file, %s is default) ", argv[1] );
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		if( madeargs )
			xdealglob( argv );
		argv = xmkarglist( line, &argc );
		madeargs = 1;
		remote = argv[2];
	}
	if (argc < 3) {
		remote = argv[1];
		expandloc = 1;
	}
	local = argv[1];
	if (!(madeglob = globulize(&local)))
		goto endput;
	if (expandloc)
		remote = local;	/* use expanded name */

	rval = estat( "", SERVICE_PARA, &attr, ccontext );
	if( rval < 0 )
		goto endput;
	if( xstrcmp( local, "-" ) ) {
		mode = XFREAD;
		if( force ) {
			/*
			We are going to use the service parameters
			of the remote file system, regardless of
			what the local file type is.
			*/
			mode |= XFFORCE;
		} else {	
			/* find out the current file attributes and then
			   set the mode accordingly 
			*/
			xbcopy(&attr, &curattr, sizeof attr);
			rval = estat (local, FILE_NAME, &attr, lcontext);
			if (rval < 0)
				goto endput;
			if (attr.x_mode & X_IFTEXT)
				mode |= XFASCII;
			if (attr.x_mode & X_IFRECORD)
				mode |= XFRECORD;
			if ((curattr.x_mode & (X_IFRECORD | X_IFTEXT)) !=
		            (attr.x_mode & (X_IFRECORD | X_IFTEXT))) 
				needrestore = 1;
		};
		inod = eopen( local, mode, FILE_NAME, &attr, lcontext );
		if( inod < 0 ) {
			rval = inod;
			goto endput;
		}
	} else {
		/* for standard objects, if force mode is off, we always
		   send the file as ASCII file and FILE structure
		*/
		if (!force) {
			/* save current transfer parameters and then set
			   it to ASCII and file structure */
			xbcopy(&attr, &curattr, sizeof attr);
			attr.x_mode &= ~X_IFMT;
			attr.x_mode |= X_IFREG | X_IFTEXT;
			if ((curattr.x_mode & (X_IFRECORD | X_IFTEXT)) !=
		            (attr.x_mode & (X_IFRECORD | X_IFTEXT))) 
				needrestore = 1;
		};			
		inod = xfileno( xstdin );
		dontclose++;
	}
	mode = (argv[0][0] == 'a') ? XFAPPEND : (XFTRUNC | XFCREAT);
	mode |= XFWRITE;
	outod = eopen( remote, mode, FILE_NAME, &attr, ccontext );
	if( outod < 0 ) {
		rval = outod;
		if( !dontclose )
			xclose( inod );
		goto endput;
	}
	flags = 0;
	if( hash )
		flags |= HASH_ONPASS;
	if( statistics )
		flags |= STATS_ONPASS;
	rval = epassthru( inod, outod, flags, ccontext );
	if( abortxfer ) {
		eabort( ccontext );
		abortxfer = 0;
	}
	if( !dontclose )
		xclose( inod );
	xclose( outod );
	if (rval < 0) {	/* error in put */
		xoprintf(xstdout, "Error in sending file %s, remote file deleted\n", 
			remote);
		eunlink(remote, FILE_NAME, ccontext);
	};
endput:
	if (needrestore) 
		echattr("", SERVICE_PARA, &curattr, ccontext);
	if( madeglob && doglob )
		xdealglob( glizept );
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return (0);
	return( rval );
}


/*
 * Receive a single file.
 */
get(argc, argv)
	int argc;
	char *argv[];
{
	int rval;
	int mode;
	int inod;
	int outod;
	char *remote;
	char *local;
	int madeargs = 0;
	int madeglob = 0;
	int dontclose = 0;
	int flags;
	int stat;
	struct xstatbuf attr;

	if (argc == 2)
		argc++, local = argv[1];
	else if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(remote-file)");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	else {
		local = argv[2];
	}
	if( argc < 2 ) {
		xoprintf(xstdout,"%s remote-file [local-file]\n", argv[0]);
		goto endget;
	}
	if (argc < 3) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(local-file, %s is default) ", argv[1] );
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		if( madeargs )
			xdealglob( argv );
		argv = xmkarglist( line, &argc );
		madeargs = 1;
		local = argv[2];
	}
	if (argc < 3) {
		local = argv[1];
	}
	remote = argv[1];
	if (!(madeglob = globulize(&local)))
		goto endget;
	mode = XFREAD;
	if( force ) {
		/*
		We are going to use the service parameters
		of the remote file system, first we fetch them,
		then we force them to be used.
		This rather round-about technique saves the invention
		of yet another mechanism.
		The fetch is necessary, because we don't necessarily
		know what the current service parameters are.
		*/
		mode |= XFFORCE;
		rval = estat( "", SERVICE_PARA, &attr, ccontext );
		if( rval < 0 )
			goto endget;
	}
	inod = eopen( remote, mode, FILE_NAME, &attr, ccontext );
	if( inod < 0 ) {
		rval = inod;
		goto endget;
	}
	if( xstrcmp( local, "-" ) ) {
		mode = (argv[0][0] == 'a') ? XFAPPEND : (XFTRUNC | XFCREAT);
		/* must open the file the way the current transfer is set to*/
		mode |= XFWRITE | XFFORCE;	
		outod = eopen( local, mode, FILE_NAME, &attr, lcontext );
		if( outod < 0 ) {
			rval = outod;
			xclose( inod );
			goto endget;
		}
	} else {
		/* for standard objects, we need to think about which
		   transfer parameter to use when force is on/off 
		*/
		outod = xfileno( xstdout );
		dontclose++;
	}
	flags = 0;
	if( hash )
		flags |= HASH_ONPASS;
	if( statistics )
		flags |= STATS_ONPASS;
	rval = epassthru( inod, outod, flags, ccontext );
	if( abortxfer ) {
		eabort( ccontext );
		abortxfer = 0;
	}
	xclose( inod );
	if( !dontclose ) {
		xclose( outod );
		if (rval < 0) {	/* error on get, delete local file */
			xoprintf(xstdout, "Error in getting file %s, partial file deleted.\n", 
				local);
			eunlink(local, FILE_NAME, lcontext);
		};
	};
endget:
	if( madeglob && doglob )
		xdealglob( glizept );
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return 0;
	return( rval );
}


/*
 * Get current working directory
 */
pwd( argc, argv )
	char *argv[];
{
	int rval;
	char buf[XBUFSIZ];

	rval = epwd( buf, sizeof( buf ), PWD, ccontext );
	if( rval >= 0 && !verbose ) {
		xoprintf( xstdout, "\t\"%s\" is current directory.\n", buf );
	}
	return( rval );
}

/*
 * Rename a remote file.
 */
renamefile(argc, argv)
	char *argv[];
{
	int madeargs = 0;
	int rval = XEINVAL;
	int stat;

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(from-name) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
usage:
		xoprintf(xstdout,"%s from-name to-name\n", argv[0]);
		goto endrname;
	}
	if (argc < 3) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(to-name) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		if( madeargs )
			xdealglob( argv );
		argv = xmkarglist( line, &argc );
	}
	if (argc < 3) 
		goto usage;
	rval = erename( argv[1], FILE_NAME, argv[2], FILE_NAME, ccontext );
endrname:
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return 0;
	return( rval );
}

/*
 * Make a directory.
 */
makedir(argc, argv)
	char *argv[];
{
	int madeargs = 0;
	int rval = XEINVAL;
	int stat;

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(directory-name) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
		xoprintf(xstdout,"%s directory-name\n", argv[0]);
		goto endmkdir;
	}
	rval = emkdir( argv[1], FILE_NAME, ccontext );
endmkdir:
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return (0);
	return( rval );
}

/*
 * Remove a directory.
 */
removedir(argc, argv)
	char *argv[];
{
	int madeargs = 0;
	int rval = XEINVAL;
	int stat;

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(directory-name) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
		xoprintf(xstdout,"%s directory-name\n", argv[0]);
		goto endrmdir;
	}
	rval = ermdir( argv[1], FILE_NAME, ccontext );
endrmdir:
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return (0);
	return( rval );
}

/*
 * Connect to peer server and
 * auto-login, if possible.
 */
setpeer(argc, argv)
	int argc;
	char *argv[];
{
	char null = 0;
	char *user = &null;
	char *pass = &null;
	char *acct = &null;
	int madeargs = 0;
	int rval = 0;
	char *cargv[2];
	int stat;
	int port;
	int special_port = 0;	/* flag for special port */

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(to) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2 || argc > 3) {
		xoprintf(xstdout,"usage: %s host-name [port]\n", argv[0]);
		rval = XEINVAL;
		goto endspeer;
	}
	if( argc == 3 ) {
		port = xatoi(argv[2]);
		special_port = 1;
	}
	if( ccontext ) {
		xrelsfs( ccontext, 0 );
	}

	if (special_port) {
		rval = xsetport(XFILE_SERVICE, FTP, port);
		if (rval != 0)
			goto endspeer;
	};
	ccontext = xgetfs( argv[1], user, pass, acct, 0 );
	if (special_port) {	/* use standard port from now on */
		rval = xsetport(XFILE_SERVICE, FTP, IPPORT_FTP);
		if (rval != 0)
			goto endspeer;
	};
	if( ccontext != XNULL ) {
		conned = 1;
	} else {
		rval = XEIO;
		conned = 0;
		goto endspeer;
	}
	cargv[0] = "defaults";
	cargv[1] = (char *)0;
	ecmd( 1, cargv, ccontext );
	if( debug ) {
		cargv[0] = "debug";
		ecmd( 1, cargv, ccontext );
	}
	if( !sendport ) {
		cargv[0] = "sendport";
		ecmd( 1, cargv, ccontext );
	}
	if( verbose ) {
		cargv[0] = "verbose";
		ecmd( 1, cargv, ccontext );
	}
endspeer:
	if( madeargs )
		xdealglob( argv );
	if (madeargs && (stat == 0))
		return (0);
	return( rval );
}

quit( argc, argv )
	int argc;
	char **argv;
{
	xexit( 0 );
}


/*
 * Send new user information (re-login)
 */
user(argc, argv)
	int argc;
	char **argv;
{
	int n;
	int madeargs = 0;
	int rval;
	char *pass;
	char *user;
	char *acct;
	char null = 0;
	char *null_pt = &null;
	int stat;

	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(Remote Username) ");
		xfflush( xstdout );
		stat = xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2 || argc > 4) {
		xoprintf(xstdout,
			"usage: %s username [password [account]]\n", argv[0]);
		goto enduser;
	}
	user = argv[1];
	pass = ( argc > 2 ) ? argv[2] : null_pt;
	acct = ( argc > 3 ) ? argv[3] : null_pt;
	rval = esendident( user, pass, acct, ccontext );
	if( rval <= 0 ) {
		xoprintf( xstdout, "Login rejected.\n" );
	}
enduser:
	if( madeargs )
		xdealglob( argv );
	return( 0 );
}

/*
 * Glob a local file name specification with
 * the expectation of a single return value.
 * Can't control multiple values being expanded
 * from the expression, we return only the first.
 */
static
globulize(cpp)
	char **cpp;
{
	char **globbed;
	char *argv[2];

	if (!doglob)
		return (1);
	argv[0] = *cpp;
	argv[1] = (char *)0;
	globbed = nglob( argv, 1 );
	if (globerr != XNULL) {
		xoprintf(xstdout,"%s: %s\n", *cpp, globerr);
		if (globbed)
			xdealglob(globbed);
		return (0);
	}
	if (globbed) {
		*cpp = *globbed;
		/* don't waste too much memory */
		glizept = globbed;
	}
	else
		return( 0 );
	return (1);
}



confirm(cmd, file)
	char *cmd, *file;
{
	char line[BUFSIZ];

	if ((!interactive) || (!fromatty))
		return (1);
	xoprintf(xstdout,"%s %s ?(n==don't,a==do all,q==do no more,y==do)? ",
		cmd, file);
	xfflush(xstdout);
	if (xgets(line) == 0)
		return ('q');
	switch ( *line ) {
		case 'n':
		case 'N':
			return( 0 );
		case 'y':
		case 'Y':
			return( 'y' );
		case 'A':
		case 'a':
			return( 'a' );
		case 'Q':
		case 'q':
			return( 'q' );
		default:
			break;
		}
	return(1);
}

/*
 * toggle forced use of service parameters of ccontext
 */
tforce( argc, argv )
	char *argv[];
{
	int rval = 0;

	if( force ) {
		force = 0;
	} else {
		force++;
	}
	if (force)
		xoprintf(xstdout, "Always use current transfer mode for file transfer.\n");
	else
		xoprintf(xstdout, "Use file attributes to determine the file transfer parameters.\n");
	return( rval );
}

/*
 * toggle prompting for `m' commands
 */
tinteractive( argc, argv )
	char *argv[];
{
	int rval = 0;

	if( interactive ) {
		interactive = 0;
	} else {
		++interactive;
	}
	if (interactive)
		xoprintf(xstdout, "Interactive prompt for multiple commands.\n");
	else
		xoprintf(xstdout, "DO not prompt for multiple commands.\n");
	return( rval );
}

#ifndef	vms
/*
 * toggle file name expansion
 */
tglob( argc, argv )
	char *argv[];
{
	int rval = 0;

	if( doglob ) {
		doglob = 0;
	} else {
		++doglob;
	}
	if (doglob)
		xoprintf(xstdout, "Enable local file name expansion.\n");
	else
		xoprintf(xstdout, "Disable local file name expansion.\n");
	return( rval );
}
#endif

/*
 * toggle bell ringing
 */
tbell( argc, argv )
	char *argv[];
{
	int rval = 0;

	if( bell ) {
		bell = 0;
	} else {
		++bell;
	}
	if (bell)
		xoprintf(xstdout, "Ring bell after each command completed.\n");
	else
		xoprintf(xstdout, "DO not ring bell after each command.\n");
	return( rval );
}

/*
 * toggle printing of hash mark
 */
thash( argc, argv )
	char *argv[];
{
	int rval = 0;

	if( hash ) {
		hash = 0;
	} else {
		++hash;
	}
	if (hash) {
		xoprintf(xstdout, "Display # for each 1K bytes transfer.\n");
	} else {
		xoprintf(xstdout, "Do not display # during data transfer.\n");
	}
	return( rval );
}

/*
 * toggle statistics printing
 */
tstat( argc, argv )
	char *argv[];
{
	int rval = 0;

	if( statistics ) {
		statistics = 0;
	} else {
		++statistics;
	}
	if (statistics)
		xoprintf(xstdout, "Displays file transfer statistics.\n");
	else
		xoprintf(xstdout, "DO not display file transfer statistics.\n");
	return( rval );
}


/*
 * toggle debug setting on connection startup
 */
gdebug( argc, argv )
	char *argv[];
{
	int rval = 0;

	if( debug ) {
		debug = 0;
	} else {
		debug++;
	}
	if (debug)
		xoprintf(xstdout, "Show FTP commands sent to server.\n");
	else
		xoprintf(xstdout, "DO not show FTP commands sent to server.\n");
	return( rval );
}



/*
 * toggle sendport setting on connection startup
 */
gsendport( argc, argv )
	char *argv[];
{
	int rval = 0;

	if( sendport ) {
		sendport = 0;
	} else {
		sendport++;
	}
	if (sendport)
		xoprintf(xstdout, "Send PORT commands for data transfer.\n");
	else
		xoprintf(xstdout, "DO not send PORT commands for data transfer.\n");
	return( rval );
}



/*
 * toggle verbose setting on connection startup
 */
gverbose( argc, argv )
	char *argv[];
{
	int rval = 0;

	if( verbose ) {
		verbose = 0;
	} else {
		verbose++;
	}
	if (verbose)
		xoprintf(xstdout, "Show FTP server's responses.\n");
	else
		xoprintf(xstdout, "DO not show FTP server's responses.\n");
	return( rval );
}
