/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ftpd.c,v 1.2 87/04/24 14:58:43 davidb Exp $ */
#ifndef lint
static char sccsid[] = " @(#)ftpd.c	1.16 7/29/85";
#endif

/*
 * FTP server.
 */
#include "ftpd.h"

#define	ABORT_MSG	"426 Connection closed; transfer aborted\r\n"
#define ABORT_NODATA	"226 Closing data connection; abort successful\r\n"

#define	RECORD_ESCAPE	'\377'
#define END_OF_FILE	'\002'
#define MAXPATHLEN	1024 /* Used to be in compat.h. dab 861126. */
#define VOID 		(int)/* Used to be in compat.h. dab 861126. */

#define	PWDLEN	256	/* size of current directory */

extern long xpasstnet(), xpassfnet();
extern	char version[];
extern	XFILE *xodopen();
extern	int fclose();
extern	char *xrerror();
extern	int xclose();
extern  char **xmkarglist();
extern  char **xglob();
extern  char *globerr;

struct	sockaddr_in ctrl_addr = { AF_INET };
struct	sockaddr_in data_source = { AF_INET };
struct	sockaddr_in data_dest = { AF_INET };
struct	sockaddr_in his_addr = { AF_INET };

int	data = 0;
int	abortxfer = 0;
#ifdef zilog
ret_buf	errcatch;
#else
jmp_buf	errcatch = { 0 };
#endif
int	logged_in = 0;
int	debug = 0;
int	timeout = 0;
int	logging = 0;
int	guest = 0;
int	type = 0;
int aborted = 0;
int	form = 0;
int	stru = 0;			/* avoid C keyword */
int	mode = 0;
int	bytesize = 0;
int	usedefault = 1;		/* for data transfers */
char	hostname[32] = {0};
char	*remotehost = (char *)0;

/*
 * Timeout intervals for retrying connections
 * to hosts that don't accept PORT cmds.  This
 * is a kludge, but given the problems with TCP...
 */
#define	SWAITMAX	90	/* wait at most 90 seconds */
#define	SWAITINT	5	/* interval between retries */

int	swaitmax = SWAITMAX;
int	swaitint = SWAITINT;

int	lostconn();
XFILE	*dataconn();
char	*ntoa();

int datamark = 0;
#define DM 242

poption( state, command, option )
	struct tel_state *state;
	int command;
	int option;
{
	if( command == DM ) {
		xoprintf( xstderr, "data mark.\n" );
		datamark = 1;
	}
}
pescape( state )
	struct tel_state *state;
{
}

/*
 * States for parsing commands issued after telnet IP.
*/
#define START 1
#define CR 2
#define CRLF 3

catch_ip( so )
	int so;
{
	int	status;
	abortxfer++;
	status = xcatch_oob( so, catch_ip );
}

clearabort()
{
	char buf[1];
	short atmark;
	int state;
	int ch;
	int rval;
	int how = 1;

	datamark = 0;
	xioctl( 0, FIONBIO, &how );
	do {
		rval = xioctl( 0, SIOCATMARK, &atmark );
		if( rval < 0 )
			break;
		if( !atmark ) {
			rval = xread( 0, buf, 1 );
			xoprintf( xstderr, "read %c\n", buf[0] );
			if( rval < 0 )
				break;
		} else {
			rval = xioctl( 0, SIOCRCVOOB, &datamark );
			break;
		}
	} while ( !datamark );
	/*
	should process a command here.
	In any case, fetch next command line.
	*/
	state = START;
	do {
		ch = xgetchar();
		xoprintf( xstderr, "read2 %c\n", ch );
		switch ( ch ) {
			case '\r':
				state = CR;
				break;
			case '\n':
				if( state == CR ) {
					state = CRLF;
				} else {
					state = START;
				}
			case XEOF:
				state = CRLF;
				break;
			default:
				state = START;
				break;
		}
	} while ( state != CRLF );
	xfflush( xstdout );
	if( data != -1 ) {
		xwrite( 1, ABORT_MSG, sizeof ABORT_MSG);
	} else {
		xwrite( 1, ABORT_NODATA, sizeof ABORT_NODATA);
	}
	abortxfer = 0;
	how = 0;
	xioctl( 0, FIONBIO, &how );
}

ftpdoit( s, from )
/*
start of generic ftp demon code
*/

int s;
struct sockaddr_in *from;
{
	int olds;
	int status;

	olds = s;
	if( olds == 0 || olds == 1 || olds == 2 ) {
		/*
		move it out of the way
		*/
		xdup2( olds, 11 );
		olds = 11;
	}
	if (logging)
		dolog(from);
	s = xtelopen( olds, poption, pescape );
	xdup2(s, 0); 
	if( s != 0 )
		xclose(s);
	xdup2(0, 1);
	/*
	handle oob data
	*/
	status = xcatch_oob( 0, catch_ip );
	xodopen( 0, "r" );
	xodopen( 1, "w" );
	/* do telnet option negotiation here */
	/*
	 * Set up default state
	 */
	data = -1;
#ifdef	vms
	if (!logged_in) {
	/* for VMS, initialize transfer parameters only if not logged in */
#endif		
	type = TYPE_A;
	form = FORM_N;
	stru = STRU_F;
	mode = MODE_S;
	bytesize = 8;
#ifdef	vms
	};
#endif
	xghname(hostname, sizeof (hostname));
	ctrl_addr.sin_port = xhtons(IPPORT_FTP);
	data_source.sin_port = xhtons(IPPORT_FTP - 1);
#ifdef	vms
	if (logged_in)
	    {
	    reply(230, "User logged in.");
	    }
	else
#endif
	reply(220, "%s FTP server (%s) ready.", hostname, version);
 	xbcopy( from, &his_addr, sizeof( his_addr ) );
	for (;;) {
		xsetjmp(errcatch);
		if( logging )
			{
			xoprintf( xstderr, "calling yyparse\n" );
			xfflush( xstderr );
			}
		yyparse();
	}
}

lostconn()
{

	if( abortxfer) {
		abortxfer = 0;
	} else {
		fatal("Connection closed.");
	}
}

retrieve(cmd, name)
	int cmd;
	char *name;
{
	XFILE *fin, *dout;
	int inod;
	int (*closefunc)();
	int omode;
	struct ftp_attr attributes;
	char *argv1[2];
	char **argv2;
	char **argv3;
	char *pt;
	struct xstatbuf fileinfo;
	int dircheck;
	int argcount;	/* count no. of expanded arguments */

	if (cmd == 0) {
		/*
		simple file
		*/
		omode = XFREAD;
		attributes.rep_type = type;
		attributes.format = form;
		attributes.structure = stru;
		attributes.trans_mode = mode;
		attributes.byte_sz = bytesize;
		inod = xsftpopen( name, omode, FILE_NAME, &attributes );
		if (inod < 0 ) {
			reply(550, "%s: %s.", name, xrerror( inod ));
			return;
		}
		fin = xodopen( inod, "r");
		if ( fin == XNULL ) {
			reply(550, "xodopen failed.");
			return;
		}
		closefunc = xclose;
	} else {
		/*
		we are to generate a psuedo file,
		at the moment some form of ls => call xls after opening
		data connection.
		*/
	}
	dout = dataconn(name, (off_t)0, "w");
	if (dout == XNULL)
		goto done;
	if( cmd )
		{
		/*
		a psuedo file object ( ls, ls -lg)
		*/
		if( xstrlen( name ) )
			{
			/*
			name may require globbing (for remote globbing).
			*/
			argv1[0] = name;
			argv1[1] = (char *)0;
			argv2 = xglob( argv1 );
			if( argv2 == XNULL || globerr )
				{
				xclose( xfileno(dout) );
				data = -1;
				reply( 500, "Remote glob failed. %s", globerr );
				if( argv2 != XNULL )
					xdealglob( argv2 );
				return;
				}
			argcount = 0;
			for (argv3 = argv2 ; *argv3; argv3++)
				argcount++;			
			/* if expand to more than one argument, we always
  		           interpretes the files as files */
			dircheck = (argcount == 1) ? 0 : 1; 
			argv3 = argv2;
			for( pt = *argv3++ ; pt ; pt = *argv3++ )
				{
				xls( xfileno(dout), pt, cmd, dircheck);
				}
			xdealglob( argv2 );
			}
		else
			{
			xls( xfileno(dout), name, cmd, 0 );
			}
		xclose( xfileno(dout) );
		data = -1;
		reply(226, "Transfer complete.");
		return;
		}
	else if (send_data(name, fin, dout) )
		{
		}
	else
		{
		reply(226, "Transfer complete.");
		}
	xclose( xfileno(dout)), data = -1;
done:
	xclose( xfileno(fin) );
}

store(name, append)
	char *name, *append;
{
	XFILE *fout, *din;
	int outod;
	int omode;
	int (*closefunc)(), dochown = 1;
	struct ftp_attr attributes;
 	int err;

	omode = XFWRITE | XFCREAT | (( *append == 'a' )? XFAPPEND : XFTRUNC );
	attributes.rep_type = type;
	attributes.format = form;
	attributes.structure = stru;
	attributes.trans_mode = mode;
	attributes.byte_sz = bytesize;
	outod = xsftpopen( name, omode, FILE_NAME, &attributes );
	if( outod < 0 )
		{
		reply(550, "%s: %s.", name, xrerror( outod ) );
		return;
		}
	fout = xodopen( outod, "w" ), closefunc = xclose;
	if (fout == XNULL) {
		reply(550, "xodopen failed.");
		return;
	}
	din = dataconn(name, (off_t)-1, "r");
	if (din == XNULL)
		goto done;
 	if (err = receive_data(name, din, fout) )
		{
		}
	else
		{
		reply(226, "Transfer complete.");
		}
	xclose( xfileno(din)), data = -1;
done:
 	if ((din == XNULL || err) && *append != 'a') {
 		xunlink (name, FILE_NAME);
 	}
	VOID xchown(name, FILE_NAME );
	xclose( xfileno(fout) );
}


getdatasock(mode)
	char *mode;
{
	int s;
	int retry;

	if (data >= 0)
		return (data);
	data_source.sin_family = AF_INET;
	for (retry = 0; retry < swaitmax; xsleep (swaitint), retry += swaitint)
	{
		s = xsocket(SOCK_STREAM, 0, &data_source,
		  SO_KEEPALIVE|SO_REUSEADDR);
		/* GAP 7/25/85: REUSEADDR fixes simultaneous xfer bug */
		if (s >= 0 || ( s != XEADDRINUSE && s != XENOBUFS))
			break;
	}
	if (s < 0)
		xperror( s, "getdatasock" );
	return ( s );
}


XFILE *
dataconn(name, size, mode)
	char *name;
	off_t size;		/* no longer used */
	char *mode;
{
	char sizebuf[32];
	XFILE *file;
	int retry = 0;
	int s;
	int rval;

	if (data >= 0) {
		reply(125, "Using existing data connection for %s.", name);
		usedefault = 1;
		return (xodopen(data, mode));
	}
	if (usedefault)
		xbcopy( &his_addr, &data_dest, sizeof(struct sockaddr));
	usedefault = 1;
	s = getdatasock(mode);
	if ( s < 0) {
		reply(425, "Can't create data socket (%s,%d): %s.",
		    ntoa(data_source.sin_addr.s_addr),
		    xntohs(data_source.sin_port),
		    xrerror( s ));
		return (XNULL);
	}
	reply(150, "Opening data connection for %s (%s,%d).",
	    name, ntoa(data_dest.sin_addr.s_addr),
	    xntohs(data_dest.sin_port));
	data = s;
	while ((rval = xconnect(data, &data_dest)) < 0) {
		if (rval == XEADDRINUSE && retry < swaitmax) {
			xsleep(swaitint);
			retry += swaitint;
			continue;
		}
		reply(425, "Can't build data connection: %s.",
		    xrerror( rval ) );
		VOID xclose(data);
		data = -1;
		return (XNULL);
	}
	file = xodopen( data, mode );
	return (file);
}

/*
 * Tranfer the contents of "instr" to
 * "outstr" peer using the appropriate
 * encapulation of the date subject
 * to Mode, Structure, and Type.
 *
 * NB: Form isn't handled.
 *
 * Implementation note:
 * 	If xpasstnet does not write out the end-of-file sequence (as in
 * VMS), we need to write the end of file sequence if in record mode.
 */
send_data(name, instr, outstr)
	char *name;
	XFILE *instr, *outstr;
{
	long rval;
#ifdef	vms
	char eof_sequence[] = { RECORD_ESCAPE, END_OF_FILE};
#endif

	rval = xpasstnet( instr, outstr );
	if( abortxfer) {
		clearabort();
		return (0);
#ifdef	vms
	} else if (stru == STRU_R) {
		xwrite(xfileno(outstr), eof_sequence, sizeof eof_sequence);
#endif
	};

	if( rval == XEOPNOTSUPP )
		{
		reply(504,"Transfer parameter not supported\n");
		return( 1 );
		}
	else if ( rval < 0 )
		{
		reply(550, "%s: %s.", name, xrerror( rval ) );
		return( 1 );
		}
	return (0);
}

/*
 * Transfer data from peer to
 * "outstr" using the appropriate
 * encapulation of the data subject
 * to Mode, Structure, and Type.
 *
 * N.B.: Form isn't handled.
 */
receive_data(name, instr, outstr)
	char *name;
	XFILE *instr, *outstr;
{
	long rval;

	rval = xpassfnet( instr, outstr );
	if( abortxfer) {
		clearabort();
		return (0);
	};
	if( rval == XEOPNOTSUPP )
		{
		reply(504, "Transfer parameter not supported.");
		return (1);
		}
	else if ( rval < 0 )
		{
		reply(550, "%s: %s.", name, xrerror( rval ) );
		return (1);
		}
	return( 0 );
}

fatal(s)
	char *s;
{
	reply(451, "Error in server: %s\n", s);
	reply(221, "Closing connection due to server error.");
	xexit(1);
}

#ifdef zilog
reply(n, s, a1, a2, a3, a4, a5, a6)
	int n;
	char *s;
	int a1, a2, a3, a4, a5, a6;
{
	int args=a1, aa2=a2, aa3=a3, aa4=a4, aa5=a5, aa6=a6;
#else
reply(n, s, args)
	int n;
	char *s;
{
#endif
	xoprintf(xstdout,"%d ", n);
	_mydoprnt(s, &args, xstdout);
	xoprintf(xstdout,"\n");
	xfflush(xstdout);
	if (debug) {
		xoprintf(xstderr, "<--- %d ", n);
		_mydoprnt(s, &args, xstderr);
		xoprintf(xstderr, "\n");
		xfflush(xstderr);
	}
}

#ifdef zilog
lreply(n, s, a1, a2, a3, a4, a5, a6)
	int n;
	char *s;
	int a1, a2, a3, a4, a5, a6;
{
	int args=a1, aa2=a2, aa3=a3, aa4=a4, aa5=a5, aa6=a6;
#else
lreply(n, s, args)
	int n;
	char *s;
{
#endif
	xoprintf(xstdout,"%d-", n);
	_mydoprnt(s, &args, xstdout);
	xoprintf(xstdout,"\n");
	xfflush(xstdout);
	if (debug) {
		xoprintf(xstderr, "<--- %d-", n);
		_mydoprnt(s, &args, xstderr);
		xoprintf(xstderr, "\n");
	}
}

replystr(s)
	char *s;
{
	xoprintf(xstdout,"%s\n", s);
	xfflush(xstdout);
	if (debug)
		xoprintf(xstderr, "<--- %s\n", s);
}

ack(s)
	char *s;
{
	reply(200, "%s command okay.", s);
}

nack(s)
	char *s;
{
	reply(502, "%s command not implemented.", s);
}

yyerror( message )

char *message;
{
	reply(500, "Command not understood: %s.", message );
	xlongjmp( errcatch, 1 );
}

delete(name)
	char *name;
{
	int rval;

	if ((rval = xunlink(name, FILE_NAME )) < 0) {
		reply(550, "%s: %s.", name, xrerror( rval ));
		return;
	}
	ack("DELE");
}

cwd(path, special)
	char *path;
	int special;
{
	int rval;

	if (( rval = xchdir(path, special ) ) < 0) {
		reply(550, "%s: %s.", path, xrerror( rval ) );
		return;
	}
	ack("CWD");
}

makedir(name)
	char *name;
{
	char	curdir[PWDLEN];
	char	fullname[PWDLEN];
	struct xstatbuf attr;
	int rval;
	
	rval = xstat(name, FILE_NAME, &attr);
	if (rval == 0) {	/* file already exists */
		reply(521, "\"%s\" directory already exists, no action taken.",
			name);
		return;
	};
	if ((rval = xmkdir(name, FILE_NAME)) < 0) {
		reply(550, "%s: %s.", name, xrerror( rval  ) );
		return;
	}
	VOID xchown(name, FILE_NAME );
	xpwd(curdir,  sizeof curdir, PWD);
	if (xchdir(name, FILE_NAME) == 0) {
		/* get full name and use for reply */
		xpwd(fullname, sizeof fullname, PWD);
		reply(257, "\"%s\" directory created.", fullname);
	} else {
		ack("MKDIR");
	};
	xchdir(curdir, FILE_NAME);
}

removedir(name)
	char *name;
{
	int rval;

	if (( rval = xrmdir(name, FILE_NAME)) < 0) {
		reply(550, "%s: %s.", name, xrerror( rval ) );
		return;
	}
	ack("RMDIR");
}

pwd()
{
	char path[MAXPATHLEN + 1];
	int success;

	success = xpwd( path, MAXPATHLEN + 1, PWD );
	if ( success < 0) {
		reply(451, "working directory not available.");
		return;
	}
	reply(251, "\"%s\" is current directory.", path);
}

char *
renamefrom(name)
	char *name;
{
	int rval;

	if ( (rval = xaccess( name, FILE_NAME, 0 ) ) < 0) {
		reply(550, "%s: %s.", name, xrerror( rval ) );
		return ((char *)0);
	}
	reply(350, "File exists, ready for destination name");
	return (name);
}

renamecmd(from, to)
	char *from, *to;
{
	int rval;

	if ((rval = xrename(from, FILE_NAME, to, FILE_NAME) ) < 0) {
		reply(550, "rename: %s.", xrerror( rval ) );
		return;
	}
	ack("RNTO");
}

/*
 * Test pathname for guest-user safety.
 */
inappropriate_request(name)
	char *name;
{
	int depth = 0, length, size;
	register char *p, *s;

	length = ( name )? xstrlen( name ) : 0 ;
	/*
	This functionality probably belongs in xsftpopen,
	but for now.
	*/
	return( 0 );
}

/*
 * Convert network-format internet address
 * to base 256 d.d.d.d representation.
 */
char *
ntoa(in)
	struct in_addr in;
{
	static char b[18];
	register char *p;

	p = (char *)&in;
#define	UC(b)	(((int)b)&0xff)
	xsprintf(b, "%d.%d.%d.%d", UC(p[0]), UC(p[1]), UC(p[2]), UC(p[3]));
	return (b);
}

dolog(sin)
	struct sockaddr_in *sin;
{
	char saddr[16], *ntoa();
	char *xraddr(), *remotehost = xraddr(sin->sin_addr.s_addr);
	long t;
	long xtime();

	if (!remotehost)
		remotehost = ntoa (sin->sin_addr.s_addr);
	t = xtime();
	xoprintf(xstderr,"FTPD: connection from %s at %ld",
		remotehost, t );
	xfflush(xstderr);
}


/*
mp  -  Even if _doprnt is more wonderful than _mydoprnt for systems which
	have _doprnt, using _doprnt is an incredible maintainance headache.
	In any case, we should support the same functionality on all
	systems.
	Hence, may _doprnt rest in peace.
*/
_mydoprnt(format, argp, FILEp)
char *format;
int *argp;
XFILE *FILEp;
{
	xoprintf(FILEp, format, *argp, *(argp+1), *(argp+2), *(argp+3),
		*(argp+4), *(argp+5));
}



/*
 * Check if the user is a guest
 */
restricted( user )
	char *user;
{
	int rval = 0;
	int ufileod;		/* object descriptor for list of guests */
	XFILE *ufilept;
	char guest[512];
	char *endp;

	ufileod = xdopen( GUESTLIST, XFREAD | XFASCII, FILE_NAME );
	if( ufileod < 0 ) {
		return( rval );		/* return default */
	}
	ufilept = xodopen( ufileod, "r" );
	while( xogets( guest, sizeof( guest ), ufilept ) != XNULL ) {
		endp = xstrchr( guest, '\n' );
		if( endp )
			*endp = 0;
		if( xstricmp( user, guest ) )
			continue;
		rval = 1;
		break;
	}
	xclose( ufileod );
	return( rval );
}
