/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: proc.c,v 1.2 87/04/24 15:12:00 davidb Exp $ */

/*	%W%	%G%	*/

#include "netstat.h"

extern	u_long xtohl();

#ifdef notdef	/* format for Msoft V7 C (EXOS 8000 V3.2 and earlier) */
struct proc {
	u_short	p_chan;		/* sleep channel */
	u_short	p_framep;	/* frame pointer */
	u_short	p_next;		/* for sleep/wakeup */
	u_short	p_last;		/* for sleep/wakeup */
};
#else	/* /* */
struct proc {
	u_short	p_chan;		/* sleep channel */
	u_short	p_framep;	/* frame pointer */
	u_short	p_sp;		/* stack pointer */
	u_short	p_next;		/* for sleep/wakeup */
	u_short	p_last;		/* for sleep/wakeup */
};
#endif

struct msg {
	u_long	mh_link;
	u_short	mh_mbid;
	u_char	mh_request;
	u_char	mh_reply;
	u_short	mh_length;
	u_short	nm_soid;
	u_long	nm_userid;
	u_char	nm_request;
	u_char	nm_reply;
	u_char	nm_pad[50];
};

struct rq {
	int	rq_opcode;
	char	*rq_name;
};

struct rq requests[] = {
	{SOACCEPT, "ACCEPT"},
	{SOCONNECT, "CONNECT"},
	{SOSEND, "SEND"},
	{SORECEIVE, "RECEIVE"},
	{SOCLOSE, "CLOSE"},
	{0, ""}
};

struct	proc proc = {0};
struct	msg msg = {0};

extern	int exos;
extern	int dflag;
char	*opname();

static	int first = 1;

nsproc(proc_start, msg_start, sleephead, runhead)
u_short proc_start, msg_start, sleephead, runhead;
{
	u_short pstart, mstart;

	klseek(exos, proc_start, 0);
	klread(exos, &pstart, sizeof(pstart));
	pstart = xtohs(pstart);
	klseek(exos, msg_start, 0);
	klread(exos, &mstart, sizeof(mstart));
	mstart = xtohs(mstart);
	xxproc(pstart, mstart, sleephead);
	xxproc(pstart, mstart, runhead);
}

xxproc(pstart, mstart, head)
u_short pstart, mstart, head;
{
	unsigned prev, next, msgaddr;
	int procn;

	if (head == 0) {
		xoprintf(xstdout, "proc queue header not in namelist\n");
		return;
	}
	klseek(exos, head, 0);
	klread(exos, &proc, sizeof(struct proc));
	fixproc(&proc);
	prev = head;
	if (first) {
		xoprintf(xstdout, "%-6.6s %-7.7s %-7.7s\n",
			"Socket", "Request", "Channel");
		first = 0;
	}
	while (proc.p_next != head) {
		next = proc.p_next;
		klseek(exos, next, 0);
		klread(exos, &proc, sizeof(struct proc));
		fixproc(&proc);
		if(proc.p_last != prev) {
			xoprintf(xstdout, "???\n");
			break;
		}
		procn = (next - pstart) / sizeof(struct proc);
		msgaddr = mstart + (procn * sizeof(struct msg));
		klseek(exos, msgaddr, 0);
		klread(exos, &msg, sizeof(struct msg));
		fixmsg(&msg);
		xoprintf(xstdout, "%6x %7.7s %7x\n", msg.nm_soid,
		  opname(msg.nm_request & 0x7F), proc.p_chan);
		prev = next;
	}
}

fixproc(pp)
struct proc *pp;
{
	pp->p_chan = xtohs(pp->p_chan);
	pp->p_framep = xtohs(pp->p_framep);
	pp->p_next = xtohs(pp->p_next);
	pp->p_last = xtohs(pp->p_last);
	if (dflag == 0)
		return;
	xoprintf(xstdout, "\tp_chan = %x\n", pp->p_chan);
	xoprintf(xstdout, "\tp_framep = %x\n", pp->p_framep);
	xoprintf(xstdout, "\tp_next = %x\n", pp->p_next);
	xoprintf(xstdout, "\tp_last = %x\n", pp->p_last);
}

fixmsg(mp)
struct msg *mp;
{
	mp->mh_link = xtohl(mp->mh_link);
	mp->mh_mbid = xtohs(mp->mh_mbid);
	mp->mh_length = xtohs(mp->mh_length);
	mp->nm_soid = xtohs(mp->nm_soid);
	mp->nm_userid = xtohl(mp->nm_userid);
	if (dflag == 0)
		return;
	xoprintf(xstdout, "\tmh_link = %X\n", mp->mh_link);
	xoprintf(xstdout, "\tmh_mbid = %x\n", mp->mh_mbid);
	xoprintf(xstdout, "\tmh_request =%x\n", mp->mh_request & 0xFF);
	xoprintf(xstdout, "\tmh_reply =%x\n", mp->mh_reply & 0xFF);
	xoprintf(xstdout, "\tmh_length = %x\n", mp->mh_length);
	xoprintf(xstdout, "\tnm_soid = %x\n", mp->nm_soid);
	xoprintf(xstdout, "\tnm_userid = %X\n", mp->nm_userid);
	xoprintf(xstdout, "\tnm_request =%x\n", mp->nm_request & 0xFF);
	xoprintf(xstdout, "\tnm_reply =%x\n", mp->nm_reply & 0xFF);
}

char *
opname(opcode)
{
	struct rq *rqp;
	static char namebuf[16];

	for (rqp = requests; rqp->rq_opcode != 0; rqp++)
		if (rqp->rq_opcode == opcode)
			break;

	if (rqp->rq_opcode)
		xsprintf(namebuf, "%-7.7s", rqp->rq_name);
	else
		xsprintf(namebuf, "%7x", opcode);
	return namebuf;
}
