/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: rcp.c,v 1.4 87/05/15 11:16:23 davidb Exp $ */
/* 
 * 12/6/83 billn: (in source() and sink()) [size, i] ints -> longs 
 * for 8086 systems.
 */
#ifndef lint
static char sccsId[] = "@(#)rcp.c	1.11 8/29/85";
#endif

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#if   !( xenix286 || xenix086 )
#include <sys/ioctl.h>
#endif
#include <netinet/in.h>
#include <pwd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/extypes.h> /* For u_char, etc., defns. dab 861125. */
#include <ndir.h>
#include <fcntl.h>

/*
   index and rindex used to be mapped in include/EXOS/exos/misc.h.
   dab 861120.
*/

#if !( V7 || BSD4dot2 )
#define index strchr
#define rindex strrchr
#endif

/*
 * rcp
 */
 
extern char	*index(), *rindex();
extern int errno; 

int	remin = 0;
int	remout = 1;
char	*colon(), *malloc(), *strcpy();
int	errs;
int	lostconn();
int	iamremote;
char	*sys_errlist[];
int	targetshouldbedirectory;
int	iamrecursive;
struct	passwd *pwd;
struct	passwd *getpwuid();

/*VARARGS*/
int	error();

main(argc, argv)
	int argc;
	char **argv;
{
	char *targ, *host, *src;
	char *suser, *tuser;
	int i;
	char buf[BUFSIZ], cmd[16];

	setpwent();
	pwd = getpwuid(getuid());
	endpwent();

	if (pwd == 0) {
		fprintf(stderr, "who are you?\n");
		exit(1);
	}
	argc--, argv++;
	if (argc > 0 && !strcmp(*argv, "-r")) {
		iamrecursive++;
		argc--, argv++;
	}
	if (argc > 0 && !strcmp(*argv, "-d")) {
		targetshouldbedirectory = 1;
		argc--, argv++;
	}
	if (argc > 0 && !strcmp(*argv, "-f")) {
		argc--, argv++; iamremote = 1;
		response();
		setuid(getuid());
		source(argc, argv);
		exit(errs);
	}
	if (argc > 0 && !strcmp(*argv, "-t")) {
		argc--, argv++; iamremote = 1;
		setuid(getuid());
		sink(argc, argv);
		exit(errs);
	}
	if (argc < 2) {
		fprintf(stderr, "Usage: rcp file-1 file-2\n");
		fprintf(stderr, "   or  rcp -r file-1 file-2 .. dir\n");
	}
	remin = -1;
	remout = -1;
	if (argc > 2)
		targetshouldbedirectory = 1;
	sprintf(cmd, "rcp%s%s",
	    iamrecursive ? " -r" : "", targetshouldbedirectory ? " -d" : "");
	signal(SIGPIPE, lostconn);
	targ = colon(argv[argc - 1]);
	if (targ) {
		*targ++ = 0;
		tuser = rindex(argv[argc - 1], '.');
		if (tuser) {
			*tuser++ = 0;
			if (!okname(tuser))
				exit(1);
		} else
			tuser = pwd->pw_name;
		for (i = 0; i < argc - 1; i++) {
			src = colon(argv[i]);
			if (src) {
				*src++ = 0;
				suser = rindex(argv[i], '.');
				if (suser) {
					*suser++ = 0;
					if (!okname(suser))
						continue;
		sprintf(buf, "rsh %s -l %s %s %s '%s.%s:%s' </dev/null",
					    argv[i], suser, cmd,
					    src, argv[argc - 1], tuser,
					     targ);
				} else
		sprintf(buf, "rsh %s %s %s '%s.%s:%s' </dev/null",
					    argv[i], cmd,
					    src, argv[argc - 1],  tuser,
					    targ);
				susystem(buf);
			} else {
				if (remin == -1) {
					sprintf(buf, "%s -t %s",
					    cmd, (*targ)? targ : "." );
					host = argv[argc - 1];
					remin = rcmd(&host, IPPORT_CMDSERVER,
					    pwd->pw_name, tuser,
					    buf, (long *)0);
					remout = remin;
					if (remin < 0) {
						error("rcp: rcmd error %d\n", errno);
						exit(1);
					}
					if (response() < 0)
						exit(1);
				}
				source(1, argv+i);
			}
		}
	} else {
		if (targetshouldbedirectory)
			verifydir(argv[argc - 1]);
		for (i = 0; i < argc - 1; i++) {
			src = colon(argv[i]);
			if (src == 0) {
				sprintf(buf, "/bin/cp%s %s %s",
				    iamrecursive ? " -r" : "",
				    argv[i], argv[argc - 1]);
				susystem(buf);
			} else {
				*src++ = 0;
				suser = rindex(argv[i], '.');
				if (suser) {
					*suser++ = 0;
					if (!okname(suser))
						continue;
				} else
					suser = pwd->pw_name;
				sprintf(buf, "%s -f %s", cmd, src);
				host = argv[i];
				remin = rcmd(&host, IPPORT_CMDSERVER,
				    pwd->pw_name, suser,
				    buf, (int *)0);
				remout = remin;
				if (remin < 0) {
					error("rcp: rcmd error %d\n", errno);
					exit(1);
				}
				sink(1, argv+argc-1);
				close(remin);
				close(remout);
				remout = -1;
				remin = -1;
			}
		}
	}
	exit(errs);
}

verifydir(cp)
	char *cp;
{
	struct stat stb;

	if (stat(cp, &stb) < 0)
		goto bad;
	if ((stb.st_mode & S_IFMT) == S_IFDIR)
		return;
	errno = ENOTDIR;
bad:
	error("rcp: %s: %s\n", cp, sys_errlist[errno]);
	exit(1);
}

char *
colon(cp)
	char *cp;
{

	while (*cp) {
		if (*cp == ':')
			return (cp);
		if (*cp == '/')
			return (0);
		cp++;
	}
	return (0);
}

okname(cp0)
	char *cp0;
{
	register char *cp = cp0;
	register int c;

	do {
		c = *cp;
		if (c & 0200)
			goto bad;
		if (!isalpha(c) && !isdigit(c) && c != '_' && c != '-')
			goto bad;
		cp++;
	} while (*cp);
	return (1);
bad:
	fprintf(stderr, "rcp: invalid user name %s\n", cp0);
	return (0);
}

susystem(buf)
	char *buf;
{

	if (fork() == 0) {
		setuid(getuid());
		system(buf);
		_exit(0);
	} else
		wait((int *)0);
}

source(argc, argv)
	int argc;
	char **argv;
{
	char *last, *name;
	struct stat stb;
	char buf[BUFSIZ];
	int x, sizerr, f;
	long i;

	mungstack();
	for (x = 0; x < argc; x++) {
		name = argv[x];
		if (access(name, 4) < 0 || (f = open(name, 0)) < 0) {
			error("rcp: %s: %s\n", name, sys_errlist[errno]);
			continue;
		}
		if (fstat(f, &stb) < 0)
			goto notreg;
		switch (stb.st_mode&S_IFMT) {

		case S_IFREG:
#ifdef	SYSTEM3
		case S_IFIFO:
#endif
			break;

		case S_IFDIR:
			if (iamrecursive) {
				close(f);
				rsource(name, (int)stb.st_mode);
				continue;
			}
			/* fall into ... */
		default:
notreg:
			close(f);
			error("rcp: %s: not a plain file\n", name);
			continue;
		}
		last = rindex(name, '/');
		if (last == 0)
			last = name;
		else
			last++;
#if  BSD4dot2 || VERSION7
		sprintf(buf, "C%04o %D %s\n",
#else
		sprintf(buf, "C%04.4o %ld %s\n",
#endif
		    stb.st_mode&07777, stb.st_size, last);
		if (write(remout, buf, strlen(buf)) < 0) {
			error("rcp: socket write error %d for file %s\n", errno, name);
			exit(1);
		}
		if (response() < 0) {
			close(f);
			continue;
		}
		sizerr = 0;
		for (i = 0; i < stb.st_size; i += BUFSIZ) {
			int amt = BUFSIZ;
			if (i + amt > stb.st_size)
				amt = stb.st_size - i;
			if (sizerr == 0 && read(f, buf, amt) != amt)
				sizerr = 1;
			if (write(remout, buf, amt) < 0 ) {
				if( !iamremote ) {
					error(
				"rcp: socket write error %d for file %s\n",
					 errno, name);
				}
				exit(1);
			}
		}
		close(f);
		if (sizerr == 0)
			ga();
		else
			error("rcp: %s: file changed size\n", name);
		response();
	}
}

extern DIR *opendir();

rsource(name, mode)
	char *name;
	int mode;
{
	DIR *d = opendir(name);
	char *last;
	char buf[BUFSIZ];
	struct direct *dp;
	char *bufv[1];
	register int len;

	if (d == NULL) {
		error("%s: %s\n", name, sys_errlist[errno]);
		return;
	}
	last = rindex(name, '/');
	if (last == 0)
		last = name;
	else
		last++;
	
#if  BSD4dot2 || VERSION7
	sprintf(buf, "D%04o %d %s\n", mode&07777, 0, last);
#else
	sprintf(buf, "D%04.4o %d %s\n", mode&07777, 0, last);
#endif
	if (write(remout, buf, strlen(buf)) < 0) {
		error("rcp: socket write error %d for directory %s\n", errno, name);
		exit(1);
	}
	if (response() < 0) {
		closedir(d);
		return;
	}
	sprintf(buf, "%s/", name);
	len = strlen(name) + 1;
	while ((dp = readdir(d)) != NULL ) {
		if (dp->d_ino == 0)
			continue;
		if (!strcmp(dp->d_name, ".") || !strcmp(dp->d_name, ".."))
			continue;
		if (len + dp->d_namlen >= BUFSIZ - 1) {
			error("%s/%s: Name too long.\n", name, dp->d_name);
			continue;
		}
		strncpy(&buf[len], dp->d_name, dp->d_namlen);
		buf[len+dp->d_namlen] = '\0';
#ifdef DEBUG
		printf("rcp:%s\n",buf);
#endif
		bufv[0] = buf;
		source(1, bufv);
	}
	closedir(d);
	if (write(remout, "E\n", 2) < 0) {
		error("rcp: socket write error %d\n", errno);
		exit(1);
	}
	response();
}

response()
{
	char resp, c, rbuf[BUFSIZ], *cp = rbuf;
	int reval;

	if (( reval = read(remin, &resp, 1)) < 0) {
		error("rcp: socket read error %d\n", errno);
		exit(1);
	}
	if (reval == 0)
		lostconn( 0 );
	switch (resp) {

	case 0:
		return (0);

	default:
		*cp++ = resp;
		/* fall into... */
	case 1:
	case 2:
		do {
			if ((reval = read(remin, &c, 1)) < 0) {
				error("rcp: socket read error %d\n", errno);
				exit(1);
			}
			if (reval == 0)
				lostconn( 0 );
			*cp++ = c;
		} while (cp < &rbuf[BUFSIZ] && c != '\n');
		error("%s\n", rbuf);
		errs++;
		if (resp == 1)
			return (-1);
		exit(1);
	}
	/*NOTREACHED*/
}

lostconn(sig)
	int sig;
{
	if( !iamremote )
		error("rcp: lost connection %d\n", sig);
	exit(1);
}

sink(argc, argv)
	int argc;
	char **argv;
{
	char *targ;
	char cmdbuf[BUFSIZ], nambuf[BUFSIZ], buf[BUFSIZ], *cp;
	int of, mode, wrerr, exists;
	long i, size;
	int reval, amt;
	char *whopp;
	struct stat stb; int targisdir = 0;
#define	SCREWUP(str)	{ whopp = str; goto screwup; }
	int mask = umask(0);
	char *myargv[1];

	mungstack();
	umask(mask);
	if (argc > 1) {
		error("rcp: ambiguous target\n");
		exit(1);
	}
	targ = *argv;
	if( !*targ ) {
		targ = ".";
	}
	if (targetshouldbedirectory)
		verifydir(targ);
	ga();
	if (stat(targ, &stb) == 0 && (stb.st_mode & S_IFMT) == S_IFDIR)
		targisdir = 1;
	for (;;) {
		cp = cmdbuf;
		if ((reval = read(remin, cp, 1)) < 0) {
			error("rcp: socket read error %d\n ", errno);
			exit(1);
		}
		if (reval == 0)
			return;
		if (*cp++ == '\n')
			SCREWUP("unexpected '\\n'");
		do {
			if ((reval = read(remin, cp, 1)) < 0) {
				error("rcp: socket read error: %d\n", errno);
				exit(1);
			}
			if (reval == 0)
				lostconn( 0 );
		} while (*cp++ != '\n');
		*cp = 0;
		if (cmdbuf[0] == '\01' || cmdbuf[0] == '\02') {
			error("%s\n", cmdbuf);
			if (cmdbuf[0] == '\02')
				exit(1);
			errs++;
			continue;
		}
		*--cp = 0;
		cp = cmdbuf;
		if (*cp == 'E') {
			ga();
			return;
		}
		if (*cp != 'C' && *cp != 'D')
			{
			error("rcp: %s\n", cp );
			exit(1);
			}
		cp++;
		mode = 0;
#ifdef DEBUG
fprintf(stderr, "before mode chk: ");
{
	char *zzp;

	for (zzp = cmdbuf; *zzp ; zzp++) {
		fprintf(stderr, "%x ", *zzp);
	}
	fprintf(stderr, "\n");
}
#endif

		for (; cp < cmdbuf+5; cp++) {
			if (*cp < '0' || *cp > '7')
				SCREWUP("bad mode");
			mode = (mode << 3) | (*cp - '0');
		}
		if (*cp++ != ' ')
			SCREWUP("mode not delimited");
		size = 0;
		while (*cp >= '0' && *cp <= '9')
			size = size * 10 + (*cp++ - '0');
		if (*cp++ != ' ')
			SCREWUP("size not delimited");
		if (targisdir)
			sprintf(nambuf, "%s%s%s", targ,
			    *targ ? "/" : "", cp);
		else
			strcpy(nambuf, targ);
		exists = stat(nambuf, &stb) == 0;
		if (exists && access(nambuf, 2) < 0)
			goto bad2;
		{ char *slash = rindex(nambuf, '/'), *dir;
		  if (slash == 0) {
			slash = "/";
			dir = ".";
		  } else {
			*slash = 0;
			dir = nambuf;
		  }
		  if (exists == 0 && access(dir, 2) < 0)
			goto bad;
		  *slash = '/';
		  if (cmdbuf[0] == 'D') {
			if (stat(nambuf, &stb) == 0) {
				if ((stb.st_mode&S_IFMT) != S_IFDIR) {
					errno = ENOTDIR;
					goto bad;
				}
			/*
			 * the owner gets write permission on a new
			 * directory so that readonly trees may be copied.
			 */
			} else if (mkdir(nambuf, mode | 0200 ) < 0)
				goto bad;
			else {
				if( !( mode & 0200 ) )
					error( "warning: %s %s\n",
					    nambuf,
				   	    "is readonly, copy is writeable");
			}
			myargv[0] = nambuf;
			sink(1, myargv);
			continue;
		  }
		  if ((of = creat(nambuf, mode)) < 0) {
	bad:
			*slash = '/';
	bad2:
			error("rcp: %s: %s\n", nambuf, sys_errlist[errno]);
			continue;
		  }
		}
		if (exists == 0) {
			stat(nambuf, &stb);
			chown(nambuf, pwd->pw_uid, stb.st_gid);
			if( cmdbuf[0] == 'D' )
				chmod(nambuf, (mode | 0200) &~ mask );
			else
				chmod(nambuf, mode &~ mask);
		}
		ga();
		wrerr = 0;
		for (i = 0; i < size; i += BUFSIZ) {
			char *cp = buf;

			amt = BUFSIZ;
			if (i + amt > size)
				amt = size - i;
			do {
				int j = read(remin, cp, amt);
				if (j < 0) {
					if( !iamremote ) {
						error(
				"rcp: socket read error %d for file %s\n",
						errno, nambuf);
					}
					unlink(nambuf);
					exit(1);
				}
				if (j == 0) {
					unlink(nambuf);
					lostconn( 0 );
				}
				amt -= j;
				cp += j;
			} while (amt > 0);
			amt = BUFSIZ;
			if (i + amt > size)
				amt = size - i;
			if (wrerr == 0 && write(of, buf, amt) != amt)
				wrerr++;
		}
		close(of);
		if (wrerr) {
			unlink( nambuf );	/* Ok, since we wouldn't
						be writing the file if
						we couldn't access it */
			response();
			error("rcp: %s: %s\n", cp, sys_errlist[errno]);
		} else {
			response();
			ga();
		}
	}
screwup:
	error("rcp: protocol screwup: %s\n", whopp);
	exit(1);
}


/*VARARGS*/
error(fmt, a1, a2, a3, a4, a5)
	char *fmt;
	int a1, a2, a3, a4, a5;
{
	char buf[BUFSIZ], *cp = buf;
#ifdef REM_DEBUG
	int eout;
#endif

	errs++;
	*cp++ = 1;
	sprintf(cp, fmt, a1, a2, a3, a4, a5);
	if (iamremote) {
		write(remout, buf, strlen(buf)); /* if it fails, it fails.... */
#ifdef REM_DEBUG
		eout = open("/usr/tmp/remout", O_APPEND || O_CREAT);
		write(eout, buf+1, strlen(buf+1));
		close(eout);
#endif
	}
	else
		write(2, buf+1, strlen(buf+1));
}

mkdir(name, mode)
	char *name;
	int mode;
{
	char *argv[4];
	int pid, rc;

	argv[0] = "mkdir";
	argv[1] = name;
	argv[2] = 0;
	pid = fork();
	if (pid < 0) {
		error("rcp: fork error %s\n", sys_errlist[errno]);
		return (1);
	}
	if (pid) {
		while (wait(&rc) != pid)
			continue;
		if (rc == 0)
			if (chmod(name, mode) < 0) {
				error("rcp: chmod error %s %s\n", name, sys_errlist[errno]);
				rc = 1;
			}
		return (rc);
	}
	setuid(getuid());
	execv("/bin/mkdir", argv);
	execv("/usr/bin/mkdir", argv);
	error("rcp: mkdir error %s\n", sys_errlist[errno]);
	_exit(1);
	/*NOTREACHED*/
}

/* probe stack for buggy c-libraries */
mungstack()
{
	char foo[1024];
	char boo[1024];
	int x;

	x = 1;
	return x;
}

ga()
{
	errno = 0;
 	if( write(remout, "", 1) <= 0 )
		error("rcp: socket write error %d\n", errno);
}
