/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: arp.c,v 1.2 87/04/24 15:21:56 davidb Exp $ */
static char sccsId[] = "@(#)arp.c	1.12 7/29/85";

/*
 * arp - display, set, and delete arp table entries
 */

/*
Pull in header files (depends on OS)
*/
#include "arp.h"

#ifdef S5vax750 
struct padnxt_addr {
	short dummy;
	short nxt_count;
};
#endif	/* S5vax750 */

#ifdef rtpc 
struct padnxt_addr {
	long dummy;
	short nxt_count;
};
#endif	/* rtpc */

char *gnxtstr();

int	boardno = 0;		/* board number	*/

xmain(argc, argv)
	int argc;
	char **argv;
{
int entire;			/* flag for how table is retrieved */

/*
Get type of mapping (for the moment only IP to Ethernet is possible).
*/
if ( argc >= 2 && xstricmp(argv[1], "IP_ETHERNET") == 0 )
	{
	/*
	The default case; a no-op really
	*/
	++argv;
	--argc;
	};

if ( (argc >= 3) && (xstricmp(argv[1], "-b") == 0)) {
	/* for certain board	*/
    	boardno = xatoi(argv[2]);
    	argv += 2;
    	argc -= 2;
};

if (argc >= 2 && xstricmp(argv[1], "-a") == 0) 
	{
	/*
	The default is to list known hosts, but the entire table may
	be requested.
	*/
	if ( argc == 3 && xstricmp(argv[2], "entire" ) == 0 )
		{
		entire = 1;
		}
	else if ( argc > 2 )
		{
		usage();
		xexit( 1 );
		}
	else
		{
		entire = 0;
		}
	dump(entire);
	xexit(0);
	}
if (argc == 2) 
	{
	/*
	retrieve a single entry
	*/
	if( get(argv[1]))
		xexit(1);
	else
		xexit(0);
	}
if (argc >= 4 && xstricmp(argv[1], "-s") == 0) 
	{
	/*
	set an entry
	*/
	if ( set(argc-2, &argv[2]) )
		xexit(1);
	else
		xexit(0);
	}
if (argc == 3 && xstricmp(argv[1], "-d") == 0) 
	{
	/*
	delete an entry
	*/
	if ( delete(argv[2]) )
		xexit(1);
	else
		xexit(0);
	}
if (argc == 3 && xstricmp(argv[1], "-f") == 0) 
	{
	/*
	load table from a file
	*/
	file(argv[2]);
	xexit(0);
	}
usage();
xexit(1);
}

file(name)
/*
 * Process a file to set standard arp entries
 */
char *name;
{
XFILE *fp;
int i;
char line[100], arg[4][50], *args[4];
int od;
char *nxtstr;

od = xdopen( name, XFREAD | XFASCII, FILE_NAME );
if ((fp = xodopen( od, "r")) == XNULL) 
	{
	xoprintf(xstderr, "arp: cannot open %s\n", name);
	xexit(1);
	}
args[0] = &arg[0][0];
args[1] = &arg[1][0];
args[2] = &arg[2][0];
args[3] = &arg[3][0];
while(xogets(line, 100, fp) != XNULL) 
	{
	/*
	i = sscanf(line, "%s %s %s %s", arg[0], arg[1], arg[2], arg[3]);
	*/
	for( i = 0, nxtstr = line ;
		( i <= 3 ) && ( nxtstr = gnxtstr( nxtstr, 50, arg[i] )) ;
		++i
	)
		;
	if (i < 2) 
		{
		xoprintf(xstderr, "arp: bad line: %s\n", line);
		continue;
		}
	set(i, args);
	}
xclose(od);
}

set(argc, argv)
/*
 * Set an individual arp entry 
 */
char **argv;
{
struct EXarp_ioctl ar;
struct sockaddr_in *sin;
struct ether_addr *ea;
int exos;
char *host = argv[0], *eaddr = argv[1];
long host_addr, rhost();
int rval;
char *pt;

argc -= 2;
argv += 2;
host_addr = rhost(&host);
if (host_addr == -1) 
	{
	xoprintf(xstderr, "arp: %s: unknown host\n", host);
	return (1);
	}
xbzero((caddr_t)&ar, sizeof ar);
ar.arp_pa.sa_family = AF_INET;
sin = (struct sockaddr_in *)&ar.arp_pa;
sin->sin_addr.s_addr = host_addr;
ar.arp_ha.sa_family = AF_ETHER;
ea = (struct ether_addr *)&ar.arp_ha;
if (ether_aton(eaddr, ea))
	return(1);
ar.arp_flags = ATF_PERM;
while(argc-- > 0) 
	{
	for( pt = argv[0] ; *pt ; ++pt )
		*pt = _tolower( *pt );
	if (xstrncmp(argv[0], "temp", 4) == 0)
		ar.arp_flags &= ~ATF_PERM;
	if (xstrncmp(argv[0], "pub", 3) == 0)
		ar.arp_flags |= ATF_PUBL;
	argv++;
	}
exos = xbrdopen( boardno, XFREAD | XFWRITE );
if (exos < 0) 
	{
        xperror(exos, "arp: cann't open admin device");
        return(1);
        }
if (( rval = xioctl(exos, BRDSARP, (caddr_t)&ar)) < 0) 
	{
	xperror(rval, host);
	return(1);
	}
xclose(exos);
return( 0 );
}


/*
 * Display an individual arp entry
 */
get(host)
char *host;
{
struct EXarp_ioctl ar;
long host_addr, rhost();
struct sockaddr_in *sin;
struct ether_addr *ea;
int exos;
int rval;

host_addr = rhost(&host);
if (host_addr == -1) 
	{
	xoprintf(xstderr, "arp: %s: unknown host\n", host);
	return(-1);
	}
xbzero((caddr_t)&ar, sizeof ar);
ar.arp_pa.sa_family = AF_INET;
sin = (struct sockaddr_in *)&ar.arp_pa;
sin->sin_addr.s_addr = host_addr;
exos = xbrdopen( boardno, XFREAD );
if (exos < 0) 
	{
        xperror( exos, "arp: can't open admin device");
        xexit(1);
        }
if ((rval = xioctl(exos, BRDGARP, (caddr_t)&ar)) < 0) 
	{
	if (rval == XENXIO)
		{
		xoprintf(xstdout,"%s (", host );
		ip_print(sin);
		xoprintf(xstdout,") -- no entry\n" );
		}
	else
		xperror(rval,"BRDGARP");
	return(-1);
	}
xclose(exos);
entry_print( &ar, host );
return( 0 );
}

/*
 * Delete an arp entry 
 */
delete(host)
	char *host;
{
struct EXarp_ioctl ar;
long host_addr, rhost();
struct sockaddr_in *sin;
int exos;
int rval;

host_addr = rhost(&host);
if (host_addr == -1) 
	{
	xoprintf(xstderr, "arp: %s: unknown host\n", host);
	return(1);
	}
xbzero((caddr_t)&ar, sizeof ar);
ar.arp_pa.sa_family = AF_INET;
sin = (struct sockaddr_in *)&ar.arp_pa;
sin->sin_addr.s_addr = host_addr;
exos = xbrdopen( boardno, XFREAD | XFWRITE );
if (exos < 0) 
	{
        xperror(exos, "arp: socket");
        xexit(1);
        }
if ((rval = xioctl(exos, BRDDARP, (caddr_t)&ar)) < 0) 
	{
	if (rval == XENXIO)
		{
		xoprintf(xstdout, "%s (", host );
		ip_print( sin );
		xoprintf(xstdout, ") -- no entry\n" );
		}
	else
		xperror(rval, "BRDDARP");
	return(1);
	}
xclose(exos);
xoprintf(xstdout, "%s (", host );
ip_print( sin );
xoprintf(xstdout,  ") deleted\n" );
return( 0 );
}

dump(entire)
/*
 * Dump the entire arp table
 */

int entire;
{
int count;
struct EXarp_ioctl ar;
char *host_name;
int result;
int exos;

exos = xbrdopen( boardno, XFREAD );
if ( exos < 0 )
	{
	xperror(exos, "arp: can't open admin device" );
	xexit( 1 );
	}
for( count = 0; ; ++count )
	{
	xbzero( &ar, sizeof( ar ) );
	ar.arp_pa.sa_family = AF_COUNT;

#ifdef	S5vax750
	((struct padnxt_addr *)(&ar.arp_pa))->nxt_count = count;
#else	/* S5vax750 */
#ifdef	rtpc
	((struct padnxt_addr *)(&ar.arp_pa))->nxt_count = count;
#else	/* rtpc */
	((struct next_addr *)(&ar.arp_pa))->nxt_count = count;
#endif	/* rtpc */
#endif	/* S5vax750 */

	result = xioctl( exos, BRDGARP, &ar );
	if( result < 0 )
		{
		if( result != XENXIO )
			xperror( result, "BRDGARP" );
		break;
		}
	host_name = raddr(((struct sockaddr_in *)&ar.arp_pa)->sin_addr.s_addr);
	if ( host_name != XNULL )
		{
		entry_print( &ar, host_name );
		}
	else if ( entire )
		{
    		if (host_name != XNULL)
	    		{
	    		entry_print( &ar, host_name );
	    		}
	    	else
	    		entry_print( &ar, XNULL);
		}
	else
		{
		}
	}
xclose( exos );
}


ether_print(ea)
	struct ether_addr *ea;
{
	char *cp = (char *)&ea->ea_addr[0];

	xoprintf(xstdout,"0x%x:0x%x:0x%x:0x%x:0x%x:0x%x", 
		0xff & cp[0], 0xff & cp[1], 0xff & cp[2], 0xff & cp[3],
		0xff & cp[4], 0xff & cp[5]);
}

ip_print(ea)
	struct sockaddr_in *ea;
{
	char *cp = (char *)&ea->sin_addr;

	xoprintf(xstdout,"0x%x.0x%x.0x%x.0x%x", cp[0] & 0xff, cp[1] & 0xff,
		cp[2] & 0xff, cp[3] & 0xff);
}

/*
states for parsing ethernet addresses
*/
#define START_ST 1
#define ZERO_ST 2
#define OCTAL_ST 3
#define DECIMAL_ST 4
#define HEX_ST 5
#define ACCEPT_ST 6
#define DONE_ST 7

ether_aton(a, n)
	char *a;
	struct ether_addr *n;
{
	int i, o[6];
	char *nxtc;

	/*
	i = sscanf(a, "%x:%x:%x:%x:%x:%x", &o[0], &o[1], &o[2],
					   &o[3], &o[4], &o[5]);
	*/
	for( i = 0, nxtc = a ; i < 6 && *nxtc ; ++i )
		{
		o[i] = 0;
		for( ; *nxtc && isxdigit( *nxtc ) ; nxtc++ )
			{
			o[i] *= 16;
			if( *nxtc >= 'a' && *nxtc <= 'f' )
				o[i] += ( *nxtc - 'a' ) + 10;
			else if( *nxtc >= 'A' && *nxtc <= 'F' )
				o[i] += ( *nxtc - 'A' ) + 10;
			else
				o[i] += *nxtc - '0';
			}
		if( *nxtc && *nxtc != ':' )
			break;
		if( *nxtc )
			++nxtc;
		}
	if ( i != 6) 
		{
		/*
		parse numbers one by one where the seperator is "."
		and the numbers may be in either decimal or
		hexadecimal (or octal).
		*/
		int state;
		char *ch = a;

		state = START_ST;
		for( i = 0 ; state != DONE_ST && i < 6 ; ++i )
			{
			state = START_ST;
			for( ; state != DONE_ST && state != ACCEPT_ST ; ++ch )
				{
				switch ( state ) {
					case START_ST:
						if( '0' == *ch )
							{
							state = ZERO_ST;
							}
						else if( '1' <= *ch &&
							'9' >= *ch )
							{
							state = DECIMAL_ST;
							o[i] = *ch - '0';
							}
						else if( *ch == ' ' )
							{
							}
						else
							{
							state = DONE_ST;
							}
						break;
					case ZERO_ST:
						if( 'x' == *ch )
							{
							state = HEX_ST;
    							o[i] = 0;
							}
						else if( '0' <= *ch &&
							'7' >= *ch )
							{
							state = OCTAL_ST;
							o[i] = *ch - '0';
							}
						else if( *ch == '.' )
							{
							state = ACCEPT_ST;
							o[i] = 0;
							}
						else
							{
							state = DONE_ST;
							}
						break;
					case OCTAL_ST:
						if( '0' <= *ch &&
							'7' >= *ch )
							{
							o[i] *= 8;
							o[i] += *ch - '0';
							}
						else if( *ch == '.' )
							{
							state = ACCEPT_ST;
							}
						else
							{
							state = DONE_ST;
							}
						break;
					case DECIMAL_ST:
						if( '0' <= *ch &&
							'9' >= *ch )
							{
							o[i] *= 10;
							o[i] += *ch - '0';
							}
						else if( *ch == '.' )
							{
							state = ACCEPT_ST;
							}
						else
							{
							state = DONE_ST;
							}
						break;

					case HEX_ST:
						if( '0' <= *ch &&
							'9' >= *ch )
							{
							o[i] *= 16;
							o[i] += *ch - '0';
							}
						else if( 'a' <= *ch &&
							'f' >= *ch )
							{
							o[i] *= 16;
							o[i] +=(*ch - 'a') + 10;
							}
						else if( 'A' <= *ch &&
							'F' >= *ch )
							{
							o[i] *= 16;
							o[i] +=(*ch - 'A') + 10;
							}
						else if( *ch == '.' ||
							*ch == ':'
						)
							{
							state = ACCEPT_ST;
							}
						else
							{
							state = DONE_ST;
							}
						break;
					default:
						xoprintf(xstderr, "Arp Bug\n" );
						xexit( 1 );
						break;
					}  /* switch */
				} /* for state != DONE or ACCEPT */
			} /* for i < 6 && state != DONE */
		} /* if i != 6 */
	if (i != 6) {
		xoprintf(xstderr, "arp: invalid Ethernet address '%s'\n", a);
		xoprintf(xstderr, "valid example: 1a:2f:3c:14:0:30\n" );
		xoprintf(xstderr,
		"alternate format: 0x1a.0x2f.0x3c.0x14.0x0.0x30\n" );
		xoprintf(xstderr, "alternate format: 26.47.60.20.0.48\n" );
		return (1);
	}
	for (i=0; i<6; i++)
    		{
    		if (o[i] > 0xff)
    			{	/* error in ethernet address */
    			xoprintf(xstderr, "Error in ethernet address value: 0x%x\n", o[i]);
    			return(1);
    			};
		n->ea_addr[i] = o[i];
    		}
	return (0);
}


usage()
{
	xoprintf(xstdout,"Usage: arp [mapping] hostname\n");
	xoprintf(xstdout,"       arp [mapping] -a [entire]\n");
	xoprintf(xstdout,"       arp [mapping] -d hostname\n");
	xoprintf(xstdout,
		"       arp [mapping] -s hostname ether_addr [temp] [pub]\n");
	xoprintf(xstdout,"       arp [mapping] -f filename\n");
}


entry_print( arp_e, host_n )
/*
Print an arp table entry in some consistent format
*/

struct EXarp_ioctl *arp_e;
char *host_n;
{
struct ether_addr *ea;
struct in_addr *sin;

sin = (struct in_addr *)&arp_e->arp_pa;
ea = (struct ether_addr *)&arp_e->arp_ha;
if( host_n )
	{
	xoprintf(xstdout,"%s (", host_n );
	}
else
	{
	xoprintf(xstdout, "unknown host (" );
	}
ip_print( sin );
xoprintf(xstdout, ") at " );
if (arp_e->arp_flags & ATF_COM)
	ether_print(ea);
else
	xoprintf(xstdout,"(incomplete)");
if (!(arp_e->arp_flags & ATF_PERM)) xoprintf(xstdout," temporary");
if (arp_e->arp_flags & ATF_PUBL) xoprintf(xstdout," published");
xoprintf(xstdout,"\n");
}

char *
gnxtstr( source, n, dest )

char *source;
int n;			/* size of dest */
char *dest;
{
int i;

for( ; *source && isspace( *source ) ; ++source )
	;
for( i = 1 ; *source && !isspace( *source ) && i < n ; *dest++ = *source++ )
	++i;
*dest = '\0';
if( *source )
	return( source );
return( 0 );
}

clientinit()
{
}
