/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: route.c,v 1.2 87/04/24 15:23:46 davidb Exp $ */
#ifndef lint
static char sccsId[] = "@(#)route.c	1.11 7/3/85";
#endif

#include "route.h"

#define XOPTADDR 0x01000000		/* board addr for exosopt */

extern long xhtonl();

u_long 	in_lnaof();
u_long	get_snetmask();

/*
 * route.c - manipulate the routing table entries.
 */

struct	rtentry route = { 0 };
int	options = 0;
int	s = 0;
struct	sockaddr_in sin = { AF_INET };
u_long	localnet;
u_long	snetmask;

long xrhost();

xmain(argc, argv)
	int argc;
	char *argv[];
{
	char *hostname;
	struct in_addr in;
	int	boardno;

	boardno = 0;
	if ((argc > 2) && (xstricmp(argv[1], "-b") == 0)) {	/* board specified */
		boardno = xatoi(argv[2]);
		argc -= 2;
		argv += 2;	
	};
			

	if (argc < 2) usage ();
	s = xbrdopen(boardno, XFREAD | XFWRITE );
	if (s < 0) {
		xperror(s, "socket");
		xexit(1);
	}
	argc--, argv++;

	hostname = "localhost";
	in.s_addr = xrhost(&hostname);
	localnet = IN_NETOF(in);
	snetmask = get_snetmask();
	
	if (xstrcmp(*argv, "add") == 0)
		newroute(argc, argv);
	else if (xstrcmp(*argv, "delete") == 0)
		newroute(argc, argv);
	else if (xstrcmp(*argv, "change") == 0)
		changeroute(argc-1, argv+1);
	else if (xstrcmp(*argv, "show") == 0)
		displayroute(argc, argv);
	else
		xoprintf(xstderr,"%s: huh?\n", *argv);
	xexit( 0 );
}

usage ()
{
	xoprintf(xstderr,"usage:\n");
	xoprintf (xstderr,"route [-b n] add <destination> <gateway>\n");
	xoprintf (xstderr,"route [-b n] delete <destination> <gateway>\n");
	xoprintf (xstderr,"route [-b n] show [<destination>]\n");
	xexit(1);
}

newroute(argc, argv)
	int argc;
	char *argv[];
{
	struct sockaddr_in *sin;
	char *cmd;
	long Destination, Gateway;
	int x;
	u_long host;

	if (argc < 3) usage ();
	cmd = *argv++;
	getaddr(*argv++, &route.rt_dst);
	getaddr(*argv, &route.rt_gateway);
	sin = (struct sockaddr_in *)&route.rt_dst;
	route.rt_flags = RTF_UP | RTF_GATEWAY;
	if (host = in_lnaof(sin->sin_addr)) {
		route.rt_flags |= RTF_HOST;
	}
	Destination = ((struct sockaddr_in *)&route.rt_dst)->sin_addr.s_addr;
	Destination = xhtonl( Destination );
	Gateway = ((struct sockaddr_in *)&route.rt_gateway)->sin_addr.s_addr;
	Gateway = xhtonl( Gateway );
	xoprintf(xstdout, "%s %s %d.%d.%d.%d, gateway %d.%d.%d.%d\n",
		    cmd,
		    (in_lnaof(sin->sin_addr))? "host": "network",
		    (int)((Destination>>24)&0xff),
		    (int)((Destination>>16)&0xff),
		    (int)((Destination>>8)&0xff),
		    (int)((Destination>>0)&0xff),
		    (int)((Gateway>>24)&0xff),
		    (int)((Gateway>>16)&0xff),
		    (int)((Gateway>>8)&0xff),
		    (int)((Gateway>>0)&0xff));
	if (x = xioctl(s, *cmd == 'a' ? BRDADDRT : BRDDELRT,
		(caddr_t)&route)){
		error(cmd, x);
	}
}

changeroute(argc, argv)
	int argc;
	char *argv[];
{
	xoprintf(xstderr, "not supported\n");
}

displayroute(argc, argv)
	int argc;
	char *argv[];
{
	struct sockaddr_in *sin;
	u_long destination;
	short n;
	char *cmd;
	int x;

	cmd = *argv++;

	/*
	 * check if single route to be displayed or all 
	 * routes to be displayed 
	*/ 

	if  (*argv) {

	    /* single route to be displayed */

	    getaddr(*argv++, &route.rt_dst);
	    sin = (struct sockaddr_in *)&route.rt_dst;
	    route.rt_flags =  RTF_GATEWAY;
	    if (in_lnaof(sin->sin_addr)){
		route.rt_flags |= RTF_HOST;
	    }
	    if (x = xioctl(s, BRDDISPRT, (caddr_t)&route))
		error(cmd, x);
	    
	    /* display the route info */

	    show(cmd, &route);

	}
	else {
		short n;
		int x;

		/* display all routes (host, network) */

		route.rt_next = (struct rtentry * )0;

		for (n = 0; n < RTHASHSIZ; n++) {

			route.rt_hash = n;
			route.rt_flags =  RTF_HOST | RTF_GATEWAY;
			if (x = xioctl(s, BRDSHOWRT, (caddr_t)&route))
				continue;
			show(cmd, &route);
			while (route.rt_next) {

				/* more entries in the table ... */

				route.rt_hash = n;
				route.rt_flags = RTF_HOST | RTF_GATEWAY;
				if ( x = xioctl(s, BRDSHOWRT, (caddr_t)&route))
					continue;
				show(cmd, &route);
			}
		}
		route.rt_next = (struct rtentry * )0;

		/* display network routes */

		for (n = 0; n < RTHASHSIZ; n++) {

			route.rt_hash = n;
			route.rt_flags =  RTF_GATEWAY;
			if (x = xioctl(s, BRDSHOWRT, (caddr_t)&route))
				continue;
			show(cmd, &route);
			while (route.rt_next) {

				/* more entries in the table ... */

				route.rt_hash = n;
				route.rt_flags = RTF_GATEWAY;
				if ( x = xioctl(s, BRDSHOWRT, (caddr_t)&route))
					continue;
				show(cmd, &route);
			}
		}

		/* if default route exists display it */

		{
		struct sockaddr_in *sin;

		    sin = (struct sockaddr_in *)&route.rt_dst;
		    sin->sin_family = AF_INET;
		    sin->sin_addr.s_addr = 0l;
		    route.rt_flags = RTF_GATEWAY;
		    if (!xioctl(s, BRDDISPRT, (caddr_t)&route))
			    show(cmd, &route);
		}
	    }
}
		


error(cmd, errno)
	char *cmd;
	int errno;
{

	xfflush(xstdout);

	if (errno == XESRCH)
		xoprintf(xstderr, "not in table\n");
	else if (errno == XEBUSY)
		xoprintf(xstderr, "entry in use\n");
	else if (errno == XENOBUFS)
		xoprintf(xstderr, "routing table overflow\n");
	else {
		xoprintf(xstderr, "(%d) ", errno);
		xperror(errno, cmd);
	}
}

extern long xrhost();

getaddr(s, sin)
	char *s;
	struct sockaddr_in *sin;
{

	sin->sin_family = AF_INET;
	if ((sin->sin_addr.s_addr = xrhost(&s)) != -1)
		return;
	if (!isdigit(*s)) {
		xoprintf(xstderr, "%s: unknown host\n", s);
		xexit(1);
	}
	sin->sin_addr.s_addr = xatoi(s);
	if (sin->sin_addr.s_addr == -1) {
		xoprintf(xstderr, "%s: bad value\n", s);
		xexit(1);
	}
}

show(cmd, route)
	char *cmd;
	struct rtentry *route;
{
	u_long destination, gateway;
	struct sockaddr_in *sin;

	sin = (struct sockaddr_in *)&route->rt_dst;
	destination = ((struct sockaddr_in *)&route->rt_dst)->sin_addr.s_addr; 
	destination = xhtonl( destination );
	gateway = ((struct sockaddr_in *)&route->rt_gateway)->sin_addr.s_addr;
	gateway = xhtonl( gateway );
	xoprintf(xstdout, "%s %s %d.%d.%d.%d, gateway %d.%d.%d.%d\n",
		    cmd,
		    (in_lnaof(sin->sin_addr))? "host": "network",
		    (int)((destination>>24)&0xff),
		    (int)((destination>>16)&0xff),
		    (int)((destination>>8)&0xff),
		    (int)((destination>>0)&0xff),
		    (int)((gateway>>24)&0xff),
		    (int)((gateway>>16)&0xff),
		    (int)((gateway>>8)&0xff),
		    (int)((gateway>>0)&0xff));
}

clientinit()
{
}

u_long
in_lnaof(in) 
	struct in_addr in;
{
	u_long host, net;

	net = IN_NETOF(in);
	host = IN_LNAOF(in);

	if ((net != localnet) || (snetmask == -1) || (snetmask == 0))
		return (host);
	else {
		host = in.s_addr & ~snetmask;
		return (host);
	}
}

u_long
get_snetmask()
{
	char *hostentry;
	u_long snetmask;
	long snetaddr;

	int rval;
	char * imask;
	struct exosopt ex_opt;

	snetaddr = XOPTADDR +
		((long)(&ex_opt.xo_snetmask[0]) - (long)(&ex_opt)); 
	if (rval = xioctl(s, BRDADDR, &snetaddr))
		return -1; 			
	if ((rval = xread(s, &snetmask, sizeof(snetmask))) != sizeof(snetmask)) 
		return -1;
	imask = (char *)&snetmask;
	return (snetmask);
}		
