/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: exos.h,v 1.2 87/04/24 15:59:57 davidb Exp $ */
/* @(#)exos.h	1.6 4/5/85 */

/*
 * Changed all Uchars and Ushorts to u_char and u_short, respectively.
 * u_char & u_short are defined in include/EXOS/sys/extypes.h.
 * dab 841125.
 */

/*
 *  9/4/84 billn:  totally rearranged to get VAX to allign structures properly
 *  	- if new fields are added, make sure everything alligns on long boundrys
 */

/*
 *  General headers.
 */
struct headers {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
};

struct messages {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */
};

/*
 * Data structures and constants for the Excelan EXOS Ethernet Front-End
 * Processor as used in front end mode.
 */

/* NET_DLOAD structure */
struct	net_dload {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	u_short	nm_length;		/* length of data */
	long	nm_source;		/* source address */
	long	nm_dest;		/* destination address */
	u_char	nm_xmbyte;		/* stash for 1-byte memory xfers */
};

/* NET_START structure */
struct	net_start {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */
	/*
	 * These two would be a single long, except for longword
	 * alignment problems.  Force access like this:
	 *	*((long *)&mp->nm_sa1) = 0x11000000L;
	 */
	short	nm_sa1;
	short	nm_sa2;
};

/*
 * The following messages all pertain to the tcp/ip/socket software
 * which runs on the board.
 */

/* Sock_pkt structure: send/receive data to/from a socket */
struct	Sock_pkt {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	short	nm_isaddr;		/* non-zero iff user spec sockaddr */
	struct	sockaddr nm_saddr;	/* socket address iff nm_isaddr */
	long	nm_bufaddr;		/* host buffer addr */
	u_short	nm_count;		/* byte count */
	char	nm_data;		/* place for data if not in a buffer */
};

/* Sock_cmd structure: send/recieve command to/from exos */
struct	Sock_cmd {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	short	nm_isaddr;		/* non-zero iff user spec sockaddr */
	struct	sockaddr nm_saddr;	/* socket address iff nm_isaddr */
	struct	sockproto nm_sproto;	/* protocol struct */
	short	nm_isproto;		/* non-zero iff user spec proto */
	short	nm_type;		/* family with protocol */
	short	nm_options;		/* flags */
	short	nm_iamroot;		/* is this user priveleged? */
};

/* Sock_ioctl structure: socket ioctl command */
struct	Sock_ioctl {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	short	nm_ioccmd;			/* ioctl command */
	char	nm_iocdata[40];			/* holder for stuff */
};

/* Sock_printf structure: printf/panic from exos */
struct	Sock_printf {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	short	nm_dummy;		/* hack - align to long-word bndrys */
	char	nm_prdata[48];		/* printf data */
};

/* Sock_select structure: select on sockets */
struct	Sock_select {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	short	nm_rw;		/* how to select (read==0/write==1) */
	short	nm_proc;	/* host proc which is selecting */
	short	nm_selcoll;	/* number of select collisions (for host) */
};

/* Sock_hasoob struct for when get out-of-band data */
struct	Sock_hasoob {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	short	nm_sopgrp;		/* proc group */
};


#ifdef LINKMODE
/* link-mode xmit/recv message */
struct	Link_tr {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	char	ltr_slot;
	char	ltr_nblocks;
	struct	dblock {
	    short	ltr_length;
	    long	ltr_address;
	} ltr_dblocks[8];
};

/* link-mode net-mode msg */
struct	Link_nmode {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	char	lnm_reqmask;
	char	lnm_optmask;
	char	lnm_mode;
};

/* link-mode net-address msg */
struct	Link_naddress {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	char	lna_reqmask;
	char	lna_slot;
	char	lna_addr[6];
};

/* link-mode net-recv msg */
struct	Link_nrecv {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	char	lnr_reqmask;
	char	lnr_slot;
};

/* link-mode reserve-type msg */
struct	Link_rtype {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* reserved for exos, or, socket id  */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* command */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	short	lrt_type;
};

#endif	/* LINKMODE */


struct	Telnet_srvr {
	/* q or mailbox headers */
#ifndef	ONBOARD
	u_short	mh_link;		/* exos link address */
	u_char	mh_reserved;		/* not used; must be 0 */
	u_char	mh_status;		/* status of queue element */
	u_short	mh_length;		/* length of data in queue element */
#else
	long	mh_link;		/* link */
	short	mh_mbid;		/* reply mailbox id */
	u_char	mh_request;		/* request code */
	u_char	mh_reply;		/* return code */
	u_short	mh_length;		/* data length */
#endif
	/* header in message proper */
	short	nm_soid;		/* pseuso-tty device number */
	long	nm_userid;		/* sequence # to attach to msg */
	u_char	nm_request;		/* set to TSCOMMAND */
	u_char	nm_reply;		/* result */

	/* semantics of this structure */
	u_char	nm_tsrqst;		/* telnet server command */
	u_char	nm_tsdlen;		/* data length */
	char	nm_tsdata[32];		/* data buffer */
};

/* nm_request types */

#define	NET_DLOAD	0
#define	NET_ULOAD	1		/* this works only AFTER startup */
#define	NET_START	2
#define	NET_PRINTF	100		/* print out a message */
#define	NET_PANIC	101		/* oh-my-gosh */
#define	IM_ALIVE	102		/* I think; therefore I tcp */

/* nm_reqmask bits */
#define	RQ_READ		2
#define	RQ_WRITE	1

/* nm_reply codes */
#define	REPLY_OK	0x00		/* all is well */

/*
 * This flag has two uses.  It's implementation is somewhat obscure and
 * should be made less so.  Perhaps this stuff can be redone soon (?).  
 *
 * Function Number One: NM_MAGIC_DATA is a magic flag or'd into nm_request or
 * nm_reply to indicate data is/should be in nm_data for send/receive instead
 * of where nm_bufaddr points to.
 *
 * Function Number Two: NM_MAGIC_DATA is a flag or`d into nm_request or nm_reply
 * to indicate that there is more data pending to/from board on send/receive.
 *
 * It might seem that these two cases can overlap and we might thus get
 * confused, though this is not the case.  The code, though, is less than
 * crystal clear, sigh.
 */
#define	NM_MAGIC_DATA	0x80

/* mq_status values */
#define	MQ_EXOS		0x01		/* exos owns queue element */
#define	MQ_DONE		0x02		/* exos is done with queue element */
#define	MQ_OVERFLOW	0x04		/* data area too big */

/*
 * Format of a standard "exos to host" or "host to exos" message:
 *	- this is what is linked together into a queue which both the
 *	  host and exos manipulate while talking to each other
 *	- a message contains:
 *		- a header describing the state of the message and its size
 *		- an actual network message
 *		- (For the host:
 *		- a link for the host to use to maintain and follow the
 *		  message queue with
 *		- a pointer to a context buffer, which is used to hold
 *		  the reply from a message)
 */
struct	msg {
	union exos_u {
		struct	headers msg_hd;
		struct	messages msg_msg;
		struct	net_dload nm_dload;
		struct	net_start nm_start;
		struct	Sock_pkt nm_packet;
		struct	Sock_cmd nm_cmd;
		struct	Sock_ioctl nm_ioctl;
		struct	Sock_printf nm_printf;
		struct	Sock_select nm_select;
		struct	Sock_hasoob nm_hasoob;
		struct	Telnet_srvr nm_telnet;
#ifdef LINKMODE
		struct	Link_tr lnm_tr;
		struct	Link_nmode lnm_nmode;
		struct	Link_naddress lnm_naddress;
		struct	Link_nrecv lnm_nrecv;
		struct	Link_rtype lnm_rtype;
#endif	/* LINKMODE */
	} nm_u;
#ifndef	ONBOARD
	struct	msg *msg_link;		/* host link to next msg */
	struct	context *msg_context;	/* pointer to context buffer */
#endif
};

/*
 * To run this board, a static data area is allocated at boot time which
 * will contain the linked list of queues used by the exos.
 *
 * The [rw]msg_area structure is used to contain the working queues which both
 * the host and the exos use.  It is declared in this fashion so as to
 * allow it to be allocated at run time in shared address space.
 *
 * NET_RBUFS and NET_WBUFS are defined so that either of the msg areas
 * will fit in a 512 byte buffer, the smallest size of buffer a unix
 * system can return from the buffer cache (which is how the memory is
 * allocated).
 */

#define	NET_RBUFS	7
#define	NET_WBUFS	7

struct	rmsg_area {
	u_short	ma_rlink;			/* exos link to ma_rmsgs */
	struct	msg ma_rmsgs[NET_RBUFS];	/* "exos to host" msgs */
	struct	msg *ma_lastr;			/* last examined read msg */
};

struct	wmsg_area {
	u_short	ma_wlink;			/* exos link to ma_rmsgs */
	struct	msg ma_wmsgs[NET_WBUFS];	/* "host to exos" msgs */
	struct	msg *ma_lastw;			/* last examined read msg */
};

#ifndef ONBOARD
#ifndef MIN
#define MIN(a,b)  	((a<b)? a:b)
#endif	/* MIN */
#endif	/* ONBOARD */
#ifdef ONBOARD
#ifndef MIN
#define MIN(a,b)	((a) < 0?0:((b) < 0?0:(((a) < (b))?(a):(b))))
#endif	/* MIN */
#endif	/* ONBOARD */

#define PK_ADDR	1		/* address field is interesting */
#define PK_FIRST 2		/* first chunk in sequence */
#define PK_LAST 4		/* last chunk in sequence */
