/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: mchc.c,v 1.2 87/04/24 16:00:20 davidb Exp $ */
/*
@(#)S5vax750.c	1.4 8/29/85

Support for AT and T System 5 Vaxen.
*/
#ifdef SYSTEM5
#include "sys/param.h"
#include "sys/types.h"
#include "sys/systm.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/file.h"
#include "sys/tty.h"
#include "sys/termio.h"
#include "sys/conf.h"
#include "sys/buf.h"
#include "sys/uba.h"
#endif

#ifdef VERSION7
#include <sys/param.h>
#include <sys/buf.h>
#include <sys/unistar.h>
#endif

#include <sys/extypes.h>
#include <sys/socket.h>
#include "exreg.h"
#include <sys/init.h>
#include "exos.h"
#include "context.h"
#undef PULLIN
#include "config.h"

#ifdef OLDCODE
extern  int ex_addr[];
#endif

extern	struct exctrl ex_db;
extern	struct rmsg_area *rmsgarea;
extern	struct wmsg_area *wmsgarea;

/***************************************************************************/
/* Set PORTADDR for YOUR system !!!                                        */
/***************************************************************************/

/* base i/o address of excelan on multibus */
#define	PORTADDR	0164000

EXbtype *imsgbuf;	/* Where else do you put it?? */

/*
 * ex_getbuf:
 *	- get a buffer from the buffer cache which does not cross
 *	  a segment boundary - this is presumed to be in the multibus
 *	  address space
 *	- if we get a buffer which crosses a segment boundary, recurse
 *	  until we get a good one
 */
struct buf *top = 0;

struct buf *
ex_getbuf(flag)
{
	register struct buf *nextbp, *bp;
	register caddr_t p;
	register tubaddr;
	struct buf *geteblk();

#ifdef DEBUG_NOISE
printf("ex_getbuf(%d)\n",flag);
#endif	/* DEBUG_NOISE */
	bp = geteblk();
/*
	p = bp->b_un.b_addr;
	if (SEGNO(p) != SEGNO(p + (BSIZE-1))) {
		nextbp = ex_getbuf();
		brelse(bp);
		return nextbp;
	}
*/
/*
 *	Map all buffers into unibus address space
*/
	bp->b_umd = mubmalloc(bp->b_bcount,0,ubaindex(ex_db.ex_uba));
	tubaddr = mubmaddr(bp,bp->b_umd,ubaindex(ex_db.ex_uba));
	/* bp->b_umd = ubmalloc(bp->b_bcount,0);
	tubaddr = ubmaddr(bp,bp->b_umd); grant junk*/
#ifdef DEBUG
printf("ex_getbuf: ubaddr = %x\n",tubaddr);
#endif	/* DEBUG */
	clear(bp->b_un.b_addr, BSIZE);
	if (flag == 1) {
		bp->b_bcount = (int)top;
		top = bp;	
	}
	return bp;
}

exinit()
{
	extern int _sdata;
	ex_db.ex_port = (int)ex_addr[0]/*PORTADDR*/;
	printf("Exinit: Ex_addr = %o ex_db.ex_port = %o\n", 
		ex_addr[0], ex_db.ex_port);
	imsgbuf = ex_getbuf(1);
	ex_db.ex_imsg = imsgbuf->b_un.b_addr;
	rmsgarea = (struct rmsg_area *) ex_getbuf(1)->b_un.b_addr;
	wmsgarea = (struct wmsg_area *) ex_getbuf(1)->b_un.b_addr;
#ifdef	DEBUG
printf("exvtop(rmsgarea) has base = %x, off = %x\n",
	(exvtop(rmsgarea,1))>>9,(exvtop(rmsgarea,1))&0x1ff);
printf("rmsg area at %x (physical=%x)\n", rmsgarea, exvtop(rmsgarea,1));
printf("wmsg area at %x (physical=%x)\n", wmsgarea, exvtop(wmsgarea,1));
#endif
	ex_db.ex_init = 1;
	return 1;
}

/* reset system interrupt hardware */
ex_zap()
{}

#ifdef OLDCODE
outb(port, value)
	int port;
	char value;
{
	printf("Outb %x to 0%o 0x%x\n", 
		(int)value, (unsigned char *)port , port);
	*((unsigned char *)(port)) = value;
}

inb(port)
	int port;
{
	return *((unsigned char *)(port));
}
#endif

/* no polling */
ex_dopoll(){}

extern	_sdata, end;
exvtop(addr,flag)
struct buf *addr;
{
	register int base,off,tubinfo,tubaddr;
	struct buf *bp;

#ifdef DEBUG_NOISE
printf("exvtop(%d,%d)\n",(int)addr,flag);
#endif	/* DEBUF_NOISE */
	if (flag == 0) {
		bp = (struct buf *)addr;
		if(bp->b_umd == 0)
			panic("buffer not mapped onto the unibus\n");

		tubaddr = umdbase(bp->b_umd)<<9|((long)(bp->b_un.b_addr))&0x1ff;
		return(tubaddr);
	}
	if ((int)addr < (int)(&end)) {
		base = ((int)addr - (int)(&_sdata))/* >> 9*/;
		off = (int)(addr) & 0x1ff;
#ifdef DEBUG
printf("exvtop: base = %x, base >> 9 = %x,off = %x\n",base,base>>9,off);
#endif	/* DEBUG */
		base = base >> 9;
		return((base << 9) | off);
	}
	for(bp=top;bp != 0; bp = (struct buf *)bp->b_bcount) {
		if ((int)addr >= (int)(bp->b_un.b_addr) 
			&& 
	    	    (int)addr < (int)(bp->b_un.b_addr) + SBUFSIZE)
	    	{
			tubaddr = umdbase(bp->b_umd)<<9 | (int)addr&0x1ff;
#ifdef DEBUG
printf("exvtop: base = %x, off = %x, ubaddr = %x\n",
		umdbase(bp->b_umd),(int)addr&0x1ff,tubaddr);
#endif	/* DEBUG */
			return(tubaddr);
		}
	}
	panic("buffer not mapped onto the unibus\n");
}
