/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: select.c,v 1.2 87/04/24 16:07:45 davidb Exp $ */
static char sccsId[] = "@(#)select.c	1.4 5/8/85";

#include <sys/socket.h>
#include <ex_ioctl.h>
#include <sys/time.h>
#include <sys/proc_dep.h>

select(nfd, rp, wp, timo)
	int nfd;
	long *rp, *wp, timo;
{
#ifdef	HOSTSELECT
	/*
	 * Translate excelan select call to 4.2 select call.
	 * Note that `select' is defined to be `Xselect' for
	 * BSD4dot2.  This define is removed in order to make
	 * the correct system call.
	 */
	struct timeval waitPeriod;
#undef	select

	waitPeriod.tv_sec = timo;
	waitPeriod.tv_usec = 0;
	return select(nfd, rp, wp, 0, &waitPeriod);
#else	/* HOSTSELECT */
	struct SOioctl s;
	static int admin_fd = 0;

	if (!admin_fd) {
	    if ((admin_fd = open("/dev/EXOS/admin", 2)) == -1) {
		    admin_fd = 0;
		    goto error;
	    }
	}

	s.nfd = nfd;
	s.rp = (long)neartolong(rp);
	s.wp = (long)neartolong(wp);
	s.timo = timo;
	s.cbuf = (long)neartolong(&s.count);		/* for return val */
	ioctl(admin_fd, SOSELECT, &s);
	return s.count;
error:
	return -1;
#endif	/* HOSTSELECT */
}
