/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xftpio.c,v 1.4 87/04/24 16:16:17 davidb Exp $ */
/*
$Header: xftpio.c,v 1.4 87/04/24 16:16:17 davidb Exp $
$Log:	xftpio.c,v $
 * Revision 1.4  87/04/24  16:16:17  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:36:49  grant
 * Updating source from Generic trees
 * 
 * Revision 1.4  87/01/07  17:42:44  mark
 * loop for copying parsed, but unused record input now
 * terminates normally
 * 
 * Revision 1.3  86/11/11  16:45:57  alexl
 * *** empty log message ***
 * 
 * Revision 1.2  86/10/15  18:02:19  mark
 * handled case of EOF and EOR
 * 
 * Revision 1.1  86/10/10  12:32:03  mark
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:43:15  mark
 * merging in changes for new ftp
 * 
 * Revision 1.5  86/09/29  16:09:06  mark
 * added code for xftpread to work in record mode
 * corrected record mode return value of xftpwrite
 * moved xftpclose to xftpfsopen, because of interactions with server
 * 
 * Revision 1.4  86/09/12  17:18:05  albert
 * Modify xftpread and xftpwrite.
 * 
*/

#include "ftplib.h"
extern char *xmalloc();

static	int ftprcopy();

xftpioctl( sys_id, cmd, arg )
	struct ftp_ofile *sys_id;
	int cmd;
	char *arg;
{
	int rval;
	struct indexbuf *ib_pt;

	switch( cmd ) {
		case XREAL_OD:
			*((int *)arg) = sys_id->od;
			rval = 0;
			break;
		case XGPOSSITION:
			ib_pt = (struct indexbuf *)arg;
			ib_pt->i_type = P_FTP;
			ib_pt->i_stype = LSK_WINIT;
			xbcopy( &sys_id->above_type,
				&ib_pt->i_data.i_ftp,
				sizeof( struct ftp_attr));
			rval = 0;
			break;
		default:
			rval = xioctl( sys_id->od, cmd, arg );
			break;
	}
	return( rval );
}

long
xftplseek( sys_id, index, strategy )
	struct ftp_ofile *sys_id;
	long index;
	int strategy;
{
	long rval;
	struct indexbuf *ib_pt;

	if( strategy == XONKEY ) {
		ib_pt = (struct indexbuf *)index;
		if( ib_pt->i_type == P_FTP ) {
			if( (ib_pt->i_stype == LSK_WINIT)
				 && !O_VALIDIN(sys_id) ) {
			/*
			may need to do more here later
			*/
			xbcopy( &ib_pt->i_data.i_ftp, &sys_id->above_type,
				sizeof( struct ftp_attr) );
			sys_id->flag2 |= F_VALIDIN;
			rval = 0;
			} else {
				rval = XEOPNOTSUPP;
			}
		} else {
			rval = XEOPNOTSUPP;
		}
	} else {
		rval = XEOPNOTSUPP;
	}
	return( rval );
}

#define EOFFOUND 4
#define RESCFOUND 2
#define CRFOUND 1
#define STARTSTATE 0

xftpread( sys_id, buf, len )
	struct ftp_ofile *sys_id;
	char *buf;
	int len;
{
/* Implementation note:
	For record structure transfer, need to watch out for the followings:
	1. Each read returns a complete record.  So we need to allocate
	   buffer to handle partial record in the buffer (i.e., the second
	   half of the record may be in the next network I/O buffer).
	2. If there is not enough space to return a whole record, this module
	   should do something about it (at least read in the whole record
           so next read will start on a record boundary??).
	3. Need to have data checking for RECORD_ESCAPE RECORD_ESCAPE sequence
	   and convert to a single RECORD_ESCAPE character.
*/

	int rval;
	register char *front_pt;
	register char *back_pt;
	char *new_data = (char *)0;
	int new_count = 0;
	int old_count;
	int needed;
	int cnt;
	register int c;

	back_pt = buf;
	rval = 0;
	if (sys_id->below_type.structure == IS_RECORD) { /* record mode */
		if( sys_id->r_state.state_v == EOFFOUND )
			return( XEOF );
		/*
		If a previous read over shot the record boundry,
		start where we left off.
		*/
		old_count = sys_id->r_state.count;
	rreread:
		if( len <= 0 ) {
			/*
			 * Return an error and save all data read.
			 */
			if( new_count == 0 ) {
				return( XEGRANULARITY );
			} else {
				needed = sys_id->r_state.count + new_count;
				if( needed <= sys_id->r_state.size ) {
					ftprcopy( buf,
						sys_id->r_state.buf,
						needed );
					sys_id->r_state.count = needed;
				} else {
					if ( sys_id->r_state.buf ) {
						xfree( sys_id->r_state.buf );
					}
				bigger:
					sys_id->r_state.size += XBUFSIZ;
					if( needed > sys_id->r_state.size )
						goto bigger;
					sys_id->r_state.buf = 
						xmalloc(sys_id->r_state.size);
					if(sys_id->r_state.buf==(char *)XNULL){
						sys_id->r_state.count = 0;
						sys_id->r_state.size = 0;
						return( XELOSTDATA );
					} else {
						sys_id->r_state.count = needed;
						ftprcopy( buf,
							sys_id->r_state.buf,
							needed );
					} /* if sys_id */
				} /* if needed */
				return( XEGRANULARITY );
			} /* if new_count */
		} /* if len <= 0 */
		if( old_count ) {
			front_pt = &(sys_id->r_state.buf
				[sys_id->r_state.count - old_count]);
			cnt = (len < old_count) ? len : old_count;
			old_count -= cnt;
		} else {
			cnt = xread( sys_id->od, back_pt, len );
			if( !new_data ) {
				new_data = back_pt;
			}
			if( cnt > 0 ) {
				new_count += cnt;
			}
			front_pt = back_pt;
		}
		if( cnt > 0 ) {
			for( ; cnt ; --cnt, ++front_pt ) {
				c = *front_pt;
				switch( sys_id->r_state.state_v ) {
					default:
						if( c == RECORD_ESCAPE ) {
						    sys_id->r_state.state_v =
							RESCFOUND;
						} else {
							*back_pt++ = c;
							++rval;
						}
						break;
					case RESCFOUND:
						switch ( c ) {
							default:
								*back_pt++ = c;
								++rval;
						    sys_id->r_state.state_v =
								STARTSTATE;
								break;
							case END_OF_RECORD:
						    sys_id->r_state.state_v =
								STARTSTATE;
								++front_pt;
								--cnt;
								goto eor;
							case END_OF_RECORD|
							     END_OF_FILE:
							case END_OF_FILE:
						    sys_id->r_state.state_v =
								STARTSTATE;
								goto eof;
						} /* switch c */
						break;
				} /* switch sys_id */
			} /* for */
			/*
			Haven't found end of record yet.
			*/
			len -= rval;
			goto rreread;
		eof:
			if( rval == 0 ) {
				rval = XEOF;
			} else {
				sys_id->r_state.state_v = EOFFOUND;
			}
			return( rval );
		eor:
			/*
			Store unused data.
			*/
			needed = old_count + cnt;
			if( !new_data ) {
				/*
				Unused data is in r_state.buf
				*/
				sys_id->r_state.count = needed;
				for( back_pt = sys_id->r_state.buf
					/* front_pt is still good */;
					needed > 0 ;
					--needed
				) {
					*back_pt++ = *front_pt++;
				}
			} else {
				/*
				Unused data is in buf
				*/
				if( needed > sys_id->r_state.size ) {
					if ( sys_id->r_state.buf ) {
						xfree( sys_id->r_state.buf );
					}
				bigger2:
					sys_id->r_state.size += XBUFSIZ;
					if( needed > sys_id->r_state.size )
						goto bigger2;
					sys_id->r_state.buf = 
						xmalloc(sys_id->r_state.size);
					if(sys_id->r_state.buf==(char *)XNULL){
						sys_id->r_state.count = 0;
						sys_id->r_state.size = 0;
						return( XELOSTDATA );
					}
				} /* if needed */
				sys_id->r_state.count = needed;
				for( back_pt = sys_id->r_state.buf
					/* front_pt is still good */;
					needed > 0 ;
					--needed
				) {
					*back_pt++ = *front_pt++;
				} /* for */
			} /* if new_data */
			return( rval );
		} else {
			rval = XELOSTDATA;
		}
	} else { /* stream mode file */
	reread:
		cnt = xread( sys_id->od, back_pt, len );
		if( (cnt > 0) && (sys_id->below_type.rep_type == RT_ASCII) ) {
			for( front_pt = back_pt ; cnt ; --cnt, ++front_pt ) {
			/* is it necessary to mask off top bit?? RFC says no?? */
				c = *front_pt & 0x7f;
				switch( c ) {
					case '\r':
						sys_id->r_state.state_v = CRFOUND;
						break;
					case '\n':
						if( sys_id->r_state.state_v == CRFOUND){
							*back_pt++ = '\n';
							++rval;
							sys_id->r_state.state_v =
									STARTSTATE;
						} else {
							*back_pt++ = c;
							++rval;
						}
						break;
					/* handle NVT convention of <CR><NULL> */
					case '\0':
						if (sys_id->r_state.state_v == CRFOUND){
							*back_pt++ = '\r';
							++rval;	
							sys_id->r_state.state_v =
								STARTSTATE;
							break;
						};
	
					default:
						if( sys_id->r_state.state_v == CRFOUND){
							*back_pt++ = '\r';
							++rval;
							sys_id->r_state.state_v =
								STARTSTATE;
						}
						*back_pt++ = c;
						++rval;
						break;
				}
			}
			if( rval == 0 ) {
				goto reread;
			}
		} else {
			rval = cnt;
		}
	} /* ISRECORD */
	return( rval );
}

xftpwrite( sys_id, buf, len )
	struct ftp_ofile *sys_id;
	char *buf;
	int len;
{
	static char eor_sequence[] = { RECORD_ESCAPE, END_OF_RECORD};
	int rval;
	int cnt;
	int mask = 0x7f;
	char *frontpt = buf;
	char *backpt = buf;
	int cnt2;
	int c;

	if (sys_id->below_type.structure == IS_RECORD) { /* record mode */
		if( sys_id->w_state.prev_return ) {
			rval = sys_id->w_state.prev_return;
			sys_id->w_state.prev_return = 0;
			return( rval );
		}
		rval = 0;
		cnt = 0;				
		while (len--) {	/* more to be written */
			cnt++;				
			if (*frontpt == RECORD_ESCAPE) { 
				/* escape character, need to escape it */
				/* write current buffer with ESCAPE first*/
				cnt2 = xwrite(sys_id->od, backpt, cnt);
				if (cnt2 < 0) {
					if (rval > 0) {
						sys_id->w_state.prev_return =
							cnt2;
						return (rval);
					} else {
						return (cnt2);
					};
				};
				rval += cnt2;	
				/* write the next ESCAPE character */
				cnt2 = xwrite(sys_id->od, eor_sequence, 1);
				if (cnt2 < 0) {
					if (rval > 0) {
						sys_id->w_state.prev_return =
							cnt2;
						return (rval);
					} else {
						return (cnt2);
					};
				};
				backpt = ++frontpt;
				cnt = 0;
			} else {
				frontpt++; /* increment pointer */
			};
		}; 	/* end while */
		/* now write out the full thing */
		if (cnt > 0) {
			cnt2 = xwrite(sys_id->od, backpt, cnt);
			if (cnt2 < 0) {
				if (rval > 0) {
					sys_id->w_state.prev_return = cnt2;
					return (rval);
				} else {
					return (cnt2);
				};
			};
			rval += cnt2;
		};
		cnt2 = xwrite(sys_id->od, eor_sequence, sizeof eor_sequence);
		if (cnt2 < 0) {
			if (rval > 0) {
				sys_id->w_state.prev_return = cnt2;
				return (rval);
			} else
				return (cnt2);
		};
		return (rval);
	};
				
	if( (sys_id->below_type.rep_type == RT_ASCII) ) {
		rval = 0;
		cnt = 0;
		if( sys_id->w_state.prev_return ) {
			rval = sys_id->w_state.prev_return;
			sys_id->w_state.prev_return = 0;
			return( rval );
		}
		while (cnt < len) {
			/* is this really necessary?? */
			c = *frontpt++ & mask;
			cnt++;
			/* do we need to change CR to <CR><NULL> also?? */
			if ( c == '\n') {
				/*
				expand lf to <cr><lf>.
				*/
				if( cnt > 1 ) {
					cnt2 = xwrite(sys_id->od, backpt,cnt-1);
					if( cnt2 < 0 ) {
						if( rval > 0 ) {
						   sys_id->w_state.prev_return =
								cnt2;
							return( rval );
						} else {
							return( cnt2 );
						}
					}
				}
				rval += cnt - 1;
				cnt2 = xwrite( sys_id->od, "\r\n", 2 );
				if( cnt2 < 0 ) {
					if( rval > 0 ) {
						sys_id->w_state.prev_return =
							cnt2;
						return( rval );
					} else {
						return( cnt2 );
					}
				}
				backpt = frontpt;
				len -= cnt;
				rval += 1;
				cnt = 0;
			}
		}  /* while */
		if ( len > 0 ) {
			cnt = xwrite( sys_id->od, backpt, len );
			if( cnt < 0 ) {
				if( rval > 0 ) {
					sys_id->w_state.prev_return = cnt;
					return( rval );
				} else {
					return( cnt );
				}
			}
			rval += cnt;
		}
		return( rval );
	}
	rval = xwrite( sys_id->od, buf, len );
	return( rval );
}

static
ftprcopy( from, to, len )
	char *from;
	char *to;
	int len;
{
	while( len > 0 ) {
		if( *from == RECORD_ESCAPE )
			*to++ = RECORD_ESCAPE;
		*to++ = *from++;
		--len;
	}
}
