/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xnatgope.c,v 1.4 87/04/24 16:18:55 davidb Exp $ */
/*
$Header: xnatgope.c,v 1.4 87/04/24 16:18:55 davidb Exp $
$Log:	xnatgope.c,v $
 * Revision 1.4  87/04/24  16:18:55  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:38:35  grant
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/10/15  18:12:18  mark
 * return better error code
 * 
 * Revision 1.1  86/10/10  12:32:48  mark
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:48:56  mark
 * merging in changes for new ftp
 * 
 * Revision 1.5  86/09/23  13:41:09  albert
 * should return XEOF when there is no more data.
 * 
 * Revision 2.1  86/09/23  09:18:08  albert
 * xnatgread should return XEOF for no more data.
 * 
 * Revision 2.0  86/09/22  18:20:17  albert
 * update from generic baseline+ development.
 * 
 * Revision 1.3  86/09/19  12:54:19  albert
 * Updating source from Generic trees
 * 
 * Revision 1.4  86/09/19  10:02:47  albert
 * allow Excelan's standard include file specification.
 * 
 * Revision 1.2  86/09/10  10:40:23  albert
 * should use Excelan's standard style of include specification.
 * 
 * Revision 1.1  86/09/04  16:19:21  albert
 * first working version
 * 
 * Revision 1.2  86/08/25  17:37:10  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:11:34  mark
 * Initial revision
 * 
*/

#include "elib.h"
#ifdef	vms
#include "h_xlib/xnatio.h"
#else	/* vms */
#include <xnatio.h>
#endif	/* vms */

extern char *xmalloc();
extern char **xglob();
extern char *globerr;
int xnatgread();
int xnatgclose();

struct xnatgstr {
	int argc;
	char **argv;
	char **argv_orig;
};

xnatgopen( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	register struct _xiobuf *file;
	struct xnatgstr *sys_id;
	char *argv[2];
	char **argv_pt;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	sys_id = (struct xnatgstr *)xmalloc( sizeof( struct xnatgstr ) );
	if( sys_id == (struct xnatgstr *)XNULL ) {
		return( XENOMEM );
	}
	argv[0] = name;
	argv[1] = 0;
	sys_id->argv = xglob( argv );
	if( !(sys_id->argv) || globerr ) {
		xfree( sys_id );
		return( XEXPAND );
	}
	sys_id->argc = 0;
	argv_pt = sys_id->argv_orig = sys_id->argv;
	while ( *argv_pt ) {
		++(sys_id->argc);
		++argv_pt;
	}
	rval = xnewod();
	if( rval < 0 ) {
		xdealglob( sys_id->argv );
		xfree( sys_id );
		return( rval );
	}
	file = &_xiob[ rval ];
	file->_sys_id = (char *)sys_id;
	file->_flag |= _XIOREAD | _XIOSTR;
	file->_read = xnatgread;
	file->_close = xnatgclose;
	return( rval );
}

xnatgread( sys_id, buf, len )
	struct xnatgstr *sys_id;
	char *buf;
	int len;
{
	int rval;

	if( sys_id->argc > 0 ) {
		rval = xstrlen( *(sys_id->argv) ) + 1;
		if( len < rval ) {
			return( XEGRANULARITY );
		}
		xstrcpy( buf, *(sys_id->argv) );
		--(sys_id->argc);
		++(sys_id->argv);
	} else {
		rval = XEOF;
	}
	return( rval );
}

xnatgclose( sys_id )
	struct xnatgstr *sys_id;
{

	xdealglob( sys_id->argv_orig );
	xfree( sys_id );
	return( 0 );
}
