/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xpassthru.c,v 1.4 87/04/24 16:19:19 davidb Exp $ */
/*
$Header: xpassthru.c,v 1.4 87/04/24 16:19:19 davidb Exp $
$Log:	xpassthru.c,v $
 * Revision 1.4  87/04/24  16:19:19  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:38:52  grant
 * Updating source from Generic trees
 * 
 * Revision 1.14  87/01/29  10:28:12  grant
 * changed swap.h to proc_dep.h PMR 1824
 * 
 * Revision 1.13  86/12/22  12:01:22  alexl
 * Correct a xenix compiler problem of assigning a near pointer to a 
 * long variable.
 * 
 * Revision 1.12  86/11/03  17:36:14  mark
 * returns 0 or an error code, bytecount caused problems on 16 bit
 * machines
 * 
 * Revision 1.11  86/10/15  15:58:42  albert
 * 1. handle transfer to/from xstdout/xstdin in record mode
 * 2. If transfer results in error, do not print statistics.
 * 
 * Revision 2.3  86/10/15  09:35:01  albert
 * handle record mode transfer for standard objects.
 * 
 * Revision 2.1  86/10/09  15:06:51  albert
 * Updating source from Generic trees
 * 
 * Revision 1.10  86/10/08  10:49:33  mark
 * merging in changes for new ftp
 * 
 * Revision 1.4  86/10/03  17:40:24  mark
 * re-added generic transfer loop
 * Unix uses xpass[tf]net only for unstructured files
 * 
 * Revision 1.3  86/09/19  10:05:44  albert
 * 1. Convert this to a jacket routine that will call xpasstnet, xpassfnet
 *    and xnetpass.  Xnetpass is a new routine that pass data between two
 *     network I/O objects without any data interpretation.
 * 2. Allow use of Excelan's standard include file specification.
 * 
 * Revision 1.3  86/09/16  17:52:26  albert
 * handle the case that data are just passed between network objects.
 * 
 * Revision 1.2  86/09/09  11:58:15  albert
 * change the routine into a jacket routine.
 * 
$ Implementation:
	This module is the jacket routines for the system-dependent routines
	xpasstnet and xpassfnet.  This module should be system-independent
	but the underlying routines may be optimized for efficiency reasons.

	For the case of third party copy, this module call the 
	system-dependent routine xnetpass to pass the data buffers between
	two network connections.
$
*/

#include "elib.h"
#ifdef	vms
#include "h_xlib/xftpio.h"
#else	/* vms */
#include <xftpio.h>
#include <sys/proc_dep.h>
#endif	/* vms */

int abortxfer = 0;		/* transfer aborted */
extern int hash;		/* flag for hash	*/
extern int type;		/* for xpass[tf]net */
extern int stru;		/* for xpass[tf]net */
extern long xpasstnet();
extern long xpassfnet();
extern long xnetpass();

xpassthru( inod, outod, flags, context )
	int inod;
	int outod;
	int flags;
	struct filesystem *context;
{
	long	start;		/* start time	*/
	long	stop;		/* stop time	*/
	long	sec;		/* number of seconds */
	struct ftp_ofile *ftpod; /* object opened by FTP */
	struct ftp_ofile *destod; /* output object opened in third party copy*/
	long	count;
	int 	special_check;	/* special check for standard objects opened
				   in wrong mode */

	/* this routine decodes the object descriptor to see which routine
	   to call for the transfer */
	
	if (flags & STATS_ONPASS) {
		start = xtime();
	};

	if( context->type == FTP 
#ifndef vms
		&& ((struct ftp_conn_state *)(context->conn_state))->
			ftp_type.structure == IS_FILE
#else
		&& (inod > xfileno(xstderr)) && (outod > xfileno(xstderr))
#endif	/* vms */
	) {
		struct ftp_conn_state *ftp_pt = (struct ftp_conn_state *)
			context->conn_state;

		hash = flags & HASH_ONPASS;
		type = ftp_pt->ftp_type.rep_type;
		stru = ftp_pt->ftp_type.structure;
		if (_xiob[inod]._odtype == XSTDHANDLE) {
			/* input is local object */
			ftpod = (struct ftp_ofile *) _xiob[outod]._sys_id;
			xodopen( ftpod->od, "w" );
			xodopen( inod, "r" );
			count = xpasstnet(&_xiob[inod], &_xiob[ftpod->od]);
		} else if (_xiob[outod]._odtype == XSTDHANDLE) {
			/* output obj is local*/
			ftpod = (struct ftp_ofile *) _xiob[inod]._sys_id;
			xodopen( ftpod->od, "r" );
			xodopen( outod, "w" );
			count = xpassfnet(&_xiob[ftpod->od], &_xiob[outod]);
		} else {
			/* third party copy */
			ftpod = (struct ftp_ofile *) _xiob[inod]._sys_id;
			destod = (struct ftp_ofile *) _xiob[outod]._sys_id;	
			xodopen( ftpod->od, "r" );
			xodopen( destod->od, "w" );
			count = xnetpass(&_xiob[ftpod->od], &_xiob[destod->od]);
		};
	} else {
		int rval;
		char buf[1024];
		int len = sizeof(buf);
		long	bytecnt = 0;
		struct indexbuf ibuf;
		long	hashbytes = 0;
		struct ftp_conn_state *ftpstate;

		/*
		generic data transfer loop
		*/
		ftpstate = (struct ftp_conn_state *) (context->conn_state);
		special_check = (context->type == FTP) &&
			        (ftpstate->ftp_type.structure == IS_RECORD);

		while( (rval = xread( inod, buf, len )) >= 0 ) {
			if( abortxfer ) {
				rval = XEINTR;
				break;
			}
			if ((special_check) && (rval > 0) &&
			    (inod <= xfileno(xstderr)) ) {
				/* since the file is not opened in record
				   mode as it should be, we need to strip off
				   the extra newline from the line */
				if (*(buf+rval-1) == '\n')
					rval--;
			};

			rval = xwrite( outod, buf, rval );
			if( rval == XENOPOSSITION ) {
				xioctl( inod, XGPOSSITION, &ibuf );
				xlseek( outod, (long)neartolong(&ibuf), XONKEY);
				rval = xwrite( outod, buf, len );
			}
			if (( rval < 0 ) && (rval != XEOF)) {
				xperror( rval, "xwrite" );
				break;
			}
			if (special_check && (outod <= xfileno(xstderr)) ) {
				/* since xread return only record buffer in
				   record mode and local file is not opened
				   in record mode, we need to append \n */
				xwrite ( outod, "\n", 1);
			};
			bytecnt += rval;
			if( flags & HASH_ONPASS ) {
				while( (bytecnt - hashbytes) > 1024 ) {
					xoprintf( xstdout, "#" );
					xfflush( xstdout );
					hashbytes += 1024;
				}
			}
		}
		count = (rval == XEOF)? bytecnt : rval;
	}
	if ((flags & STATS_ONPASS) && (count > 0L)) {
		stop = xtime();
		sec = stop - start;
		if (sec <= 0)
			sec = 1;
		xoprintf(xstdout, "%ld bytes %s in %ld seconds (%ld bytes/s)\n",
			count, "transmitted", sec, count / sec);
	};
	return ( (count< 0L) ? (int)count : 0 );
}

