/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xdir.c,v 1.2 87/04/24 16:50:14 davidb Exp $ */
/*
@(#)xdir.c	1.5 8/8/85

Xdir(3X) for Unix - make a directory, remove a directory, move a file.
*/
#include <xerrno.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */
#include <xspecial.h>
#include <errno.h>

static int dircall();

xmkdir (what, special )
char *what;
int special;
{
char buf[ MXNAMELEN + 1 ];
int rval;

rval = xmodname( &what, special, buf, sizeof( buf ) );
if( rval < 0 )
	return( rval );
return (dircall ("/bin/mkdir", "mkdir", what, 0, 0));
}

xrmdir (what, special )
char *what;
int special;
{
char buf[ MXNAMELEN + 1 ];
int rval;

rval = xmodname( &what, special, buf, sizeof( buf ) );
if( rval < 0 )
	return( rval );
return (dircall ("/bin/rmdir", "rmdir", what, 0, 0));
}

xrename (from, from_special, to, to_special )
char *from, *to;
int from_special, to_special;
{
char buf[ MXNAMELEN + 1 ];
char buf2[ MXNAMELEN + 1 ];
int rval;

rval = xmodname( &from, from_special, buf, sizeof( buf ) );
if( rval < 0 )
	return( rval );
rval = xmodname( &to, to_special, buf2, sizeof( buf2 ) );
if( rval < 0 )
	return( rval );
return (dircall ("/bin/mv", "mv", from, to, 0));
}

extern int errno;

static
dircall (path, a, b, c, d)
char *path, *a, *b, *c, *d;
{
	int statbuf;
	int pid;
	int rval = 0;
	int stat;


	if ((pid = fork ()) == -1)
		return (XMAPERRNO(errno));
	if (pid == 0)
	{
		close (0);
		close (1);
		close (2); /* should really pass on as messages to remote */
		execl (path, a, b, c, d);
		exit (-1);
	}
	/*
	command is expected to be one and only child,
	and exit with 0 status on success,
	but code is written to prevent zombies.
	*/
	do {
		if( !rval )
			rval = wait( &statbuf );
		else
			wait( &stat );
		} while ( errno != ECHILD );
	if ( rval != pid  || statbuf != 0)
		return ( XSYSERR );
	return (0);
}
