/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xdirread.c,v 1.4 87/04/24 16:50:33 davidb Exp $ */
/*
$Header: xdirread.c,v 1.4 87/04/24 16:50:33 davidb Exp $
$Log:	xdirread.c,v $
 * Revision 1.4  87/04/24  16:50:33  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:42:11  grant
 * Updating source from Generic trees
 * 
 * Revision 1.2  87/01/19  17:33:38  grant
 * davidb's cleanup. headers.
 * 
 * Revision 1.7  86/12/19  18:02:02  davidb
 * Updating source from Generic trees
 * 
 * Revision 1.3  86/11/05  08:29:30  alexl
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  14:21:03  mark
 * merging in new ftp
 * 
 * Revision 1.2  86/09/04  20:43:29  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/08/25  17:51:55  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  18:58:55  mark
 * Initial revision
 * 

Unix specific file for reading a directory io object
*/
#include <xstdio.h>
#include <UnixXos.h>
#include <xspecial.h>
#include <xerrno.h>
#include <sys/extypes.h> /* For u_char, etc., defns. dab 861125. */
#include <ndir.h>
#include <xstat.h>
#include <xdir.h>

extern int errno;

xdirread( dirpt, buf, len )
DIR *dirpt;
struct xdirect *buf;
int len;
{
	register struct direct *dp;
	register struct xdirect *buf_dp = (struct xdirect *)buf;

	if( len < sizeof( struct xdirect ) ) {
		xperror( XEGRANULARITY, "xdirread(gran)" );
		return( XEGRANULARITY );
	}
retry:
	dp = readdir( dirpt );
	if( dp == XNULL ) {
		return( 0 );
	}
	/*
	fill in information on file
	*/
	buf_dp->d_namelen = dp->d_namlen;
	xbcopy( &dp->d_name[0], &buf_dp->d_name[0], dp->d_namlen );
	buf_dp->d_reclen = ( (int)(&buf_dp->d_name[0]) - (int)buf_dp) + 
		buf_dp->d_namelen;
	buf_dp->d_name[ buf_dp->d_namelen ] = 0; /* put null in for xstat */
	if( !xstrcmp( buf_dp->d_name, "." ) || !xstrcmp( buf_dp->d_name, "..")){
		goto retry;
	}
	xstat( buf_dp->d_name, FILE_NAME, &buf_dp->d_prop );
	return( buf_dp->d_reclen );
}
