/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xint_term.c,v 1.2 87/04/24 16:51:26 davidb Exp $ */
/*
@(#)xint_term.c	1.7 5/8/85

Xint_term(3X) for Unix.
*/
#include <signal.h>
#include <xspecial.h>
#include <xerrno.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */

extern int errno;

#ifdef SYSTEM5
/*
 * newer xenix's aren't V7 compatable
 */
#undef xenix286
#endif	/* SYSTEM5 */

#if ( V7 || BSD4dot2 || xenix286 )
#include <sgtty.h>

#define TTYOP1 TIOCGETP
#define TTYOP2 TIOCSETP
#define xtty_flag sg_flags
#define TTYSTRUCT sgttyb

#else

#ifdef SYSTEM5
#include <sys/termio.h>
#else
#include <termio.h>
#ifdef xenix286
#include <sys/ioctl.h>
#endif
#endif

#define TTYOP1 TCGETA
#define TTYOP2 TCSETAW
#define xtty_flag c_lflag
#define TTYSTRUCT termio

#endif	/* BSD4dot2 */


static struct TTYSTRUCT svstbuf;
static int st_saved = 0;
static int hl_saved = 0;

xraw_term( handler )

int (*handler)();
{
int rval;

/* xint_term( handler ); */
rval = xsetterm( XECHO, XOFF_STERM );
if ( rval < 0 )
	{
	return( rval );
	}
rval = xsetterm( XLINE_EDIT, XOFF_STERM );
if ( rval < 0 )
	{
	xsetterm( XECHO, XON_STERM );
	return( rval );
	}
return( 0 );
}

xrestore_term()
{
int rval;

/*
restore old state
*/
rval = xsetterm( XECHO, XON_STERM );
if ( rval < 0 )
	return( rval );
rval = xsetterm( XLINE_EDIT, XON_STERM );
if ( rval < 0 )
	return( rval );
return( 0 );
}

static int (*ohandler)() = 0;


xint_term( handler )

int (*handler)();
{

ohandler = signal( SIGINT, handler );
hl_saved = 1;
ohandler = handler;
}

int (*
xgetintterm())()
{

	if( !hl_saved ) {
		ohandler = signal( SIGINT, SIG_IGN );
		signal( SIGINT, ohandler );
		hl_saved = 1;
	}
	return( ohandler );
}

xsetterm( option, onoff )

int option;
int onoff;
{
int oldval;
struct TTYSTRUCT stbuf;
int rval;

rval = ioctl( 0, TTYOP1, &stbuf );
if( !st_saved )
	{
	mybcopy( &stbuf, &svstbuf, sizeof( stbuf ));
	st_saved = 1;
	}
if( rval < 0 )
	return( XMAPERRNO(errno) );
switch ( option ) {
	case XECHO:
		oldval = ( stbuf.xtty_flag & ECHO )? 1 : 0;
		if( onoff )
			{
			stbuf.xtty_flag |= ECHO;
			}
		else
			{
			stbuf.xtty_flag &= ~ECHO;
			}
		break;
	case XLINE_EDIT:
#if ( V7 || BSD4dot2 || xenix286 )
		oldval = ( stbuf.xtty_flag & RAW )? 0 : 1;
		if( !onoff )
			{
			stbuf.xtty_flag |= RAW;
			}
		else
			{
			stbuf.xtty_flag &= ~RAW;
			}
#else

		oldval = ( stbuf.c_iflag & BRKINT )? 1 : 0;
		if( onoff )
			{
			/*
			Don't emulate raw mode
			*/
			if( st_saved )
				{
				mybcopy( &svstbuf, &stbuf, sizeof( stbuf ));
				}
			else
				{
				return( XEIO );
				}
			}
		else
			{
			/*
			Emulate Raw mode
			*/
			stbuf.c_iflag &= ~(INLCR | ICRNL | BRKINT);
			stbuf.c_iflag |= IXON;
			stbuf.c_oflag |= OPOST;
			stbuf.c_oflag &= ~(OLCUC | ONLCR | OCRNL
				| ONOCR | ONLRET);
			stbuf.c_lflag &= ~(ICANON | ISIG);
			stbuf.c_cc[VMIN] = '\01';
			stbuf.c_cc[VTIME] ='\0';
			}
#endif
		break;
	default:
		return( XEINVAL );
	}
rval = ioctl( 0, TTYOP2, &stbuf );
if( rval < 0 )
	return( XMAPERRNO(errno) );
return( oldval );
}
