;********************************************************
;*							*
;*	STORAGE ALLOCATION FOR 256 BYTE SCRATCH RAM	*
;*							*
;********************************************************
;
;

VECTAB	EQU	$		;INTERRUPT VECTOR TABLE STARTS HERE
SIOVEC:	DEFS	16		;SPACE FOR 8 VECTORS FOR SIO
CTCVEC:	DEFS	8		;SPACE FOR 4 VECTORS FOR CTC
SYSVEC:	DEFS	4		;SPACE FOR 2 VECTORS FOR SYSTEM PIO
GENVEC:	DEFS	4		;SPACE FOR 2 VECTORS FOR GENERAL PIO
;
;
;	KEYBOARD DATA INPUT FIFO VARIABLES

FIFO:	DEFS	16		;CONSOLE INPUT FIFO
FIFCNT:	DEFS	1		;FIFO DATA COUNTER
FIFIN:	DEFS	1		;FIFI INPUT POINTER
FIFOUT:	DEFS	1		;FIFO OUTPUT POINTER
LOCK:	DEFS	2		;SHIFT LOCK CHARACTER+FLAG BYTE
;
;
;	STACK POINTER SAVE AND LOCAL STACK FOR INTERRUPT ROUTINES

SPSAVE:	DEFS	2		;USER STACK POINTER SAVE AREA
TMPSTK:	DEFS	32		;LOCAL STACK FOR INTERRUPTS
;
;
;	'SOFTWARE' VECTORS FOR INTERRUPT SERVICE ROUTINES

TIKVEC:	DEFS	2		;ONE SECOND INTERRUPT ROUTINE VECTOR
PINVEC:	DEFS	2		;PARALLEL CONSOLE INPUT VECTOR
SINVEC:	DEFS	2		;SERIAL CONSOLE INPUT VECTOR
;
;
;	CLOCK-TIMER INTERRUPT VARIABLES

TIKCNT:	DEFS	2		;BINARY CLOCK TICK COUNTER
DAY:	DEFS	1		;CALENDAR DAY
MONTH:	DEFS	1		;	  MONTH
YEAR:	DEFS	1		;	  YEAR
HRS:	DEFS	1		;CLOCK HOURS REGISTER
MINS:	DEFS	1		;      MINUTES RETISTER
SECS:	DEFS	1		;      SECONDS REGISTER
;
;
;	DISK I/O DRIVER VARIABLES

UNIT:	DEFS	1		;CURRENTLY SELECTED DISK#
TRKTAB:	DEFS	4		;4 DRIVE HEAD POSITION TABLE
SPEED:	DEFS	1		;SEEK SPEED FOR 1771 COMMANDS
RECLEN:	DEFS	1		;SECTOR RECORD LENGTH VARIABLE
MOTOR:	DEFS	1		;DRIVE MOTOR TURN-OFF TIMER
TRACK:	DEFS	1
SECTOR:	DEFS	1
CMDTYP:	DEFS	1		;COMMAND BYTE FOR READS/WRITES
RETRY:	DEFS	1		;DISK OPERATION RE-TRY COUNT
IOPTR:	DEFS	2		;DISK I/O BUFFER POINTER
;
;
;
;	CRT OUTPUT DRIVER VARIABLES

CURSOR:	DEFS	2		;CURSOR POINTER
CHRSAV:	DEFS	1		;CHARACTER OVERLAYED BY CURSOR
CSRCHR:	DEFS	1		;CHARACTER USED FOR A CURSOR
BASE:	DEFS	1		;CURRENT CONTENTS OF SCROLL REGISTER
LEADIN:	DEFS	1		;STATE OF LEAD-IN SEQUENCE HANDLER
;
;
;	NULL PAD COUNT FOR SERIAL OUTPUT DELAY

NULLS:	DEFS	1		;# OF NULLS SENT AFTER CONTROL CHARS.
;
;
;	LISTHEAD POINTER FOR DYNAMIC MEMORY ALLOCATION SCHEME

FREPTR:	DEFS	2
;
;
;	CONSOLE MONITOR PROGRAM VARIABLES

PARAM1:	DEFS	2		;STORAGE FOR NUMBERS READ
PARAM2:	DEFS	2		; FROM LINE INPUT BUFFER
PARAM3:	DEFS	2		; BY 'PARAMS' SUBROUTINE
PARAM4:	DEFS	2
ESCFLG:	DEFS	1		;CONSOLE ESCAPE FLAG
COFLAG:	DEFS	1		;CONSOLE OUTPUT TOGGLE
LAST:	DEFS	2		;LAST ADDRESS USED BY 'MEMDMP'
LINBUF:	DEFS	64		;CONSOLE LINE INPUT BUFFER
;
;
