program calcbytes;

var
  answer : char;

  xtal_frequency, monitor_frequency, character_time,
  line_time, actual_h_freq, actual_v_freq : real;

  number_of_characters, number_of_lines, vertical_correction,
  vertical_total, power_line_frequency : integer;

function hexint (x:integer) : string [2];
   var
     a: string[4];
   begin
     a:=hex$(x);
     hexint:='  ';
     hexint[1]:=a[1];
     hexint[2]:=a[2]
   end;

procedure do_the_work;

begin
  write ('enter your crystal frequency in MHz ');
  readln (xtal_frequency);
  write ('enter your monitor scan frequency in KHz ');
  readln (monitor_frequency);
  write ('what is your local power line frequency, in Hz? ');
  readln (power_line_frequency);
  number_of_characters:=round(1000*xtal_frequency/(9*monitor_frequency));
  if number_of_characters < 100
    then
      begin
	number_of_characters:=100;
	writeln;
	writeln ('Warning!  Cannot achieve desired horizontal scan rate.');
  	writeln ('Proceeding on 100 character basis. (80 displayed)')
      end;
  
  character_time:=9.0e-06/xtal_frequency;
  line_time:=number_of_characters*character_time;
  number_of_lines:= round((1/power_line_frequency)/line_time);
  vertical_correction:= number_of_lines mod 12;
  vertical_total:= number_of_lines div 12;
  
  if vertical_total < 25
   then
     begin
       writeln;
       writeln ('Warning!  Cannot achieve desired vertical scan rate.');
       writeln ('Proceeding on 25 line total basis. (24 displayed)');
       vertical_total:=25; 
       number_of_lines:=12*25;
       vertical_correction:=0
     end;
  
  actual_h_freq:= 1/(1000*line_time);
  actual_v_freq:= 1/(number_of_lines*line_time);
  writeln;
  writeln ('crystal frequency=',xtal_frequency,' MHz');
  writeln('actual h freq.=',actual_h_freq,' KHz');
  writeln('actual v freq.=',actual_v_freq,' Hz');
  writeln('number of characters= ',number_of_characters);
  writeln('vertical total= ',vertical_total);
  writeln('vertical correction= ',vertical_correction);
  writeln;
  write ('R0=',number_of_characters-1:4);
  write ('    ',hexint(number_of_characters-1),'H');
  writeln ('    ; number of characters/line-1');
  write ('R1=  80');
  write ('    50H');
  writeln ('    ; number of displayed char/line');
  write ('R2= ',80+((number_of_characters-80)div 2));
  write ('    ',hexint(80+((number_of_characters-80)div 2)),'H');
  writeln ('    ; horizontal sync position (varies with monitor)');
  write ('R3=  28H   28H');
  writeln ('    ; V sync length (2)/H sync width (8)');
  write ('R4= ',vertical_total-1);
  write ('    ',hexint(vertical_total-1),'H');
  writeln ('    ; character lines total-1');
  write ('R5= ',vertical_correction:3);
  write ('    ',hexint(vertical_correction),'H');
  writeln ('    ; added scan lines to trim V frequency');
  write ('R6=  24    18H');
  writeln ('    ; number of character lines displayed');
  write ('R7=  24    18H');
  writeln ('    ; vertical sync position (varies with monitor)');
  write ('R8=   0     0');
  writeln ('     ; no interlace and no skew');
  write ('R9=  11    0BH');
  writeln ('    ; number of raster lines/char -1');
  write ('R10= 20H   20H');
  writeln ('    ; no cursor');
  writeln ('R11 thru R15 =0')
end;

begin {the repetetive part}

  repeat
    do_the_work;
    writeln;
    write ('Do you want to try other values? (y/n) ');
    readln (answer);
    writeln;
  until answer='n'

end.
