/****************************************************************************
 File: cbwin.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.23  $
   $Author:   pstahl  $
     $Date:   03 Mar 1992 11:46:54  $

 This file contains the API definition for clsCorkBoardWin.
 clsCorkBoardWin inherits from clsIconWin.

 "cbwin" stands for Cork Board Window.
****************************************************************************/

/**** Introduction ****/
/*
 A cork board window is an icon window associated with a document.  The
 cork board window puts embedded documents in a subdirectory of the
 document.  This frees the document's application from having to manage
 the embedded windows and documents in the cork board window.  The PenPoint
 Application Framework uses clsCorkBoardWin to implement the "cork margin"
 that all documents have by default.

 Clients should rarely (if ever) need to create cork board windows
 themselves since the Application Framework has a clean UI and API for
 enabling the cork margin.  clsApp creates a cork board window as the
 command bar of the document's main window (assuming the main window
 is a frame).

 See Also
    -:  app.h for messages to enable the cork margin of an application.
*/

#ifndef CBWIN_INCLUDED
#define CBWIN_INCLUDED

#ifndef ICONWIN_INCLUDED
#include <iconwin.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT CORKBOARD_WIN, *P_CORKBOARD_WIN;

/**** Quick Help Tags ****/
#define qhCorkBoardWin				MakeTag(clsCorkBoardWin, 1)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_CORKBOARD_WIN_NEW, returns STATUS
	category: class message
	Creates a cork board window.
*/

typedef struct CORKBOARD_WIN_NEW_ONLY {
	U32		reserved1[4];
	U16		reserved2:16;
} CORKBOARD_WIN_NEW_ONLY, *P_CORKBOARD_WIN_NEW_ONLY;

#define	corkboardWinNewFields	\
	iconWinNewFields			\
	CORKBOARD_WIN_NEW_ONLY		corkboardWin;

typedef struct CORKBOARD_WIN_NEW {
	corkboardWinNewFields
} CORKBOARD_WIN_NEW, *P_CORKBOARD_WIN_NEW;

/****************************************************************************
 msgNewDefaults				takes P_CORKBOARD_WIN_NEW, returns STATUS
	category: class message
	Initializes the CORKBOARD_WIN_NEW structure to default values.

 Zeroes out pArgs->corkboardWin and sets:
//{
	pArgs->win.flags.style					|= wsShrinkWrapWidth;
	pArgs->win.flags.style					|= wsShrinkWrapHeight;
	pArgs->embeddedWin.style.quickMove		= false;
	pArgs->border.style.topMargin			= bsMarginSmall;
	pArgs->border.style.bottomMargin		= bsMarginSmall;
	pArgs->border.style.leftMargin			= bsMarginSmall;
	pArgs->border.style.rightMargin			= bsMarginSmall;
	pArgs->iconWin.style.iconType			= awSmallPictAndTitle;
	pArgs->iconWin.style.propagateIconType	= true;
	pArgs->iconWin.style.allowOpenInPlace	= false;
	pArgs->iconWin.style.constrainedLayout	= true;
//}
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from other classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgEmbeddedWinGetDest		takes P_EMBEDDED_WIN_GET_DEST, returns STATUS
	Passes back the destination for embedded win move or copy.

 clsCorkBoardWin responds by forcing the embedded document to be put in
 the embedding document's cork board subdirectory (appCorkboardDirName),
 creating this directory if it does not exist.

 See Also
    app.h	definition of appCorkboardDirName string.
*/

#endif	// CBWIN_INCLUDED
