/****************************************************************************
 dvscsi.h

 Copyright 1992, GO Corporation,   All Rights Reserved

 The public definition of the scsi device interface.

 $Revision:   1.12  $
   $Author:   thall  $
     $Date:   24 Mar 1992 15:09:46  $
****************************************************************************/
#ifndef DVSCSI_INCLUDED
#define DVSCSI_INCLUDED

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 This section contains definitions specific to the SCSI device. 
 The definitions contained here are data structures that are necessary
 for the MIL SCSI specific functions along with standard
 MIL device data structures with additional fields specific to the
 SCSI device.
*/

/**** SCSI Device Specific Function Numbers ****/
/*
 The following definitions are the device specific functions supported
 by the SCSI device. The function numbers start immediately after
 the last function number used by the functions that are common to all
 MIL devices. These function numbers correspond to the Function Transfer
 Table (FTT) entries.
*/

#define milSCSIGetDevParameters	milLastCommonFunction+1
#define milSCSISend				milLastCommonFunction+2
#define milSCSIReset			milLastCommonFunction+3

#define fnCountSCSI				fnCountBase+3

/**** SCSI Device Function Transfer Table ****/
/*
 This structure is the declaration of the SCSI Device Function
 Transfer Table. It includes one entry for each of the MIL driver
 functions common to all MIL devices along with one entry for
 each of the device specific functions for the MIL SCSI device.
 Each entry contains fields that define the size of the request
 block for that function, the staging requirements of the function,
 and the address of the actual function. 
*/

typedef struct MIL_FTT_SCSI {
	funcTransTableCommonFields
	MIL_FUNCTION_DESC functionDesc[fnCountSCSI];
} MIL_FTT_SCSI, *P_MIL_FTT_SCSI;


typedef struct MIL_SCSI_UNIT_PARAMETERS {
	U16 scsiUnitFlags;
	U16 reservedU16[2];
	U32 reservedU32[2];
} MIL_SCSI_UNIT_PARAMETERS, *P_MIL_SCSI_UNIT_PARAMETERS;



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 					SCSI Device Specific Functions	   	 				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 The following function definitions are the SCSI device specific
 functions. Access to these functions is provided by the FTT defined
 above. All of the functions defined below will be passed 3 pointers.

	pCommonData:
		This is a pointer to the common data area.

	pRB:
		This is a pointer to the function request block.

	pDeviceBlock:
		This is a pointer to the device block for the device

 All of the functions return STATUS. Any STATUS other than staging 
 statuses will cause the request to terminate. The staging statuses
 will result in the specified staging operation to be performed.
*/



/****************************************************************************
 milSCSIGetDevParameters		returns STATUS
 	Provides device specific information about the SCSI device.

 This function is a single stage function that provides device 
 specific information about the scsi device.

*/ 
/**** Device Specific Request Block Fields ****/
/*

 The milSCSIGetDevParameters funtion request block contains a data 
 structure that defines the SCSI device specific parameters. The 
 fields are defined below.

	scsiFlags:
		This field conatins bits that identify capabilities, status,
		and modes of operation. Currently there are no bits defined.
		
	activeDevices:

	currentSCSIStatus:

*/

typedef struct MIL_SCSI_DEVICE_PARAMETERS {
	U16 scsiFlags;
	U32 activeDevices;
	U16 currentSCSIStatus;
	U16 reservedU16[2];
	U32 reservedU32[2];
} MIL_SCSI_DEVICE_PARAMETERS, *P_MIL_SCSI_DEVICE_PARAMETERS;

/*
 rbPublicFieldsSCSIGetDevParameters

 This define merges the device specific data structure with the standard
 MIL device parameters reserved fields.

*/

#define rbPublicFieldsSCSIGetDevParameters \
	MIL_SCSI_DEVICE_PARAMETERS scsiDevParms; \
	U16 funcReservedU16[2]; \
	U32 funcReservedU32[2];

/*
 
 milSCSIGetDevParameters Request Block

*/

typedef struct MIL_RB_PUB_SCSI_GET_DEV_PARAMETERS {
	milRequestBlockCommonFields
	rbPublicFieldsSCSIGetDevParameters
} MIL_RB_PUB_SCSI_GET_DEV_PARAMETERS, *P_MIL_RB_PUB_SCSI_GET_DEV_PARAMETERS;


/****************************************************************************
 milSCSISend		returns STATUS
 	Provides device specific information about the SCSI device.

 This function is sends a command to the specified SCSI device.

*/
 
/**** Device Specific Request Block Fields ****/

/*
 The milSCSISend fuction request block contains fields that identify
 a send opertation to be performed on the SCSI bus. The following
 fields are defined for this function.

	targetID:
		This field contains the SCSI ID of the device that is to
		be the receiver.
	
	targetLUN:
		This field contains the Logical Unit Number of the logical
		unit within the SCSI device that is to receive the command.

	pCommandBlock:
		This field is a pointer to the standard SCSI command block
		that is to be sent.

	commandBlockLength:
		This field contains a value which is the number of bytes
		in the command block.
	
	pDataBlock:
		This field is a pointer to a data block associated with
		the SCSI command.

	dataBlockLength:
		This field contains a value that specifies the number of 
		bytes in the data block.

	receiveData:
		This field identifies if data is to be sent or received.

	pReqSenseBlock:
		This field is a pointer to a buffer that will receive 
		the status Request Sense Block information.

	reqSenseBlockLength:
		This field contains a value that represents size of the
		Request Sense Block buffer specified in bytes.

	scsiStatus:
		This field contains the SCSI status returned by the device.
*/


#define rbPublicFieldsSCSISend \
	U16         targetID; \
	U16         targetLUN; \
	P_UNKNOWN   pCommandBlock; \
	U16         commandBlockLength; \
	P_UNKNOWN   pDataBlock; \
	U32         dataBlockLength; \
	BOOLEAN     receiveData; \
	P_UNKNOWN   pReqSenseBlock; \
	U16         reqSenseBlockLength; \
	U32         scsiStatus; \
	U16         funcReservedU16[2]; \
	U32         funcReservedU32[2];

/*
 
 milSCSISend Request Block

*/

typedef struct MIL_RB_PUB_SCSI_SEND {
	milRequestBlockCommonFields
	rbPublicFieldsSCSISend
} MIL_RB_PUB_SCSI_SEND, *P_MIL_RB_PUB_SCSI_SEND;



/****************************************************************************
 milSCSIReset		returns STATUS
 	Initiates a SCSI bus reset.

 This function initiates a SCSI bus reset as specified in the 
 request block.


*/

/**** Device Specific Request Block Fields ****/
/*

 The milSCSIReset funtion request block contains a field that 
 indicates the type of reset to be performed.

	scsiReset:
		This field identifies the type of reset. The caller
		can reset the bus, reset the device, or reset the unit.
*/

Enum16(MIL_SCSI_RESET) 
{
 milSCSIResetBus = 0, 
 milSCSIResetDevice = 1,
 milSCSIResetUnit = 2,
};

#define rbPublicFieldsSCSIReset \
    MIL_SCSI_RESET  scsiReset; \
    U16             reserved[2]; \
    U32             funcReservedU32[2];

/*
 
 milSCSIReset Request Block

*/
typedef struct MIL_RB_PUB_SCSI_RESET {
    milRequestBlockCommonFields
    rbPublicFieldsSCSIReset
} MIL_RB_PUB_SCSI_RESET, *P_MIL_RB_PUB_SCSI_RESET;


#endif
