/****************************************************************************
 File: filetype.h

 Copyright 1992, GO Corporation, All Rights Reserved.

 $Revision:   1.2  $
 $Author:   msapsfor  $
 $Date:   24 Feb 1992 11:26:42  $

 This file defines common file types used for import and export
 between PenPoint and other operating systems.
****************************************************************************/
#ifndef FILETYPE_INCLUDED
#define FILETYPE_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif

#ifndef UID_INCLUDED
#include <uid.h>
#endif

/*
 The following file types are common enough to merit a central registry.
 Contact GO Developer Technical Support if you want to add a file type
 to the registry.

 The file types are defined as tags; they are primarily intended to be
 stored as the value of the fsAttrFileType file attribute.
 If a file is explicitly typed via this mechanism, applications can
 more easily decide if they can import it.
*/
#define fileTypeUndefined					((TAG)0L)

/*
 fileTypeASCII implies 8-bit bytes encoding the 7-bit ASCII set
 defined by ANSI X3.64.  Any byte with value greater than 0x7F will
 be interpreted in a manner dependent on the subsystem involved;
 e.g. clsText (and thus the MiniText application) will assume the bytes
 encode IBM-PC Code Page 850.
*/
#define fileTypeASCII						MakeTag(clsFileHandle, 0)

/*
 fileTypeASCIISoftLineBreaks is similar to fileTypeASCII.  The difference
 is that in a line that has no explicit new line or carriage return,
 a space is transformed into a line feed near the 72nd character.
*/
#define fileTypeASCIISoftLineBreaks			MakeTag(clsFileHandle, 1)

/*
 fileTypeRTF implies Microsoft Corporation's Rich Text Format (RTF).
*/
#define fileTypeRTF							MakeTag(clsFileHandle, 2)

/*
 fileTypeRTF implies Aldus Corporation and Microsoft Corporation's
 Tag Image File Format (TIFF).
*/
#define fileTypeTIFF						MakeTag(clsFileHandle, 3)

/*
 fileTypeRTF implies Go Corporation's Picture Segment format.
*/
#define fileTypePicSeg						MakeTag(clsFileHandle, 4)


#endif	// FILETYPE_INCLUDED
