/*
 *  i86.h       Defines the structs and unions used to handle the input and
 *              output registers for the Intel x86 and 386 interrupt interface
 *              routines.
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988,1989,1990.  All rights reserved.
 */
#ifndef _I86_H_INCLUDED

#pragma pack(1);
#undef __FILLER


extern  void _disable( void );
extern  void _enable( void );

#ifdef  __INLINE_FUNCTIONS__
 extern void _inline__disable( void );
 extern void _inline__enable( void );
 #define _disable() _inline__disable()
 #define _enable()  _inline__enable()
#endif

/* macros to break 'far' pointers into segment and offset components */

#define FP_OFF(__p) ((unsigned)(__p))
#ifdef __386__
  unsigned short FP_SEG( void __far * );
  #pragma aux    FP_SEG = parm caller [eax dx] value [dx];

  /*      make a far pointer from segment and offset */
  void __far *MK_FP(unsigned short,unsigned);
  #pragma aux    MK_FP = parm caller [dx] [eax] value [eax dx];
#else
  #define FP_SEG(__p) ((unsigned)((unsigned long)(void __far*)(__p) >> 16))

  /*      make a far pointer from segment and offset */
#define MK_FP(__s,__o) ((void __far*)(((unsigned long)(__s)<<16)|(unsigned)(__o)))
#endif

#pragma pack();

#define _I86_H_INCLUDED
#endif
