/****************************************************************************
 File: manager.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.37  $
   $Author:   sbartlet  $
     $Date:   04 Mar 1992 13:55:54  $

 This file contains the API for clsManager.

 clsManager inherits from clsObject.
 Provides an abstract manager class and associated protocol.

 Managers are used to implement group behavior for collections of components.
 For example, each instance of clsChoice uses one to change the state of
 child buttons when the user is tapping on the choice's children.  Also,
 the menu button holding onto a menu uid acts as a manager for that menu.
 Manager uids are held by instances of clsTkTable.
****************************************************************************/

#ifndef MANAGER_INCLUDED
#define MANAGER_INCLUDED

#define	managerNewFields	\
    objectNewFields

/*
 A manager returns stsManagerContinue if it wishes msgWinSend propogation
 to continue. Any other return value causes propogation to stop and
 the return value to be passed back to the original msgWinSend sender.
*/

#define stsManagerContinue						MakeMsg(clsManager, 1)

#endif	// MANAGER_INCLUDED


