/****************************************************************************
 File: resutil.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.1  $
   $Author:   jbennett  $
     $Date:   03 Mar 1992 11:51:08  $

 This file contains the API definition for the Resource Utility procedures.
 The functions described in this file are contained in RESFILE.LIB.

****************************************************************************/
#ifndef RESUTIL_INCLUDED
#define RESUTIL_INCLUDED

#ifndef RESFILE_INCLUDED
#include <resfile.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Public functions									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 ResUtilLoadObject		returns STATUS
	Loads an object from theProcessResList.

 This is a short cut to using msgResReadObject to read on object in
 from theProcessResList.
*/
STATUS EXPORTED	ResUtilLoadObject(
	RES_ID		resId,		// the resource ID of the object
	P_OBJECT	pObject		// Out: the object
);

/****************************************************************************
 ResUtilLoadString		returns STATUS
	Loads a string item from theProcessResList.

 This is a short cut to using msgResReadData to read a string in from
 theProcessResList.

 There are two ways of supplying space to load the string into.  You can
 specify a pointer and a length for the data passed back (heap = null,
 *ppString = ptr, *pLength = xx) or you can specify a valid heap from which
 the resource file will allocate memory for the data (heap = heap ID,
 *ppString = doesn't matter, pLength = null or *pLength = doesn't matter).
 Typically if the size of the data is already known and it is small and
 short lived, then the data is "allocated" on the stack.  Otherwise, the
 data is allocated on behalf of a heap.
*/
STATUS EXPORTED	ResUtilLoadString(
	PP_CHAR		ppString,	// In/Out: the pointer to the buffer/string
	P_U32		pLength,	// In/Out: the length of the buffer/string
	OS_HEAP_ID	heap,		// Heap to allocate from.
	RES_ID		resId		// resId for a string
);

/****************************************************************************
 ResUtilLoadListString		returns STATUS
	Loads an item from a string list in the application resource list.

 This is a short cut to using msgResReadData to read a single string form a
 string array that is in theProcessResList.

 Works just like ResUtilLoadString, except it uses the group and indexed
 resource ID to construct the resource ID of a string list and the index
 into it.
*/
STATUS EXPORTED	ResUtilLoadListString(
	PP_CHAR		ppString,	// In/Out: the pointer to the buffer/string
	P_U32		pLength,	// In/Out: the length of the buffer/string
	OS_HEAP_ID	heap,		// Heap to allocate from.
	U32			listGroup,	// The list group to select from
	IX_RES_ID	listResId	// Indexed resId for a string
);

#endif	// RESUTIL_INCLUDED

