/****************************************************************************
 File: servconf.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.1  $
   $Author:   jgarrett  $
     $Date:   10 Mar 1992 16:26:24  $

 This file contains the API definition for clsMILConflictGroupMgr.
 clsMILConflictGroupMgr inherits from clsServiceMgr.
 Provides definition of conflict group managers.

 A conflict group manager is automatically created for each conflict
 group in the MIL when one or more MIL service instances are created
 for the MIL devices which are part of that conflict group.	The uid
 of the conflict group manager is that of the conflict group itself.
 In other words, if there is a conflict group identified with the
 tag theMILConflictGroup4, then the conflict group manager will have
 a well-known uid of MILConflictGroup4.

 A conflict group manager is very much like a service manager. All of
 the MIL service instances that represent devices in the conflict
 group are on the conflict group manager. Each service instance is
 also made an observer of the conflict group manager.

 The conflict group manager keeps track of which MIL service owns the
 conflict group. The owning service is the only one that is permitted
 to actually use one of the devices in the conflict group.
****************************************************************************/
#ifndef SERVCONF_INCLUDED
#define SERVCONF_INCLUDED

#ifndef SERVICE_MANAGER_INCLUDED
#include <servmgr.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew						takes P_SM_NEW, returns STATUS
	category: class message
	Creates a new conflict group manager.
 
 This message should *never* be called by clients. Conflict group managers
 are automatically created. The new args must always be the same as for
 a service manager.
*/


/****************************************************************************
 msgCGGetOwner				takes P_CG_GET_OWNER, returns STATUS
	Gets the current owner of the conflict group.

 If no one owns the conflict group, 'objNull' will be returned in the
 owner field.
*/
#define msgCGGetOwner		   		   	MakeMsg(clsMILConflictGroupMgr, 1)

typedef struct CG_GET_OWNER {
	OBJECT				owner;			// Out: owner.
	U8					reserved[16];
} CG_GET_OWNER, *P_CG_GET_OWNER;


/****************************************************************************
 msgCGSetOwner				takes P_CG_SET_OWNER, returns STATUS
	Sets a new conflict group owner.

 'owner' can be objNull to specify that this conflict group has no owner.

 Old and new owners will recieve service messages which allow them to veto 
 the ownership change and informs them that the change has taken effect. 
 The message sequence is as follows:

	1.:	msgSvcOwnerAquireRequested is sent to the new owner. 
	    pArgs->ownedService is set to the conflict group. The new owner can
		veto the owner change by returning a status of anything other
	    than stsOK or stsNotUnderstood. msgCGSetOwner returns with the abort 
		status. 

	2.:	msgSvcOwnerReleaseRequested is sent to the old owner. 
	    pArgs->ownedService is set to the conflict group. The old owner can
		can	veto the owner change by returning a status of anything other
	    than stsOK or stsNotUnderstood. msgCGSetOwner returns with the abort 
		status.
 
	3.:	msgSvcOwnerReleased is sent to the old owner.

	4.:	msgSvcOwnerAquired is sent to the new owner.

	5.:	msgCGOwnerChanged is sent to all observers of this conflict group
		manager, includding all of the service instances on this manager.

 Return Value
	stsBadObject:  			New owner is not an object.
	stsBadAncestor:			New owner has invalid ancestor.

 See Also
	service.h, for definition of msgSvc... messages.
*/
#define msgCGSetOwner		   		   	MakeMsg(clsMILConflictGroupMgr, 2)

typedef struct CG_SET_OWNER {
	OBJECT				owner;		// New owner.
} CG_SET_OWNER, *P_CG_SET_OWNER;


/****************************************************************************
 msgCGPollConnected				takes pNull, returns STATUS
	Polls all the services in the conflict group to see who is connected.

 A conflict group manager recieves this message when any service within
 the conflict group thinks it might be connected. The conflict group
 manager sends msgMILSvcAreYouConnected to each service. It then sends
 msgSvcConnectionStateResolved to each service, choosing one of the
 services as the connected one.
*/
#define msgCGPollConnected	   		   	MakeMsg(clsMILConflictGroupMgr, 3)

/****************************************************************************
 msgCGInformDisconnected 			takes pNull, returns STATUS
	Tells all the services in the conflict group that a disconnect happened.

 A conflict group manager recieves this message when the connected
 service within the conflict group decides it is disconnected. The conflict
 group manager sends msgSvcConnectionStateResolved to each service, 
 specifying that nobody is connected.
*/
#define msgCGInformDisconnected	   	   	MakeMsg(clsMILConflictGroupMgr, 4)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	 						Notification Messages						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgCGOwnerChanged		 	takes P_CG_OWNER_NOTIFY, returns STATUS
	category: observer notification
	A conflict group's owner has changed.
*/
#define msgCGOwnerChanged		   	   	MakeMsg(clsMILConflictGroupMgr, 10)

typedef struct CG_OWNER_NOTIFY {
	OBJECT				conflictGroup;	// conflict group whose owner changed.
	OBJECT				oldOwner;		// old owner.
	OBJECT				owner;			// new owner.
} CG_OWNER_NOTIFY, *P_CG_OWNER_NOTIFY;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *      	      	   			     Tags								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#define tagConflictChoice			MakeTag(clsMILConflictGroupMgr, 1) 

#endif	// SERVCONF_MGR_INCLUDED


