/****************************************************************************
 File: spmgr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.14  $
   $Author:   ghullend  $
     $Date:   28 Feb 1992 14:15:10  $

 This file contains the API for the Spell Manager Class and theSpellManager.

 clsSpellManager inherits from clsObject.
 theSpellManager is a well-known instance of clsSpellManager.

 See Also spell.h, pdict.h
****************************************************************************/

#ifndef SPMGR_INCLUDED
#define SPMGR_INCLUDED


#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef WIN_INCLUDED
#include <win.h>
#endif

#ifndef XLATE_INCLUDED
#include <xlate.h>
#endif

#ifndef GWIN_INCLUDED
#include <gwin.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				   Common typedefs										   *	
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
	This structure is passed to theSpellManager when the user makes the
	spell gesture on a window.
*/

typedef struct SP_MGR_GESTURE {
	GWIN_GESTURE   gesture;
} SP_MGR_GESTURE, * P_SP_MGR_GESTURE;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				   Messages												   *	
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Sent to Traversal Clients  ****/

/****************************************************************************
 msgSpMgrCreateContext	takes VOID, returns STATUS
	Piggybacked with msgTraverseCreate.*Ctx messages.
	
	Initiates a	spelling traversal.
*/

#define msgSpMgrCreateContext					MakeMsg(clsSpellManager,1)

/****************************************************************************
 msgSpMgrFindMisspelling	takes SP_MGR_DIALOG, returns STATUS
	Asks the recipient to find the next misspelled word (using SpellCheck()
	on successive space-delimited	tokens).

	Piggybacked with msgTraverseFind.  
*/

#define msgSpMgrFindMisspelling					MakeMsg(clsSpellManager,2)

/****************************************************************************
 msgSpMgrCorrectMisspelling	takes SP_MGR_DIALOG, returns STATUS
	Asks the recipient to correct the misspelled word he previously found
	in response to a msgSpMgrFindMisspelling message.
   
	Piggybacked with msgTraverseApply.  Correction is in the word field.
*/

#define msgSpMgrCorrectMisspelling				MakeMsg(clsSpellManager,3)

/****************************************************************************
 msgSpMgrAcceptMisspelling	takes SP_MGR_DIALOG, returns STATUS
	Asks the recipient to accept the misspelled word he previously found in
	response to a msgSpMgrFindMisspelling message.
   
	Piggybacked with msgTraverseApply.  Dialog Struct is copied.
*/

#define msgSpMgrAcceptMisspelling				MakeMsg(clsSpellManager,5)

/****  Received From GWin  ****/

/****************************************************************************
 msgSpMgrGesture	takes P_SP_MGR_GESTURE, returns STATUS
	This causes theSpellManager to initiate a spell traversal from a gesture,
	as opposed to from a menu.

	When a user makes the spelling gesture on an embedded window, the
	window sends msgSpMgrGesture to theSpellManager with the
	SP_MGR_GESTURE structure filled in.

*/

#define msgSpMgrGesture			  				MakeMsg(clsSpellManager,4)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				   Miscellaneous												   *	
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Quick Help Tags  ****/

#define SpMgrReplaceButtonTag	MakeTag(clsSpellManager,1)
#define SpMgrIgnoreButtonTag	MakeTag(clsSpellManager,2)
#define SpMgrCancelButtonTag	MakeTag(clsSpellManager,3)
#define SpMgrInsertionPadTag	MakeTag(clsSpellManager,4)
#define SpMgrTKTableTag			MakeTag(clsSpellManager,5)
#define SpMgrBackgroundTag		MakeTag(clsSpellManager,6)
#define SpMgrClearButtonTag		MakeTag(clsSpellManager,7)
#define SpMgrRememberButtonTag	MakeTag(clsSpellManager,8)
#define SpMgrTitleBarTag		MakeTag(clsSpellManager,9)

#define hlpSpMgrReplaceButton	SpMgrReplaceButtonTag
#define hlpSpMgrIgnoreButton	SpMgrIgnoreButtonTag	
#define hlpSpMgrCancelButton	SpMgrCancelButtonTag	
#define hlpSpMgrInsertionPad	SpMgrInsertionPadTag	
#define hlpSpMgrTKTable			SpMgrTKTableTag			
#define hlpSpMgrBackground		SpMgrBackgroundTag		
#define hlpSpMgrClearButton		SpMgrClearButtonTag		
#define hlpSpMgrRememberButton	SpMgrRememberButtonTag
#define hlpSpMgrTitleBar		SpMgrTitleBarTag		

// Different help tags for when this is proof instead of spell

#define hlpProofInsertionPad	MakeTag(clsSpellManager,10)
#define hlpProofTKTable			MakeTag(clsSpellManager,11)

#endif
