/*
 *  sys/stat.h  Equates and prototype for fstat, stat functions
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988-1991.  All rights reserved.
 */
#ifndef _TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

#ifndef _STAT_H_INCLUDED
#pragma pack(1);

/*
        Which file times and how they are defined are volume specific.

        For FAT volumes only st_mtime is defined, st_atime and st_ctime
        are always zero.
*/

struct stat {
        unsigned short st_mode; /* file mode */
        ino_t   st_ino;         /* this inode's #, always zero for PenPoint */
        dev_t   st_dev;         /* disk drive file resides on */
        short   st_nlink;       /* # of hard links */
        short   st_uid;         /* user-id, always 'root', i.e., 0 */
        short   st_gid;         /* group-id, always 'root', i.e., 0 */
        off_t   st_size;        /* total file size */
        time_t  st_atime;       /* last access time (see comment above) */
        time_t  st_mtime;       /* last modify time (see comment above) */
        time_t  st_ctime;       /* last status change time (see comment above) */
};

/* File attribute constants for st_mode field */

#define S_IFMT          0770000 /* type of file */
#define S_IFREG         0010000 /* regular */
#define S_IFDIR         0020000 /* directory */
#define S_IFCHR         0040000 /* character special file */
#define S_IFBLK         0100000 /* block special file */
#define S_IFFIFO        0200000 /* FIFO special file */

#define S_ISREG( m )    (((m) & S_IFMT) == S_IFREG)
#define S_ISDIR( m )    (((m) & S_IFMT) == S_IFDIR)

/* Always zero for PenPoint */
#define S_ISCHR( m )    (((m) & S_IFMT) == S_IFCHR)
#define S_ISBLK( m )    (((m) & S_IFMT) == S_IFBLK)
#define S_ISFIFO( m )   (((m) & S_IFMT) == S_IFFIFO)

/* Owner permission */
#define S_IRWXU         0000700
#define S_IRUSR         0000400
#define S_IWUSR         0000200
#define S_IXUSR         0000100

/* Group permission.  Same as owner's on PenPoint */
#define S_IRWXG         0000070
#define S_IRGRP         0000040
#define S_IWGRP         0000020
#define S_IXGRP         0000010

/* Other permission.  Same as owner's on PenPoint */
#define S_IRWXO         0000007
#define S_IROTH         0000004
#define S_IWOTH         0000002
#define S_IXOTH         0000001

int     chmod( const char *__path, mode_t __mode );
int     fstat( int __fildes, struct stat * __buf );
int     mkdir( const char *__path, mode_t __mode );
int     stat( const char * __path, struct stat * __buf );
mode_t  umask( mode_t __cmask );

#pragma pack();
#define _STAT_H_INCLUDED
#endif
