/****************************************************************************
 txtxlist.h
 Copyright 1992, GO Corporation, All Rights Reserved.

 $Revision:   1.202  $
   $Author:   msapsfor  $
     $Date:   24 Feb 1992 11:47:54  $

 This file contains the Text subsystem additions to xlist (see xlist.h).

 A Text View (see txtView.h) gathers input directly from the user via
	keyboard input:			delivered by msgInputEvent, with
							Cls(pArgs->devCode) == Cls(clsKey);
	low-level pen input:	also msgInputEvent, but Cls(clsPen);
	gestures:				delivered by msgGWinXlist; and
	insertion pads:			which provide data starting with
							msgIPDataAvailable.

 The user input delivered to a Text View from an insertion pad is
 communicated via an xlist.  As a result of its processing of the xlist,
 the Text View modifies its associated data object.  Each xlist moves
 through the following stages: (1) it comes into being as a way for the hwx
 system to provide low-level information about the user input to clsIP
 (see insert.h); (2) clsIP packages the low-level information into
 medium-level information which is self-sent; (3) finally, clsTextIP
 re-interprets this information and packages it into high-level information
 which requires concepts specific to the Text subsystem.  Thus, an xlist
 from a TextIP (see txtView.h) can contain one or more elements of the
 following specialized types.  For each type, the constraint on the
 structure of the information pointed to by the pData field of the
 XLIST_ELEMENT is listed.
	xtCharAttrs:	pData points to an XLIST_CHAR_ATTRS;
	xtParaAttrs:	pData points to an XLIST_PARA_ATTRS;
	xtTabs:			pData points to an XLIST_TABS;
	xtCharPos:		pData is a TEXT_INDEX (cast to a P_UNKNOWN).
 The types themselves are defined as part of XTYPE in xlist.h; the
 data structures and their semantics are defined below.

 In general, an xlist is position-independent.  However, the caller of
 msgGWinXlist often wants the associated xlist to modify a Text View's
 data object beginning at a particular character index; an element of type
 xtCharPos allows the caller to specify such an index.

 To make it easier to maintain the position-independent property of an xlist,
 Text Views recognize maxTEXT_INDEX (see txtData.h) as having a special
 meaning when used as the value of the first field of the pData in an xlist
 element of type xtCharAttrs, xtParaAttrs and xtTabs
 (i.e., pData->first == maxTEXT_INDEX).  If the pData->length is 0,
 a pData->first of maxTEXT_INDEX causes the xlist processing code to remember
 the current index in the Text data object and to take no other action;
 if the pData->length is non-zero, the pData->first of maxTEXT_INDEX
 causes the xlist processing code to update pData->first with the previously
 remembered index.  This allows the caller of msgGWinXlist to generate
 an xlist with the following structure:
	xtCharPos:		to start processing at a particular index;
	xtText:			one or more times, to add characters;
	xtCharAttrs:	with first of maxTEXT_INDEX, length of 0;
	xtText:			one or more times, to add more characters;
	xtCharAttrs:	with first of maxTEXT_INDEX, length not 0,
					thereby setting the character attributes
					for exactly the bracketed characters.
****************************************************************************/

#ifndef TXTXLIST_INCLUDED
#define TXTXLIST_INCLUDED

#ifndef XLIST_INCLUDED
#include <xlist.h>
#endif

#ifndef TXTDATA_INCLUDED
#include <txtData.h>
#endif

/*
 Upon encountering an xlist element of type xtCharAttrs, a Text View does a
 msgTextChangeAttrs to its data object, making use of the fields of the
 P_XLIST_CHAR_ATTRS by mapping them to the corresponding fields of
 TEXT_CHANGE_ATTRS as follows:
	tag:		forced to atomChar
	first:		copied from first
	length:		copied from length
	pNewMask:	set to &mask
	pNewValues:	set to &attrs
 */
typedef struct {
	TEXT_INDEX		first;
	TEXT_INDEX		length;
	TA_CHAR_MASK	mask;
	TA_CHAR_ATTRS	attrs;
} XLIST_CHAR_ATTRS, *P_XLIST_CHAR_ATTRS;

/*
 Upon encountering an xlist element of type xtParaAttrs, a Text View does a
 msgTextChangeAttrs to its data object, making use of the fields of the
 P_XLIST_PARA_ATTRS by mapping them to the corresponding fields of
 TEXT_CHANGE_ATTRS as follows:
	tag:		forced to atomPara
	first:		copied from first
	length:		copied from length
	pNewMask:	set to &mask
	pNewValues:	set to &attrs
 */
typedef struct {
	TEXT_INDEX		first;
	TEXT_INDEX		length;
	TA_PARA_MASK	mask;
	TA_PARA_ATTRS	attrs;
} XLIST_PARA_ATTRS, *P_XLIST_PARA_ATTRS;

/*
 Upon encountering an xlist element of type xtTabs, a Text View does a
 msgTextChangeAttrs to its data object, making use of the fields of the
 P_XLIST_TABS by mapping them to the corresponding fields of
 TEXT_CHANGE_ATTRS as follows:
	tag:		forced to atomParaTabs
	first:		copied from first
	length:		copied from length
	pNewMask:	set to Nil()
	pNewValues:	set to &tabs
 */
typedef struct {
	TEXT_INDEX		first;
	TEXT_INDEX		length;
	TA_MANY_TABS	tabs;
} XLIST_TABS, *P_XLIST_TABS;

#endif
