/****************************************************************************
 xgesture.h
 Copyright 1992, GO Corporation, All Rights Reserved

 Interface file for clsXGesture

 $Revision:   1.10  $
   $Author:   bldmstr  $
     $Date:   20 Feb 1992 15:07:42  $

    clsXGesture inherits from clsXtract.
****************************************************************************/
#ifndef XGESTURE_INCLUDED
#define XGESTURE_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef UID_INCLUDED
#include <uid.h>
#endif
#ifndef GEO_INCLUDED
#include <geo.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Gesture Definitions  ****/

/*
 These tags define the codes returned for a recognized gesture.  Wherever
 a "gesture id" is called for, one of these codes is expected.

 Certain of these gesture codes are OBSOLETE.  That is, the shapes that
 they denote were experimental and are no longer recognized by the 
 gesture recognizer.  All such obsolete codes are indicated by the
 comment "not generated" at the end of the definition.
*/

#define xgsNull				MakeTag(clsXGesture, 0xff)	// 255

// selection
#define xgsLeftParens		MakeTag(clsXGesture, '(')	//  40
#define xgsRightParens		MakeTag(clsXGesture, ')')	//  41
#define xgsPlus				MakeTag(clsXGesture, '+')	//  43
#define xgs1Tap				MakeTag(clsXGesture, '.')	//  46
#define xgs2Tap				MakeTag(clsXGesture, 0x80)	// 128
#define xgs3Tap				MakeTag(clsXGesture, 0x81)	// 129
#define xgs4Tap				MakeTag(clsXGesture, 0x82)	// 130

//	Removed xgsNTapDrag

#define xgsPlusTap			MakeTag(clsXGesture, 0x87)	// 135 not generated
#define xgsCheckTap			MakeTag(clsXGesture, 0x88)	// 136
#define xgsTapHold			MakeTag(clsXGesture, 0x89)	// 137
#define xgsPressHold		MakeTag(clsXGesture, 0x8a)	// 138

// deletion
#define xgsCross        	MakeTag(clsXGesture, 'X')	//  88 == xgsXGesture
#define xgsPigtailHorz		MakeTag(clsXGesture, 0x8b)	// 139 not generated
#define xgsScratchOut		MakeTag(clsXGesture, 0x8c)	// 140
#define xgsPigtailVert		MakeTag(clsXGesture, 0x8d)	// 141

// insert/replace
#define xgsCircle			MakeTag(clsXGesture, 'O')	//  79 == xgsOGesture
#define xgsCircleTap		MakeTag(clsXGesture, 0x8e)	// 142
#define xgsUpCaret			MakeTag(clsXGesture, 0x8f)	// 143
#define xgsRightCaret		MakeTag(clsXGesture, 0x90)	// 144 not generated
#define xgsCircleDblTap		MakeTag(clsXGesture, 0x91)	// 145 not generated
#define xgsCircleLine		MakeTag(clsXGesture, 0x92)	// 146
#define xgsCircleFlickUp	MakeTag(clsXGesture, 0x93)	// 147
#define xgsCircleFlickDown	MakeTag(clsXGesture, 0x94)	// 148
#define xgsUpCaretDot		MakeTag(clsXGesture, 0x95)	// 149
#define xgsUpCaretDblDot	MakeTag(clsXGesture, 0x96)	// 150 not generated
#define xgsDblArrow			MakeTag(clsXGesture, 0x97)	// 151 not generated
#define xgsDblCircle		MakeTag(clsXGesture, 0x98)	// 152

// move/copy
#define xgsUpArrow			MakeTag(clsXGesture, 0x99)	// 153
#define xgsUp2Arrow			MakeTag(clsXGesture, 0x9a)	// 154
#define xgsDownArrow		MakeTag(clsXGesture, 0x9b)	// 155
#define xgsDown2Arrow		MakeTag(clsXGesture, 0x9c)	// 156
#define xgsLeftArrow		MakeTag(clsXGesture, 0x9d)	// 157
#define xgsLeft2Arrow		MakeTag(clsXGesture, 0x9e)	// 158
#define xgsRightArrow		MakeTag(clsXGesture, 0x9f)	// 159
#define xgsRight2Arrow		MakeTag(clsXGesture, 0xa0)	// 160

#define xgsDblUpCaret		MakeTag(clsXGesture, 0xa1)	// 161
#define xgsDblDownCaret		MakeTag(clsXGesture, 0xa2)	// 162 not generated
#define xgsUpTriangle		MakeTag(clsXGesture, 0xa3)	// 163 not generated
#define xgsDownTriangle		MakeTag(clsXGesture, 0xa4)	// 164 not generated

#define xgsRightUp			MakeTag(clsXGesture, 0xa5)	// 165
#define xgsRightUpFlick		MakeTag(clsXGesture, 0xa6)	// 166
#define xgsRightDown		MakeTag(clsXGesture, 0xa7)	// 167

// white space
#define xgsCGesture			MakeTag(clsXGesture, 'C')	//  67
#define xgsLLCorner			MakeTag(clsXGesture, 'L')	//  76 "DownRight","LGesture"
#define xgsLLCornerFlick	MakeTag(clsXGesture, 0xa8)	// 168 "DownRightFlick"
#define xgsLRCorner			MakeTag(clsXGesture, 0xa9)	// 169 "DownLeft"
#define xgsLRCornerFlick	MakeTag(clsXGesture, 0xaa)	// 170 "DownLeftFlick"
#define xgsParagraph		MakeTag(clsXGesture, 0xab)	// 171
#define xgsLeftCaret		MakeTag(clsXGesture, 0xac)	// 172 not generated
#define xgsULCorner			MakeTag(clsXGesture, 0xad)	// 173 "UpRight"

// scroll
#define xgsFlickUp			MakeTag(clsXGesture, 0xae)	// 174
#define xgsFlickDown		MakeTag(clsXGesture, 0xaf)	// 175
#define xgsFlickLeft		MakeTag(clsXGesture, 0xb0)	// 176
#define xgsFlickRight		MakeTag(clsXGesture, 0xb1)	// 177
#define xgsDblFlickUp		MakeTag(clsXGesture, 0xb2)	// 178
#define xgsDblFlickDown		MakeTag(clsXGesture, 0xb3)	// 179
#define xgsDblFlickLeft		MakeTag(clsXGesture, 0xb4)	// 180
#define xgsDblFlickRight	MakeTag(clsXGesture, 0xb5)	// 181
#define xgsFlickTapUp		MakeTag(clsXGesture, 0xb6)	// 182 not generated
#define xgsFlickTapDown		MakeTag(clsXGesture, 0xb7)	// 183 not generated
#define xgsFlickTapLeft		MakeTag(clsXGesture, 0xb8)	// 184 not generated
#define xgsFlickTapRight	MakeTag(clsXGesture, 0xb9)	// 185 not generated
#define xgsTrplFlickUp		MakeTag(clsXGesture, 0xba)	// 186
#define xgsTrplFlickDown	MakeTag(clsXGesture, 0xbb)	// 187
#define xgsTrplFlickLeft	MakeTag(clsXGesture, 0xbc)	// 188
#define xgsTrplFlickRight	MakeTag(clsXGesture, 0xbd)	// 189
#define xgsQuadFlickUp		MakeTag(clsXGesture, 0xbe)	// 190
#define xgsQuadFlickDown	MakeTag(clsXGesture, 0xbf)	// 191
#define xgsQuadFlickLeft	MakeTag(clsXGesture, 0xc0)	// 192
#define xgsQuadFlickRight	MakeTag(clsXGesture, 0xc1)	// 193

// misc
#define xgsLineCaretRight	MakeTag(clsXGesture, 0xc2)	// 194 not generated
#define xgsLineCaretLeft	MakeTag(clsXGesture, 0xc3)	// 195 not generated
#define xgsLineDblCaret		MakeTag(clsXGesture, 0xc4)	// 196 not generated

// User-defineable 
#define xgsLeftDown			MakeTag(clsXGesture, 0xc5)	// 197
#define xgsLeftUp			MakeTag(clsXGesture, 0xc6)	// 198
#define xgsUpLeft			MakeTag(clsXGesture, 0xc7)	// 199

// Undo
#define xgsVertCounterFlick	MakeTag(clsXGesture, 0xc8)	// 200
#define xgsHorzCounterFlick	MakeTag(clsXGesture, 0xc9)	// 201
#define xgsInfinity		   	MakeTag(clsXGesture, 0xca)	// 202 not generated
#define xgsCircleCrossOut  	MakeTag(clsXGesture, 0xcb)	// 203

// Borders On
#define xgsBordersOn	   	MakeTag(clsXGesture, 0xcc)	// 204

#define xgsAsterisk			MakeTag(clsXGesture, '*')	// not generated

// Capital letters gestures 
#define xgsAGesture			MakeTag(clsXGesture, 'A')	//  65
#define xgsBGesture			MakeTag(clsXGesture, 'B')	//  66
// for xgsCGesture see above                                67
#define xgsDGesture			MakeTag(clsXGesture, 'D')	//  68
#define xgsEGesture			MakeTag(clsXGesture, 'E')	//  69
#define xgsFGesture			MakeTag(clsXGesture, 'F')	//  70
#define xgsGGesture			MakeTag(clsXGesture, 'G')	//  71
#define xgsHGesture			MakeTag(clsXGesture, 'H')	//  72
#define xgsIGesture			MakeTag(clsXGesture, 'I')	//  73
#define xgsJGesture			MakeTag(clsXGesture, 'J')	//  74
#define xgsKGesture			MakeTag(clsXGesture, 'K')	//  75
// for xgsLGesture see xgsLLCorner, above                   76
#define xgsMGesture			MakeTag(clsXGesture, 'M')	//  77
#define xgsNGesture			MakeTag(clsXGesture, 'N')	//  78
#define xgsOGesture			MakeTag(clsXGesture, 'O')	//  79 == xgsCircle
#define xgsPGesture			MakeTag(clsXGesture, 'P')	//  80
#define xgsQGesture			MakeTag(clsXGesture, 'Q')	//  81
#define xgsRGesture			MakeTag(clsXGesture, 'R')	//  82
#define xgsSGesture			MakeTag(clsXGesture, 'S')	//  83
#define xgsTGesture			MakeTag(clsXGesture, 'T')	//  84
#define xgsUGesture			MakeTag(clsXGesture, 'U')	//  85
#define xgsCheck			MakeTag(clsXGesture, 'V')	//  86 == xgsVGesture
#define xgsVGesture			MakeTag(clsXGesture, 'V')	//  86 == xgsCheck
#define xgsWGesture			MakeTag(clsXGesture, 'W')	//  87
#define xgsXGesture			MakeTag(clsXGesture, 'X')	//  88 == xgsCross
#define xgsYGesture			MakeTag(clsXGesture, 'Y')	//  89
#define xgsZGesture			MakeTag(clsXGesture, 'Z')	//  90
#define xgsQuestion			MakeTag(clsXGesture, '?')	//  63

// graphic gestures in geo.ptc - currently not implemented
#define xgsRect				MakeTag(clsXGesture, 0xf0)	// 240 not generated
#define xgsRoundRect		MakeTag(clsXGesture, 0xf1)	// 241 not generated
#define xgsSpline			MakeTag(clsXGesture, 0xf2)	// 242 not generated
#define xgsPolyline			MakeTag(clsXGesture, 0xf3)	// 243 not generated

#define xgs0TapHold			xgsPressHold
#define xgs1TapHold			xgsTapHold
#define xgs2TapHold			MakeTag(clsXGesture, 0xf4)	// 244
#define xgs3TapHold			MakeTag(clsXGesture, 0xf5)	// 245
#define xgs4TapHold			MakeTag(clsXGesture, 0xf6)	// 246


/****  Output Data Structure  ****/

/*
 Information returned in an xlist.
*/
typedef struct XLATE_GDATA {
	U32 gType;	  	// gesture code (one of the 32-bit values defined above)
	XY32 hotPoint;	// target point in window coordinates
} XLATE_GDATA, *P_XLATE_GDATA;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Messages											   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNewDefaults: takes P_XLATE_NEW, returns STATUS
	Sets default values in XLATE_NEW structure for a gesture recognizer

 Sets
//{
	pArgs->xlate.metrics.charCount = 1;
	pArgs->xlate.metrics.lineCount = 1;
//}
 and all other values to 0
*/

/****************************************************************************
 msgNew: takes P_XLATE_NEW, returns STATUS
    Creates a new Gesture translation object.

 Note: sets the XLATE_NEW.mode to xlGesture, regardless of the value passed
 in via pArgs.
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Notification Messages								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgXGestureComplete: takes NULL, returns STATUS
	Hook for subclasses to postprocess the results of gesture recognition.

 Not implemented.
*/
#define msgXGestureComplete         MakeTag(clsXGesture, 64)

#endif
