/****************************************************************************
 xlfilter.h

 Copyright 1992, GO Corporation, All Rights Reserved

 $Revision:   1.3  $
     $Date:   25 Feb 1992 15:09:50  $

 This file contains the API definition for some of the xlist filters.
 xlist filters provide a mechanism to alter the contents of an xlist.

 Xlists are a dynamic list of dynamic items.  Their API is defined in the
 file xlist.h.  This file simply defines a filter function to operate
 on the xlist.  This function should have probably been included in the
 file xlist.h.

 See Also
	xlist.h
****************************************************************************/

#ifndef XLFILTER_INCLUDED
#define XLFILTER_INCLUDED

#ifndef XLIST_INCLUDED
#include <xlist.h>
#endif

/****************************************************************************
 XList2Text						returns STATUS
	Converts a translator xlist to lines of xtText & xtBounds.

 Converts xlist of the form:

 	[xtBounds xtTextWord [xtTextWord]] xtTextListEnd

 into:

 	[xtBounds xtText]

 where xtText is the space delimited xtTextWords.

 Sets the xlfXList2Text flag in the xlist to indicate that the filter
 has been executed on this list.  A subsequent invocation of XList2Text
 with this flag set will return stsOK without processing any data.
 Turning this flag off will cause another pass over the data.  This
 will have no side affects.

 See Also
	xlist.h
*/
STATUS EXPORTED XList2Text(
	P_XLIST pXList);

#endif
