/****************************************************************************
 adderevl.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.4  $
     $Date:   31 Jan 1992 08:22:32  $
   $Author:   kcatlin  $

 This header defines messages and status values for clsExpr.

****************************************************************************/

#ifndef ADDEREVL_INCLUDED
#define ADDEREVL_INCLUDED

#include <clsmgr.h>



#define DELIMITER 1
#define VARIABLE 2
#define NUMBER 3

#define nullValue			(double)0

#define MAX_SYNTAX 40	// maximum length of a syntax error

/**************************** MACROS ***************************/



BOOLEAN expr_ok(double *answer, char *expr, char error[]);



/**************************** CONSTANTS ***********************/

#define maxExprLen	200	// maximum length of an expression
#define maxValueLen	200	// maximum length of the expression's value

// The id police have assigned us the range: 2146..2149, clsAdderEvaluatorApp uses 2147
#define clsAdderEvaluator 				MakeWKN(2147,1,wknGlobal)

/**************************** TYPES ***************************/

typedef struct EVAL_FRAME *P_EVAL_FRAME;

typedef struct EVAL_FRAME {
	CHAR			expression[maxExprLen];    // in: expression to evaluate
   BOOLEAN     badExpr;                   // out: true if expression was bad
   double      value;                     // out: numerical answer
	CHAR			valueStr[maxValueLen];     // out: string answer or error msg
} EVAL_FRAME;


/****************************************************************************
	msgAdderEvaluatorEval:	takes P_EVAL_FRAME, returns STATUS

	Sends an expression into the expression analyzer.

	Sends back value of expression.  valueStr[] contains the ascii
   representation of the result if badExpr is false, or an error message
   if badExpr is true.

   Takes P_EVAL_FRAME, returns STATUS.  < stsOK if we couldn't perform
   the evaluation (ie: alloc's failed or something).  If the expression
   was invalid, the badExpr flag in P_EVAL_FRAME is set to true.

   If prevValueExists AND the expression string begins with an operator,
   the prevValue will be prefixed before evaluation.  This lets us handle
   stuff like "/2 * 100" to operate on a previous value.
****************************************************************************/
#define msgAdderEvaluatorEval								MakeMsg(clsAdderEvaluator, 1)


/****************************************************************************
 ClsAdderEvaluatorInit	returns STATUS
	Initializes / installs clsAdderEvaluatorTable.

	This routine is only called during installation of the class.
*/
STATUS PASCAL
ClsAdderEvaluatorInit (void);

#endif
