/****************************************************************************
 File: basicsvc.c
 
 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.3  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:05:24  $

 This file contains sample code for a minimal service, clsBasicService.

 This is the absolute minimum required to make a service. Add your methods
 to this framework.
****************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <debug.h>
#include <method.h>

#ifndef BASICSVC_INCLUDED
#include <basicsvc.h>
#endif

// Service managers to put instances on. SUBSTITUTE YOUR SERVICE MGR HERE!
static UID managers = {theSerialDevices};

STATUS PASCAL ClsBasicServiceInit(void);

STATUS EXPORTED DllMain(void)
{
	SVC_INIT_SERVICE	initService;
	SVC_NEW				svcNew;
	STATUS				s;

	// Install class.
	StsRet(ClsBasicServiceInit(), s);

	// Let the system know about our service. 
	memset(initService.spare, 0, sizeof(initService.spare));
	initService.autoCreate = false;	 		
	initService.serviceType = 0;
	initService.initServiceFlags = 0; // Flags. Or-in options.
	ObjCallRet(msgSvcClassInitService, clsBasicService, &initService, s);

	// Create an instance. 
	ObjCallWarn(msgNewDefaults, clsBasicService, &svcNew);
	svcNew.svc.pServiceName = "Basic Instance";  // Name of this instance.
	ObjCallRet(msgNew, clsBasicService, &svcNew, s);

	return stsOK;

} // DllMain


/****************************************************************************
	BasicSvcNewDefaults
	
	Set defaults. This is where the service characterstics that are common
	to all instances of your service subclasses are specified.
****************************************************************************/
MsgHandlerWithTypes(BasicSvcNewDefaults, P_SVC_NEW, P_IDATA)
{
	MsgHandlerParametersNoWarning;

	// What service manager(s) should instances go on?
	pArgs->svc.numManagers = 1;
	pArgs->svc.pManagerList = &managers;

	// What are the exclusivity requirements for this service?
	pArgs->svc.style.exclusiveOpen = true;

	return stsOK;
	
} // BasicSvcNewDefaults


/****************************************************************************
	ClsBasicServiceInit
	
	Install our class.
****************************************************************************/
STATUS PASCAL ClsBasicServiceInit(void)
{
	STATUS					s;
	CLASS_NEW				new;

	// Create the service class.
	ObjCallWarn(msgNewDefaults, clsClass, &new);
	new.object.uid			= clsBasicService;	// SUBSTITUTE YOUR CLASS HERE!
	new.cls.pMsg			= clsBasicServiceTable;
	new.cls.ancestor		= clsService;
	new.cls.size			= 0;
	new.cls.newArgsSize		= SizeOf(SVC_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return s;

} // ClsBasicServiceInit


