/****************************************************************************
 File: calceng.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.3  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:07:36  $

 This header defines the public interface for clsCalcEngine.
****************************************************************************/

#ifndef CALCENG_INCLUDED
#define CALCENG_INCLUDED

													#ifndef GO_INCLUDED
#include <go.h>
													#endif
													#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
													#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Typedefs, #defines, and Status Values                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//
// from the new administrated UID space:
//
#define clsCalcEngine					MakeWKN(2142,1,wknGlobal)


#define stsCalcEngineUnknownOperator	MakeStatus(clsCalcEngine, 1)
#define stsCalcEngineUnknownKey			MakeStatus(clsCalcEngine, 2)
#define stsCalcEngineComputeError		MakeStatus(clsCalcEngine, 3)


#define maxDigits				30


typedef CHAR BUFFER[maxDigits];


Enum16(CALC_ENGINE_KEY) {

	// Digits
	zero            = '0',
	one             = '1',
	two             = '2',
	three           = '3',
	four            = '4',
	five            = '5',
	six             = '6',
	seven           = '7',
	eight           = '8',
	nine            = '9',
	decimalPoint    = '.',

	// Equals operator
	equals          = 1,

	// Binary operators
	plus            = 2,
	minus           = 3,
	multiply        = 4,
	divide          = 5,

	// Unary operators
	unaryOps        = 10,
	squareRoot      = 11,
	changeSign      = 12,
	clear           = 13,
	clearAll        = 14,
	nop             = 0

};


typedef struct CALC_ENGINE_TOKEN {

	CALC_ENGINE_KEY		key;	// In
	BUFFER				buf;	// Out
	double				value;	// Out

} CALC_ENGINE_TOKEN, * P_CALC_ENGINE_TOKEN;


#define calcEngineNewFields \
	objectNewFields


typedef struct CALC_ENGINE_NEW {

	calcEngineNewFields

} CALC_ENGINE_NEW, * P_CALC_ENGINE_NEW;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	Messages Sent to a CalcEngine                                          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgCalcEngineProcessKey	takes P_CALC_ENGINE_TOKEN, returns STATUS
	Drops a key into the calculator engine.

	The calculator engine interprets keys one at a time
	and returns the current value as a string to display.
*/
#define msgCalcEngineProcessKey						MakeMsg(clsCalcEngine, 1)


/****************************************************************************
 msgCalcEngineEnterNumber	takes P_CALC_ENGINE_TOKEN, returns STATUS
	Self-sent to process numbers.
*/
#define msgCalcEngineEnterNumber					MakeMsg(clsCalcEngine, 2)


/****************************************************************************
 msgCalcEngineEnterOperator	takes P_CALC_ENGINE_TOKEN, returns STATUS
	Self-sent to process operators.

 Return Value
	stsCalcEngineUnknownOperator:	Incorrect operator value specified.
	stsCalcEngineComputeError:		Computational error encountered.
*/
#define msgCalcEngineEnterOperator					MakeMsg(clsCalcEngine, 3)

#endif

