/****************************************************************************
 file:   npapp.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.8  $
   $Author:   kcatlin  $
     $Date:   16 Mar 1992 19:16:04  $

 This file contains the Paint app.
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <go.h>
#include <uid.h>
#include <clsmgr.h>
#include <appmgr.h>
#include <os.h>
#include <app.h>
#include <frame.h>
#include <menu.h>		// to create menubar
#include <swin.h>		// to create scrolling window
#include <print.h>
#include <resfile.h>
#include <debug.h>
#include <notepapr.h>
#include <gmargin.h>
#include <apptag.h>
#include "methods.h"

/****************************************************************************/
/*					D E F I N E S   A N D   T Y P E D E F S					*/
/****************************************************************************/

#define clsNotePaperApp  		 MakeGlobalWKN(3512,1)

typedef struct INSTANCE_DATA {

	OBJECT	notePaper;

} INSTANCE_DATA, *P_INSTANCE_DATA;

/****************************************************************************/
/*					F O R W A R D   D E C L A R A T I O N S					*/
/****************************************************************************/

/****************************************************************************/
/*				S T A T I C   D A T A   D E C L A R A T I O N S				*/
/****************************************************************************/

/****************************************************************************/
/*			L O C A L   F U N C T I O N S   &   M E T H O D S			    */
/****************************************************************************/

/****************************************************************************
	msgAppInit
****************************************************************************/
MsgHandlerWithTypes(NotePaperAppAppInit, P_ARGS, P_INSTANCE_DATA)
{
	STATUS			s;
	INSTANCE_DATA	inst;
	NOTE_PAPER_NEW	new;


	//  First pass message to ancestor.
	//
	ObjCallAncestorRet(msgAppInit, self, pArgs, ctx, s);

	//  Update/Write instance data.
	//
	memset(&inst, 0, sizeof(inst));
	
	// Create the NotePaper component
	//
	ObjCallWarn(msgNewDefaults, clsNotePaper, &new);
	new.notePaper.style.bHideTopRule	= true;
	new.notePaper.style.bWidthOpts	  	= false;
	new.notePaper.style.bAutoGrow		= true;
	new.view.createDataObject 			= true;
 	new.gWin.helpId						=
 	new.win.tag	   						= tagNotePaper;
	ObjCallRet(msgNew, clsNotePaper, &new, s);
	inst.notePaper						= new.object.uid;
	ObjectWrite(self, ctx, &inst);

	// Set NotePaper's width to the width of the printer page
	{
		PRINT_AREA	printArea;
		SYSDC_NEW	dcn;
		OBJECT		dc;
		WIN_METRICS	wm;

		printArea.pMetrics = pNull;
		ObjCallWarn(msgPrintPaperArea, thePrintManager, &printArea);

		ObjCallWarn(msgNewDefaults, clsSysDrwCtx, &dcn);
		ObjCallWarn(msgNew, clsSysDrwCtx, &dcn);
		dc = dcn.object.uid;
		ObjectCall(msgDcSetWindow, dc, (P_ARGS)pData->notePaper);
		ObjectCall(msgDcUnitsMil, dc, pNull);
		ObjCallWarn(msgWinGetMetrics, dc, &wm);
		wm.bounds.size.w = printArea.area.w;
		ObjCallWarn(msgWinDelta, dc, &wm);
		ObjCallWarn(msgDestroy, dc, pNull);
	}
	
	return(stsOK);

	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	NotePaperAppControlProvideEnable

	msgControlProvideEnable.
****************************************************************************/
MsgHandlerWithTypes(NotePaperAppControlProvideEnable, P_CONTROL_PROVIDE_ENABLE, P_INSTANCE_DATA)
{
	switch(pArgs->tag)
	{
		case tagAppMenuSelectAll:
			pArgs->enable = true;
			return(stsOK);
	}
	return ObjCallAncestorCtxWarn(ctx);
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	NotePaperAppSelectAll

	Respond to msgAppSelectAll
****************************************************************************/
MsgHandlerWithTypes(NotePaperAppSelectAll, P_ARGS, P_INSTANCE_DATA)
{
	STATUS				s;

	ObjCallRet(msg, pData->notePaper, pArgs, s);

	return stsOK;
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	NotePaperAppPrintGetProtocols
				
	msgPrintGetProtocols
****************************************************************************/
MsgHandlerWithTypes(NotePaperAppPrintGetProtocols, P_PRINT_PROTOCOLS, P_INSTANCE_DATA)
{
	pArgs->paginationMethod = prPaginationTile;
	pArgs->embeddeeSearch = prEmbeddeeSearchByPrintJob;
	return stsOK;
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	NotePaperAppAppOpen

	Respond to msgAppOpen.

	Create objects necessary to make app visible and interact with the user.
****************************************************************************/
MsgHandlerWithTypes(NotePaperAppAppOpen, P_APP_OPEN, P_INSTANCE_DATA)
{
	STATUS				s;
	APP_METRICS			am;
	GESTURE_MARGIN_NEW	new;
	OBJECT				menuBar = objNull;
	TBL_LAYOUT_STYLE	ts;

	Dbg(Debugf("NotePaperApp[%p] AppOpen", self);)

	ObjCallRet(msgAppGetMetrics, self, &am, s);
	
	
	// create gesture margin window and insert into the frame
	ObjCallRet(msgNewDefaults, clsGestureMargin, &new, s);
	if(pArgs->printing)
		new.gestureMargin.style.gestureMargin	= false;
	new.scrollWin.clientWin					= pData->notePaper;
	new.scrollWin.style.forward				= swForwardGesture;
	new.scrollWin.style.expandChildHeight	= true;
	new.scrollWin.style.vertScrollbar		= true;
	new.scrollWin.style.autoVertScrollbar	= false;
	new.scrollWin.style.getDelta		 	= true;
	new.gWin.helpId							=
	new.win.tag								= tagNotePaperMargin;
	new.win.flags.style						|= wsShrinkWrapWidth;
	ObjCallRet(msgNew, clsGestureMargin, &new, s);
	
	ObjCallRet(msgFrameSetClientWin, am.mainWin, (P_ARGS)new.object.uid, s);
	
	// Create the menu bar.
	ObjCallRet(msgAppCreateMenuBar, self, &menuBar, s);
		
	// Set its style
	ObjCallWarn(msgTblLayoutGetStyle, menuBar, &ts);
	ts.childYAlignment	= tlAlignCenter;
	ts.widthExtra		= tlExtraBeforeLast;
	ObjCallWarn(msgTblLayoutSetStyle, menuBar, &ts);
		
	// Allow the NotePaper component to add its specific menus to
	// the menu bar.
	ObjCallRet(msgNotePaperAddMenus, pData->notePaper, (P_ARGS)menuBar, s);
	ObjCallRet(msgNotePaperAddModeCtrl, pData->notePaper, (P_ARGS)menuBar, s);
		
	// Set the menu bar as the menu bar of the frame.
	ObjCallRet(msgFrameSetMenuBar, am.mainWin, (P_ARGS)menuBar, s);


	ObjCallAncestorRet(msgAppOpen, self, pArgs, ctx, s);
	return(stsOK);
	MsgHandlerParametersNoWarning;
} 
/****************************************************************************
	NotePaperAppAppClose

	Respond to msgAppClose.

	Destroy objects used to interact with the user (self no longer visible).
****************************************************************************/
MsgHandlerWithTypes(NotePaperAppAppClose, P_ARGS, P_INSTANCE_DATA)
{
	APP_METRICS		am;
	STATUS			s;

	ObjCallAncestorCtxRet(ctx, s);

	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallWarn(msgFrameDestroyMenuBar, am.mainWin, pNull);

	return stsOK;
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	Respond to msgSave.
****************************************************************************/
MsgHandlerWithTypes(NotePaperAppSave, P_OBJ_SAVE, P_INSTANCE_DATA)
{					
	STATUS s;
	ObjCallAncestorCtxRet(ctx, s);
 	return ObjCallWarn(msgResPutObject, pArgs->file, pData->notePaper);
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	Respond to msgRestore.
****************************************************************************/
MsgHandlerWithTypes(NotePaperAppRestore, P_OBJ_RESTORE, P_INSTANCE_DATA)
{
	STATUS s;
	INSTANCE_DATA		inst;
	
	ObjCallAncestorCtxRet(ctx, s);
	
	memset(&inst, 0, sizeof(INSTANCE_DATA));
	ObjCallRet(msgResGetObject, pArgs->file, &inst.notePaper, s);
	ObjectWrite(self, ctx, &inst);

	return stsOK;
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	NotePaperAppFree

	Respond to msgFree.

 	Destroy remaining stateful objects (self no longer exists).
****************************************************************************/
MsgHandlerWithTypes(NotePaperAppFree, P_ARGS, P_INSTANCE_DATA)
{
	STATUS 				s;
	INSTANCE_DATA	inst;


	//  Read instance data.
	//
	inst = *pData;

	ObjCallAncestorRet(msgFree, self, pArgs, ctx, s);

	// Destroy my objects
	if(inst.notePaper)
		ObjectCall(msgDestroy, inst.notePaper, 0);

	return(stsOK);
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	ClsNotePaperAppInit
	
	Install the NotePaperApp application.
****************************************************************************/
STATUS EXPORTED ClsNotePaperAppInit (void)
{
	APP_MGR_NEW		new;
	STATUS			s;

	//
	//  Install the app class clsNotePaperApp
	//
	ObjCallRet(msgNewDefaults, clsAppMgr, &new, s);
	new.object.uid	 		  	= clsNotePaperApp;
	new.object.key	 		  	= objWKNKey;
	new.cls.pMsg			  	= NotePaperAppMethodTable;
	new.cls.ancestor		  	= clsApp;
	new.cls.size			  	= SizeOf(INSTANCE_DATA);
	new.cls.newArgsSize		  	= SizeOf(APP_NEW);
	strcpy(new.appMgr.name, "NotePaper App");
	strcpy(new.appMgr.company, "GO Corporation");
	strcpy(new.appMgr.version, "1.0");
	strcpy(new.appMgr.defaultDocName, "NotePaper Sample");
	new.appMgr.copyright		=  \   				 
		"\213 1990-1992 GO Corporation\nAll Rights Reserved.";
	new.appMgr.flags.stationery	= true;
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	return stsOK;
}


/****************************************************************************
	main

	Main application entry point.
		
	Install/register self or install private components and start-up self.
****************************************************************************/
STATUS CDECL main (
	int			argc,  
	char *		argv[],
	U16			processCount)
{
	STATUS	s;

	Dbg(Debugf("NotePaperApp processCount[%d]", processCount);)

	if (processCount == 0)
	{
		//  Create application class.
		StsRet(ClsNotePaperAppInit(), s);
		   
		//  Invoke app monitor to install this application.
		AppMonitorMain(clsNotePaperApp, objNull);
	}
	else
	{
		// Initialize local well-knowns

		//  Create an application instance and dispatch messages.
		AppMain();
	
	}
	Unused(argc);
	Unused(argv);
			  
}	/* main */
